/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDCQTAB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS  prdc_QueryColorData
 *            prdc_QueryLogColorTable
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                 /* CON3201 */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPILOGCOLORTABLE
#define INCL_GPIERRORS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSSEMAPHORES
#undef INCL_GPILOGCOLORTABLE
#undef INCL_GPIERRORS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSPROCESS            /* CON3201 */

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                    /* CON3201 */

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdcextf.h>
#include <prdgextf.h>
#include <prdyextf.h>



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdc_QueryColorData                                    */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC        DcH;                                                */
/*   ULONG        ArgCount;                                           */
/*   ULONG     *  ArgArray;                                           */
/*   lpDCI        lpIData;                                            */
/*   ULONG        FunN;                                               */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function returns the format of the current logical current  */
/*   table along with its low and high index.                         */
/*                                                                    */
/**********************************************************************/
ULONG  prdc_QueryColorData ( hanDC    DcH,
                             ULONG    ArgCount,
                             ULONG  * ArgArray,
                             lpDCI    lpIData,
                             ULONG    FunN)

{
#define TFUNC "prdc_QueryColorData"

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT i;           /* Loop control variable              */
    USHORT Last;  /* Maximum number of items to return  */

    TRACE8(TFUNC, "Count", &ArgCount, 1);
    TRACE8(TFUNC, "&Array", &ArgArray, 1);
    TRACE8(TFUNC, "DcH", &DcH, 1);
    TRACE8(TFUNC, "FunN", &FunN, 1);

    prdm_EnterDriver(lpIData);

    if ( (LONG)ArgCount < 0 )
    {
        /**************************************************************/
        /* Invalid parm                                               */
        /**************************************************************/
        LOGERR( TFUNC, "Invalid Parm", FNULL, 0,
                PMERR_INV_LENGTH_OR_COUNT );
        prdm_LeaveDriver(lpIData);
        return(ERROR_ZERO);
    }

    /******************************************************************/
    /* Establish the number of items that can be returned.            */
    /******************************************************************/
    if ((Last = (USHORT)ArgCount) > 3)
    {
        Last = 3;
    }

    /******************************************************************/
    /* Repeat for each returnable item.                               */
    /******************************************************************/
    for ( i = 0; i < Last; i++ )
    {
             /**************************************************************/
             /* Select the current item to be returned                     */
        /**************************************************************/
        switch (i)
        {
        case QCD_LCT_FORMAT:
            /**********************************************************/
            /* The colour table format                                */
            /**********************************************************/
            ArgArray[QCD_LCT_FORMAT] = lpIData->DCIColFormat;
            break;

        case QCD_LCT_LOINDEX:
            /**********************************************************/
            /* The smallest colour table index                        */
            /**********************************************************/
            ArgArray[QCD_LCT_LOINDEX] = lpIData->DCILowIndex;
            break;

        case QCD_LCT_HIINDEX:
            /**********************************************************/
            /* The largest colour table index                         */
            /**********************************************************/
            ArgArray[QCD_LCT_HIINDEX] = lpIData->DCIHighIndex;
            break;
        }
             /*.. switch (i) ..............................................*/

    }
    /*.. for (i = 0; i < Last; i++) .......each item returned.........*/

    /******************************************************************/
    /* Zero the rest of the given buffer.                             */
    /******************************************************************/
    for ( i = Last; i < (USHORT)ArgCount; i++ )
        ArgArray[i] = 0L;

    TRACE4(TFUNC, "Return OK", FNULL, 0);
    prdm_LeaveDriver(lpIData);
    return(OK);

}
#undef TFUNC




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdc_QueryLogColorTable                                */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC         DcH;                                               */
/*   ULONG         ArgOptions;                                        */
/*   ULONG         ArgStart;                                          */
/*   ULONG         ArgCount;                                          */
/*   ULONG     *   ArgArray;                                          */
/*   lpDCI         DCIData;                                           */
/*   ULONG         FunN;                                              */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function returns the logical colour table entries specified */
/*   by ArgStart and ArgCount at ArgArray.                            */
/*                                                                    */
/**********************************************************************/
ULONG prdc_QueryLogColorTable ( hanDC     DcH,
                                ULONG     ArgOptions,
                                ULONG     ArgStart,
                                ULONG     ArgCount,
                                ULONG  *  ArgArray,
                                lpDCI     DCIData,
                                ULONG     FunN)

{
#define TFUNC "prdc_QueryLogColorTable"
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT         NumVals;             /* The number of values returned  */
    USHORT         MaxCount;             /* The Maximum number of entries  */
                                                        /* to return at ArgArray          */
    USHORT         i;                   /* Loop control variable          */
    lpColorTable   lpCT;            /* Pointer to the logical colour  */
                                    /* table                          */

    TRACE8(TFUNC, "Options", &ArgOptions, 1);
    TRACE8(TFUNC, "Start", &ArgStart, 1);
    TRACE8(TFUNC, "Count", &ArgCount, 1);
    TRACE8(TFUNC, "&Array", &ArgArray, 1);
    TRACE8(TFUNC, "DcH", &DcH, 1);
    TRACE8(TFUNC, "FunN", &FunN, 1);

    /******************************************************************/
    /* Do entry processing                                            */
    /******************************************************************/
#ifdef PRD_TIMING
    DEKHOOK0(A,7,1F)
#endif
    prdm_EnterDriver(DCIData);

    /******************************************************************/
    /* Set up pointer to logical colour table                                   */
    /******************************************************************/
    lpCT = DCIData->DCIColorTable;

    /******************************************************************/
    /* If current mode is RGB mode then it is an error to call this   */
    /* function.                                                                 */
    /******************************************************************/
    if (DCIData->DCIColFormat == LCOLF_RGB)
    {
         TRACE4(TFUNC, "Error RGB Mode", FNULL, 0);
         prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,9F)
#endif
         return((ULONG)QLCT_RGB);
    }

    if ( (LONG)ArgCount < 0 )
    {
        /**************************************************************/
        /* PD00125                                                    */
        /**************************************************************/
        LOGERR( TFUNC, "Invalid Parm", FNULL, 0,PMERR_INV_LENGTH_OR_COUNT );
        prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,9F)
#endif
        return((ULONG)QLCT_ERROR);
    }

    /******************************************************************/
    /* If we have to return the index as well then ensure that        */
    /* MaxCount (the number of items we return) is an even number so  */
    /* we do not write data beyond the end of the available memory.   */
    /******************************************************************/
    MaxCount = (USHORT) ArgCount;

    if (ArgOptions & LCOLOPT_INDEX)
        MaxCount -= (MaxCount % 2);

    NumVals = 0;

    TRACE4(TFUNC, "MaxCount", &MaxCount, 1);
    TRACE4(TFUNC, "Table Size",&DCIData->DCIColTabSize, 1);

    /******************************************************************/
    /* While there are still entries in the colour table and there is */
    /* still room to return them then return an entry.                */
    /******************************************************************/
    for ( i = (USHORT)ArgStart;
          NumVals < MaxCount && i < DCIData->DCIColTabSize;
          i++)
    {
        if (lpCT[i].LogRGB == 0xFFFFFFFFL)
        {
            /**********************************************************/
            /* If the entry is an invalid colour then only return it  */
            /* if we are returning RGB values only.                   */
            /**********************************************************/
            if ((ArgOptions & LCOLOPT_INDEX) == 0)
                ArgArray[NumVals++] = 0xFFFFFFFFL;
        }
        else
        {
            /**********************************************************/
            /* Otherwise, return the index (if required) and the RGB  */
            /* value.                                                 */
            /**********************************************************/
            if (ArgOptions & LCOLOPT_INDEX)
                ArgArray[NumVals++] = i;
            ArgArray[NumVals++] = lpCT[i].LogRGB;
        }
    }
    /*.. for (i = (USHORT)ArgStart; ..while there is room in table...*/

    TRACE4(TFUNC, "Return", &NumVals, 1);

    /******************************************************************/
    /* Return the number of entries returned at ArgArray.             */
    /******************************************************************/
    prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,9F)
#endif
    return((ULONG)NumVals);
}
#undef TFUNC

