/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDBDELT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdb_DeviceDeleteBitmap
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdbtyp1.h>
#include <prdbextf.h>
#include <prdgextf.h>
#include <prdyextf.h>
#include <prdbsize.h>

/*extern PFSRSEM pBMLockSem;    CON3201 */
extern HMTX   hmtxBMLockSem; /* CON3201 */

#define TFUNC "prdb_DevDeleteBitmap"

/******************************************************************************/
/*  FUNCTION: prdb_DeviceDeleteBitmap                                         */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  See "OS/2 Technical Reference: I/O Subsytems and Device Drivers"          */
/*                                                                            */
/*  hanDC          DcH;                                                       */
/*  pBMListEntry   ArgHandle;                                                 */
/*  PDELETERETURN  ArgReturns;                                                */
/*  ULONG          ArgUsage;                                                  */
/*  lpDCI          DCIData;                                                   */
/*  ULONG          FunN;                                                      */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function deletes a bitmap in the printer drivers bitmap list.        */
/******************************************************************************/
ULONG EXPENTRY prdb_DeviceDeleteBitmap( hanDC          DcH,
                                        pBMListEntry   ArgHandle,
                                        PDELETERETURN  ArgReturns,
                                        ULONG          ArgUsage,
                                        lpDCI          DCIData,
                                        ULONG          FunN )

{

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    USHORT         Result;              /* function return code                */
    pBMListEntry  ListEntry;           /* Pointer to a bitmap list entry      */
/*  PBITMAPINFO   ReturnParms;         CON3201 - GRE CHANGE                   */
    PBITMAPINFO2  ReturnParms;         /* The structure to return the bitmap  */
                                       /* parameters                          */
    lpBMSPad      SPad;                /* PD00400 : Pointer to bitmap scratch */
                                       /* pad - lpBMSPad is a typedef pointer */
                                       /* to the structure BMConvertScratch   */


#ifdef PRD_TIMING
    DEKHOOK0(A,7,47)
#endif

    /**************************************************************************/
    /*  Find the bitmap list entry for this bitmap.  If bitmap not found then */
    /*  log and return an error.                                              */
    /**************************************************************************/
    if (!(ListEntry = ArgHandle))
    {
        LOGERR("prdbDelete", "bitmap not found", NULL, 0, PMERR_INV_HBITMAP);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,C7)
#endif
        return(ERROR_ZERO);
    }

    /**************************************************************************/
    /*  Try to lock the bitmap, logging an error if unsuccessful              */
    /**************************************************************************/
/*    FSRSemEnter(hmtxBMLockSem);    32BIT....*/
    DosRequestMutexSem(hmtxBMLockSem, SEM_INDEFINITE_WAIT);
    if (ListEntry->BMLocked)
    {
/*     FSRSemLeave(hmtxBMLockSem);   32BIT.....*/
       DosReleaseMutexSem(hmtxBMLockSem);
        LOGERR("prdbDelete", "bitmap locked", FNULL, 0, PMERR_BITMAP_IN_USE);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,C7)
#endif
        return(ERROR_ZERO);
    }
    ListEntry->BMLocked = TRUE;
/*    FSRSemLeave(hmtxBMLockSem);      32BIT....*/
      DosReleaseMutexSem(hmtxBMLockSem);

    /**************************************************************************/
    /*  If the bitmap is currently selected into a DC then return an error.   */
    /**************************************************************************/
    TRACE4("prdbDelete", "List entry DC", &(ListEntry->DCHandle), 1);
    if (ListEntry->DCHandle)
    {
        ListEntry->BMLocked = FALSE;
        LOGERR("prdbDelete", "bitmap selected", NULL, 0,PMERR_BITMAP_IS_SELECTED);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,C7)
#endif
        return(ERROR_ZERO);
    }

    /**************************************************************************/
    /*  If bitmap to be translated and returned before deleting we just give  */
    /*  the caller the internal bitmap, instead of deleting it.  We do,       */
    /*  however, need to set up the colour table for it.                      */
    /**************************************************************************/
    if (ArgUsage & CBM_INIT)
    {
        TRACE4("prdbDelete", "bitmap to be deleted", NULL, 0);

        /**********************************************************************/
        /*  Get some memory for the bitmap format parameters                  */
        /*                                                                    */
        /*  PD00793 : Use sizeof(BITMAPINFOHEADER), not the BITMAPINFO as     */
        /*  there is a packed array at the end of the BITMAPINFO structure of */
        /*  indeterminate size.                                               */
        /**********************************************************************/
     /* Result = SSALLOCSEG((SHORT)(sizeof(BITMAPINFOHEADER) + 3 *  */
     /*                     (1 << ListEntry->Parms.Bitcount)),      */
     /*                     &SELECTOROF(ReturnParms),0);            */
        Result = SafeSSALLOCMEM(&ReturnParms,                        /*CON3201*/
                            ((ULONG)(sizeof(BITMAPINFOHEADER2) + 4 * /*CON3201*/
                            (1 << ListEntry->Parms.Bitcount))),      /*CON3201*/
                            0) ;
        if (Result)
        {
            LOGDOSERR(TFUNC, "SSALLOCSEG Fail", &Result, 1, Result);
            ListEntry->BMLocked = FALSE;
#ifdef PRD_TIMING
    DEKHOOK0(A,7,C7)
#endif
            return(ERROR_ZERO);
        }
     /* OFFSETOF(ReturnParms) = 0;  CON3201 */

        /**********************************************************************/
        /*  Copy the bitmap parameters from the list entry.                   */
        /*                                                                    */
        /*  PD00423 : Change the assignment for cbFix to size the correct     */
        /*  structure - was BITMAPINFOHEADER (wrong).                         */
        /*                                                                    */
        /*  PD00793 : Use sizeof(BITMAPINFOHEADER), not the BITMAPINFO as     */
        /*  there is a packed array at the end of the BITMAPINFO structure of */
        /*  indeterminate size.                                               */
        /**********************************************************************/
/*      ReturnParms->cbFix     = sizeof(BITMAPINFOHEADER); */
        ReturnParms->cbFix     = MIN_BITMAPINFOHEADER2;
/*      ReturnParms->cx        = (USHORT)ListEntry->Parms.Width;  */
/*      ReturnParms->cy        = (USHORT)ListEntry->Parms.Height; */
        ReturnParms->cx        = ListEntry->Parms.Width;           /* CON3201 */
        ReturnParms->cy        = ListEntry->Parms.Height;          /* CON3201 */
        ReturnParms->cPlanes   = (USHORT)ListEntry->Parms.Planes;
        ReturnParms->cBitCount = (USHORT)ListEntry->Parms.Bitcount;

        /**********************************************************************/
        /*  Put ReturnParms selector into ArgReturns data.                    */
        /**********************************************************************/
        ArgReturns->pInfo = (ULONG)ReturnParms;

        /**********************************************************************/
        /*  Put bitmap handle selector in ArgReturns.                         */
        /**********************************************************************/
        ArgReturns->pBits = (ULONG)ListEntry->Bitmap;

        /**********************************************************************/
        /*  Set up a colour table for the bitmap                              */
        /*                                                                    */
        /*  PD00400 : Allocate the memory used for the BM scratch pad         */
        /*                                                                    */
        /*  PD00422 : Change the alloc to the global heap rather than the     */
        /*  local heap since DCIData *may* be FNULL.                          */
        /**********************************************************************/
        if (prdg_AllocGlobalHeapItem((USHORT)sizeof(BMConvertScratch),
                                  /* (PBYTE far *)&SPad) != OK) */
                                     (PBYTE *)&SPad) != OK)        /* CON3201 */
        {
            ArgReturns->pInfo = 0;     /* PD00400...                          */
         /* SSFREESEG(SELECTOROF(ReturnParms));    PD00400...                 */
            SSFREEMEM(ReturnParms);                                /* CON3201 */
            return((ULONG)ERROR_NEG);
        }
        SPad->IntBpp = ReturnParms->cBitCount;
        SPad->ExtBpp = ReturnParms->cBitCount;

        /**********************************************************************/
        /*  PD00400 : Pass in the parameter SPad                              */
        /**********************************************************************/
        prdb_SetExternalColourTable(&(ReturnParms->argbColor[0]), SPad);

        /**********************************************************************/
        /*  PD00400 : Free the memory used for the BM scratch pad             */
        /*                                                                    */
        /*  PD00422 : Change the free to the global heap rather than the      */
        /*  local heap since DCIData *may* be FNULL (and since the thing was  */
        /*  allocated on the global heap... duhhh...).                        */
        /**********************************************************************/
/* CON3201 changed cast to PUSHORT*                                           */
/*      (VOID)prdg_FreeGlobalHeapItem(sizeof(BMConvertScratch), (PSHORT)&SPad);*/
        (VOID)prdg_FreeGlobalHeapItem(sizeof(BMConvertScratch), (PUSHORT*)&SPad);
    }
    else
    {

        /**********************************************************************/
        /*  Free memory for the bitmap if we are not returning it.            */
        /**********************************************************************/
        TRACE4("prdbDelete", "free bitmap memory", NULL, 0);
        (VOID)prdb_FreeBitmap((PBYTE)ArgHandle->Bitmap);
    }

    /**************************************************************************/
    /*  Remove the bitmap list entry and return the return value of           */
    /*  DeleteBitmap after unlocking the bitmap                               */
    /**************************************************************************/
    TRACE4("prdbDelete", "removing list entry", &ListEntry, 1);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,C7)
#endif
    return(prdb_DeleteBitmap(ListEntry));
}
#undef TFUNC
