/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDBDATA
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdbcone.h>
#include <prdconse.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdbsize.h>

/******************************************************************************/
/*  This file contains data for the raster op codes and patterns              */
/******************************************************************************/

/******************************************************************************/
/*  The BitmapList is the list of all currently active Bitmaps managed by this*/
/*  Device Driver.                                                            */
/******************************************************************************/
/*
BitmapListEntry far *BitmapList = FNULL; */
BitmapListEntry *BitmapList = FNULL;                               /* CON3201 */

/******************************************************************************/
/*  The Parse Strings used to generate sequences of Bitblt operations.        */
/******************************************************************************/
ParseStringType  ParseTable [NUMBER_PARSE] =
                   { {SRC,  PAT,  DEST, DEST,  DEST, DEST, DEST, DEST },
                     {SRC,  PAT,  DEST, SRC,   PAT,  DEST, SRC,  PAT  },
                     {SRC,  DEST, PAT,  SRC,   DEST, PAT,  SRC,  DEST },
                     {DEST, DEST, DEST, DEST,  DEST, DEST, DEST, DEST },
                     {DEST, DEST, DEST, DEST,  DEST, DEST, DEST, DEST },
                     {SRC , POP,  SRC,  PAT,   PUSH, DEST, SRC,  SRC  },
                     {SRC , POP,  SRC,  PAT,   PUSH, PAT,  DEST, SRC  },
                     {SRC , POP,  SRC,  DEST,  PUSH, PAT,  DEST, SRC  },
                     };

USHORT           RopTable[256] =       /* table of raster op codes            */

                                       /* X'00' - X'0F'                       */
                     { 0x0042, 0x0289, 0x0C89, 0x00AA,
                       0x0C88, 0x00A9, 0x0865, 0x02C5,
                       0x0F08, 0x0245, 0x0329, 0x0B2A,
                       0x0324, 0x0B25, 0x08A5, 0x0001,

                                       /* X'10' - X'1F'                       */
                       0x0C85, 0x00A6, 0x0868, 0x02C8,
                       0x0869, 0x02C9, 0x5CCA, 0x1D54,
                       0x0D59, 0x1CC8, 0x06C5, 0x0768,
                       0x06CA, 0x0766, 0x01A5, 0x0385,

                                       /* X'20' - X'2F'                       */
                       0x0F09, 0x0248, 0x0326, 0x0B24,
                       0x0D55, 0x1CC5, 0x06C8, 0x1868,
                       0x0369, 0x16CA, 0x0CC9, 0x1D58,
                       0x0784, 0x060A, 0x064A, 0x0E2A,

                                       /* X'30' - X'3F'                       */
                       0x032A, 0x0B28, 0x0688, 0x0008,
                       0x06C4, 0x1864, 0x01A8, 0x0388,
                       0x078A, 0x0604, 0x0644, 0x0E24,
                       0x004A, 0x18A4, 0x1B24, 0x00EA,

                                       /* X'40' - X'4F'                       */
                       0x0F0A, 0x0249, 0x0D5D, 0x1CC4,
                       0x0328, 0x0B29, 0x06C6, 0x076A,
                       0x0368, 0x16C5, 0x0789, 0x0605,
                       0x0CC8, 0x1954, 0x0645, 0x0E25,

                                       /* X'50' - X'5F'                       */
                       0x0325, 0x0B26, 0x06C9, 0x0764,
                       0x08A9, 0x0009, 0x01A9, 0x0389,
                       0x0785, 0x0609, 0x0049, 0x18A9,
                       0x0649, 0x0E29, 0x1B29, 0x00E9,

                                       /* X'60' - X'6F'                       */
                       0x0365, 0x16C6, 0x0786, 0x0608,
                       0x0788, 0x0606, 0x0046, 0x18A8,
                       0x58A6, 0x0145, 0x01E9, 0x178A,
                       0x01E8, 0x1785, 0x1E28, 0x0C65,

                                       /* X'70' - X'7F'                       */
                       0x0CC5, 0x1D5C, 0x0648, 0x0E28,
                       0x0646, 0x0E26, 0x1B28, 0x00E6,
                       0x01E5, 0x1786, 0x1E29, 0x0C68,
                       0x1E24, 0x0C69, 0x0955, 0x03C9,

                                       /* X'80' - X'8F'                       */
                       0x03E9, 0x0975, 0x0C49, 0x1E04,
                       0x0C48, 0x1E05, 0x17A6, 0x01C5,
                       0x00C6, 0x1B08, 0x0E06, 0x0666,
                       0x0E08, 0x0668, 0x1D7C, 0x0CE5,

                                       /* X'90' - X'9F'                       */
                       0x0C45, 0x1E08, 0x17A9, 0x01C4,
                       0x17AA, 0x01C9, 0x0169, 0x588A,
                       0x1888, 0x0066, 0x0709, 0x07A8,
                       0x0704, 0x07A6, 0x16E6, 0x0345,

                                       /* X'A0' - X'AF'                       */
                       0x00C9, 0x1B05, 0x0E09, 0x0669,
                       0x1885, 0x0065, 0x0706, 0x07A5,
                       0x03A9, 0x0189, 0x0029, 0x0889,
                       0x0744, 0x06E9, 0x0B06, 0x0229,

                                       /* X'B0' - X'BF'                       */
                       0x0E05, 0x0665, 0x1974, 0x0CE8,
                       0x070A, 0x07A9, 0x16E9, 0x0348,
                       0x074A, 0x06E6, 0x0B09, 0x0226,
                       0x1CE4, 0x0D7D, 0x0269, 0x08C9,

                                       /* X'C0' - X'CF'                       */
                       0x00CA, 0x1B04, 0x1884, 0x006A,
                       0x0E04, 0x0664, 0x0708, 0x07AA,
                       0x03A8, 0x0184, 0x0749, 0x06E4,
                       0x0020, 0x0888, 0x0B08, 0x0224,

                                       /* X'D0' - X'DF'                       */
                       0x0E0A, 0x066A, 0x0705, 0x07A4,
                       0x1D78, 0x0CE9, 0x16EA, 0x0349,
                       0x0745, 0x06E8, 0x1CE9, 0x0D75,
                       0x0B04, 0x0228, 0x0268, 0x08C8,

                                       /* X'E0' - X'EF'                       */
                       0x03A5, 0x0185, 0x0746, 0x06EA,
                       0x0748, 0x06E5, 0x1CE8, 0x0D79,
                       0x1D74, 0x5CE6, 0x02E9, 0x0849,
                       0x02E8, 0x0848, 0x0086, 0x0A08,

                                       /* X'F0' - X'FF'                       */
                       0x0021, 0x0885, 0x0B05, 0x022A,
                       0x0B0A, 0x0225, 0x0265, 0x08C5,
                       0x02E5, 0x0845, 0x0089, 0x0A09,
                       0x008A, 0x0A0A, 0x02A9, 0x0062 };

USHORT           PatternTabSize = 17;

/******************************************************************************/
/*  Following are the greyscale pattern tables for high resolution and low to */
/*  mid resolution.  The high resolution patterns differ from the low to mid  */
/*  resolution patterns in that the high res patterns are all 'regular'       */
/*  patterns that are created by adding a pel to an existing pattern to create*/
/*  an incrementally larger pattern.  The patterns are all 'normalized' in    */
/*  that there are not distinguishible sub-patterns apparent in the final     */
/*  output.  The low to mid res patterns are more susceptible to this sub-    */
/*  pattern phenomenon due basically to the small number of pels that one has */
/*  to work with at the lower resolutions.  All the patterns are 8 pels wide  */
/*  by 8 scan lines deep.                                                     */
/*  600DPI : 64 entry grey scale tables to better support 600x600 grey scale  */
/******************************************************************************/

BYTE  greyscale_table[] = {
          0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /*  0               */
          0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /*  1               */
          0xff, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, /*  2               */
          0xff, 0x9f, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, /*  3               */
          0xff, 0x9f, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, /*  4               */
          0xff, 0x9f, 0xbf, 0xff, 0xff, 0xf9, 0xff, 0xff, /*  5               */
          0xff, 0x9f, 0xbf, 0xff, 0xff, 0xf9, 0xfb, 0xff, /*  6               */
          0xff, 0x9f, 0x9f, 0xff, 0xff, 0xf9, 0xfb, 0xff, /*  7               */
          0xff, 0x9f, 0x9f, 0xff, 0xff, 0xf9, 0xf9, 0xff, /*  8               */
          0xdf, 0x9f, 0x9f, 0xff, 0xff, 0xf9, 0xf9, 0xff, /*  9               */
          0xdf, 0x9f, 0x9f, 0xff, 0xfd, 0xf9, 0xf9, 0xff, /* 10               */
          0xdf, 0x8f, 0x9f, 0xff, 0xfd, 0xf9, 0xf9, 0xff, /* 11               */
          0xdf, 0x8f, 0x9f, 0xff, 0xfd, 0xf8, 0xf9, 0xff, /* 12               */
          0xdf, 0x8f, 0x8f, 0xff, 0xfd, 0xf8, 0xf9, 0xff, /* 13               */
          0xdf, 0x8f, 0x8f, 0xff, 0xfd, 0xf8, 0xf8, 0xff, /* 14               */
          0xdf, 0x8f, 0x8f, 0xdf, 0xfd, 0xf8, 0xf8, 0xff, /* 15               */
          0xdf, 0x8f, 0x8f, 0xdf, 0xfd, 0xf8, 0xf8, 0xfd, /* 16               */
          0xcf, 0x8f, 0x8f, 0xdf, 0xfd, 0xf8, 0xf8, 0xfd, /* 17               */
          0xcf, 0x8f, 0x8f, 0xdf, 0xfc, 0xf8, 0xf8, 0xfd, /* 18               */
          0xcf, 0x87, 0x8f, 0xdf, 0xfc, 0xf8, 0xf8, 0xfd, /* 19               */
          0xcf, 0x87, 0x8f, 0xdf, 0xfc, 0x78, 0xf8, 0xfd, /* 20               */
          0xcf, 0x87, 0x87, 0xdf, 0xfc, 0x78, 0xf8, 0xfd, /* 21               */
          0xcf, 0x87, 0x87, 0xdf, 0xfc, 0x78, 0x78, 0xfd, /* 22               */
          0xcf, 0x87, 0x87, 0xcf, 0xfc, 0x78, 0x78, 0xfd, /* 23               */
          0xcf, 0x87, 0x87, 0xcf, 0xfc, 0x78, 0x78, 0xfc, /* 24               */
          0xcf, 0x87, 0x87, 0x8f, 0xfc, 0x78, 0x78, 0xfc, /* 25               */
          0xcf, 0x87, 0x87, 0x8f, 0xfc, 0x78, 0x78, 0xf8, /* 26               */
          0x8f, 0x87, 0x87, 0x8f, 0xfc, 0x78, 0x78, 0xf8, /* 27               */
          0x8f, 0x87, 0x87, 0x8f, 0xf8, 0x78, 0x78, 0xf8, /* 28               */
          0x8f, 0x87, 0x87, 0x87, 0xf8, 0x78, 0x78, 0xf8, /* 29               */
          0x8f, 0x87, 0x87, 0x87, 0xf8, 0x78, 0x78, 0x78, /* 30               */
          0x87, 0x87, 0x87, 0x87, 0xf8, 0x78, 0x78, 0x78, /* 31               */
          0x87, 0x87, 0x87, 0x87, 0x78, 0x78, 0x78, 0x78, /* 32               */
          0x87, 0x87, 0x87, 0x83, 0x78, 0x78, 0x78, 0x78, /* 33               */
          0x87, 0x87, 0x87, 0x83, 0x78, 0x78, 0x78, 0x38, /* 34               */
          0x87, 0x87, 0x87, 0x81, 0x78, 0x78, 0x78, 0x38, /* 35               */
          0x87, 0x87, 0x87, 0x81, 0x78, 0x78, 0x78, 0x18, /* 36               */
          0x87, 0x87, 0x83, 0x81, 0x78, 0x78, 0x78, 0x18, /* 37               */
          0x87, 0x87, 0x83, 0x81, 0x78, 0x78, 0x38, 0x18, /* 38               */
          0x87, 0x87, 0x83, 0x80, 0x78, 0x78, 0x38, 0x18, /* 39               */
          0x87, 0x87, 0x83, 0x80, 0x78, 0x78, 0x38, 0x08, /* 40               */
          0x83, 0x87, 0x83, 0x80, 0x78, 0x78, 0x38, 0x08, /* 41               */
          0x83, 0x87, 0x83, 0x80, 0x38, 0x78, 0x38, 0x08, /* 42               */
          0x83, 0x87, 0x83, 0x00, 0x38, 0x78, 0x38, 0x08, /* 43               */
          0x83, 0x87, 0x83, 0x00, 0x38, 0x78, 0x38, 0x00, /* 44               */
          0x03, 0x87, 0x83, 0x00, 0x38, 0x78, 0x38, 0x00, /* 45               */
          0x03, 0x87, 0x83, 0x00, 0x30, 0x78, 0x38, 0x00, /* 46               */
          0x03, 0x87, 0x03, 0x00, 0x30, 0x78, 0x38, 0x00, /* 47               */
          0x03, 0x87, 0x03, 0x00, 0x30, 0x78, 0x30, 0x00, /* 48               */
          0x03, 0x83, 0x03, 0x00, 0x30, 0x78, 0x30, 0x00, /* 49               */
          0x03, 0x83, 0x03, 0x00, 0x30, 0x38, 0x30, 0x00, /* 50               */
          0x01, 0x83, 0x03, 0x00, 0x30, 0x38, 0x30, 0x00, /* 51               */
          0x01, 0x83, 0x03, 0x00, 0x10, 0x38, 0x30, 0x00, /* 52               */
          0x00, 0x83, 0x03, 0x00, 0x10, 0x38, 0x30, 0x00, /* 53               */
          0x00, 0x83, 0x03, 0x00, 0x00, 0x38, 0x30, 0x00, /* 54               */
          0x00, 0x03, 0x03, 0x00, 0x00, 0x38, 0x30, 0x00, /* 55               */
          0x00, 0x03, 0x03, 0x00, 0x00, 0x30, 0x30, 0x00, /* 56               */
          0x00, 0x01, 0x03, 0x00, 0x00, 0x30, 0x30, 0x00, /* 57               */
          0x00, 0x01, 0x03, 0x00, 0x00, 0x10, 0x30, 0x00, /* 58               */
          0x00, 0x01, 0x01, 0x00, 0x00, 0x10, 0x30, 0x00, /* 59               */
          0x00, 0x01, 0x01, 0x00, 0x00, 0x10, 0x10, 0x00, /* 60               */
          0x00, 0x00, 0x01, 0x00, 0x00, 0x10, 0x10, 0x00, /* 61               */
          0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, /* 62               */
          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, /* 63               */
          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};/* 64               */

/******************************************************************************/
/*  PD00071 : Added the following table for mid to low resolution graphics.   */
/******************************************************************************/

BYTE  greyscale_table2[] = {
          0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /*  0               */
          0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, /*  1               */
          0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x7f, /*  2               */
          0xff, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x7f, /*  3               */
          0xff, 0xf7, 0xff, 0xf7, 0xff, 0x7f, 0xff, 0x7f, /*  4               */
          0xff, 0xf7, 0xfd, 0xf7, 0xff, 0x7f, 0xff, 0x7f, /*  5               */
          0xff, 0xf7, 0xfd, 0xf7, 0xff, 0x7f, 0xdf, 0x7f, /*  6               */
          0xff, 0xf7, 0xdd, 0xf7, 0xff, 0x7f, 0xdf, 0x7f, /*  7               */
          0xff, 0xf7, 0xdd, 0xf7, 0xff, 0x7f, 0xdd, 0x7f, /*  8               */
          0xff, 0xf7, 0xdd, 0x77, 0xff, 0x7f, 0xdd, 0x7f, /*  9               */
          0xff, 0xf7, 0xdd, 0x77, 0xff, 0x7f, 0xdd, 0x77, /* 10               */
          0xff, 0x77, 0xdd, 0x77, 0xff, 0x7f, 0xdd, 0x77, /* 11               */
          0xff, 0x77, 0xdd, 0x77, 0xff, 0x77, 0xdd, 0x77, /* 12               */
          0xfd, 0x77, 0xdd, 0x77, 0xff, 0x77, 0xdd, 0x77, /* 13               */
          0xfd, 0x77, 0xdd, 0x77, 0xdf, 0x77, 0xdd, 0x77, /* 14               */
          0xdd, 0x77, 0xdd, 0x77, 0xdf, 0x77, 0xdd, 0x77, /* 15               */
          0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, /* 16               */
          0xdd, 0x75, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, /* 17               */
          0xdd, 0x75, 0xdd, 0x77, 0xdd, 0x57, 0xdd, 0x77, /* 18               */
          0xdd, 0x55, 0xdd, 0x77, 0xdd, 0x57, 0xdd, 0x77, /* 19               */
          0xdd, 0x55, 0xdd, 0x77, 0xdd, 0x55, 0xdd, 0x77, /* 20               */
          0xdd, 0x55, 0xd5, 0x77, 0xdd, 0x55, 0xdd, 0x77, /* 21               */
          0xdd, 0x55, 0xd5, 0x77, 0xdd, 0x55, 0x5d, 0x77, /* 22               */
          0xdd, 0x55, 0x55, 0x77, 0xdd, 0x55, 0x5d, 0x77, /* 23               */
          0xdd, 0x55, 0x55, 0x77, 0xdd, 0x55, 0x55, 0x77, /* 24               */
          0xdd, 0x55, 0x51, 0x77, 0xdd, 0x55, 0x55, 0x77, /* 25               */
          0xdd, 0x55, 0x51, 0x77, 0xdd, 0x55, 0x15, 0x77, /* 26               */
          0xdd, 0x55, 0x11, 0x77, 0xdd, 0x55, 0x15, 0x77, /* 27               */
          0xdd, 0x55, 0x11, 0x77, 0xdd, 0x55, 0x11, 0x77, /* 28               */
          0xdd, 0x54, 0x11, 0x77, 0xdd, 0x55, 0x11, 0x77, /* 29               */
          0xdd, 0x54, 0x11, 0x77, 0xdd, 0x45, 0x11, 0x77, /* 30               */
          0xdd, 0x44, 0x11, 0x77, 0xdd, 0x45, 0x11, 0x77, /* 31               */
          0xdd, 0x44, 0x11, 0x77, 0xdd, 0x44, 0x11, 0x77, /* 32               */
          0xd9, 0x44, 0x11, 0x77, 0xdd, 0x44, 0x11, 0x77, /* 33               */
          0xd9, 0x44, 0x11, 0x77, 0x9d, 0x44, 0x11, 0x77, /* 34               */
          0x99, 0x44, 0x11, 0x77, 0x9d, 0x44, 0x11, 0x77, /* 35               */
          0x99, 0x44, 0x11, 0x77, 0x99, 0x44, 0x11, 0x77, /* 36               */
          0x99, 0x44, 0x11, 0x76, 0x99, 0x44, 0x11, 0x77, /* 37               */
          0x99, 0x44, 0x11, 0x76, 0x99, 0x44, 0x11, 0x67, /* 38               */
          0x99, 0x44, 0x11, 0x66, 0x99, 0x44, 0x11, 0x67, /* 39               */
          0x99, 0x44, 0x11, 0x66, 0x99, 0x44, 0x11, 0x66, /* 40               */
          0x99, 0x44, 0x11, 0x62, 0x99, 0x44, 0x11, 0x66, /* 41               */
          0x99, 0x44, 0x11, 0x62, 0x99, 0x44, 0x11, 0x26, /* 42               */
          0x99, 0x44, 0x11, 0x42, 0x99, 0x44, 0x11, 0x26, /* 43               */
          0x99, 0x44, 0x11, 0x42, 0x99, 0x44, 0x11, 0x24, /* 44               */
          0x98, 0x44, 0x11, 0x42, 0x99, 0x44, 0x11, 0x24, /* 45               */
          0x98, 0x44, 0x11, 0x42, 0x98, 0x44, 0x11, 0x24, /* 46               */
          0x90, 0x44, 0x11, 0x42, 0x98, 0x44, 0x11, 0x24, /* 47               */
          0x90, 0x44, 0x11, 0x42, 0x09, 0x44, 0x11, 0x24, /* 48               */
          0x90, 0x44, 0x11, 0x40, 0x09, 0x44, 0x11, 0x24, /* 49               */
          0x90, 0x44, 0x11, 0x40, 0x09, 0x44, 0x11, 0x04, /* 50               */
          0x80, 0x44, 0x11, 0x40, 0x09, 0x44, 0x11, 0x04, /* 51               */
          0x80, 0x44, 0x11, 0x40, 0x08, 0x44, 0x11, 0x04, /* 52               */
          0x00, 0x44, 0x11, 0x40, 0x08, 0x44, 0x11, 0x04, /* 53               */
          0x00, 0x44, 0x11, 0x40, 0x00, 0x44, 0x11, 0x04, /* 54               */
          0x00, 0x44, 0x11, 0x00, 0x00, 0x44, 0x11, 0x04, /* 55               */
          0x00, 0x44, 0x11, 0x00, 0x00, 0x44, 0x11, 0x00, /* 56               */
          0x00, 0x44, 0x01, 0x00, 0x00, 0x44, 0x11, 0x00, /* 57               */
          0x00, 0x44, 0x01, 0x00, 0x00, 0x44, 0x10, 0x00, /* 58               */
          0x00, 0x44, 0x00, 0x00, 0x00, 0x44, 0x10, 0x00, /* 59               */
          0x00, 0x44, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, /* 60               */
          0x00, 0x40, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, /* 61               */
          0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, /* 62               */
          0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, /* 63               */
          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};/* 64               */

/**********************************************************************/
/* PD00474 : PolyScanLine speed up.                                   */
/**********************************************************************/
ULONG alDwordMask[33] =
{
         0xFFFFFFFF, 0xFFFFFF7F, 0xFFFFFF3F, 0xFFFFFF1F,
         0xFFFFFF0F, 0xFFFFFF07, 0xFFFFFF03, 0xFFFFFF01,
         0xFFFFFF00, 0xFFFF7F00, 0xFFFF3F00, 0xFFFF1F00,
         0xFFFF0F00, 0xFFFF0700, 0xFFFF0300, 0xFFFF0100,
         0xFFFF0000, 0xFF7F0000, 0xFF3F0000, 0xFF1F0000,
         0xFF0F0000, 0xFF070000, 0xFF030000, 0xFF010000,
         0xFF000000, 0x7F000000, 0x3F000000, 0x1F000000,
         0x0F000000, 0x07000000, 0x03000000, 0x01000000,
         0x00000000
};
