/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDBCTAB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_WINPOINTERS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdbcone.h>

#define NO_SYS
#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP
#undef PRDMTYPE_INCL

/**********************************************************************/
/* Internal 1 bpp -> External 4 bpp Colour Conversion table           */
/*                                                                    */
/* This table converts 4 pels (= 1 nibble) at a time. It uses the     */
/* conversion 0 -> 0000 = 0x0                                         */
/*            1 -> 1111 = 0xF                                         */
/* As we write a USHORT at a time, we need to store the table in      */
/* a flipped format.                                                  */
/**********************************************************************/

USHORT ConvertTablei1toe4[16] = {0x0000U, 0x0F00U, 0xF000U, 0xFF00U,
                                 0x000FU, 0x0F0FU, 0xF00FU, 0xFF0FU,
                                 0x00F0U, 0x0FF0U, 0xF0F0U, 0xFFF0U,
                                 0x00FFU, 0x0FFFU, 0xF0FFU, 0xFFFFU};

/**********************************************************************/
/* Internal 1 bpp -> External 8 bpp Colour Conversion table           */
/*                                                                    */
/* This table converts 4 pels (= 1 nibble) at a time. It uses the     */
/* conversion 0 -> 00000000 = 0x00                                    */
/*            1 -> 11111111 = 0xFF                                    */
/* As we write a ULONG at a time, we need to store the table in a     */
/* completely byte reversed format.                                   */
/*                                                                    */
/**********************************************************************/
ULONG ConvertTablei1toe8[16] ={0x00000000UL, 0xFF000000UL, 0x00FF0000UL,
                               0xFFFF0000UL, 0x0000FF00UL, 0xFF00FF00UL,
                               0x00FFFF00UL, 0xFFFFFF00UL, 0x000000FFUL,
                               0xFF0000FFUL, 0x00FF00FFUL, 0xFFFF00FFUL,
                               0x0000FFFFUL, 0xFF00FFFFUL, 0x00FFFFFFUL,
                               0xFFFFFFFFUL};

/**********************************************************************/
/* Internal 4 bpp -> External 1 bpp Colour Conversion table           */
/*                                                                    */
/* This table converts from the internal 4 bpp format (which only     */
/* uses colours 0 to 7) to external 1 bpp format. This is done by     */
/* simply thresholding all of the internal colours, to see if they    */
/* are closest to white or black.  This table will be evaluated at    */
/* compile time.                                                      */
/*                                                                    */
/* The threshold value is carefully chosen so that 0x808080 just      */
/* maps to black.  The color table returned for a 1 bpp format bitmap */
/* is always black 0 and white 1.                                     */
/**********************************************************************/
BYTE ConvertTablei4toe1[8] = {
        ((DVT8Col0Red + DVT8Col0Green + DVT8Col0Blue) / 385),
        ((DVT8Col1Red + DVT8Col1Green + DVT8Col1Blue) / 385),
        ((DVT8Col2Red + DVT8Col2Green + DVT8Col2Blue) / 385),
        ((DVT8Col3Red + DVT8Col3Green + DVT8Col3Blue) / 385),
        ((DVT8Col4Red + DVT8Col4Green + DVT8Col4Blue) / 385),
        ((DVT8Col5Red + DVT8Col5Green + DVT8Col5Blue) / 385),
        ((DVT8Col6Red + DVT8Col6Green + DVT8Col6Blue) / 385),
        ((DVT8Col7Red + DVT8Col7Green + DVT8Col7Blue) / 385)};


/**********************************************************************/
/* Set up a scratchpad for parameter passing inside PRDBINEX and      */
/* PRDBEXIN                                                           */
/**********************************************************************/
/*       BMConvertScratch SPad;    PD00400 :Now is allocated heapspace*/




















