/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDAKERN
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prda_GetKerningPairTable
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* conv to C/SET2  CON3201 */
#define INCL_DOSPROCESS                 /* conv to C/SET2  CON3201 */
#define INCL_DOSSEMAPHORES              /* conv to C/SET2  CON3201 */
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#define INCL_DOSMISC
#include <os2.h>
#undef INCL_DOSSEMAPHORES
#undef INCL_DOSPROCESS                 /* conv to C/SET2  CON3201 */
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS
#undef INCL_DOSMISC

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* conv to C/SET2  CON3201 */

#include <prddcone.h>

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdaextf.h>

extern PFNL da_GetKerningPairTable;

#ifdef DDT_KERNING_ENABLED



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prda_GetKerningPairTable                               */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC          DcH;                                              */
/*   ULONG          ArgCount;                                         */
/*   lpKerningPair  ArgKernPairs;                                     */
/*   lpDCI          DCIData;                                          */
/*   ULONG          FunN;                                             */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function returns the kerning pairs for the current font as  */
/*   an array at ArgKernPairs.                                        */
/*                                                                    */
/*   Warning .. old code, driver does not hook this function now.     */
/*                                                                    */
/**********************************************************************/
/*   CON3201 convert to C/SET2                                        */

ULONG prda_GetKerningPairTable ( HDC            DcH,
                                 ULONG          ArgCount,
                                 lpKerningPair  ArgKernPairs,
                                 lpDCI          DCIData,
                                 ULONG          FunN )

{
#define TFUNC "prda_GetKernTab"

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT             Count;          /* Number of kern pairs        */
    lpFontDataType     pFontData;      /* Information about the font  */
    lpKerningPair      lpKernPairs;    /* Pointer to kerning pairs    */
    lpKerningTable     lpKernTable;    /* Pointer to kerning pairs    */
    USHORT             entry;          /* Loop variable               */
    USHORT             Version;        /* PM Version Number           */
    USHORT             KernPairs;

    TRACE8(TFUNC, "ArgCount", &ArgCount, 1);
    TRACE8(TFUNC, "&ArgKernPairs", &ArgKernPairs, 1);
    TRACE8(TFUNC, "DcH", &DcH, 1);
    TRACE8(TFUNC, "FunN", &FunN, 1);

    /******************************************************************/
    /* PD00075 : The OS1.3 GetKerningPairTable function traps if this */
    /* function is not hooked by the driver. So never return for      */
    /* simulation. Instead, return zero kerning pairs - there are no  */
    /* kerned device fonts. If system fonts are kerned, the kerning   */
    /* would no have worked, due to the trap in the OS GetKPTable.    */
    /*                                                                */
    /* 5/9/91 Update: the simulation only traps for device fonts.     */
    /******************************************************************/

    /******************************************************************/
    /* PD00121 : log a warning if invalid parameter.                  */
    /******************************************************************/
    if ((LONG)ArgCount < 0)
    {
        LOGWARNING(TFUNC, "Bad Count", FNULL, 0,
                                           PMERR_INV_LENGTH_OR_COUNT);
        return(ERROR_NEG);
    }

    prdm_EnterDriver(DCIData);
    if ( !(DCIData->DCICurTxtAts->cdef.fFlags & CDEF_GENERIC) )
    {
        /**************************************************************/
        /* Device fonts cause trap in the engine function. There are  */
        /* no kerning pairs, so return zero.                          */
        /**************************************************************/
        prdm_LeaveDriver(DCIData);
        return(0);
    }
    /* Remove version check for 32-bit conversion          CON3201   */
#if 0
//  /******************************************************************/
//  /* Get the OS version                                             */
//  /******************************************************************/
//  if (DOS_OK != DosGetVersion(&Version))
//  {
//      TRACE4(TFUNC, "DosGetVersion Error", &Version, 1);
//      prdm_LeaveDriver(DCIData);
//      return(ERROR_NEG);
//  }
//
//
//  /******************************************************************/
//  /* OS/2 v 1.3 now works here, so return for simulation.           */
//  /* For v 1.2, handle the call in the driver.                      */
//  /******************************************************************/
//  if ((HIBYTE(Version) > 10) || (LOBYTE(Version) >= 30))
//  {
#endif
        prdm_LeaveDriver(DCIData);
        return( da_GetKerningPairTable  (DcH,
                                         ArgCount,
                                         ArgKernPairs,
                                         DCIData,
                                         FunN ));

    /* following is 1.2 code - remove for 32 bit conversion  CN3201  */
#if 0
//  }
//
//  pFontData = &DCIData->DCIFontData;
//
//  /******************************************************************/
//  /* Get number of kerning pairs from the metrics.                  */
//  /******************************************************************/
//  KernPairs = pFontData->pMetrics->usKerningPairs;
//
//  /******************************************************************/
//  /* Set count to number of pairs to return (ensure we don't read   */
//  /* past the end of the table) and return if we don't need to      */
//  /* fetch any.                                                     */
//  /******************************************************************/
//  Count = min( (USHORT)ArgCount, KernPairs);
//
//  if (Count == 0)
//  {
//      prdm_LeaveDriver(DCIData);
//      return(0);
//  }
//
//  lpKernTable = (lpKerningTable)
//             ((PBYTE)pFontData->pHeader + pFontData->pHeader->ulSize);
//
//  if (lpKernTable->Identity != 3)
//  {
//      /**************************************************************/
//      /* Invalid kerning pair table: ignore.                        */
//      /**************************************************************/
//      prdm_LeaveDriver(DCIData);
//      return(0);
//  }
//
//  /******************************************************************/
//  /* Set lpKern to point to the first kern pair in the table of     */
//  /* kern pairs.                                                    */
//  /******************************************************************/
//  lpKernPairs = (lpKerningPair)(&lpKernTable->Pairs);
//
//  /******************************************************************/
//  /* Copy the kerning information for the font to the array at      */
//  /* ArgKernPairs.                                                  */
//  /******************************************************************/
//  for ( entry = 0; entry < Count; entry++ )
//  {
//      ArgKernPairs[entry].Char1      = lpKernPairs[entry].Char1;
//      ArgKernPairs[entry].Char2      = lpKernPairs[entry].Char2;
//      ArgKernPairs[entry].KernAmount = lpKernPairs[entry].KernAmount;
//  }
//
//  prdm_LeaveDriver(DCIData);
//  /******************************************************************/
//  /* return number of pairs found.                                  */
//  /******************************************************************/
//  return (Count);
#endif
}

#undef TFUNC

#endif /* ifdef DDT_KERNING_ENABLED */
