/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDZTRCF
 *
 * DESCRIPTIVE NAME = Printer Device Driver Trace and Error Logging
 *                    Macro definitions.
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define TRACE4(S,C,P,N)
#define TRACE6(S,C,P,N)
#define TRACE8(S,C,P,N)
/*
extern USHORT far pascal prdz_Init( BOOL );
extern VOID far pascal prdz_Term();
*/
extern USHORT prdz_Init( BOOL );                                   /* CON3201 */
extern VOID prdz_Term();                                           /* CON3201 */

#ifdef DEBUG_SEGMENTS

/* CON3201
**USHORT pascal far prdz_SSALLOC( USHORT, PUSHORT, USHORT, PCHAR );
**USHORT pascal far prdz_SSALLOCHUGE( USHORT, USHORT, PUSHORT,
**                                    USHORT, USHORT, PCHAR );
**USHORT pascal far prdz_SSFREE( USHORT, PCHAR );
*/

ULONG  prdz_SSALLOC( PVOID, ULONG, ULONG, PCHAR );                 /* CON3201 */
ULONG prdz_SSFREE( PVOID, PCHAR );                                 /* CON3201 */

/* CON3201
#define SSALLOCSEG(X, Y, Z)        prdz_SSALLOC((X), (Y), (Z), TFUNC)
#define SSFREESEG(X)               prdz_SSFREE( (X), TFUNC)
#define SSALLOCHUGE(X, Y, Z, T, U) prdz_SSALLOCHUGE((X),(Y),(Z),(T),(U),TFUNC)
*/

#define SSALLOCMEM(X, Y, Z)        prdz_SSALLOC((X), (Y), (Z), TFUNC)
#define SSFREEMEM(X)               prdz_SSFREE( (X), TFUNC)
#define SSALLOCHUGE(X, Y, Z, T, U) prdz_SSALLOCHUGE((X),(Y),(Z),(T),(U),TFUNC)

#else

/* CON3201
#define SSALLOCSEG(X,Y,Z)       SSAllocSeg(X,Y,Z)
#define SSFREESEG(X)            SSFreeSeg(X)
#define SSALLOCHUGE(X,Y,Z,T,U)  SSAllocHuge(X,Y,Z,T,U)
*/

#define SSALLOCMEM(X,Y,Z)       SSAllocMem(X,Y,Z)           /* CON3201 */
#define SSFREEMEM(X)            SSFreeMem(X)                       /* CON3201 */
#define SSALLOCHUGE(X,Y,Z,T,U)  SSAllocMem(X,Y,Z)                  /* CON3201 */

#endif /* debug_segments */

/**********************************************************************/
/* TRACE macros                                                       */
/**********************************************************************/

#ifdef PRD_TRACE
#if (PRD_TRACE != 0)
/*
extern void far pascal prdz_Trace(PBYTE,PBYTE,PBYTE,USHORT);
*/
extern void prdz_Trace(PBYTE,PBYTE,PBYTE,USHORT);          /* CON3201 */

#if (PRD_TRACE <= 4)
#undef  TRACE4
#define TRACE4(S,C,P,N) prdz_Trace((PBYTE)(S),(PBYTE)(C), \
                                   (PBYTE)(P),(USHORT)(N))
#endif

#if (PRD_TRACE <= 6)
#undef  TRACE6
#define TRACE6(S,C,P,N) prdz_Trace((PBYTE)(S),(PBYTE)(C), \
                                   (PBYTE)(P),(USHORT)(N))
#endif

#if (PRD_TRACE <= 8)
#undef  TRACE8
#define TRACE8(S,C,P,N) prdz_Trace((PBYTE)(S),(PBYTE)(C), \
                                   (PBYTE)(P),(USHORT)(N))
#endif

#if (PRD_TRACE <= 12)
#undef  TRACE12
#define TRACE12(S,C,P,N) prdz_Trace((PBYTE)(S),(PBYTE)(C), \
                                   (PBYTE)(P),(USHORT)(N))
#endif

#endif
#endif


/**********************************************************************/
/* LOGERR Macros                                                      */
/**********************************************************************/
#ifdef PRD_DEBUG
    /*  extern void far pascal prdz_LogErr(PBYTE,PBYTE,USHORT); */
        extern void prdz_LogErr(PBYTE,PBYTE,USHORT);       /* CON3201 */
#define LOGERR(S,C,P,N,E)                                              \
        prdz_LogErr(S,C,E)
#else /* ndef PRD_DEBUG */
#define LOGERR(S,C,P,N,E)                                              \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,E),                \
                        SEI_NOBEEP|SEI_NOPROMPT)
#endif /* ndef PRD_DEBUG */

#define LOGWARNING(S,C,P,N,E)                                          \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_WARNING,E),               \
                        SEI_NOBEEP|SEI_NOPROMPT)

#ifdef PRD_DEBUG
     /* extern void far pascal prdz_LogDosErr(PBYTE,PBYTE,USHORT); */
        extern void prdz_LogDosErr(PBYTE,PBYTE,USHORT);    /* CON3201 */
#define LOGDOSERR(S,C,P,N,E)                                           \
        prdz_LogDosErr(S,C,E)
#else /* ndef PRD_DEBUG */
#define LOGDOSERR(S,C,P,N,E)                                           \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,PMERR_BASE_ERROR), \
                        SEI_NOBEEP|SEI_NOPROMPT|SEI_DOSERROR,          \
                        E)
#endif /* ndef PRD_DEBUG */


#define RIP(S,C,P,N,E)                                                 \
        {DebugOutput(S);                                               \
         DebugOutput(C);                                               \
         WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,1),               \
                         SEI_REGISTERS|SEI_STACKTRACE,                 \
                         C)                                            \
        }


/**********************************************************************/
/* Debug constants...                                                 */
/**********************************************************************/
#define  DECIMAL    0x01
#define  HEX        0x02
#define  BINARY     0x04

#ifdef PRD_DEBUG
/*
VOID FAR PASCAL CrLf(VOID);
VOID FAR PASCAL OutputValue(ULONG, USHORT);
VOID FAR PASCAL OutputValueLen(ULONG, USHORT, USHORT);
VOID FAR PASCAL OutputPair(PCHAR,ULONG,USHORT);
VOID FAR PASCAL OutputString(PCHAR);
VOID FAR PASCAL OutputStringNoCRLF(PCHAR);
VOID FAR PASCAL OutputPrompt(PCHAR);
*/
VOID CrLf(VOID);                                           /* CON3201 */
VOID OutputValue(ULONG, USHORT);                           /* CON3201 */
VOID OutputValueLen(ULONG, USHORT, USHORT);                /* CON3201 */
VOID OutputPair(PCHAR,ULONG,USHORT);                       /* CON3201 */
VOID OutputString(PCHAR);                                  /* CON3201 */
VOID OutputStringNoCRLF(PCHAR);                            /* CON3201 */
VOID OutputPrompt(PCHAR);                                  /* CON3201 */

#else
/*
extern VOID FAR PASCAL   CrLf();
extern VOID FAR PASCAL   OutputValue(ULONG, USHORT);
extern VOID FAR PASCAL   OutputValueLen(ULONG, USHORT, USHORT);
extern VOID FAR PASCAL   OutputPair(PCHAR, ULONG, USHORT);
extern VOID FAR PASCAL   OutputString(PCHAR);
extern VOID FAR PASCAL   OutputStringNoCRLF(PCHAR);
extern VOID FAR PASCAL   OutputPrompt(PCHAR);
*/
extern VOID   CrLf();                                      /* CON3201 */
extern VOID   OutputValue(ULONG, USHORT);                  /* CON3201 */
extern VOID   OutputValueLen(ULONG, USHORT, USHORT);       /* CON3201 */
extern VOID   OutputPair(PCHAR, ULONG, USHORT);            /* CON3201 */
extern VOID   OutputString(PCHAR);                         /* CON3201 */
extern VOID   OutputStringNoCRLF(PCHAR);                   /* CON3201 */
extern VOID   OutputPrompt(PCHAR);                         /* CON3201 */

/* CON3201 Already defined in PMWINP.H
#define DebugOutput(X)
*/
extern BOOL DebugOn;
extern BOOL WaitForKey;

#endif
/*
extern SHORT FAR PASCAL prdz_ProfileInit( ULONG );
extern SHORT FAR PASCAL prdz_ProfileTerm( ULONG );
*/
extern SHORT prdz_ProfileInit( ULONG );                    /* CON3201 */
extern SHORT prdz_ProfileTerm( ULONG );                    /* CON3201 */

