/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDTTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver Types for Text and
 *                    Markers
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Structure definition for Font Metrics File type.                   */
/**********************************************************************/
typedef struct
    {
        BYTE                     FMFName[FILENAME_SIZE];
        FOCAMETRICS              Metrics;
        USHORT                   WidthFlag;
        BYTE                     DriverType;
        BYTE                     PrinterType;
        FONTDEFINITIONHEADER     FontHeader;
        USHORT                   CharWidth[256];
    } FMFFileStrucType;
/*
typedef FMFFileStrucType far * lpFMFFileStruc;
*/
typedef FMFFileStrucType * lpFMFFileStruc;                 /* CON3201 */


/**********************************************************************/
/* Structure definition for CpEntryType                               */
/**********************************************************************/
typedef struct
    {
        SHORT            Cp;            /* Codepage (e.g. 437)        */
        BYTE             NoChangeBytes; /* Number of bytes in metrics */
                                        /* that change                */
        BYTE             ChangeString[1];/*Array of bytes in pairs:   */
                                         /* index into FMF and value  */
    } CpEntryType;


/**********************************************************************/
/* Structure definition for MultiCp Structure Type                    */
/**********************************************************************/
typedef struct
    {
        SHORT                    UWLLength;  /* Length of UWL         */
        PBYTE                    UWLPtr;     /* Pointer to UWL        */
        SHORT                    NumCps;     /* Number of Codepages   */
                                             /* supported by this FMF */
     /* CpEntryType far *        pCpEntry[1];   array of pointers to  */
                                                           /* CON3201 */
        CpEntryType *            pCpEntry[1];/* array of pointers to  */
                                             /* codepage entries      */
    } MultiCpType;
/*
typedef MultiCpType far * lpMultiCpType;
*/
typedef MultiCpType * lpMultiCpType;                       /* CON3201 */


typedef struct
    {
        USHORT           BaseMatchNo;
        BYTE             EngineAttrs;
        BYTE             CPIndex;
    } LCIDType;

/*
typedef LCIDType far *lpLCIDType;
*/
typedef LCIDType *lpLCIDType;                              /* CON3201 */


typedef struct
    {
        USHORT           flAttrs;
        USHORT           usFGIDBold;
        USHORT           usFGIDItalic;
        USHORT           usFGIDItalicBold;
    } EngineAttributeType;
/*
typedef EngineAttributeType far * lpEngAttrsType;
*/
typedef EngineAttributeType * lpEngAttrsType;              /* CON3201 */


/**********************************************************************/
/* Structure definition for Resident Font list type.                  */
/**********************************************************************/
typedef struct
    {
        ULONG            ResourceId;  /* Resource Id for FMF          */
        lpFMFFileStruc   pFMFData;    /* Base font FMF pointer        */
        lpMultiCpType    pMultiCp;    /* MultiCp font FMF pointer     */
        lpEngAttrsType   pEngAttrs;   /* Pointer to Engine Attributes */
        USHORT           SelectionId; /* DCT_SELECT_FONT parameter    */
        USHORT           GlobalId;    /* Set Font Global parameter    */
        USHORT           PreDCTCmd;   /* Pre printer escape seqn.     */
        USHORT           PostDCTCmd;  /* Post printer escape seqn.    */
        USHORT           NumAttrs;    /* Number of attributes         */
        USHORT           Attrs;       /* Attribute bit flags          */
        USHORT           CodePage;    /* Code page           PD00220  */
        lpFMFFileStruc   pItalicFMF;  /* Italic font FMF pointer PD00265 */
    } FontListType;
/*
typedef FontListType far *lpFontListType;
*/
typedef FontListType *lpFontListType;                      /* CON3201 */
/*
typedef lpFontListType far *lplpFontListType;
*/
typedef lpFontListType *lplpFontListType;                  /* CON3201 */


/**********************************************************************/
/* Structure definition for Code Page Font list type.                 */
/**********************************************************************/
typedef struct
    {
        USHORT           ResourceId;  /* Resource Id for FMF          */
        USHORT           FMFUseFlag;  /* Dummy or Real FMF            */
        lpFMFFileStruc   pFMFData;    /* FMF pointer                  */
    } FontCPListType;
/*
typedef FontCPListType far *lpFontCPListType;
*/
typedef FontCPListType *lpFontCPListType;                  /* CON3201 */
/*
typedef lpFontCPListType far *lplpFontCPListType;
*/
typedef lpFontCPListType *lplpFontCPListType;              /* CON3201 */


/**********************************************************************/
/* Structure definition for Font Info type.                           */
/*                                                                    */
/* - Only the first two structure elements are used for non-device    */
/*   (i.e. engine and marker) fonts.                                  */
/*                                                                    */
/* - pFont contains a pointer to a structure whose type varies        */
/*   with the font type:                                              */
/*     device font ..... lpFMFFileStruc                               */
/*     engine font ..... PFOCAFONT                                    */
/*     marker font ..... MarkerFontType                               */
/*                                                                    */
/* - CodePageNo is only set and used for code page and resident fonts */
/*   in the Pro Driver.                                               */
/**********************************************************************/
typedef struct
    {
        lpFMFFileStruc   pFont;       /* FMF pointer - contains       */
                                      /* metrics for the base version */
                                      /* of the font                  */
        USHORT           Type;        /* Resident, Code Page, Card,   */
                                      /* Download, Engine or Marker   */
        USHORT           Index;       /* Index of font into list of   */
                                      /* its own type (or into its    */
                                      /* own code page if Code Page   */
                                      /* font)                        */
        USHORT           CodePageNo;  /* Code Page - this is an index */
                                      /* into DVTCodePageList, not    */
                                      /* the code page number itself  */
                                      /* (i.e. 0 not 437) - it is     */
                                      /* only used for code page      */
                                      /* fonts                        */
        USHORT           Attr;        /* Attribute code (see FATT_*   */
                                      /* values set up in TCONE.H)    */
        LCIDType         LCID;        /* Match number 4-bytes         */
        lpMultiCpType    pMultiCp;    /* Pointer for MultiCp font FMF */
    } FontInfoType;
/*
typedef FontInfoType far *lpFontInfoType;
*/
typedef FontInfoType *lpFontInfoType;                      /* CON3201 */
/*
typedef lpFontInfoType far *lplpFontInfoType;
*/
typedef lpFontInfoType *lplpFontInfoType;                  /* CON3201 */


/**********************************************************************/
/* Structure definition for Code Point type.                          */
/*                                                                    */
/* - Only CodePoint, Width, Height and BaseOffset and their WorkCoord */
/*   equivalents are set up and used for device fonts.                */
/*                                                                    */
/* - Increment is set up for non-device fonts but is not currently    */
/*   used ( 21/8/90 ).                                                */
/*                                                                    */
/* - If the font is an ABC-spaced (engine) font then Width is set to  */
/*   ASpace + BSpace + CSpace.                                        */
/*                                                                    */
/* - WorkCoord fields are not used for non-device fonts.              */
/*                                                                    */
/* - For device fonts, WorkCoords are either COORD_FONT or            */
/*   COORD_WORLD.                                                     */
/*                                                                    */
/* - For device fonts, Width, Height and BaseOffset are always in     */
/*   FontCoords and reflect actual character size - used for clipping.*/
/*   Their WorkCoord equivalents reflect the size of the bounding box */
/*   and are used for positioning (cf mode 2 raster fonts).           */
/*                                                                    */
/**********************************************************************/
typedef struct
    {
        USHORT            CodePoint;
        USHORT            Width;
        USHORT            Height;
        USHORT            BaseOffset;
        USHORT            WorkCoords;
        ULONG             WidthInWorkCoords;
        ULONG             HeightInWorkCoords;
        ULONG             BaseOffsetInWorkCoords;
        USHORT            Increment;
        USHORT            ASpace;
        USHORT            BSpace;
        USHORT            CSpace;
        PBYTE             Defn;
    } CodePointType;
/*
typedef CodePointType far *lpCodePointType;
*/
typedef CodePointType *lpCodePointType;                    /* CON3201 */


/**********************************************************************/
/* Structure definition for ResAdj type.                              */
/**********************************************************************/
typedef struct
    {
        USHORT            FontResX;
        USHORT            FontResY;
        USHORT            DeviceResX;
        USHORT            DeviceResY;
    } ResAdjType;
/*
typedef ResAdjType far *lpResAdjType;
*/
typedef ResAdjType *lpResAdjType;                          /* CON3201 */


/**********************************************************************/
/* Structure definition for Font Data type.                           */
/*                                                                    */
/* - Genre indicates whether this is a device font or not, for        */
/*   device fonts pFontData in the Info structure is a pointer to a   */
/*   FMF.                                                             */
/*                                                                    */
/* - pHeader and CodeTable are not set up or used for device fonts.   */
/**********************************************************************/
typedef struct
    {
        PFOCAMETRICS           pMetrics;
        FontInfoType           Info;
        USHORT                 Genre;
        BOOL                   Simulated;
        CodePointType          CPtInfo;
        PFONTDEFINITIONHEADER  pHeader;
        PUSHORT                CodeTable;
        ResAdjType             ResAdj;
        FIXED                  NHFSFixed;
        FIXED                  NVFSFixed;
        USHORT                 Shear;
    } FontDataType;
/*
typedef FontDataType far *lpFontDataType;
*/
typedef FontDataType *lpFontDataType;                      /* CON3201 */

/**********************************************************************/
/* Four points of rectangle                          PD00073          */
/**********************************************************************/

typedef struct
    {
        POINTL BottomLeft;
        POINTL TopLeft;
        POINTL BottomRight;
        POINTL TopRight;
    } FOURPOINTL;
/*
typedef FOURPOINTL far *PFOURPOINTL;
*/
typedef FOURPOINTL *PFOURPOINTL;                           /* CON3201 */

/**********************************************************************/
/* Type definition for GPI TextBand Entries.                          */
/* All x coord values are held in font coords; y coords in device.    */
/*                                                                    */
/* NHFS and NVFS are used for the Font Selection Command for          */
/* outline fonts.                                                     */
/**********************************************************************/
typedef struct GTBtag
   {
     /* struct GTBtag far * GTBNextEntry;    Pointer to next entry    */
                                                           /* CON3201 */
        struct GTBtag     * GTBNextEntry; /* Pointer to next entry    */
        POINTS              GTBTxtPos;
        POINTS              GTBTxtEnd;
        USHORT              GTBNumCdPts;
        BYTE                GTBFgClr;
        BYTE                GTBBkClr;
        FontInfoType        GTBInfo;
        USHORT              GTBCodePage;
        USHORT              GTBRegistryId;
        USHORT              GTBFontSize;
        FIXED               GTBNHFS;
        FIXED               GTBNVFS;
        USHORT              GTBShear;
        USHORT              GTBAngle;              /* PD00073            */
        USHORT              GTBCharPosAlloc;
        PLONG               GTBCharStartPos;     /* PD00076                   */
        PSHORT              GTBCharEndPos;
        PFOURPOINTL         GTBStrike;           /* array; PD00073            */
        USHORT              GTBCharMode;         /* PD00670 CM_MODEx x=1,2,3  */
        BYTE                GTBFontSizeType;     /* PD00073 moved to here     */
        CHAR                GTBCdPts[1];         /* NOTE !!!!! This field is  */
                                                 /* in fact used as an array  */
                                                 /* of 'n' codepoints and not */
                                                 /* just one as declared here */
    } GPITextBandEntry;
/*
typedef GPITextBandEntry far *lpGTBEntry;
*/
typedef GPITextBandEntry *lpGTBEntry;                      /* CON3201 */

#define GTB_ENTRY_SIZE        sizeof(GPITextBandEntry)

/**********************************************************************/
/* Structure definition for attributes passed to prdt_TextOut???Font. */
/**********************************************************************/
typedef struct
    {
        USHORT      ForeColor;
        USHORT      ForeMix;
        USHORT      BackColor;
        USHORT      BackMix;
    } TextAttrsType;
/*
typedef TextAttrsType far *lpTextAttrsType;
*/
typedef TextAttrsType *lpTextAttrsType;                    /* CON3201 */

/**********************************************************************/
/* Marker font type.                                                  */
/**********************************************************************/
typedef struct
    {
        FOCAFONT     Font;
        ULONG        Offsets[12];
        BYTE         Defn[96];
    } MarkerFontType;


#ifdef DDT_KERNING_ENABLED
/**********************************************************************/
/* Type definition for kerning pairs                                  */
/**********************************************************************/
typedef struct
    {
        USHORT           Char1;
        USHORT           Char2;
        USHORT           KernAmount;
    } KerningPairType;
/*
typedef KerningPairType far *lpKerningPair;
*/
typedef KerningPairType *lpKerningPair;                    /* CON3201 */

typedef struct
    {
        ULONG            Identity;
        ULONG            Size;
        KerningPairType  Pairs;
    } KerningTableType;
/*
typedef KerningTableType far *lpKerningTable;
*/
typedef KerningTableType *lpKerningTable;                  /* CON3201 */
#endif

/**********************************************************************/
/* Structure definition for MultiCp Font Metrics File type.           */
/**********************************************************************/


#pragma pack(1)
typedef struct
    {
        BYTE                     FMFName[FILENAME_SIZE];
        FOCAMETRICS              Metrics;
        USHORT                   WidthFlag;
        BYTE                     DriverType;
        BYTE                     PrinterType;
        USHORT                   FGIDBold;
        USHORT                   FGIDItalic;
        USHORT                   FGIDBoldItalic;
        BYTE                     NumCodepages;
        USHORT                   FirstCodepage;
    } MultiCpFMFFileStrucType;

#pragma pack()

/*
typedef MultiCpFMFFileStrucType far * lpMultiCpFMFFileStruc;
*/
typedef MultiCpFMFFileStrucType * lpMultiCpFMFFileStruc;   /* CON3201 */

/*********************************************************************/
/* Structure for each entry in the CodePageUse table                 */
/*********************************************************************/
typedef struct
    {
        USHORT     usTargetCP;
        USHORT     RootCPList[3];
    } CPTUseTableEntry;

/**********************************************************************/
/* Structure for each entry in the CodePageMapTable                   */
/**********************************************************************/
typedef struct
    {
        USHORT     usRootCP;
        USHORT     usSize;
        PSHORT     TranslateTable;
    } CPTMappingTableEntry;



typedef struct
    {
        PBYTE      DeviceName;
        HMTX      ControlSemaphore;   /* CON3201 : changed to HMTX */
    } DeviceSemTableEntry;
/*
typedef DeviceSemTableEntry far *DeviceSemTable;
*/
typedef DeviceSemTableEntry *DeviceSemTable;               /* CON3201 */

/**********************************************************************/
/* Structure for String Info for outline fonts       PD00073          */
/**********************************************************************/
typedef struct
    {
        PPOINTL                  pCharPos;       /* Array of char  positions */
        FOURPOINTL               Box;            /* Bounding textbox of str  */
        PFOURPOINTL              pCell;          /* Array of character cells */
        PFOURPOINTL              pStrk;          /* Array of strikeout rects */
        PFOURPOINTL              pUndl;          /* Array of underline rects */
        POINTL                   EndPosition;    /* End position of string   */
        USHORT                   TotalPoints;
    } StringInfoType;
/*
typedef StringInfoType far *lpStringInfoType;
*/
typedef StringInfoType *lpStringInfoType;                  /* CON3201 */

/**********************************************************************/
/* Structure for character cell  Info for outline fonts       PD00073 */
/**********************************************************************/
typedef struct
    {
        LONG                  Width;          /* Cell width               */
        LONG                  Height;         /* total cell height        */
        LONG                  BaseOffset;     /* offset from bottom of    */
                                              /* cell to char baseline    */
        LONG                  StrkBottom;     /* Strikeout position bottom*/
        LONG                  StrkTop;        /* Top of Strikeout Rect    */
        LONG                  UndlBottom;     /* Underline position bottom*/
        LONG                  UndlTop;        /* Top of Underline Rect    */
        LONG                  emHeight;       /* used for positioning in  */
                                              /* CHDIRN_TOP/BOTTOM        */
        LONG                  StrikeBottomDev;/* Strikeout- offsets in dev*/
        LONG                  StrikeTopDev;   /* coordinates. these       */
                                              /* include the charbox sign */
        BOOL                  FixedSpace;     /* flag indicating fixed    */
                                              /*  space                   */
    } CellInfoType;
/*
typedef CellInfoType far *lpCellInfoType;
*/
typedef CellInfoType *lpCellInfoType;                      /* CON3201 */
