/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDPTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver Printer Control types
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Type definitions for Printer Control.                              */
/**********************************************************************/
typedef struct
{
    PBYTE           FormInfoPtr;       /* Ptr to string with units    */
                                       /* and dimensions              */
    ULONG           TopMargin;         /* from SourceInfo             */
    USHORT          FormNumber;        /* Form number                 */
    BYTE            FeedTechnique;     /* Used for feeding the form   */
                                       /*   (PFT_ parameter)          */
    BYTE            FormControl;       /* Type of form sheet/envelope */
                                       /*   (FC_ parameter)           */
    BYTE            SourceDrawer;      /* Source drawer to use        */
                                       /*   (SD_ parameter)           */
    BYTE            FormId;            /* Form id used for 4019       */
                                       /*   printers                  */
    BYTE            FormName[33];      /* Name used for prompting if  */
                                       /* manual form                 */
} PPMInfoType;

typedef PPMInfoType  *lpPPMInfoType;

typedef struct
{
    ULONG       LastMatchNo;           /* Most recent font match no   */
    USHORT      LastFontId;            /* Most recent printer font id */
                                       /* (as used in Esc I n)        */
    USHORT      LastCodePageNo;        /* Most recent font code page  */
                                       /* number (as used in Set Code */
                                       /* Page)                       */
    USHORT      LastColour;            /* Most recent colour setting  */
                                       /* (4224 - C2 only)            */
    FIXED       LastHeight;            /* | Most recent size settings */
    FIXED       LastWidth;             /* | (outline fonts only)      */
    USHORT      LastShear;             /* | (outline fonts only)      */
    USHORT      LastAngle;             /* | (outline fonts only)      */
} FontSettingsType;

typedef FontSettingsType *lpFontSettingsType;

/**********************************************************************/
/* Structure definition for Default Font Info type.                   */
/**********************************************************************/
typedef struct
    {
        FontInfoType    Info;
        USHORT          IndexInCard;   /* Index of font in the card   */
        tCard           CardName;
    } DfltFontInfoType;

typedef DfltFontInfoType *lpDfltFontInfoType;

/* CON3201 moved from PRDGPART.H:                                      */
/* The enum constants must be specified when the enum tag is declared. */

enum FFcontrolType

    {
        prdg_FFconditional,
        prdg_FFcompulsory,
        prdg_FFnever
    };

/**********************************************************************/
/* pDeviceBlock (PDB) Instance Data.                                  */
/**********************************************************************/
typedef struct
{
    BYTE               PDBDeviceName[40];
                                       /* Device name to read         */
                                       /* PM_SPOOLER_DD entry.        */
    BOOL               DfltPrtType;    /* Default Printer Type        */
    PBYTE              PDBDriverName;  /* String for Driver Name      */
                                       /* e.g. IBM42XX                */
    PBYTE              PDBLogAddress;  /* String for Logical Address  */
                                       /* e.g. LPT1 or LPT1Q          */
    USHORT             PDBOutputType;  /* Type of output: STD or RAW  */
/* CON3201 - Change from unsigned to HFILE                            */
/*  unsigned           PDBHandle;         Handle for DOS Device       */
    HFILE              PDBHandle;      /* Handle for DOS Device       */
    BYTE               PDBScratch[DCT_MAX_SIMPLE];
                                       /* Scratch Pad for Printer     */
    ULONG              PDBSplHandle;   /* Spooler Handle              */
    BOOL               PDBPrtOpen;     /* Flag indicating prt open    */
    BYTE               LPName[32];     /* Logical printer name e.g.   */
                                       /* PRINTER1                    */
    BYTE               IniVersion[4];  /* Ini entry version number    */
    USHORT             PrinterType;    /* Current printer type        */
    DDTType            DDT;            /* Copy of the DDT to be used  */
    USHORT             RasterMode;     /* Resolution used             */
    USHORT             Orientation;    /* Portrait or landscape       */
    ULONG              Version;        /* Driver version number       */
    enum FFcontrolType FFcontrol;      /* Formfeed handling control   */
    USHORT             FontCount;      /* Total number of base fonts  */
                                       /* (i.e. no attributed         */
                                       /* versions) - so includes     */
                                       /* resident, code page,        */
                                       /* download and card fonts     */
    lplpFontListType   FontList;       /* List of resident fonts      */
    ULONG              TextSpacing;    /* Value for ESC A to set page */
    ULONG              LengthLines;    /* Page length in lines        */
    lpPrtDataEntry     PrinterData;    /* Entry in printer state list */
    DevRect            FormClipRegion; /* Clip region for current form*/
    USHORT             PageDepthPels;  /* Depth of the page in pels   */
    USHORT             PageWidthPels;  /* Width of the page in pels   */
    USHORT             NumberOfForms;  /* Single or dual page job     */
    PPMInfoType        PPMInfo[2];     /* Will be used to select form */
    BOOL               FormSpecifiedOnOpen;
                                       /* If forms spec on DevOpenDC  */
    BOOL               CancelJob;      /* Manual feed fix - raw data  */
                                       /* not printed                 */
    USHORT             TotalResidentFonts;
    USHORT             TotalCodePageFonts;
    USHORT             TotalCartridgeFonts;
    USHORT             TotalDownloadFonts;
                                       /* Total Number of resident,   */
                                       /* codepage, download and      */
                                       /* cartridge fonts (including  */
                                       /* attributes)                 */
    USHORT             CPJob;          /* Code page during a queued   */
                                       /* raw job. Initial state of   */
                                       /* printer unknown, but during */
                                       /* a job, want to minimise no  */
                                       /* of downloadcodepage calls.  */
                                       /* CPCurrent (DCIData) tracks  */
                                       /* the physical state of the   */
                                       /* printer.                    */
    USHORT             FormYOffset;    /* Offsets from the top-left   */
    USHORT             FormXOffset;    /* corner of the physical      */
                                       /* paper to the top-left       */
                                       /* corner of the form clip     */
                                       /* region.                     */

    DeviceSemTable     PDBDevice;      /* pointer to device table     */
                                       /* PD00636                     */
    FontSettingsType   FontSettings;   /* "Description" of font       */
                                       /* selected on printer - used  */
                                       /* to avoid unnecessary escape */
                                       /* sequences                   */
    DfltFontInfoType   DfltFont;       /* Normal default font         */
    DfltFontInfoType   DfltDeviceFont; /* Raw data default font       */
    USHORT             BandCompression;/* Compression mode (4019)     */
    USHORT             DuplexControl;  /* simplex, duplex etc         */
    USHORT             DownSysFonts;   /* Fast System fonts flag      */
    USHORT             DisableOutlineFonts; /* Guess...               */
    PBYTE              pStartPtr;      /* Pointer to the start of ini */
    USHORT             DfltFontPointSz;/* Point Size value for default*/
                                       /* outline font : PD00137      */
    BOOL               DriverDataConvert; /* PD00479 */
    BOOL               MinorDriverDataConvert;             /* PD00665 */
    PDEVOPENSTRUC      lpSplData;      /* PD00227                     */
    USHORT             PrinterPatterns;/* PD00769  Printer Patterns flag */
    USHORT             Reserved[2];    /* For future expansion        */
} PDBIType;

typedef PDBIType *lpPDBI;


/**********************************************************************/
/* Structure for passing information between PrintMakeRastColor,      */
/* PrintBand, and PrintRast when using a colour printer.              */
/**********************************************************************/
typedef struct
{
   PBYTE    Output[8];        /* Pointer to output blocks for each    */
                              /* colour                               */
   USHORT   OutputLength[8];  /* Length of colour block               */
   USHORT   OutputSize;       /* Size in bytes of each output block   */
} ColOutputType;

typedef ColOutputType *lpColOutputType;

/**********************************************************************/
/* Type setting for initialising the printer to remove all current    */
/* download fonts.                                                    */
/**********************************************************************/
typedef struct
{
    BYTE        PrinterId;             /* 31 for 4019                 */
    BYTE        SubCommand;            /* 8 = permanent, 9 = temp     */
    BYTE        FontId;
} DLFType;

/**********************************************************************/
/* Type for Set Cursor Position                                       */
/**********************************************************************/
typedef struct
{
    BYTE        HorHigh;               /* Low horizontal move byte    */
    BYTE        HorLow;                /* High horizontal move byte   */
    BYTE        VerHigh;               /* Low vertical move byte      */
    BYTE        VerLow;                /* High vertical move byte     */
} SCPType;

/**********************************************************************/
/* Type for raster image graphics                                     */
/**********************************************************************/
typedef struct
{
    BYTE        CountLow;              /* Count low byte              */
    BYTE        CountHigh;             /* Count high byte             */
    BYTE        HorzResHigh;           /* Horizontal resolution parm  */
    BYTE        HorzResLow;
    BYTE        VertResHigh;           /* Vertical resolution parm    */
    BYTE        VertResLow;
    BYTE        BytesPerLineHigh;      /* APA Data bytes per line     */
    BYTE        BytesPerLineLow;
    BYTE        WriteMode;             /* Always zero (OR)            */
    BYTE        DataCompression;       /* 0 = None, 2=G4, 17=Byte     */
} RIGType;


/**********************************************************************/
/* Parameter for prde_FillPDB                                         */
/**********************************************************************/
typedef struct
    {
        DEVOPENSTRUC       DO;
        PBYTE              Unused;
        USHORT             DcType;
    } FPParamsLst;

/**********************************************************************/
/* Parameters for prde_FillLDB                                        */
/**********************************************************************/
typedef struct
    {
        ULONG      Version;
        PULONG     TabSize;
    } FLParamsLst;

typedef struct
    {
        PUSHORT     Flags;
        PULONG      DispTab;
    } FLReturnsLst;

/**********************************************************************/
/* Parameters for prde_EnableDC                                       */
/**********************************************************************/
typedef struct
    {
        lpPDBI          PDBInstance;
        ULONG           DcType;
        ULONG           DcH;
    } EDCParamsLst;

/**********************************************************************/
/* Type for rule and fill                                             */
/**********************************************************************/
typedef struct
{
    BYTE        WH;                    /* Width high byte             */
    BYTE        WL;                    /* Width low byte              */
    BYTE        HH;                    /* Height high byte            */
    BYTE        HL;                    /* Height low byte             */
} RFType;

