/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDPCONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Printer Control
 *                    Constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Size of memory (in bytes) required to contain a single Text Entry's*/
/* worth of codepoints and control sequences for the printer.         */
/**********************************************************************/
#define MIN_TEXT_SIZE        1000

/**********************************************************************/
/* Constants used in prdp_PrintError                                  */
/**********************************************************************/
#define PRINT_CANCEL            0
#define PRINT_RETRY             1

/**********************************************************************/
/* Code returned from prdp_PrintStart                               */
/**********************************************************************/
#define CANCEL_OK               2

/**********************************************************************/
/* Always output data to the printer using Addstring or PrintSimple.  */
/* The actual escape sequences may be:                                */
/*                                                                    */
/* - supplied directly in the call                                    */
/* - accessed from the EST via the printer specific DCT               */
/* - accessed from  the EST directly                                  */
/**********************************************************************/
#define USE_NOTABLE            10
#define USE_PRINTER_TABLE      20
#define USE_GLOBAL_TABLE       30

/**********************************************************************/
/* Constants for Prdp_selectAttribute parameters.                     */
/**********************************************************************/
#define PRE_DCT   1
#define POST_DCT  2

/**********************************************************************/
/* Size of caption and message string buffers for SplMsgBox           */
/**********************************************************************/
#define CAPTION_LENGTH         50
#define MESSAGE_LENGTH        250

/**********************************************************************/
/* Maximum size of a read from a file (nice round number less than    */
/* 64K).                                                              */
/**********************************************************************/
#define MAX_FILE_READ_LENGTH    0xFFF0

/**********************************************************************/
/* Constants to be used in the PPM command                            */
/**********************************************************************/
#define PFT_MANUAL              0x01
#define PFT_TRACTOR             0x02
#define PFT_AUTOMATIC           0x03
#define FC_SHEET                0x01
#define FC_ENVELOPE             0x02
#define SD_TRAY_1               0x01
#define SD_TRAY_2               0x02
#define SD_TRAY_3               0x03
#define SD_ACTIVE_VALUE         0x00

/**********************************************************************/
/* Constants to indicate which INI field is to be updated in          */
/* prdp_UpdateIniState.                                               */
/**********************************************************************/
#define UPDATE_SLOT_1           1
#define UPDATE_SLOT_2           2
#define UPDATE_TRAY_1           3
#define UPDATE_TRAY_2           4

/**********************************************************************/
/* Constants for font download.                                       */
/**********************************************************************/
#define DLF_PERMANENT            8
#define DLF_TEMPORARY            9

/**********************************************************************/
/* Constants to indicate quality mode for Q printers.                 */
/**********************************************************************/
#define DRAFT_MODE              1
#define QUALITY_MODE            2
#define ENHANCED_MODE           3

/**********************************************************************/
/* Constants for the duplex control field                             */
/**********************************************************************/
#define SIMPLEX                 1
#define NORMAL_DUPLEX           2
#define TUMBLE_DUPLEX           3

