/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDMDLGS
 *
 * DESCRIPTIVE NAME = Printer Device Driver Dialog Identifiers
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/*                                                                    */
/*      NAMING AND NUMBERING CONVENTION OF DIALOG IDENTIFIERS         */
/*      -----------------------------------------------------         */
/*                                                                    */
/* All have format DB_xxx_description where:                          */
/*                                                                    */
/* - DB  stands for Dialog Box                                        */
/*                                                                    */
/* - xxx can be:                                                      */
/*                                                                    */
/*       DLG for dialog identifiers                     100 - 199     */
/*       PSH for push buttons                           200 - 299     */
/*       LST for list boxes                             300 - 399     */
/*       RAD for radio buttons and radio button titles  400 - 499     */
/*       TXT for text strings and entry fields          500 - 599     */
/*                                                                    */
/* DB_TXT_DUMMY should be used in the dialogs for any static text     */
/* such as list box titles and other textual instructions.            */
/**********************************************************************/

/**********************************************************************/
/* DUMMY TEXT ENTRY                                                   */
/**********************************************************************/
#define DB_TXT_DUMMY              500

/**********************************************************************/
/* PRINTER PROPERTIES DIALOG IDENTIFIERS                              */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DB_DLG_PP4019             100
#define DB_DLG_PP4029             101
#define DB_DLG_PPPROS             102
#define DB_DLG_PP4224             103
#define DB_DLG_PPQUES             104
#define DB_DLG_PP3816             105
#define DB_DLG_PP2300             141
#define DB_DLG_PP4029_DOFF        142
#define DB_DLG_PP2300_2           150
#define DB_DLG_PPINKJET           160                         /* INKJET       */
#define DB_DLG_PPPRONTO           161                         /* INKJET       */
#define DB_DLG_PPEXECJET          162                         /* INKJET       */


/**********************************************************************/
/* PRINTER PROPERTIES PUSHBUTTON IDENTIFERS. Contextual help is       */
/* defined for all of these push buttons.                             */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DB_PSH_PPENTER            210
#define DB_PSH_PPCANCEL           211
#define DB_PSH_PPHELP             212
#define DB_PSH_CARTRIDGES         213
#define DB_PSH_CODEPAGES          214
#define DB_PSH_DOWNLOAD           215
#define DB_PSH_DEFAULT_FONT       216
#define DB_PSH_ADD_FORM           217
#define DB_PSH_DELETE_FORM        218
#define DB_PSH_CHANGE_FORM        219
#define DB_PSH_CONNECTIONS        220




/**********************************************************************/
/* JOB SET UP DIALOG IDENTIFIERS                                      */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DB_DLG_JPSINGLE           106
#define DB_DLG_JPDUAL             107
#define DB_DLG_JPDUAL_DUPLEX      108
#define DB_DLG_JP4029_DOFF        109




/**********************************************************************/
/* JOB SET UP PUSHBUTTON IDENTIFERS. Contextual help is defined for   */
/* all of these push buttons.                                         */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DB_PSH_JPENTER            221
#define DB_PSH_JPCANCEL           222
#define DB_PSH_JPHELP             223




/**********************************************************************/
/* DIALOG IDENTIFIERS FOR THE PRINTER PROPERTIES DIALOGS              */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Resolutions defined as a list box.                                 */
/**********************************************************************/
#define DB_LST_PPRESOLUTION       300

/**********************************************************************/
/* Resolutions defined as radio buttons.                              */
/**********************************************************************/
#define DB_RAD_PPRESOLUTION       400
#define DB_RAD_PPRES0             401
#define DB_RAD_PPRES1             402
#define DB_RAD_PPRES2             403
#define DB_RAD_PPRES3             404

/**********************************************************************/
/* Orientation radio buttons.                                         */
/**********************************************************************/
#define DB_RAD_PPORIENTATION      405
#define DB_RAD_PPPORTRAIT         406
#define DB_RAD_PPLANDSCAPE        407

/**********************************************************************/
/* Extended NLS machine (Nile/Tiber only)                             */
/**********************************************************************/
#define DB_RAD_EXTENDED_NLS       491
#define DB_RAD_NLS_MACHINE        492
#define DB_RAD_US_MACHINE         493

/**********************************************************************/
/* defined form list box                                              */
/**********************************************************************/
#define DB_LST_DEFINED_FORMS      301

/**********************************************************************/
/* default spool file list box                                        */
/**********************************************************************/
#define DB_LST_SPOOL_FILE         302

/**********************************************************************/
/* Printer Memory Options list box                                    */
/**********************************************************************/
#define DB_LST_MEM_OPTIONS        303

/**********************************************************************/
/* Fast System Fonts                                                  */
/**********************************************************************/
#define DB_RAD_PPFAST_SYSFONTS    466
#define DB_RAD_PPFSF_ENABLED      467
#define DB_RAD_PPFSF_DISABLED     468

/******************************************************************************/
/* PD00769 : Added following four identifiers for check boxes                 */
/******************************************************************************/
#define DB_CHK_PP_FAST_SYSFONTS      475
#define DB_CHK_PP_PRINTER_PATTERNS   476
#define DB_CHK_JP_FAST_SYSFONTS      477
#define DB_CHK_JP_PRINTER_PATTERNS   478

/**********************************************************************/
/* IBM4019 printer control sequence compression.                      */
/**********************************************************************/
#define DB_RAD_COMPRESS_4019      408
#define DB_RAD_CMP_4019_NONE      410
#define DB_RAD_CMP_4019_G4        411

/**********************************************************************/
/* IBM4029 Printer control sequence compression.                      */
/**********************************************************************/
#define DB_RAD_COMPRESS_4029      409
#define DB_RAD_CMP_4029_NONE      472
#define DB_RAD_CMP_4029_G4        473
#define DB_RAD_CMP_4029_BYTE      474

/**********************************************************************/
/* Papers sources. Code is special cased for 4019 so can uses the     */
/* correct constant. Note that for 42XX and 52XX the order of sources */
/* must match the order defined in PRDD?2XX.                          */
/**********************************************************************/
#define NO_OF_4019_SOURCES          2
#define NO_OF_SOURCES               4

/**********************************************************************/
/* Paper sources                                                      */
/**********************************************************************/
#define DB_RAD_4019_SOURCES       413
#define DB_RAD_4019_TRAY1         414
#define DB_RAD_4019_TRAY2         415

/**********************************************************************/
/* Possible source configurations.  The dual paper tray option for    */
/* the IBM52XX needs to be handled as a special case since whether it */
/* is selected or not controls whether the envelope tray options are  */
/* enabled.                                                           */
/**********************************************************************/
#define DB_RAD_42XX_SOURCES       416
#define DB_RAD_42XX_F1            417
#define DB_RAD_42XX_F2            418
#define DB_RAD_42XX_F3            419
#define DB_RAD_42XX_F4            420

#define DB_RAD_52XX_SOURCES       421
#define DB_RAD_52XX_MANUAL        422
#define DB_RAD_52XX_TRACTOR       423
#define DB_RAD_52XX_SINGLE        424
#define DB_RAD_52XX_DUAL          425

/**********************************************************************/
/* Optional feeds.  Two main definitions.  Note that 52XX and the     */
/* 4019 only have two entries whilst the 4029 has all three.          */
/**********************************************************************/
#define DB_RAD_FEED_OPT_TWO       427
#define DB_RAD_NO_FEED            428
#define DB_RAD_ENVELOPE           429

/**********************************************************************/
/* PD00183 : New dialog constants.  Although these items are          */
/* sequential they need not be.                                       */
/**********************************************************************/
#define DB_RAD_FEED_OPT_THREE     426
#define DB_RAD_MM_NONE            494
#define DB_RAD_MM_ENVELOPE        495
#define DB_RAD_MM_ENVPLUS         496
#define DB_RAD_MM_100_SHEET       497                      /* PD00156 */

/**********************************************************************/
/* Duplex option                                                      */
/**********************************************************************/
#define DB_RAD_DUPLEX_OPTION      431
#define DB_RAD_DUP_ENABLED        432
#define DB_RAD_DUP_DISABLED       433

/**********************************************************************/
/* Duplex control (simplex/normal/tumble)                             */
/**********************************************************************/
#define DB_RAD_DUPLEX_CONTROL     434
#define DB_RAD_SIMPLEX            435
#define DB_RAD_NORMAL             436
#define DB_RAD_TUMBLE             437

/**********************************************************************/
/* Printer Fonts available                                            */
/**********************************************************************/
#define DB_RAD_DEVICE_FONTS       438
#define DB_RAD_FONTS_ON           439
#define DB_RAD_FONTS_ON_2         485                     /* PD00604 */
#define DB_RAD_FONTS_OFF          440
#define DB_RAD_FONTS_LIMITED      439                     /* PD00604 */

/**********************************************************************/
/* Downloadable codepages                                             */
/**********************************************************************/
#define DB_RAD_CODEPAGE_MEM       441
#define DB_RAD_CPMEM_NO           442
#define DB_RAD_CPMEM_YES          443

/**********************************************************************/
/* Form feed control                                                  */
/**********************************************************************/
#define DB_RAD_FF_CONTROL         444
#define DB_RAD_FF_NONE            445
#define DB_RAD_FF_COMPULSORY      446
#define DB_RAD_FF_CONDITIONAL     447



/**********************************************************************/
/* DIALOG IDENTIFIERS FOR THE JOB SET UP DIALOGS                      */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Job set up application name                                        */
/**********************************************************************/
#define DB_TXT_APP_NAME_CURRENT   501

/**********************************************************************/
/* Resolutions defined as a list box.                                 */
/**********************************************************************/
#define DB_LST_JPRESOLUTION       304

/**********************************************************************/
/* Resolutions defined as radio buttons.                              */
/**********************************************************************/
#define DB_RAD_JPRESOLUTION       448
#define DB_RAD_JPRES0             449
#define DB_RAD_JPRES1             450
#define DB_RAD_JPRES2             451
#define DB_RAD_JPRES3             452

/**********************************************************************/
/* Orientation radio buttons.                                         */
/**********************************************************************/
#define DB_RAD_JPORIENTATION      453
#define DB_RAD_JPPORTRAIT         454
#define DB_RAD_JPLANDSCAPE        455

/**********************************************************************/
/* Default font                                                       */
/* PD00242 : Added ID for 4029 default font list box in job properties */
/**********************************************************************/
#define DB_LST_JP_DFLTFONTS       305
#define DB_LST_JP_DFLTFONTS_4029  330

/**********************************************************************/
/* Form configuration                                                 */
/**********************************************************************/
#define DB_RAD_FORM_CONFIG        456
#define DB_RAD_SINGLE_FORM        457
#define DB_RAD_DUAL_FORM          458

/**********************************************************************/
/* Single form list box                                               */
/**********************************************************************/
#define DB_LST_SFORM_TEXT         306
#define DB_LST_SFORM              307

/**********************************************************************/
/* First page list box                                                */
/**********************************************************************/
#define DB_LST_DFORM1_TEXT        308
#define DB_LST_DFORM1             309

/**********************************************************************/
/* Rest of document list box                                          */
/**********************************************************************/
#define DB_LST_DFORM2_TEXT        310
#define DB_LST_DFORM2             311

/**********************************************************************/
/* Duplex control (simplex/normal/tumble)                             */
/**********************************************************************/
#define DB_RAD_JPDUPLEX_CONTROL   459
#define DB_RAD_JPSIMPLEX          460
#define DB_RAD_JPNORMAL           461
#define DB_RAD_JPTUMBLE           462

/**********************************************************************/
/* Fast System Fonts                                                  */
/**********************************************************************/
#define DB_RAD_JPFAST_SYSFONTS    469
#define DB_RAD_JPFSF_ENABLED      470
#define DB_RAD_JPFSF_DISABLED     471

/**********************************************************************/
/* Outline Fonts                                              PD00136 */
/**********************************************************************/
#define DB_RAD_PPOUTLINE_FONTS    479
#define DB_RAD_PPOUTF_ENABLED     480
#define DB_RAD_PPOUTF_DISABLED    481

#define DB_RAD_JPOUTLINE_FONTS    482
#define DB_RAD_JPOUTF_ENABLED     483
#define DB_RAD_JPOUTF_DISABLED    484



/**********************************************************************/
/* OTHER DIALOG IDENTIFIERS: FORMS                                    */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DB_ADD_FORM               109
#define DB_CHANGE_FORM            110
#define DB_ADD_FORM_MARGIN        111
#define DB_CHANGE_FORM_MARGIN     112
#define DB_FORM_CONN_4019         134
#define DB_FORM_CONN_4029         135
#define DB_FORM_CONN_PROS         136
#define DB_FORM_CONN_4224         137
#define DB_FORM_CONN_QUES         138
#define DB_FORM_CONN_3816         139

/**********************************************************************/
/* OTHER DIALOG IDENTIFIERS: DEFAULT_FONTS                            */
/*                                                                    */
/**********************************************************************/
#define DB_DEFAULT_FONTS          114
#define DB_DEFAULT_FONTS_4029     140                      /* PD00137 */
#define DB_DEFAULT_FONTS_NO_CP    142

/**********************************************************************/
/* OTHER DIALOG IDENTIFIERS: DOWNLOAD CODEPAGES                       */
/*                                                                    */
/**********************************************************************/
#define DB_CODE_PAGE_LIST         115
#define DB_ADD_CODE_PAGE          116
#define DB_CODE_PAGE_SOURCE       117
#define DB_CODE_PAGE_TARGET       118
#define DB_REMOVE_CODE_PAGE       119
#define DB_RELOAD_CODE_PAGE       120

/**********************************************************************/
/* OTHER DIALOG IDENTIFIERS: CARDS AND CARTRIDGES                     */
/*                                                                    */
/**********************************************************************/
#define DB_CARTRIDGES             121
#define DB_CARDS                  122
#define DB_ADD_CARTRIDGE          123
#define DB_ADD_CARTRIDGE_LIST     124
#define DB_CARTRIDGE_TARGET       125
#define DB_INIT_METRICS_SOURCE    126
#define DB_INIT_METRICS_TARGET    127
#define DB_REMOVE_CARTRIDGE       128

/**********************************************************************/
/* OTHER DIALOG IDENTIFIERS: DOWNLOAD FONTS                           */
/*                                                                    */
/**********************************************************************/
#define DB_DOWNLOAD_FONTS         129
#define DB_ADD_DOWNLOAD_FONT      130
#define DB_ADD_DOWNLOAD_LIST      131
#define DB_DOWNLOAD_TARGET        132
#define DB_REMOVE_DOWNLOAD        133

/**********************************************************************/
/* COMMON PUSH BUTTONS FOR THE SUB-DIALOG WINDOW PROCESSING.          */
/* Exceptions are made only when necessary and are documented below   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DB_PSH_ENTER              224
#define DB_PSH_CANCEL             225
#define DB_PSH_HELP               226
#define DB_PSH_ADD                227
#define DB_PSH_REMOVE             228

/**********************************************************************/
/* FORMS CONTROL WINDOWS.  These are used for the add and the change  */
/* forms.  Enter, cancel and help are those used by the Printer       */
/* Properties because they do not have their own dialog routine.      */
/**********************************************************************/
#define DB_TXT_FORM_NAME          502
#define DB_TXT_FORM_WIDTH         503
#define DB_TXT_FORM_HEIGHT        504
#define DB_TXT_LFT_CLIP_LIMIT     505
#define DB_TXT_RHT_CLIP_LIMIT     506
#define DB_TXT_BTM_CLIP_LIMIT     507
#define DB_TXT_TOP_CLIP_LIMIT     508
#define DB_TXT_UNITS              509
#define DB_TXT_UNITS_INS          510
#define DB_TXT_UNITS_MMS          511
#define DB_TXT_UNITS_TEXT         512
#define DB_LST_FORMS_LIST         326
#define DB_TXT_PE_TYPE            514
#define DB_TXT_PE_TYPE_TEXT       515

/**********************************************************************/
/* CONNECTIONS CONTROL WINDOWS. enter, cancel and help are common.    */
/*                                                                    */
/**********************************************************************/
#define DB_LST_PAPER_SOURCES      312
#define DB_LST_AVAILABLE_FORMS    313

/**********************************************************************/
/* DEFAULT FONT CONTROL WINDOWS.  Uses enter, cancel and help as      */
/* common.                                                            */
/*                                                                    */
/**********************************************************************/
#define DB_LST_PP_DFLTFONTS       314



/**********************************************************************/
/* DOWNLOADABLE CODEPAGE CONTROL WINDOWS.                             */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* MAIN DIALOG.  Uses enter, cancel, add, remove and help as common.  */
/**********************************************************************/
#define DB_LST_CPF_AVAIL          315
#define DB_PSH_CPF_RELOAD         229
#define DB_TXT_CPF_850            552
#define DB_TXT_CPF_850_DESC       553

/**********************************************************************/
/* ADDING A DOWNLOADABLE CODEPAGE LIST DIALOG BOX.  Uses cancel and   */
/* help as common.                                                    */
/**********************************************************************/
#define DB_LST_CPF_ADDLIST        316
#define DB_PSH_CPF_ADD_CNF        230

/**********************************************************************/
/* ADDING A CODEPAGE SOURCE PATH DIALOG BOX.  Uses add, cancel and     */
/* help as common.                                                    */
/**********************************************************************/
#define DB_TXT_CPF_CRISPY         516
#define DB_TXT_CPF_FLOPPY         517
#define DB_TXT_CPF_SPATH          518

/**********************************************************************/
/* ADDING A CODEPAGE TARGET PATH DIALOG BOX.  Uses help as common.    */
/**********************************************************************/
#define DB_TXT_CPF_TPATH          519
#define DB_PSH_CPF_COPY           231
#define DB_PSH_CPF_NOCOPY         232

/**********************************************************************/
/* REMOVING A CODEPAGE DIALOG BOX.  Uses enter, cancel and help as    */
/* common                                                             */
/**********************************************************************/
#define DB_LST_CPF_RLIST          317

/**********************************************************************/
/* Initial download. Use CANCEL and HELP as common.                   */
/**********************************************************************/
#define DB_LST_CPF_INITIAL        318
#define DB_RAD_CPF_PERJOB         463
#define DB_RAD_CPF_PERJOB_ON      464
#define DB_RAD_CPF_PERJOB_OFF     465




/**********************************************************************/
/* CARD AND CARTRIDGE CONTROL                                         */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* CARD MAIN DIALOG BOX.  Use enter, cancel, add, remove and help     */
/* push buttons as common.                                            */
/**********************************************************************/
#define DB_LST_CDF_AVAIL          319
#define DB_LST_CDF_SLOT1          320
#define DB_LST_CDF_SLOT2          321
#define DB_PSH_CDF_INSTALL        234

/**********************************************************************/
/* ADD CARD SOURCE DIALOG BOX.  Use enter, cancel and help as common  */
/**********************************************************************/
#define DB_TXT_CDF_SPATH          522

/**********************************************************************/
/* ADD CARD LIST DIALOG BOX.  Use cancel and help as common but the   */
/* enter needs to do some checking so make it different.              */
/**********************************************************************/
#define DB_LST_CDF_ADDLIST        322
#define DB_PSH_CDF_ADD_CNF        235

/**********************************************************************/
/* ADD CARD TARGET DIALOG BOX.  Use help as above.                    */
/**********************************************************************/
#define DB_TXT_CDF_TPATH          523
#define DB_PSH_CDF_COPY           236
#define DB_PSH_CDF_NOCOPY         237

/**********************************************************************/
/* REMOVE CARD FONT DIALOG BOX. Use enter, cancel and help as above   */
/**********************************************************************/
#define DB_LST_CDF_REMOVE         323

/**********************************************************************/
/* INSTALL INITIAL METRICS SOURCE PATH DIALOG BOX.  use enter, cancel */
/* and help as above.                                                 */
/**********************************************************************/
#define DB_TXT_CDF_SPATH_INSTALL  520

/**********************************************************************/
/* INSTALL INITIAL METRICS TARGET PATH DIALOG BOX.  use enter, cancel */
/* and help as above                                                  */
/**********************************************************************/
#define DB_TXT_CDF_TPATH_INSTALL  521




/**********************************************************************/
/* DOWNLOAD FONT CONTROL                                              */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* DOWNLOAD FONTS MAIN DIALOG BOX. Use enter, cancel, add, remove and */
/* help as common.                                                    */
/**********************************************************************/
#define DB_LST_DLF_FONTS          324

/**********************************************************************/
/* ADD DOWNLOAD FONT SOURCE DIALOG BOX.  use enter, cancel, and help  */
/* as above.                                                          */
/**********************************************************************/
#define DB_TXT_DLF_SPATH          524

/**********************************************************************/
/* ADD DOWNLOAD FONT LIST DIALOG BOX. use cancel and help as above    */
/* but keep add different                                             */
/**********************************************************************/
#define DB_LST_DLF_FONTLIST       325
#define DB_PSH_DLF_ADD_CNF        238

/**********************************************************************/
/* ADD DOWNLOAD FONT TARGET DIALOG BOX. Use help as above.            */
/**********************************************************************/
#define DB_TXT_DLF_TPATH          525
#define DB_PSH_DLF_COPY           239
#define DB_PSH_DLF_NOCOPY         240

/**********************************************************************/
/* REMOVE DOWNLOAD FONT DIALOG BOX. Use enter, cancel and help as     */
/* above.                                                             */
/**********************************************************************/
#define DB_LST_DLF_REMOVE         327

/**********************************************************************/
/* VERSION NUMBER FIELDS                                              */
/**********************************************************************/
#define DB_TXT_VERS_42XX          526
#define DB_TXT_VERS_52XX          527
#define DB_TXT_VERS_4019          528

/**********************************************************************/
/* OUTLINE FONT POINT SIZE                                PD00137     */
/**********************************************************************/
#define DB_LST_PPPOINTSZ          328
#define DB_LST_JPPOINTSZ          329

