/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDFTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver Device Mode type
 *                    definitions
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Download character control block                                   */
/**********************************************************************/
typedef struct
{
   BYTE   Control1;      /* 0x1B - control character 1                */
   BYTE   Control2;      /* 0x3D - Download fonts                     */
   USHORT usLen;         /* Length of data following -                */
                         /* sizeof(DEVICECHAR)-4+length of char data  */
   BYTE   id;            /* 0x31 - Printer Id                         */
   BYTE   SubCmd;        /* Subcommand - 0x02                         */
   BYTE   IDCont;        /* 0 = complete                              */
   BYTE   CP;            /* Codepoint                                 */
   SHORT  LeftOffset;    /* 0 for us                                  */
   SHORT  TopOffset;     /* 0 for us                                  */
   USHORT Width;         /* Box width - HL                            */
   USHORT Height;        /* Box Height (from font header for us) - HL */
   USHORT EscWidth;      /* Escapement width ( = width for us) - HL   */
} DEVICECHAR;

typedef DEVICECHAR *PDEVICECHAR;

/**********************************************************************/
/* Structure of the device font header                                */
/**********************************************************************/
typedef struct
{
   BYTE    Control1;       /* 0x1B - control character 1              */
   BYTE    Control2;       /* 0x3D - Download fonts                   */
   USHORT  usLen;          /* Length of data following -              */
                           /*   sizeof(DEVICEFONTHEADER) - 4          */
   BYTE    id;             /* 0x31 - Printer Id                       */
   BYTE    SubCmd;         /* Subcommand - 0x01                       */
   BYTE    HdrID;          /* Font header id 0                        */
   BYTE    bFlags;         /* Spacing and qualification flags 2       */
/* CON3201 - Change in size of int from 16 to 32 bits, now make short
   UINT    CPGID;             Codepage Global id (850 ?) - HL
   UINT    FGID;              Font global id (eg "e7")     HL
*/
   USHORT  CPGID;          /* Codepage Global id (850 ?) - HL         */
   USHORT  FGID;           /* Font global id (eg "e7")     HL         */
   ULONG   PointSize;      /* Point size -(selection) - 100 * real HL */
/* CON3201 - Change in size of int from 16 to 32 bits, now make short
   UINT    MaxCellHeight;     MaxCell height = yCellHeight HL
   UINT    BaseLineOffset;    pCellBaseOffset
*/
   USHORT  MaxCellHeight;  /* MaxCell height = yCellHeight HL         */
   USHORT  BaseLineOffset; /* pCellBaseOffset                         */
   BYTE    Zeros[12];      /* Shifts, underscore data etc             */
   ULONG   Pitch;          /* Font pitch - try 0 (HL)                 */
   BYTE    CPSubSet;       /* Codepage Subset - 0                     */
   BYTE    Reserved[3];    /* More zeros                              */
} DEVICEFONTHEADER;

typedef DEVICEFONTHEADER *PDFH;



typedef struct _ENGINEDEVICEFONTHDR
{
   struct _ENGINEDEVICEFONTHDR *
             pedfhNext;           // Chaining

   USHORT    usDFID;              // Number allocated for this font
                                  // if downloaded (EDF_FONT_DOWNLOADED).
                                  // These ids are between 1 and 99 (above
                                  // any ids of resident, card or downloaded
                                  // device fonts -
                                  //  (DCIPdbInstance->FontCount /
                                  //   DDT_ATTRIBUTED_FONTS)).
                                  // Allocated dynamically at download time
                                  // - correspond to the Download Font ID
                                  // (DFID) of the font in the printer.
   PFOCAFONT pFont;               // The engine font.
                                  // Initialized to the engine font pointer.
                                  // Set to 0 when the engine font is deleted.
                                  // The code searches for this value before
                                  // deciding to create a new edf structure
   PFOCAFONT pSaved;              // Our version of the font if the engine
                                  // deletes it.
   USHORT    fsFontStatus;        // Status flags (See below)
   USHORT    usFontSize;          // Size when downloaded
   USHORT    usGlyphUsed[256/16]; // 1 bit per glyph - 'used on the current
                                  // page.
   USHORT    usGlyphDownLoaded[256/16];
                                  // 1 bit per glyph -
                                  //    'downloaded to the  printer
}
ENGINEDEVICEFONTHDR;

typedef ENGINEDEVICEFONTHDR *PEDFH;

#define EDF_FONT_DOWNLOADED          1  // Downloaded to the printer
#define EDF_FONT_DELETED             2  // Engine has deleted its font
#define EDF_FONT_DOWNLOADED_ON_PAGE  8  // Downloaded to the printer
#define EDF_USED_ON_PAGE             4  // Has been used on this page (ie is
                                        // it a candidate for discarding ?

/**********************************************************************/
/* Define some constants for maximum size characters we support here  */
/**********************************************************************/
#define MAX_DOWNLOAD_ID 31              // Max value for usDFID
#define EDF_MAX_HEIGHT 150
#define EDF_MAX_FONTS 10
#define EDF_MAX_WIDTH 150
#define EDF_MAX_PRINTERMEMORY 500000L   // 0.5 megabytes
#define EDF_MIN_SIZE 60000


/**********************************************************************/
/* Translate a codepoint to a glyph index                             */
/*  pFoca     = Pointer to FOCAFONT structure for our font            */
/*  cp        = CodePoint                                             */
/*  gi        = Glyph index (USHORT)                                  */
/**********************************************************************/
#define CP_TO_GI(pFoca,cp) \
    ((USHORT)((USHORT)(cp - pFoca->fmMetrics.usFirstChar) > \
     pFoca->fmMetrics.usLastChar ? \
     pFoca->fmMetrics.usDefaultChar : cp - pFoca->fmMetrics.usFirstChar))


/**********************************************************************/
/* Special defintion to point into a font                             */
/**********************************************************************/
typedef struct { ULONG definition; USHORT a_space;  } *PFC;

#define SWAP(a) MAKEUSHORT(HIBYTE(a),LOBYTE(a))



