/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDECONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Enable constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Number of Parameters in SplData ( type DEVOPENDATA )                      */
/******************************************************************************/
#define NO_OF_PARMS_SPLDATA             9L

/******************************************************************************/
/*  Options for DOSALLOCSEG used for creating heaps during enable             */
/******************************************************************************/
#define SHARED_HEAP                     2
#define NON_SHARED_HEAP                 0

/******************************************************************************/
/*  Return codes for prde_MatchDirectSpoolerInfo and                          */
/*  prde_MatchQueuedSpoolerInfo                                               */
/******************************************************************************/
#define MATCH                           3
#define NO_MATCH                        4

/******************************************************************************/
/*  Dummy value if no resident fonts are available.                           */
/******************************************************************************/
#define NO_RESIDENT_FONTS              -1

/******************************************************************************/
/*  Dummy value used for fields in FMF and CDF structures which aren't present*/
/*  in 4019 files.                                                            */
/******************************************************************************/
#define DUMMY_FONT_VALUE             0xFF

/******************************************************************************/
/*  First byte of FMF for Heritage printer indicates Multi-codepage outline   */
/*  FMF font.                                                                 */
/******************************************************************************/
#define MULTICP_FMF_VALUE            0xFD

/******************************************************************************/
/*  DIAL/NILE : Code page constants                                           */
/******************************************************************************/
#define CP_437                        437

/******************************************************************************/
/*  DIAL/NILE : Number of fonts per code page depending on memory available.  */
/******************************************************************************/
#define PRO_II_MEM                     10
#define PRO_II_NO_MEM                   8
#define PRO_III_MEM                    13
#define PRO_III_NO_MEM                  9

/******************************************************************************/
/*  DIAL/NILE : Number of fonts available for Nile/Tiber versions.            */
/*  PD00651 : Number of resident fonts for 24wire NLS decreased with printer  */
/*  restrictions.                                                             */
/******************************************************************************/
#define US_9WIRE                       85
#define NLS_9WIRE                     187
#define US_24WIRE                     175
#define NLS_24WIRE                    209

/******************************************************************************/
/*  Maximum allowable code pages in the Global outline table.  CPIndex in LCID*/
/*  can only be 7 bits so a limit of 127 is REAL!                             */
/******************************************************************************/
#define MAX_OS2_CODEPAGES             127

/******************************************************************************/
/*  The Maximum number of code page entries to allocate for the global outline*/
/*  code page table (OutlineCodepages).  This number can not be larger than   */
/*  127 since the CpIndex in the LCID is only 7 bits.                         */
/******************************************************************************/
#define MAX_OUTLINE_CODEPAGE_ENTRIES  127

/******************************************************************************/
/*  Constants to indicate code page is/not resident in Heritage printer This  */
/*  is stored in the global outline table in the CpType field to indicate that*/
/*  this code page must be downloaded to be supported when CpType field is    */
/*  NON_RESIDENT.                                                             */
/******************************************************************************/
#define RESIDENT                       -1
#define NON_RESIDENT                    0

/******************************************************************************/
/*  Constant to indicate that a code page is supported by OS/2.  this is      */
/*  stored in the global outline table in CPVResId field to indicate that no  */
/*  CPV resource file is necessary to support this code page.                 */
/******************************************************************************/
#define OS2SUPPORTED                   -1

/******************************************************************************/
/*  PD00506 : Define for init of color table format in DCIData.               */
/******************************************************************************/
#define LCOLF_BOGUS                    99
