/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDDTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver DVT/DDT/GDT/DCT types
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* Device Value Table (DVT) types for code pages.                     */
/**********************************************************************/
typedef struct
    {
        USHORT     Number;
        USHORT     ResourceId;
    } DVTCPListType;

typedef DVTCPListType *lpDVTCPList;

typedef struct
    {
        PSZ        CrispyNo;
        PSZ        FloppyNo;
    } NLSDiskPairType;

typedef NLSDiskPairType *lpNLSDiskPair;

typedef struct
    {
        PSZ            BINFileName;
        lpNLSDiskPair  NLSDiskName;
        USHORT         CPSource;
    } DVTCPSourceType;

typedef DVTCPSourceType *lpDVTCPSource;

/**********************************************************************/
/* Code Page Source type for a code page picked up from resources -   */
/* this "maps" onto DVTCPSourceType above.                            */
/**********************************************************************/
typedef struct
    {
        ULONG      ResourceId;
        ULONG      BINFileSize;
        USHORT     CPSource;
    } DVTCPSourceResType;

typedef DVTCPSourceResType *lpDVTCPSourceRes;


/**********************************************************************/
/* PD00220 : Italic slope types                                       */
/**********************************************************************/
typedef struct
    {
        USHORT      Slope;
    } DVTItalicSlopeType;

typedef DVTItalicSlopeType *lpDVTItalicSlope;


/**********************************************************************/
/* DVT Raster Mode types                                              */
/**********************************************************************/
typedef struct
    {
        USHORT    ResWidth;
        USHORT    ResDepth;
        BYTE      VertLinePels;
        BYTE      VertLinePelsHiRes;
        USHORT    HorzRoughFPelsL; /* No of pels (in font coords) the */
        USHORT    HorzRoughFPelsR; /*  printer head is moved for      */
        USHORT    HorzFineFPels;   /*  rough moves left and right and */
                                   /*  for a fine move (always right) */
        USHORT    VerticalUnits;   /* Units for the graphics line     */
                                   /* spacing                         */
        USHORT    LineSpacing;
        USHORT    AspectRatio;
        USHORT    MaxVerticalMove;
        USHORT    PortPattIndex;   /* Pattern index in portrait mode  */
        USHORT    LandPattIndex;   /* Pattern index in landscape mode */
        PSZ       Description;
    } DVTRasterModeType;

typedef DVTRasterModeType *lpDVTRasterMode;

/**********************************************************************/
/* DVT Source and Tray List types                                     */
/**********************************************************************/
typedef struct
    {
        USHORT       ResourceId;     /* For string to display         */
        BYTE         DMTrayUsage;    /* Where in DMData form list     */
                                     /* is held                       */
        BYTE         SourceType;     /* Paper / Envelope              */
        BYTE         FeedType;       /* Automatic / Manual            */
        BYTE         JoinType;       /* Sheet / Tractor               */
    } DVTSourceTrayType;

typedef DVTSourceTrayType *lpDVTSourceTray;

typedef struct
    {
        USHORT            NoOfLogicalTrays;
        USHORT            TopMargin;             /* In inches x 100   */
                                                 /* (so 1/2" -> 50)   */
        USHORT            NoOfPaperTrays;
        USHORT            NoOfEnvTrays;
        USHORT            ManualPaperFeed;
        USHORT            ManualEnvFeed;
        lpDVTSourceTray   SourceTrayList;
    } DVTSourceListType;

typedef DVTSourceListType *lpDVTSourceList;

/**********************************************************************/
/* Other DVT types.                                                   */
/**********************************************************************/
typedef struct
    {
        PULONG       Colors;
        USHORT       ColorNum;
    } DVTColorTableType;

typedef DVTColorTableType *lpDVTColorTable;

typedef struct
    {
        USHORT    BitCount;
        USHORT    Planes;
    } DVTFormatType;

typedef DVTFormatType *lpDVTFormat;

typedef struct
    {
        BYTE      FormType;
        BYTE      FormId;
        USHORT    FormNameId;
        CHAR      FormData[FORM_DIMS_LENGTH];
    } DVTFormsType;

typedef DVTFormsType *lpDVTForms;

/**********************************************************************/
/* DVTRetFlagsType consists of the following fields:                  */
/*                                                                    */
/*   PageCorrection: True if a Form Feed required at bottom           */
/*                     of page.                                       */
/*   ImplicitReturn: True if the variable linefeed command            */
/*                     inserts a carriage return.                     */
/*                                                                    */
/**********************************************************************/
typedef struct
    {
        BOOL      PageCorrection;
        BOOL      ImplicitReturn;
    } DVTRetFlagsType;

typedef DVTRetFlagsType *lpDVTRetFlags;


/**********************************************************************/
/* Device Description Table (DDT) type.                               */
/**********************************************************************/
typedef struct
    {
        USHORT            DDTDriverType;
        USHORT            DDTMaxPrintWidth;
        lpDVTRasterMode   DDTRasterMode;
        lpDVTSourceList   DDTSourceList;
        lpDVTColorTable   DDTDevColorTable;
        lpDVTFormat       DDTFormat;
        lpDVTForms        DDTDefinedForms;
        lplpFontListType  DDTFontList;
        USHORT            DDTBandsPerPage;
        BYTE              DDTDefResolution;
        BYTE              DDTDefOrientation;
        USHORT            DDTHorizMoveType;
        USHORT            DDTFontsInCodePage;
        USHORT            DDTNoOfRasterModes;
        USHORT            DDTNoOfDefinedForms;
        USHORT            DDTNoOfResidentFonts;
        USHORT            DDTDfltFontNo;
        USHORT            DDTSourceFlags;
        USHORT            DDTFormFlags;
        USHORT            DDTFontFlags;
        USHORT            DDTDialogFlags;
        USHORT            DDTInitFlags;
        BYTE              DDTMaxColors;
        BYTE              DDTItalicSlopeIndex;
        USHORT            DDTAttrFontsInCP;
        USHORT            DDTNoOfCardSlots;
        USHORT            DDTNoOfMemoryOptions;
        PUSHORT           DDTMemoryOptionText;
        PULONG            DDTMemoryOptionTable;
        USHORT            DDTCardImageNumAttrs;
        USHORT            DDTCardImageAttrs;
        USHORT            DDTCardOutlineNumAttrs;
        USHORT            DDTCardOutlineAttrs;
        USHORT            DDTDownImageAttrs;
        USHORT            DDTPP_DialogId;       /*Printer properties dialog id*/
        USHORT            DDTJSU_DialogId;      /*Job set up dialog id        */
        USHORT            DDTDEFNT_DialogId;    /*Default font dialog id      */
        USHORT            DDTFORMC_DialogId;    /*Form connections dialog id  */
        USHORT            DDTPrinterFonts;      /*PD00604:printer fonts setting */
        USHORT            DDTDefFontPSz;        /*def font point size         */
    } DDTType;

typedef DDTType *lpDDTType;


/**********************************************************************/
/* Global Description Table (GDT) type.                               */
/**********************************************************************/
typedef struct
    {
        lpDVTColorTable   GDT11ColorTable;
        lpDVTColorTable   GDT41ColorTable;
        lpDVTColorTable   GDT81ColorTable;
        lpDVTRetFlags     GDTRetFlags;
    } GDTType;


/**********************************************************************/
/* Device Description Table types                                     */
/**********************************************************************/
typedef struct
    {
        char *    Name;
        char *    Description;
    } DVTDescriptionType;

typedef DVTDescriptionType *lpDVTDescription;

typedef struct
    {
        PCHAR    Name;
    } DVTNameType;

typedef DVTNameType *lpDVTName;

typedef struct
    {
        USHORT             NoOfDataTypes;
        lpDVTName          DataTypes;
    } DVTDevDescriptionType;


/**********************************************************************/
/* Escape Sequence Table (EST) entry type.                            */
/**********************************************************************/
typedef struct
    {
        PSZ             EscapeSeq;
        USHORT          EscapeSeqLen;
        USHORT          ParamMask;
    } ESTEntryType;


/**********************************************************************/
/* Device Command Table (DCT) entry type.                             */
/**********************************************************************/
typedef USHORT  DCTEntryType;

typedef DCTEntryType * lpDCTEntryType;

/**********************************************************************/
/* Attribute table type.                                              */
/**********************************************************************/
typedef struct
    {
        USHORT          PreDCTCmd;
        USHORT          PostDCTCmd;
    } AttTableType;

