/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDDCONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Table Macros and Constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/* Printer Driver type constants.                                             */
/******************************************************************************/
#define DDT_IBM42XX_DRV               0
#define DDT_IBM52XX_DRV               1
#define DDT_IBM4019_DRV               2

/**********************************************************************/
/* Constant for printer arrays.                                       */
/*                                                                    */
/* NOTE: this MUST be updated if one of the drivers gets to have      */
/* more than 20 printers attached.                                    */
/**********************************************************************/
#define LARGEST_NO_OF_PRINTERS        20

/**********************************************************************/
/* Printer Type constants for PRO driver                              */
/**********************************************************************/
#define IBM_PRO_PRINTER_I             0    /* Note that the code uses */
#define IBM_PRO_PRINTER_II            1    /* the fact that these are */
#define IBM_PRO_PRINTER_III           2    /* consecutive and start   */
#define IBM_PRO_PRINTER_XL            3    /* from zero               */
#define IBM_PRO_PRINTER_II_XL         4
#define IBM_PRO_PRINTER_III_XL        5
#define IBM_PRO_PRINTER_X24           6
#define IBM_PRO_PRINTER_X24E          7
#define IBM_PRO_PRINTER_XL24          8
#define IBM_PRO_PRINTER_XL24E         9
#define IBM_4224_COLOR               10
#define IBM_4224_MONO                11
#define IBM_NILE_9                   12
#define IBM_TIBER_9                  13
#define IBM_NILE_24                  14
#define IBM_TIBER_24                 15
#define IBM_4226                     16
#define IBM_2390_PS1                 17
#define IBM_EXECJET                  18                       /* INKJET       */
#define IBM_PRONTO                   19                       /* INKJET       */

/**********************************************************************/
/* Printer Type constants for Q driver                                */
/**********************************************************************/
#define IBM_QUIETWRITER_III           0    /* Note that the code uses */
#define IBM_QUICKWRITER               1    /* the fact that these are */
#define IBM_3816_SIMPLEX              2    /* consecutive and start   */
#define IBM_3816_DUPLEX               3    /* from zero               */

/**********************************************************************/
/* Printer Type constants for LZ driver                               */
/**********************************************************************/
#define IBM_4019_LASER                0    /* Note that the code uses */
#define IBM_4019_LASER_E              1    /* the fact that these are */
#define IBM_HERITAGE                  2    /* consecutive and start   */
#define IBM_HERITAGE_E                3    /* from zero               */
#define IBM_HERITAGE_L                4    /* PD00157...              */
#define IBM_HERITAGE_P                5    /* PD00157...              */
#define IBM_HERITAGE_6P               6    /* PD00640...              */
#define IBM_HERITAGE_10P              7    /* PD00640...              */

/**********************************************************************/
/* Bit flags for testing DDT printer handling/support flags.          */
/**********************************************************************/
#define DDT_NONE                     0x0000


                                             /*   Source flags        */
#define DDT_VAR_PAPER_SOURCE_SUPPORT 0x0001  /* Printer has variable  */
                                             /* source configerations */
#define DDT_ENV_TRAY_SUPPORT         0x0002  /* Printer supports an   */
                                             /* automatic env. tray   */
#define DDT_MULTIMEDIA_TRAY_SUPPORT  0x0004  /* Printer supports the  */
                                             /* multimedia tray       */
#define DDT_SOURCE_GREYED            0x0008  /* PD00183 : Sources are */
                                             /* in dlg and need grey  */
                                             /* - 4224 color          */
                                             /* - Heritage P          */

/**********************************************************************/
/* Not used. Replaced by DDT_SOURCE_GREYED                            */
/**********************************************************************/
#define DDT_PAPER_SOURCE_NOTSUPPORT  0x0008  /* for 4224 color        */
                                             /* grey out the paper    */
                                             /* source window         */
#define DDT_DUPLEX_SUPPORT           0x0010  /* for 3816 Duplex.      */
#define DDT_DUPLEX_OPTIONAL          0x0020  /* for 4019 Heritage.    */
#define DDT_DUPLEX_NOTSUPPORT        0x0040  /* PD00157 : Heritage P  */

/**********************************************************************/
/* Not used, replaced by DDT_SOURCES_GREYED                           */
/**********************************************************************/
#define DDT_ONE_PAPER_TRAY           0x0080  /* PD00157 : Heritage P  */

                                             /* FORM FLAGS            */
#define DDT_NON_PRINTABLE_MARGIN     0x0001  /* All forms have a non- */
                                             /* printable margin (eg  */
                                             /* for laser printers)   */
#define DDT_VAR_FORM_FEED_CONTROL    0x0002  /* Printer has variable  */
                                             /* from feed control     */
#define DDT_VAR_BOTTOM_CLIP          0x0004  /* INKJET:Printer has    */
                                             /* variable bottom clip  */
                                             /* limit                 */


                                             /*   Font flags          */
#define DDT_CARTRIDGE_OPTION         0x0001  /* The driver handles    */
                                             /* Cartridges            */
#define DDT_CARTRIDGE_SUPPORT        0x0002  /* The printer type      */
                                             /* supports Cartridges   */
#define DDT_ADD_CODE_PAGE_OPTION     0x0004  /* The driver handles    */
                                             /* adding Code Pages     */
#define DDT_ADD_CODE_PAGE_SUPPORT    0x0008  /* The printer supports  */
                                             /* adding Code Pages     */
#define DDT_ENGINE_ATTR_INDEX        0x0010  /* Engine attrs does not */
                                             /* contain FGIDS but     */
                                             /* indices into the font */
                                             /* list.                 */
#define DDT_CODE_PAGE_NOTOPTION      0x0020  /* The driver always has */
                                             /* memory available      */
                                             /* i.e. PRO XL           */
#define DDT_DOWN_CP_MEM_SUBSET_AVAIL 0x0040  /* Printer has a subset  */
                                             /* of download codepage  */
                                             /* memory at all times   */
                                             /*                       */
#define DDT_NLS_FONTS_OPTIONAL       0x0080  /* 2 versions of Nile/   */
                                             /* Tiber: US & NLS       */
                                             /*                       */

#define DDT_ITALIC_SLOPE_VARIES      0x0100  /* Not used              */

#define DDT_ADD_QUALITY_TO_FACE      0x0200  /* A description of the  */
                                             /* quality level is      */
                                             /* added when returning  */
                                             /* the metrics           */
#define DDT_ONE_CARD_SLOT            0x0400  /* PD00157 : Heritage P  */

#define DDT_DISPLAY_POINT_SIZE       0x1000  /* The point size is     */
                                             /* displayed in the      */
                                             /* default font dialog   */
                                             /* box                   */
#define DDT_VARIABLE_MEMORY_RADIO    0x2000  /* The printer has       */
                                             /* variable memory       */
                                             /* options used for      */
                                             /* download fonts and    */
                                             /* uses radiobuttons     */
#define DDT_VARIABLE_MEMORY_LBOX     0x4000  /* The printer has       */
                                             /* variable memory       */
                                             /* options used for      */
                                             /* download fonts and    */
                                             /* uses a listbox.       */
#define DDT_DOWNLOAD_MULTICP_SUPPORT  0x8000 /* Additional codepages  */
                                             /* can be downloaded     */
                                             /* to the printer to     */
                                             /* support outline fonts */
                                             /* in many codepages.    */


                                             /*   Dialog flags        */
#define DDT_DUAL_FORM_JOB_SOME       0x0001  /* Some source configs.  */
                                             /* support dual form     */
                                             /* jobs                  */
#define DDT_DUAL_FORM_JOB_ALL        0x0002  /* All source configs.   */
                                             /* support dual form     */
                                             /* jobs                  */
#define DDT_RADIO_RESOLUTION         0x0004  /* Use radio buttons     */
                                             /* (not list box) for    */
                                             /* the resolution        */
#define DDT_COMPRESS_G4              0x0008  /* LaserPrinter compress */
                                             /* options               */
#define DDT_COMPRESS_G4_BYTE         0x0010  /* Heritage compression  */
                                             /* options               */
#define DDT_FAST_SYSTEM_FONTS        0x0020  /* Laser printers fast   */
                                             /* system fonts option.  */
#define DDT_DISABLE_OUTLINE_FONTS    0x0040  /* PD00136 : The driver  */
                                             /* can disable outline   */
                                             /* fonts                 */
#define DDT_DEF_OUTLN_FNT_PSZ        0x0080  /* PD00137 : Point Size  */
                                             /* selection for def font*/
#define DDT_NLS_VERSION              0x0100  /* PD00295 : supports    */
                                             /* Extended NLS buttons  */
#define DDT_LIMIT_FONTS              0x0200  /* PD00604 : supports    */
                                             /* returning limited #   */
                                             /* of fonts button       */
#define DDT_DISABLE_600_DPI_FONTS    0x0400  /* Disable option for    */
                                             /* 600 DPI printers      */

/**********************************************************************/
/* Printer initialisation flags. These flags control which escape     */
/* sequences are sent out on a per page basis.                        */
/**********************************************************************/
#define DDT_INIT_VERTICAL_UNITS     0x0001
#define DDT_INIT_PAGE_LENGTH        0x0002
#define DDT_INIT_TEXT_SPACING       0x0004
#define DDT_INIT_ASPECT_RATIO       0x0008
#define DDT_INIT_MARGINS            0x0010
#define DDT_INIT_ORIENTATION        0x0020
#define DDT_INIT_PPM_SOURCE         0x0040
#define DDT_INIT_PPM_SOURCE_FORM    0x0080
#define DDT_SCP_SUPPORT             0x0100  /* Select Code Page      */
                                            /* supported             */
#define DDT_SCP_4224_SUPPORT        0x0200  /* Select Code Page      */
                                            /* 4224 supported        */
#define DDT_SFG_SUPPORT             0x0400  /* Set Font Global       */
                                            /* supported             */
#define DDT_INIT_PPM_DUPLEX         0x0800
#define DDT_PRINT_ANGLE_SUPPORT     0x1000  /* Print angle supported */
                                            /* PD00073               */


                                             /*   Horizontal move     */
#define DDT_MOVE_NO_STEP             0x0001  /*   type (for text)     */
#define DDT_MOVE_STEP_RIGHT          0x0002
#define DDT_MOVE_STEP_BOTH           0x0004
#define DDT_MOVE_ABS_SCP             0x0008  /* Set Cursor Position   */
#define DDT_MOVE_STEP_RIGHT_RAST     0x0010  /*   PD00484             */
#define DDT_MOVE_RGHT_LEFT_CLIP      0x0020  /* INKJET                */
#define DDT_MOVE_RGHT_LEFT_CLIP_2    0x0040  /* INKJET                */


/**********************************************************************/
/* Device Description Table (DDT) constants.                          */
/**********************************************************************/
#define DDT_DUMMY_VALUE           0

#define DDT_TWO_COLORS            2
#define DDT_EIGHT_COLORS          8

#define DDT_NO_RASTER             0
#define DDT_ONE_LINE_RASTER       1
#define DDT_EIGHT_LINE_RASTER     8
#define DDT_24_LINE_RASTER       24

/**********************************************************************/
/* DDT constants used in definitions of sources configerations        */
/* The DMTrayUsage constants (CS_*) are declared in PRDMCONE.H.       */
/**********************************************************************/
#define DDT_PAPER_FORM            'P'          /* SourceType          */
#define DDT_ENVELOPE_FORM         'E'
#define DDT_DEFAULT_OR_ENV_FORM   'B'          /* 8.5x11 or envelope  */
#define DDT_AUTO_FEED             0x01         /* FeedType            */
#define DDT_MANUAL_FEED           0x00
#define DDT_SHEET_FEED            0x01         /* JoinType            */
#define DDT_TRACTOR_FEED          0x00


/**********************************************************************/
/* DCIStateFlags...                                                   */
/**********************************************************************/
#define COMPLETE_OPEN_DONE       0x00000001
#define LOCATE_FONT_REQD         0x00000002
#define TEXT_SIML_REQD           0x00000004
#define FONT_COORDS_VALID        0x00000008
#define ENG_ATTS_REQD            0x00000010
#define ESTABLISH_FONT_REQD      0x00000020
#define BLIT_SIML_IN_PROCESS     0x00000040 /* PD00567...                     */


/**********************************************************************/
/* List of Macros used in the code:                                   */
/*                                                                    */
/*   MULT_BITMAP_FORMATS    0   Set on this allows color printer      */
/*                              to create (1,1) as well as (4,1)      */
/*                              bitmaps.                              */
/*                                                                    */
/*   OMIT_OLD_CODE          0                                         */
/*                                                                    */
/*   OMIT_FOR_WORK_AROUND   0                                         */
/*                                                                    */
/*   PORT_SEMAPHORE         0   Set on this causes the driver to      */
/*                              use semaphores for accesing ports     */
/*                              LPT1-3 and COM1-3.  Note that there   */
/*                              is no semaphore support for LPT4-9    */
/*                              and COM4-9.                           */
/*                                                                    */
/*   DDT_KERNING_ENABLED    1   Set on this hooks and handles the     */
/*                              GetKerningPairTable function.         */
/*                              PD00075 : enable kerning to prevent   */
/*                              trap in the GRE GetKPTable function.  */
/*                                                                    */
/*   DDT_FORM_TEMPLATES     0   Set on this forces the use of a       */
/*                              pre-defined form as the template in   */
/*                              the Add Form dialog box - i.e added   */
/*                              forms cannot be used as a template.   */
/*                                                                    */
/*   DDT_NO_PRINT_MARGIN    0   Set on this uses the bottom-left      */
/*                              corner of the physical paper as the   */
/*                              origin for SCP commands rather than   */
/*                              the bottom-left corner of the         */
/*                              printable area (applies to 4019       */
/*                              printers only).                       */
/*                                                                    */
/*   DDT_BANDING            1   Set on for code to support            */
/*                              multiple bands per page.              */
/*                                                                    */
/*                                                                    */
/*   PRD_DEBUG              |   Debugging tools .. values set in      */
/*   PRD_TRACE              |   MAK file.                             */
/*   INIT_TEST_TYPE         |                                         */
/*                                                                    */
/*   SHEAR_ADDED            1   Do shearing for 4029 outline fonts    */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DDT_BANDING

#define DDT_KERNING_ENABLED

#define SHEAR_ADDED

/**********************************************************************/
/* Device Command Table (DCT) Constants.                              */
/* The numbers defined here are indices into the DCT, and need to be  */
/* in step with DCT initialisation.                                   */
/* The constant DCT_NUMBER_ENTRIES acts as a check and MUST be        */
/* incremented if extra entries are added to the DCT.                 */
/**********************************************************************/
#define DCT_PRINTER_INIT_1            0
#define DCT_PRINTER_INIT_2            1
#define DCT_PRINTER_INIT_3            2

#define DCT_RASTER_MODE_1             3   /* These values must be     */
#define DCT_RASTER_MODE_2             4   /* contiguous for the code  */
#define DCT_RASTER_MODE_3             5   /* in PRDEFPDB.C to work    */
#define DCT_RASTER_MODE_4             6   /* correctly.               */
#define DCT_RASTER_MODE_5             7   /* PD00556 */

#define DCT_ROUGH_MOVE_LEFT           8
#define DCT_ROUGH_MOVE_RIGHT          9
#define DCT_FINE_MOVE_LEFT           10
#define DCT_FINE_MOVE_RIGHT          11

#define DCT_SELECT_FONT              12

#define DCT_END_OF_JOB               13
#define DCT_SELECT_ITALIC            14
#define DCT_START_DUPLEX             15

/**********************************************************************/
/* The constant DCT_NUMBER_ENTRIES acts as a check and MUST be        */
/* incremented if extra entries are added to the DCT.                 */
/**********************************************************************/
#define DCT_NUMBER_ENTRIES           16   /* PD00556 */


/**********************************************************************/
/* Escape Sequence Table (EST) Constants.                             */
/* The numbers defined here are indices into the EST, and need to be  */
/* in step with EST initialisation.                                   */
/* The constant EST_NUMBER_ENTRIES acts as a check and MUST be        */
/* incremented if extra entries are added to the DCT.                 */
/**********************************************************************/
#define EST_NOT_USED                 -1   /* Entry in DCT not used    */
                                          /* for this printer         */
#define EST_NULL                      0
#define EST_BACKSPACE                 1
#define EST_LINE_FEED                 2
#define EST_FORM_FEED                 3
#define EST_CARRIAGE_RETURN           4
#define EST_SPACE                     5

#define EST_PRO_INIT_1                6
#define EST_PRO_INIT_2                7
#define EST_PRO_INIT_3                8
#define EST_QUIET_INIT_1              9
#define EST_QUIET_INIT_2             10
#define EST_QUIET_INIT_3             11

#define EST_SET_VERTICAL_UNITS       12
#define EST_SET_T_LINE_SPACING       13
#define EST_SET_G_LINE_SPACING       14
#define EST_SET_PAGE_LENGTH          15
#define EST_VARIABLE_LINE_FEED       16

#define EST_NORMAL_DENSITY           17
#define EST_GRAPHICS_MODE_0          17

#define EST_DUAL_DENSITY_HALF_SPEED  18
#define EST_GRAPHICS_MODE_1          18

#define EST_HIGH_DENSITY             19
#define EST_GRAPHICS_MODE_3          19

#define EST_HIGH_RESOLUTION_A        20
#define EST_GRAPHICS_MODE_8          20

#define EST_HIGH_RESOLUTION_B        21
#define EST_GRAPHICS_MODE_9          21

#define EST_HIGH_RESOLUTION_C        22
#define EST_GRAPHICS_MODE_10         22

#define EST_HIGH_RESOLUTION_D        23
#define EST_GRAPHICS_MODE_11         23

#define EST_HIGH_RESOLUTION_E        24
#define EST_GRAPHICS_MODE_12         24

#define EST_SET_ASPECT_RATIO         25

#define EST_DOWNLOAD_FONT            26
#define EST_SELECT_FONT              27
#define EST_PRINT_TEXT               28

#define EST_MOVE_RIGHT               29
#define EST_CR_THEN_MOVE_RIGHT       30
#define EST_MOVE_LEFT                31

#define EST_10_CPI                   32
#define EST_12_CPI                   33

#define EST_15_CPI                   34
#define EST_17_CPI                   34

#define EST_20_CPI                   35

#define EST_PROP_SPACING_ON          36
#define EST_PROP_SPACING_OFF         37
#define EST_D_WIDE_ON                38
#define EST_D_WIDE_OFF               39
#define EST_D_HIGH_ON                40
#define EST_D_HIGH_OFF               41
#define EST_D_WIDE_HIGH_ON           42
#define EST_D_WIDE_HIGH_OFF          43
#define EST_UNDERSCORE_ON            44
#define EST_UNDERSCORE_OFF           45
#define EST_BOLD_ON                  46
#define EST_BOLD_OFF                 47
#define EST_BOLD_D_WIDE_ON           48
#define EST_BOLD_D_WIDE_OFF          49
#define EST_BOLD_D_HIGH_ON           50
#define EST_BOLD_D_HIGH_OFF          51
#define EST_BOLD_D_WIDE_HIGH_ON      52
#define EST_BOLD_D_WIDE_HIGH_OFF     53
#define EST_BOLD_UNDERSCORE_ON       54
#define EST_BOLD_UNDERSCORE_OFF      55
#define EST_D_STRIKE_D_WIDE_ON       56
#define EST_D_STRIKE_D_WIDE_OFF      57
#define EST_D_STRIKE_UNDERSCORE_ON   58
#define EST_D_STRIKE_UNDERSCORE_OFF  59

#define EST_DRAFT_MODE               60
#define EST_QUALITY_MODE             61
#define EST_ENHANCED_MODE            62

#define EST_SELECT_SOURCE            63
#define EST_SIC_PRO_X24              64
#define EST_SIC_SET_MODE             65
#define EST_SIC_INIT_CODE_PAGE_850   66

#define EST_SET_CODE_PAGE            67
#define EST_SET_CODE_PAGE_4224       68
#define EST_INIT_LOCAL_FONT          69

#define EST_SET_FORE_COLOR           70

#define EST_SEL_OCR_A_876            71
#define EST_SEL_OCR_B_877            72

#define EST_SPH_SET_ITALIC           73
#define EST_SPH_RESET_ITALIC         74
#define EST_SPH_SET_ITALIC_15        75
#define EST_SPH_SET_ITALIC_12        76
#define EST_SPH_RESET_ITALIC_10      77

#define EST_SET_ORIENTATION          78
#define EST_SET_FONT_GLOBAL_3816     79
#define EST_DEL_LOCAL_FONTS          80
#define EST_D_STRIKE_ON              81
#define EST_D_STRIKE_OFF             82

#define EST_SIC_3816_SIMPLEX         83
#define EST_SIC_3816_DUPLEX          84

#define EST_NUL_SACRIFICE            85
#define EST_MARGINS                  86
#define EST_DUMMY_DOWNLOAD           87

#define EST_SIC_4019                 88
#define EST_SELECT_SOURCE_FORM       89
#define EST_MOVE_SCP                 90
#define EST_RIG                      91
#define EST_DLF                      92
#define EST_SET_FONT_GLOBAL_4019     93
#define EST_FSC_FGID_PART_1          94
#define EST_FSC_FGID_PART_2          95
#define EST_FSC_FGID_PART_3          96
#define EST_SIC_4019_END             97
#define EST_SELECT_ITALIC            98
#define EST_SELECT_SOURCE_DUPLEX     99
#define EST_RF                      100
#define EST_FSC_SHEAR_PART_1        101
#define EST_FSC_SHEAR_PART_2        102
#define EST_FSC_SHEAR_PART_3        103
#define EST_FSC_SHEAR_PART_4        104
#define EST_SELECT_PRINT_ANGLE      105
#define EST_SET_FONT_GLOBAL_NT      106
#define EST_NT_FAST_DRAFT           107
#define EST_NT_DRAFT                108
#define EST_NT_LQ                   109
#define EST_BEGIN_NT_SIC            110                   /* PD00222  */
#define EST_BEGIN_NT_SIC_2          111                   /* PD00222  */
#define EST_END_NT_SIC              112                   /* PD00222  */
#define EST_SET_NT_VERTICAL_UNITS   113                   /* PD00222  */
#define EST_SET_FONT_GOTHIC_10      114                   /* PD00333  */
#define EST_SET_NT_DRAFT_HORZ_SP    115                   /* PD00537  */

#define EST_HIGH_RESOLUTION_F       116                   /* INKJET   */
#define EST_GRAPHICS_MODE_16        116                   /* INKJET   */

#define EST_FONT_LQ_GOTHIC_10       117                   /* INKJET   */
#define EST_MOVE_SCP_600_DPI        118                   /* 600DPI   */
#define EST_RF_600_DPI              119                   /* 600DPI   */
#define RULE_AND_FILL_SIZE           13                   /* PD00769  */


/**********************************************************************/
/* The constant EST_NUMBER_ENTRIES acts as a check and MUST be        */
/* incremented if extra entries are added to the EST.                 */
/**********************************************************************/
#define EST_NUMBER_ENTRIES          120


/**********************************************************************/
/* Selection codes for orientation.                                   */
/**********************************************************************/
#define ORIENT_PORTRAIT          0x6B
#define ORIENT_LANDSCAPE         0x6C

/**********************************************************************/
/* Selection codes for resident fonts                                 */
/**********************************************************************/
                                                /* ProPrinters        */
#define SEL_DRAFT                0
#define SEL_FASTFONT             1
#define SEL_NLQ                  2
#define SEL_NLQ_II               3
#define SEL_ITALIC              11
#define SEL_LQ_COURIER10         2
#define SEL_LQ_COURIER12        10
#define SEL_LQ_COURIER17        18
#define SEL_LQ_COURIERPS         3

                                                /* 4224               */
#define SEL_DP_GOTHIC            0x01
#define SEL_DP_COURIER_FP        0x02
#define SEL_DP_COURIER_PS        0x04
#define SEL_NLQ_COURIER_FP       0x03
#define SEL_NLQ_ESSAY_PS         0x05
#define SEL_OCR_A_340            0x10
#define SEL_OCR_B_340            0x11

                                                /* Quick and Quiet    */
#define SEL_437_10_CPI          32
#define SEL_437_12_CPI          33
#define SEL_437_17_CPI          34
#define SEL_437_PS              35
#define SEL_850_10_CPI          36
#define SEL_850_12_CPI          37
#define SEL_850_17_CPI          38
#define SEL_850_PS              39


/**********************************************************************/
/* Constants for 4019 A4 clip change.                                 */
/**********************************************************************/
#define A4_FORM                  3
#define A4_FORM_ID               4
#define A4_CLIP_INDEX           14


/**********************************************************************/
/* Values for ProPrinters and the 4224s                    PD00265    */
/**********************************************************************/
#define IDR_850_BIN_PRO_II        2001
#define IDR_850_BIN_PRO_III       2002
#define IDR_850_BIN_PRO_X24       2003

#define IDR_9_DRAFT_10               1
#define IDR_9_DRAFT_12               2
#define IDR_9_DRAFT_17               3
#define IDR_9_NLQ_10                 4
#define IDR_9_NLQ_12                 5
#define IDR_9_DRAFT_PS               6
#define IDR_9_NLQ_PS                 7
#define IDR_9_DRAFT_20               8
#define IDR_9_FASTFONT_12            9
#define IDR_9_NLQII_10              10
#define IDR_9_NLQII_12              11
#define IDR_9_ITALIC_10             12
#define IDR_9_ITALIC_12             13

#define IDR_24_DRAFT_10             21
#define IDR_24_DRAFT_12             22
#define IDR_24_DRAFT_17             23
#define IDR_24_LQ_10                24
#define IDR_24_LQ_12                25
#define IDR_24_LQ_17                26
#define IDR_24_LQ_PS                27

#define IDR_42_DPGOTH_10            41
#define IDR_42_DPGOTH_12            42
#define IDR_42_DPGOTH_15            43
#define IDR_42_DPCOUR_10            44
#define IDR_42_DPCOUR_12            45
#define IDR_42_DPCOUR_15            46
#define IDR_42_NLQ_10               47
#define IDR_42_NLQ_12               48
#define IDR_42_NLQ_15               49
#define IDR_42_DPGOTH_ITALIC_10     50
#define IDR_42_DPGOTH_ITALIC_12     51
#define IDR_42_DPGOTH_ITALIC_15     52
#define IDR_42_DPCOUR_ITALIC_10     53
#define IDR_42_DPCOUR_ITALIC_12     54
#define IDR_42_DPCOUR_ITALIC_15     55
#define IDR_42_NLQ_ITALIC_10        56
#define IDR_42_NLQ_ITALIC_12        57
#define IDR_42_NLQ_ITALIC_15        58
#define IDR_42_DPCOUR_PS            59
#define IDR_42_NLQESSAY_PS          60
#define IDR_42_DPCOUR_ITALIC_PS     61
#define IDR_42_NLQESSAY_ITALIC_PS   62
#define IDR_42_OCR_A_876            63
#define IDR_42_OCR_B_877            64

#define IDR_850_9_DRAFT_10         101
#define IDR_850_9_DRAFT_12         102
#define IDR_850_9_DRAFT_17         103
#define IDR_850_9_NLQ_10           104
#define IDR_850_9_NLQ_12           105
#define IDR_850_9_DRAFT_PS         106
#define IDR_850_9_NLQ_PS           107
#define IDR_850_9_DRAFT_20         108
#define IDR_850_9_FASTFONT_12      109
#define IDR_850_9_NLQII_10         110
#define IDR_850_9_NLQII_12         111
#define IDR_850_9_ITALIC_10        112
#define IDR_850_9_ITALIC_12        113

#define IDR_850_24_DRAFT_10        121
#define IDR_850_24_DRAFT_12        122
#define IDR_850_24_DRAFT_17        123
#define IDR_850_24_LQ_10           124
#define IDR_850_24_LQ_12           125
#define IDR_850_24_LQ_17           126
#define IDR_850_24_LQ_PS           127

#define IDR_850_42_DPGOTH_10       131
#define IDR_850_42_DPGOTH_12       132
#define IDR_850_42_DPGOTH_15       133
#define IDR_850_42_DPGOTH_16       134
#define IDR_850_42_DPCOUR_10       135
#define IDR_850_42_DPCOUR_12       136
#define IDR_850_42_DPCOUR_15       137
// #define IDR_850_42_DPCOUR_PS    138         /* Not supported on printer */
#define IDR_850_42_NLQ_10          139
#define IDR_850_42_NLQ_12          140
#define IDR_850_42_NLQ_15          141
// #define IDR_850_42_NLQESSAY_PS  142         /* Not supported on printer */

#define IDR_850_42_DPGOTH_ITALIC_10       143
#define IDR_850_42_DPGOTH_ITALIC_12       144
#define IDR_850_42_DPGOTH_ITALIC_15       145
#define IDR_850_42_DPGOTH_ITALIC_16       146
#define IDR_850_42_DPCOUR_ITALIC_10       147
#define IDR_850_42_DPCOUR_ITALIC_12       148
#define IDR_850_42_DPCOUR_ITALIC_15       149
// #define IDR_850_42_DPCOUR_ITALIC_PS   150  /* Not supported on printer */
#define IDR_850_42_NLQ_ITALIC_10          151
#define IDR_850_42_NLQ_ITALIC_12          152
#define IDR_850_42_NLQ_ITALIC_15          153
// #define IDR_850_42_NLQESSAY_ITALIC_PS  154  /* Not supported on printer */

#define IDR_851_9_DRAFT_10         201
#define IDR_851_9_DRAFT_12         202
#define IDR_851_9_DRAFT_17         203
#define IDR_851_9_NLQ_10           204
#define IDR_851_9_NLQ_12           205
#define IDR_851_9_DRAFT_PS         206
#define IDR_851_9_NLQ_PS           207
#define IDR_851_9_DRAFT_20         208
#define IDR_851_9_FASTFONT_12      209
#define IDR_851_9_NLQII_10         210
#define IDR_851_9_NLQII_12         211
#define IDR_851_9_ITALIC_10        212
#define IDR_851_9_ITALIC_12        213

#define IDR_851_24_DRAFT_10        221
#define IDR_851_24_DRAFT_12        222
#define IDR_851_24_DRAFT_17        223
#define IDR_851_24_LQ_10           224
#define IDR_851_24_LQ_12           225
#define IDR_851_24_LQ_17           226
#define IDR_851_24_LQ_PS           227


#define IDR_852_9_DRAFT_10         301
#define IDR_852_9_DRAFT_12         302
#define IDR_852_9_DRAFT_17         303
#define IDR_852_9_NLQ_10           304
#define IDR_852_9_NLQ_12           305
#define IDR_852_9_DRAFT_PS         306
#define IDR_852_9_NLQ_PS           307
#define IDR_852_9_DRAFT_20         308
#define IDR_852_9_FASTFONT_12      309
#define IDR_852_9_NLQII_10         310
#define IDR_852_9_NLQII_12         311
#define IDR_852_9_ITALIC_10        312
#define IDR_852_9_ITALIC_12        313

#define IDR_852_24_DRAFT_10        321
#define IDR_852_24_DRAFT_12        322
#define IDR_852_24_DRAFT_17        323
#define IDR_852_24_LQ_10           324
#define IDR_852_24_LQ_12           325
#define IDR_852_24_LQ_17           326
#define IDR_852_24_LQ_PS           327


#define IDR_853_9_DRAFT_10         401
#define IDR_853_9_DRAFT_12         402
#define IDR_853_9_DRAFT_17         403
#define IDR_853_9_NLQ_10           404
#define IDR_853_9_NLQ_12           405
#define IDR_853_9_DRAFT_PS         406
#define IDR_853_9_NLQ_PS           407
#define IDR_853_9_DRAFT_20         408
#define IDR_853_9_FASTFONT_12      409
#define IDR_853_9_NLQII_10         410
#define IDR_853_9_NLQII_12         411
#define IDR_853_9_ITALIC_10        412
#define IDR_853_9_ITALIC_12        413

#define IDR_853_24_DRAFT_10        421
#define IDR_853_24_DRAFT_12        422
#define IDR_853_24_DRAFT_17        423
#define IDR_853_24_LQ_10           424
#define IDR_853_24_LQ_12           425
#define IDR_853_24_LQ_17           426
#define IDR_853_24_LQ_PS           427


#define IDR_855_9_DRAFT_10         501
#define IDR_855_9_DRAFT_12         502
#define IDR_855_9_DRAFT_17         503
#define IDR_855_9_NLQ_10           504
#define IDR_855_9_NLQ_12           505
#define IDR_855_9_DRAFT_PS         506
#define IDR_855_9_NLQ_PS           507
#define IDR_855_9_DRAFT_20         508
#define IDR_855_9_FASTFONT_12      509
#define IDR_855_9_NLQII_10         510
#define IDR_855_9_NLQII_12         511
#define IDR_855_9_ITALIC_10        512
#define IDR_855_9_ITALIC_12        513

#define IDR_855_24_DRAFT_10        521
#define IDR_855_24_DRAFT_12        522
#define IDR_855_24_DRAFT_17        523
#define IDR_855_24_LQ_10           524
#define IDR_855_24_LQ_12           525
#define IDR_855_24_LQ_17           526
#define IDR_855_24_LQ_PS           527


#define IDR_862_9_DRAFT_10         601
#define IDR_862_9_DRAFT_12         602
#define IDR_862_9_DRAFT_17         603
#define IDR_862_9_NLQ_10           604
#define IDR_862_9_NLQ_12           605
#define IDR_862_9_DRAFT_PS         606
#define IDR_862_9_NLQ_PS           607
#define IDR_862_9_DRAFT_20         608
#define IDR_862_9_FASTFONT_12      609
#define IDR_862_9_NLQII_10         610
#define IDR_862_9_NLQII_12         611
#define IDR_862_9_ITALIC_10        612
#define IDR_862_9_ITALIC_12        613

#define IDR_862_24_DRAFT_10        621
#define IDR_862_24_DRAFT_12        622
#define IDR_862_24_DRAFT_17        623
#define IDR_862_24_LQ_10           624
#define IDR_862_24_LQ_12           625
#define IDR_862_24_LQ_17           626
#define IDR_862_24_LQ_PS           627


#define IDR_863_24_DRAFT_10        631
#define IDR_863_24_DRAFT_12        632
#define IDR_863_24_DRAFT_17        633
#define IDR_863_24_LQ_10           634
#define IDR_863_24_LQ_12           635
#define IDR_863_24_LQ_17           636
#define IDR_863_24_LQ_PS           637


#define IDR_864_9_DRAFT_10         641
#define IDR_864_9_DRAFT_12         642
#define IDR_864_9_DRAFT_17         643
#define IDR_864_9_NLQ_10           644
#define IDR_864_9_NLQ_12           645
#define IDR_864_9_DRAFT_PS         646
#define IDR_864_9_NLQ_PS           647
#define IDR_864_9_DRAFT_20         648
#define IDR_864_9_FASTFONT_12      649
#define IDR_864_9_NLQII_10         650
#define IDR_864_9_NLQII_12         651
#define IDR_864_9_ITALIC_10        652
#define IDR_864_9_ITALIC_12        653

#define IDR_864_24_DRAFT_10        661
#define IDR_864_24_DRAFT_12        662
#define IDR_864_24_DRAFT_17        663
#define IDR_864_24_LQ_10           664
#define IDR_864_24_LQ_12           665
#define IDR_864_24_LQ_17           666
#define IDR_864_24_LQ_PS           667


/**********************************************************************/
/* Values for the IBM2380, IBM2381                      PD00265       */
/**********************************************************************/
#define IDR_9W_437_DRAFT_10        702
#define IDR_9W_437_DRAFT_12        703
#define IDR_9W_437_DRAFT_15        704
#define IDR_9W_437_DRAFT_17        705
#define IDR_9W_437_DRAFT_20        706

#define IDR_9W_437_DRAFT_PS        711
#define IDR_9W_850_DRAFT_PS        712
#define IDR_9W_860_DRAFT_PS        713
#define IDR_9W_863_DRAFT_PS        714
#define IDR_9W_865_DRAFT_PS        715
#define IDR_9W_852_DRAFT_PS        716
#define IDR_9W_855_DRAFT_PS        717
#define IDR_9W_857_DRAFT_PS        718
#define IDR_9W_862_DRAFT_PS        719
#define IDR_9W_864_DRAFT_PS        720
#define IDR_9W_869_DRAFT_PS        721

#define IDR_9W_437_FDRAFT_10       725

#define IDR_9W_437_COURIER_10      731
#define IDR_9W_437_COURIER_12      732
#define IDR_9W_437_COURIER_15      733
#define IDR_9W_437_COURIER_17      734
#define IDR_9W_437_COURIER_20      735

#define IDR_9W_437_COURIER_PS      741
#define IDR_9W_850_COURIER_PS      742
#define IDR_9W_860_COURIER_PS      743
#define IDR_9W_863_COURIER_PS      744
#define IDR_9W_865_COURIER_PS      745
#define IDR_9W_852_COURIER_PS      746
#define IDR_9W_855_COURIER_PS      747
#define IDR_9W_857_COURIER_PS      748
#define IDR_9W_862_COURIER_PS      749
#define IDR_9W_864_COURIER_PS      750
#define IDR_9W_869_COURIER_PS      751

#define IDR_9W_437_GOTHIC_10       761
#define IDR_9W_437_GOTHIC_12       762
#define IDR_9W_437_GOTHIC_17       763

#define IDR_9W_437_GOTHIC_PS       771
#define IDR_9W_850_GOTHIC_PS       772
#define IDR_9W_860_GOTHIC_PS       773
#define IDR_9W_863_GOTHIC_PS       774
#define IDR_9W_865_GOTHIC_PS       775
#define IDR_9W_852_GOTHIC_PS       776
#define IDR_9W_855_GOTHIC_PS       777
#define IDR_9W_857_GOTHIC_PS       778
#define IDR_9W_862_GOTHIC_PS       779
#define IDR_9W_864_GOTHIC_PS       780
#define IDR_9W_869_GOTHIC_PS       781

#define IDR_9W_437_DRAFT_PSI       791
#define IDR_9W_850_DRAFT_PSI       792
#define IDR_9W_860_DRAFT_PSI       793
#define IDR_9W_863_DRAFT_PSI       794
#define IDR_9W_865_DRAFT_PSI       795
#define IDR_9W_852_DRAFT_PSI       796
#define IDR_9W_855_DRAFT_PSI       797
#define IDR_9W_857_DRAFT_PSI       798
#define IDR_9W_862_DRAFT_PSI       799
#define IDR_9W_864_DRAFT_PSI       800
#define IDR_9W_869_DRAFT_PSI       801

#define IDR_9W_437_COURIER_PSI     811
#define IDR_9W_850_COURIER_PSI     812
#define IDR_9W_860_COURIER_PSI     813
#define IDR_9W_863_COURIER_PSI     814
#define IDR_9W_865_COURIER_PSI     815
#define IDR_9W_852_COURIER_PSI     816
#define IDR_9W_855_COURIER_PSI     817
#define IDR_9W_857_COURIER_PSI     818
#define IDR_9W_862_COURIER_PSI     819
#define IDR_9W_864_COURIER_PSI     820
#define IDR_9W_869_COURIER_PSI     821

#define IDR_9W_437_GOTHIC_PSI      831
#define IDR_9W_850_GOTHIC_PSI      832
#define IDR_9W_860_GOTHIC_PSI      833
#define IDR_9W_863_GOTHIC_PSI      834
#define IDR_9W_865_GOTHIC_PSI      835
#define IDR_9W_852_GOTHIC_PSI      836
#define IDR_9W_855_GOTHIC_PSI      837
#define IDR_9W_857_GOTHIC_PSI      838
#define IDR_9W_862_GOTHIC_PSI      839
#define IDR_9W_864_GOTHIC_PSI      840
#define IDR_9W_869_GOTHIC_PSI      841

/**********************************************************************/
/* Values for the IBM2390, IBM2391                           PD00265  */
/**********************************************************************/
#define IDR_24W_437_DRAFT_10       901
#define IDR_24W_437_DRAFT_12       902
#define IDR_24W_437_DRAFT_15       903
#define IDR_24W_437_DRAFT_17       904
#define IDR_24W_437_DRAFT_20       905
#define IDR_24W_437_DRAFT_24       906

#define IDR_24W_437_DRAFT_PS       911
#define IDR_24W_850_DRAFT_PS       912
#define IDR_24W_860_DRAFT_PS       913
#define IDR_24W_863_DRAFT_PS       914
#define IDR_24W_865_DRAFT_PS       915
#define IDR_24W_852_DRAFT_PS       916
#define IDR_24W_855_DRAFT_PS       917
#define IDR_24W_857_DRAFT_PS       918
#define IDR_24W_862_DRAFT_PS       919
#define IDR_24W_864_DRAFT_PS       920
#define IDR_24W_869_DRAFT_PS       921

#define IDR_24W_437_FDRAFT_10      925

#define IDR_24W_437_COURIER_10     931
#define IDR_24W_437_COURIER_12     932
#define IDR_24W_437_COURIER_15     933
#define IDR_24W_437_COURIER_17     934
#define IDR_24W_437_COURIER_20     935
#define IDR_24W_437_COURIER_24     936

#define IDR_24W_437_COURIER_PS     941
#define IDR_24W_850_COURIER_PS     942
#define IDR_24W_860_COURIER_PS     943
#define IDR_24W_863_COURIER_PS     944
#define IDR_24W_865_COURIER_PS     945
#define IDR_24W_852_COURIER_PS     946
#define IDR_24W_855_COURIER_PS     947
#define IDR_24W_857_COURIER_PS     948
#define IDR_24W_862_COURIER_PS     949
#define IDR_24W_864_COURIER_PS     950
#define IDR_24W_869_COURIER_PS     951

#define IDR_24W_437_GOTHIC_10      953
#define IDR_24W_437_GOTHIC_12      954
#define IDR_24W_437_GOTHIC_17      955

#define IDR_24W_437_GOTHIC_PS      956
#define IDR_24W_850_GOTHIC_PS      957
#define IDR_24W_860_GOTHIC_PS      958
#define IDR_24W_863_GOTHIC_PS      959
#define IDR_24W_865_GOTHIC_PS      961
#define IDR_24W_852_GOTHIC_PS      962
#define IDR_24W_855_GOTHIC_PS      963
#define IDR_24W_857_GOTHIC_PS      964
#define IDR_24W_862_GOTHIC_PS      965
#define IDR_24W_864_GOTHIC_PS      966
#define IDR_24W_869_GOTHIC_PS      967

#define IDR_24W_437_PRESTIGE_10    971
#define IDR_24W_437_PRESTIGE_12    972
#define IDR_24W_437_PRESTIGE_17    973

#define IDR_24W_437_PRESTIGE_PS    974
#define IDR_24W_850_PRESTIGE_PS    975
#define IDR_24W_860_PRESTIGE_PS    976
#define IDR_24W_863_PRESTIGE_PS    977
#define IDR_24W_865_PRESTIGE_PS    978
#define IDR_24W_852_PRESTIGE_PS    979
#define IDR_24W_855_PRESTIGE_PS    980
#define IDR_24W_857_PRESTIGE_PS    981
#define IDR_24W_862_PRESTIGE_PS    982
#define IDR_24W_864_PRESTIGE_PS    983
#define IDR_24W_869_PRESTIGE_PS    984

#define IDR_24W_437_ORATOR_10      990
#define IDR_24W_437_ORATOR_12      991
#define IDR_24W_437_ORATOR_17      992

#define IDR_24W_437_ORATOR_PS      993
#define IDR_24W_850_ORATOR_PS      994
#define IDR_24W_860_ORATOR_PS      995
#define IDR_24W_863_ORATOR_PS      996
#define IDR_24W_865_ORATOR_PS      997

#define IDR_24W_437_PRESENTOR_10  1001
#define IDR_24W_437_PRESENTOR_12  1002
#define IDR_24W_437_PRESENTOR_17  1003

#define IDR_24W_437_PRESENTOR_PS  1005
#define IDR_24W_850_PRESENTOR_PS  1006
#define IDR_24W_860_PRESENTOR_PS  1007
#define IDR_24W_863_PRESENTOR_PS  1008
#define IDR_24W_865_PRESENTOR_PS  1009

#define IDR_24W_437_SCRIPT_10     1011
#define IDR_24W_437_SCRIPT_12     1012
#define IDR_24W_437_SCRIPT_17     1013

#define IDR_24W_437_SCRIPT_PS     1014
#define IDR_24W_850_SCRIPT_PS     1015
#define IDR_24W_860_SCRIPT_PS     1016
#define IDR_24W_863_SCRIPT_PS     1017
#define IDR_24W_865_SCRIPT_PS     1018

/**********************************************************************/
/* PD00221 : Add Fast Draft 12 for 4226                    PD00265    */
/**********************************************************************/
#define IDR_9W_437_FDRAFT_12       1020

/******************************************************************************/
/*  INKJET : Add Prestige 15 and 20 for the 4072                              */
/******************************************************************************/
#define IDR_24W_437_PRESTIGE_15    1030
#define IDR_24W_437_PRESTIGE_20    1031
/******************************************************************************/
/*  INKJET Add Courier 20 and Prestige 12                                     */
/******************************************************************************/
#define IDR_48N_437_COURIER_20     1032
#define IDR_48N_437_PRESTIGE_12    1033
/******************************************************************************/
/*  PD00757 : Add Gothic 20 for the ExecJet                                   */
/******************************************************************************/
#define IDR_48N_437_GOTHIC_20      1034

/**********************************************************************/
/* Values for Quiet, Quick and 3816                                   */
/**********************************************************************/
#define IDR_QUIET_ENHANCED_10         1
#define IDR_QUIET_ENHANCED_12         2
#define IDR_QUIET_ENHANCED_17         3
#define IDR_QUIET_ENHANCED_PS         4
#define IDR_QUIET_QUALITY_10          5
#define IDR_QUIET_QUALITY_12          6
#define IDR_QUIET_QUALITY_17          7
#define IDR_QUIET_QUALITY_PS          8
#define IDR_QUIET_DRAFT_10            9
#define IDR_QUIET_DRAFT_12           10
#define IDR_QUIET_DRAFT_17           11
#define IDR_QUIET_DRAFT_PS           12


#define IDR_QUICK_437_QUALITY_10     21
#define IDR_QUICK_437_QUALITY_12     22
#define IDR_QUICK_437_QUALITY_17     23
#define IDR_QUICK_437_QUALITY_PS     24
#define IDR_QUICK_437_DRAFT_10       25
#define IDR_QUICK_437_DRAFT_12       26
#define IDR_QUICK_437_DRAFT_17       27
#define IDR_QUICK_437_DRAFT_PS       28
#define IDR_QUICK_850_QUALITY_10     29
#define IDR_QUICK_850_QUALITY_12     30
#define IDR_QUICK_850_QUALITY_17     31
#define IDR_QUICK_850_QUALITY_PS     32
#define IDR_QUICK_850_DRAFT_10       33
#define IDR_QUICK_850_DRAFT_12       34
#define IDR_QUICK_850_DRAFT_17       35
#define IDR_QUICK_850_DRAFT_PS       36


#define IDR_PP_437_COUR_10           41   /*   Courier 10                 */
#define IDR_PP_437_COUR_BL_10        42   /*   Courier Bold 10            */
#define IDR_PP_437_COUR_IT_10        43   /*   Courier Italic 10          */
#define IDR_PP_437_COUR_IT_BL_10     44   /*   Courier Italic Bold 10     */
#define IDR_PP_437_COUR_12           45   /*   Courier 12                 */
#define IDR_PP_437_COUR_BL_12        46   /*   Courier Bold 12            */
#define IDR_PP_437_COUR_17           47   /*   Courier 17                 */
#define IDR_PP_437_COUR_BL_17        48   /*   Courier Bold 17            */
#define IDR_PP_437_PRES_10           49   /*   Prestige 10                */
#define IDR_PP_437_PRES_BL_10        50   /*   Prestige Bold 10           */
#define IDR_PP_437_PRES_12           51   /*   Prestige 12                */
#define IDR_PP_437_PRES_BL_12        52   /*   Prestige Bold 12           */
#define IDR_PP_437_DOCUMENT_PSM      53   /*   Document PSM               */
#define IDR_PP_437_DOCUMENT_BL_PSM   54   /*   Document Bold PSM          */
#define IDR_PP_437_BOLDFACE_PSM      55   /*   Boldface PSM               */

#define IDR_PP_850_COUR_10           56   /*   Courier 10                 */
#define IDR_PP_850_COUR_BL_10        57   /*   Courier Bold 10            */
#define IDR_PP_850_COUR_IT_10        58   /*   Courier Italic 10          */
#define IDR_PP_850_COUR_IT_BL_10     59   /*   Courier Italic Bold 10     */
#define IDR_PP_850_COUR_12           60   /*   Courier 12                 */
#define IDR_PP_850_COUR_BL_12        61   /*   Courier Bold 12            */
#define IDR_PP_850_COUR_17           62   /*   Courier 17                 */
#define IDR_PP_850_COUR_BL_17        63   /*   Courier Bold 17            */
#define IDR_PP_850_PRES_10           64   /*   Prestige 10                */
#define IDR_PP_850_PRES_BL_10        65   /*   Prestige Bold 10           */
#define IDR_PP_850_PRES_12           66   /*   Prestige 12                */
#define IDR_PP_850_PRES_BL_12        67   /*   Prestige Bold 12           */
#define IDR_PP_850_PRES_IT_12        68   /*   Prestige Italic 12         */
#define IDR_PP_850_PRES_IT_BL_12     69   /*   Prestige Italic Bold 12    */
#define IDR_PP_850_DOCUMENT_PSM      70   /*   Document PSM               */
#define IDR_PP_850_DOCUMENT_BL_PSM   71   /*   Document Bold PSM          */
#define IDR_PP_850_BOLDFACE_PSM      72   /*   Boldface PSM               */
#define IDR_PP_850_BOLDFACE_IT_PSM   73   /*   Boldface Italic PSM        */
#define IDR_PP_850_LTR_GTH_12        74   /*   Letter Gothic 12           */
#define IDR_PP_850_LTR_GTH_BL_12     75   /*   Letter Gothic Bold 12      */
#define IDR_PP_850_ORATOR_10         76   /*   Orator 10                  */
#define IDR_PP_850_ORATOR_BL_10      77   /*   Orator Bold 10             */
#define IDR_PP_850_ESSAY_PSM         78   /*   Essay PSM                  */
#define IDR_PP_850_ESSAY_BL_PSM      79   /*   Essay Bold PSM             */
#define IDR_PP_850_ESSAY_IT_PSM      80   /*   Essay Italic PSM           */
#define IDR_PP_850_ESSAY_IT_BL_PSM   81   /*   Essay Italic Bold PSM      */
#define IDR_PP_850_ESSAY_LT_PSM      82   /*   Essay Light PSM            */
#define IDR_PP_850_ESSAY_LT_BL_PSM   83   /*   Essay Light Bold PSM       */
#define IDR_PP_850_GTH_TXT_10        84   /*   Gothic Text 10             */
#define IDR_PP_850_GTH_TXT_BL_10     85   /*   Gothic Text Bold 10        */
#define IDR_PP_850_GTH_TXT_12        86   /*   Gothic Text 12             */
#define IDR_PP_850_GTH_TXT_BL_12     87   /*   Gothic Text Bold 12        */
#define IDR_PP_850_GTH_TXT_IT_12     88   /*   Gothic Text Italic 12      */
#define IDR_PP_850_GTH_TXT_IT_BL_12  89   /*   Gothic Text Italic Bold 12 */
#define IDR_PP_850_GTH_TXT_13        90   /*   Gothic Text 13             */
#define IDR_PP_850_GTH_TXT_BL_13     91   /*   Gothic Text Bold 13        */
#define IDR_PP_850_GTH_TXT_15        92   /*   Gothic Text 15             */
#define IDR_PP_850_GTH_TXT_BL_15     93   /*   Gothic Text Bold 15        */
#define IDR_PP_850_GTH_TXT_CN_15     94   /*   Gothic Text Cond 15        */
#define IDR_PP_850_GTH_TXT_CN_BL_15  95   /*   Gothic Text Cond Bold 15   */
#define IDR_PP_850_GTH_TXT_20        96   /*   Gothic Text 20             */
#define IDR_PP_850_GTH_TXT_27        97   /*   Gothic Text 27             */
#define IDR_PP_850_GTH_TXT_TRI       98   /*   Gothic Text Tri-pitch      */
#define IDR_PP_850_GTH_TXT_BL_TRI    99   /*   Gothic Text Bld Tri-pitch  */
#define IDR_PP_850_SRF_TXT_10       100   /*   Serif Text 10              */
#define IDR_PP_850_SRF_TXT_BL_10    101   /*   Serif Text Bold 10         */
#define IDR_PP_850_SRF_TXT_IT_10    102   /*   Serif Text Italic 10       */
#define IDR_PP_850_SRF_TXT_IT_BL_10 103   /*   Serif Text Italic Bold 10  */
#define IDR_PP_850_SRF_TXT_12       104   /*   Serif Text 12              */
#define IDR_PP_850_SRF_TXT_BL_12    105   /*   Serif Text Bold 12         */
#define IDR_PP_850_SRF_TXT_IT_12    106   /*   Serif Text Italic 12       */
#define IDR_PP_850_SRF_TXT_IT_BL_12 107   /*   Serif Text Italic Bold 12  */
#define IDR_PP_850_SRF_TXT_15       108   /*   Serif Text 15              */
#define IDR_PP_850_SRF_TXT_BL_15    109   /*   Serif Text Bold 15         */
#define IDR_PP_850_RMN_TXT_10       110   /*   Roman Text 10              */
#define IDR_PP_850_RMN_TXT_BL_10    111   /*   Roman Text Bold 10         */
#define IDR_PP_850_SCRIPT_12        112   /*   Script 12                  */
#define IDR_PP_850_SCRIPT_BL_12     113   /*   Script Bold 12             */
#define IDR_PP_850_SON_SRF_8        114   /*   Sonoran Serif 8pt          */
#define IDR_PP_850_SON_SRF_10       115   /*   Sonoran Serif 10pt         */
#define IDR_PP_850_SON_SRF_BL_10    116   /*   Sonoran Serif Bold 10pt    */
#define IDR_PP_850_SON_SRF_IT_10    117   /*   Sonoran Serif Ital 10pt    */
#define IDR_PP_850_SON_SRF_12       118   /*   Sonoran Serif 12pt         */
#define IDR_PP_850_SON_SRF_BL_16    119   /*   Sonoran Serif Bold 16pt    */
#define IDR_PP_850_SON_SRF_BL_18    120   /*   Sonoran Serif Bold 18pt    */
#define IDR_PP_850_SON_SRF_BL_24    121   /*   Sonoran Serif Bold 24pt    */

#define IDR_PP_860_COUR_10          122   /*   Courier 10                 */
#define IDR_PP_860_COUR_BL_10       123   /*   Courier Bold 10            */

#define IDR_PP_861_COUR_10          124   /*   Courier 10                 */
#define IDR_PP_861_COUR_BL_10       125   /*   Courier Bold 10            */

#define IDR_PP_865_COUR_10          126   /*   Courier 10                 */
#define IDR_PP_865_COUR_BL_10       127   /*   Courier Bold 10            */

#define IDR_PP_876_OCR_A_10         128   /*   OCR-A 10                   */

#define IDR_PP_877_OCR_B_10         129   /*   OCR-B 10                   */

#define IDR_PP_907_APL_10           130   /*   APL 10                     */
#define IDR_PP_907_APL_BL_10        131   /*   APL Bold 10                */
#define IDR_PP_907_APL_20           132   /*   APL 20                     */

#define IDR_PP_911_KATKN_GTH_10     133   /*   Katakana Gothic 10         */
#define IDR_PP_911_KATKN_GTH_BL_10  134   /*   Katakana Gothic Bold 10    */


/**********************************************************************/
/* Constants for 4019 Heritage printer driver - multi-codepage support*/
/* These are Non OS/2 supported code pages that are supported by the  */
/* Heritage printer by using a resource CPV file.                     */
/**********************************************************************/

#define IDR_4019_CPV_FILE_CP819        1031
#define IDR_4019_CPV_FILE_CP861        1032
