/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDD42XX.H
 *
 * DESCRIPTIVE NAME = IBM42XX Device Driver Version Constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* DRIVER VERSIONS:                                                   */
/*                                                                    */
/*                                                                    */
/*  000 to ...                                                        */
/*                                                                    */
/*      INI information is ignored. The driver cannot use this        */
/*      information and resets itself to defaults.                    */
/*                                                                    */
/*  045 (OS2_INI_THRESHOLD) to ...                                    */
/*                                                                    */
/*      INI information is preserved by migrating this format to the  */
/*      latest format.                                                */
/*                                                                    */
/*  200 (OS2_INI_MAGIC_NUMBER1) to ...                                */
/*                                                                    */
/*      INI information is ignored. These are development levels      */
/*      that have not been released.                                  */
/*                                                                    */
/*  221 (OS2_INI_VERSION_THRESHOLD1) to 249                           */
/*                                                                    */
/*      INI information is preserved by migrating this format to the  */
/*      latest format.                                                */
/*                                                                    */
/*  250 (OS2_INI_MAGIC_NUMBER2)  to  ...  current                     */
/*                                                                    */
/*      INI information is used. No migration is neccesary.           */
/*                                                                    */
/*                                                                    */
/* In the description above the versions numbers are inclusive of     */
/* the constant discussed. For example migration occurs for for INI   */
/* data versions of 040 to 199 inclusive.                             */
/**********************************************************************/


/**********************************************************************/
/* The current version of the driver displayed in the dialogs.  This  */
/* must stay the same as the OS2_INI_VERSION.                         */
/**********************************************************************/
#define OS2_INI_VERSION_DLG42XX   "2.104"

#ifndef PRD_DEFINE_ONLY
/**********************************************************************/
/* The current version of the driver used to save INI information.    */
/* This must stay the same as the OS2_INI_VERSION_DLG42XX.            */
/**********************************************************************/
PCHAR   OS2_INI_VERSION        = "356";


/**********************************************************************/
/* These two values are thresholds and do not change. See comments    */
/* above for descriptions.                                            */
/*                                                                    */
/* Suggest calling these:                                             */
/*      OS2_INI_THRESHOLD                                             */
/*      OS2_INI_THRESHOLD1                                            */
/**********************************************************************/
PCHAR   OS2_INI_THRESHOLD      = "040";
PCHAR   OS2_INI_MAGIC_NUMBER1  = "200";

/**********************************************************************/
/* These two values are thresholds and do not change. See comments    */
/* above for descriptions.                                            */
/*                                                                    */
/* Suggest calling these:                                             */
/*      OS2_INI_VERSION_THRESHOLD1                                    */
/*      OS2_INI_VERSION_THRESHOLD2                                    */
/**********************************************************************/
PCHAR   OS2_INI_VERSION_THRESHOLD1 = "221";
PCHAR   OS2_INI_VERSION_THRESHOLD2 = "250";

/**********************************************************************/
/* This value changes when the INI data changes format during the     */
/* development of the driver.                                         */
/*                                                                    */
/* Suggest calling this:                                              */
/*      OS2_INI_RELEASE1                                              */
/**********************************************************************/
PCHAR   OS2_INI_MAGIC_NUMBER2  = "250";

/**********************************************************************/
/* This value changes when the DRIVERDATA changes format during the   */
/* development.                                                       */
/* Suggest calling this:                                              */
/*      OS2_INI_DDRELEASE1                                            */
/**********************************************************************/
PCHAR   OS2_DD_MAGIC_NUMBER    = "250";

/**********************************************************************/
/* PD00587: need to add another magic number for DRIVERDATA as        */
/*  we had to add a new field.                                        */
/**********************************************************************/
PCHAR   OS2_DD_MAGIC_NUMBER2    = "275";

/******************************************************************************/
/*  PD00651 : New Magic number for NLS font list changes in the Nile/Tiber    */
/******************************************************************************/
PCHAR   OS2_DD_MAGIC_NUMBER3  = "278";

/******************************************************************************/
/* PD00769 : New Magic number for PrinterPatterns field added to driverdata   */
/******************************************************************************/
PCHAR   OS2_DD_MAGIC_NUMBER4  = "310";

/**********************************************************************/
/* ???                                                                */
/**********************************************************************/
PCHAR   DOWNSYSFONTS_THRESHOLD = "088";
#endif

