/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDCONTY
 *
 * DESCRIPTIVE NAME = Printer Device Driver Constants used in
 *                    type definitions.
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define DEF_COL_TABLE_SIZE      16     /* Default color table size            */
#define DCT_MAX_SIMPLE          32     /* PD00432...                          */
#define PARSE_STRING_SIZE        8     /* No. chars in a Rop parse string -   */
                                       /* used by bitblt                      */
#define MAX_OPERANDS             5     /* Max operands in a Rop               */
#define NO_OF_DOWN_CPS           8     /* Number of downloadable Code Pages   */
                                       /* (including 850)                     */
#define NO_OF_ADDABLE_CPS        7     /* Number of addable Code Pages        */
#define SLEN_BOX_MESSAGE       255     /* Maximum size of messages used in    */
                                       /* WinMessageBox                       */
#define MAX_NO_OF_CARD_SLOTS     2     /* Maximum number of card or cartridge */
                                       /* slots available on any printer      */
                                       /* supported                           */
#define MAX_NO_OF_PAPER_TRAYS    3     /* Maximum number of automatic paper   */
                                       /* trays in any source configuration.  */
#define NO_OF_AUTO_TRAYS         5     /* Number of automatic trays info is   */
                                       /* held for in DMData and DMSettings.  */
#define MAX_NO_OF_CARDS         50     /* Maximum no.of shipped cards that    */
                                       /* can be handled when  unpacking      */
                                       /* initial metrics                     */
#define FILENAME_SIZE           12     /* For "FILENAME.EXT"                  */
#define CARD_DATA_LENGTH         9     /* Length for card name incl. a '\0'.  */

/******************************************************************************/
/*  Size and length constants for Forms                                       */
/*                                                                            */
/*  PD00253 : Moved from PRDDDCONE.H                                          */
/******************************************************************************/
#define FORM_NAME_LENGTH        32
#define NUMBER_LENGTH            7
#define UNITS_LENGTH             1
#define FORM_DATA_LENGTH         (FORM_NAME_LENGTH + 1 +                       \
                                  6 * (NUMBER_LENGTH + 1) + UNITS_LENGTH + 2)
#define FORM_DIMS_LENGTH         FORM_DATA_LENGTH - FORM_NAME_LENGTH
