/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDBTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver types for Bitmaps
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Type definition for bitmap parameters                                     */
/******************************************************************************/
typedef struct
    {
      ULONG  cbFix;            /* Length of structure                         */
      ULONG  Width;            /* Bit-map width in pels                       */
      ULONG  Height;           /* Bit-map height in pels                      */
      ULONG  Planes;           /* Number of bit planes                        */
      ULONG  Bitcount;         /* Number of bits per pel within a plane       */
      ULONG  ulCompression;    /* Compression scheme used to store the bitmap */
      ULONG  cbImage;          /* Length of bit-map storage data in bytes     */
      ULONG  cxResolution;     /* x resolution of target device               */
      ULONG  cyResolution;     /* y resolution of target device               */
      ULONG  cclrUsed;         /* Number of color indices used                */
      ULONG  cclrImportant;    /* Number of important color indices           */
      USHORT usUnits;          /* Units of measure                            */
      USHORT usReserved;       /* Reserved                                    */
      USHORT usRecording;      /* Recording algorithm                         */
      USHORT usRendering;      /* Halftoning algorithm                        */
      ULONG  cSize1;           /* Size value 1                                */
      ULONG  cSize2;           /* Size value 2                                */
      ULONG  ulColorEncoding;  /* Color encoding                              */
      ULONG  ulIdentifier;     /* Reserved for application use                */
      ULONG  BytesPerRow;
      BOOL   MonBmapReq;       /* set on if mono bitmap requested but         */
                               /* driver only creates color.                  */
    } BitmapParms;

/******************************************************************************/
/*  Type definition for bitmap list entry.                                    */
/******************************************************************************/
typedef struct BLEtag
    {
        PBYTE            Bitmap;
        USHORT           Huge;         /* selector increment for huge bitmaps */
        BitmapParms      Parms;        /* width, height, planes and bitcount  */
        lpDCI            DCHandle;     /* DC handle if selected               */
        lpDVTColorTable  DCTPtr;       /* pointer to device color table for   */
                                       /* this format                         */
        USHORT           BandXOrigin;  /* bottom x coord of DC band           */
        USHORT           BandYOrigin;  /* bottom y coord of DC band           */
        signed           XOrigin;      /* bottom x & y coord of DC            */
        signed           YOrigin;      /* band including DC origin            */
        BOOL             BMLocked;     /* bitmap locked indicator             */
        BOOL             ColBmapReq;   /* set on if color bitmap requested but*/
                                       /* driver only creates mono.           */
        BOOL             ColorDetected;/* PD00567 : Set on if we've detected  */
                                       /* color in the bitmap                 */
    } BitmapListEntry;

typedef BitmapListEntry * pBMListEntry;

/******************************************************************************/
/*  Type definition for a parse string used in Rops                           */
/******************************************************************************/
typedef USHORT ParseStringType[PARSE_STRING_SIZE];

/******************************************************************************/
/*  Type definition for an operand string (used by BitBlt)                    */
/******************************************************************************/
typedef USHORT OpStringType[MAX_OPERANDS];

/******************************************************************************/
/*  Type definition for Pattern data (which varies with the resolution).      */
/******************************************************************************/
typedef struct
    {
        PBYTE *  PatternTable;
        ULONG        PatternWidth;
        ULONG        PatternHeight;
        ULONG        PatternBytesPerRow;
    } PatternInfoType;

typedef PatternInfoType * lpPatternInfoType;

/******************************************************************************/
/*  Type definition for argument to BitBlt                                    */
/******************************************************************************/
typedef struct
    {
        LONG  cSize;
        LONG  lColor;
        LONG  lBackColor;
    } BitBltAttrsType;

/******************************************************************************/
/*  For External 24 bpp -> Internal 4 bpp bitmap conversions we maintain a    */
/*  cache table of the most recent colours accessed, and which internal       */
/*  colours they were closest to.  This cache table is an array of objects of */
/*  type ColourCache, and the array is of size CacheSize.                     */
/******************************************************************************/
typedef struct
    {
        RGB2    RGBValue;                     /* CON3201 - change RGB to RGB2 */
        USHORT  NearestMatch;
    } ColourCache;

#define CacheSize 9

/******************************************************************************/
/*  BMConvertScratch Structure : this is a structure used in bitmap conversion*/
/*  code to reduce parameter passing in function calls.                       */
/******************************************************************************/
typedef struct
    {
        USHORT  LinesToConvert;        /* used to count down from ScanLines   */
        USHORT  PelsPerLine;           /* number of pels in a line            */
        PBYTE   SrcPtr;                /* current position in source bitmap   */
        PVOID   DestPtr;               /* current position in dest bitmap     */
                                       /* this is a void pointer because we   */
                                       /* use it to write bytes, words,       */
                                       /* ULONGs and RGBs at various times    */
        USHORT  IntBpp;                /* internal bits per pel, = 1 or 4     */
        USHORT  ExtBpp;                /* external bits per pel, =1,4,8 or 24 */
        ULONG   ChunkLength;           /* number of whole bytes to convert    */
        USHORT  PelsLeftOver;          /* number of pels at end of line       */
        BOOL    Safe;                  /* flag if line crosses a segment      */

        /**********************************************************************/
        /*  The following field is only used in PRDBINEX.C and only used in   */
        /*  the routine CopyInttoExt.  It holds the number of bytes in the    */
        /*  entire section of the bitmap to be copied.                        */
        /**********************************************************************/
        ULONG   BytesToConvert;

        /**********************************************************************/
        /*  The following fields are only used in PRDBEXIN.C                  */
        /**********************************************************************/
        ULONG   DestBytesPerLine;      /* rounds up any partial bytes         */
        USHORT  FillFlag;              /* for 1bpp->1bpp, gives action        */
        USHORT  ColoursHad;            /* for ->1bpp, which cols we've had    */

        /**********************************************************************/
        /*  The following union contains the colour conversion table for      */
        /*  PRDBEXIN.C.  This colour table is set up for each conversion, and */
        /*  in most cases is an array of BYTES.  However, in the case of      */
        /*  External 1bpp to Internal 4bpp conversions, we want to set up a   */
        /*  table for four pels (i.e.  a nibble) at a time, which gives two   */
        /*  destination bytes, i.e.  a USHORT.  We also keep track of what    */
        /*  colour each of the two colours in the external bitmap are closest */
        /*  to, and we use this information for converting any leftover pels  */
        /*  at the end of a line.                                             */
        /**********************************************************************/
        union
        {
            BYTE            ConvertTable[256];
            struct
                {
                    USHORT  ConvertTable[16];
                    BYTE    OneBppColour[2];
                } Bpp1;
        } Col;
    } BMConvertScratch;

typedef BMConvertScratch *lpBMSPad; /* PD00400 : Pointer to Scratchpad    */
