/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDBTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver types for BitBlt for IBM42XX
 *                    and IBM52XX
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Define the type to hold bitblt working storage.  A variable of this type  */
/*  is declared in the mainline routine and pointer to it is then passed as   */
/*  parameter when calling the various subroutines.  This saves having to pass*/
/*  lots on parameters on function calls.                                     */
/******************************************************************************/
typedef struct
    {
        lpDCI            SourceDCI;    /* source DC handle                    */
        lpDCI            TargetDCI;    /* target DC handle                    */
        BOOL             SrcRowInSeg;
        BOOL             TrgRowInSeg;
        PBYTE            PatStart;
        DevPoint         PatOrigin;
        USHORT           PatIndex;
        USHORT           Mix;          /* mix value for Rop                   */
        PULONG           Parm;         /* pointer to source and target        */
                                       /* coordinates                         */
        ULONG            Count;        /* number of coordinate pairs passed   */
        ULONG            Style;        /* compress/stretch or not             */
        PBYTE            SrcBM;        /* source bitmap handle                */
        PBYTE            TrgBM;        /* target bitmap handle                */
        pBMListEntry     SrcLE;        /* bitmap list entry for source bitmap */
        pBMListEntry     TrgLE;        /* bitmap list entry for target bitmap */
        DevPoint         SrcStartPos;  /* start position for each source row  */
        DevPoint         TrgStartPos;  /* start position for each target row  */
        DevRect          SrcRect;      /* source rectangle for bitblt         */
        DevRect          TrgRect;      /* target rectangle for bitblt         */
        DevRect          SaveSrcRect;  /* original source rectangle           */
        DevRect          SaveTrgRect;  /* original target rectangle           */
        ULONG            SrcIndex;     /* index for source bitmap             */
        ULONG            TrgIndex;     /* index for target bitmap             */
        ULONG            SrcEndIndex;  /* index for last byte in source row   */
        ULONG            TrgEndIndex;  /* index for last byte in target row   */
        USHORT           HorzDir;      /* horizontal direction                */
        USHORT           VertDir;      /* vertical direction                  */
        SHORT            Phase;        /* phase difference                    */
        USHORT           PhaseRightShift;
        USHORT           PhaseLeftShift;
        OpStringType     OpString;     /* string of binary operations for Rop */
        ParseStringType  ParseStr;     /* parse string to use for Rop         */
        USHORT           StrIndex;     /* index into parse string for first   */
                                       /* operand                             */
        USHORT           Rop;          /* Raster OPeration                    */
        BYTE             StartMask;    /* Start mask for current row          */
        BYTE             EndMask;      /* end mask for current row            */
        USHORT           Source;       /* 'Source present' flag               */
        BYTE             Carry;        /* Carry byte used when phase          */
                                       /* difference exists                   */
        BOOL             LastSrcByte;  /* 'end of source row' flag            */
        BOOL             LastTrgByte;  /* 'end of target row' flag            */
        BOOL             PatternReq;   /* pattern required or not             */
        USHORT           PatternNumb;  /* from attributes                     */
        BYTE             ConvPat0;     /* '0' and '1' of pattern in target    */
        BYTE             ConvPat1;     /* format                              */
        BOOL             PatMonBmapReq; /* Flag from pattern BitmapListEntry  */
        ULONG            PatHeight;    /* height and width of bitmap          */
        ULONG            PatWidth;     /* being used as pattern               */
        ULONG            PatBytesPerRow; /* no. of bytes for each row of a    */
                                       /* pattern definition                  */
        PBYTE            PatBM;        /* pointer to pattern bitmap           */
        PBYTE            FontBM;       /* pointer to font bitmap used as a    */
                                       /* pattern, if any                     */
        USHORT           FontBMSize;   /* size of font bitmap, if any         */
        USHORT           SrcCopyMode;  /* Source modification mode            */
        USHORT           PatCopyMode;
        ULONG            ArgStyle;     /* Blt style flags                     */
        BitBltAttrsType  ArgAttrs;     /* Blt attributes                      */
        PBYTE             GS_Pattern;  /* Grey Scale pattern                  */
    } Vars;

