/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDBTYP1
 *
 * DESCRIPTIVE NAME = Printer Device Driver types for Bitblt
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Define the type to hold bitblt working storage.  A variable of this type  */
/*  is declared in the mainline routine and pointer to it is then passed as   */
/*  parameter when calling the various subroutines.  This saves having to pass*/
/*  lots on parameters on function calls.                                     */
/******************************************************************************/
typedef struct
    {
        /**********************************************************************/
        /*  1.  This is the first 16 bytes of this structure.  It describes   */
        /*  the target bitmap and the DWORDs to copy for one row.             */
        /**********************************************************************/
        PBYTE            TrgBM;        /* target bitmap handle                */
        ULONG            TrgIndex;     /* index for target bitmap             */
        ULONG            TrgEndIndex;  /* index for last byte                 */
        USHORT           usTrgDwords;  /* number of DWORDS                    */
        USHORT           usDummy1;

        /**********************************************************************/
        /*  2.  This is the next 16 bytes of this structure.  It describes the*/
        /*  source bitmap and the BYTEs to copy for each row, the direction of*/
        /*  copy and the number of bits to shift the src                      */
        /**********************************************************************/
        PBYTE            SrcBM;        /* source bitmap handle                */
        ULONG            SrcIndex;     /* index for source bitmap             */
        ULONG            SrcEndIndex;  /* index for last byte                 */
        SHORT            sDirection;   /* direction of phase shift            */
        BYTE             cShift;       /* number of bytes to shift            */
        BYTE             cInvShift;    /* inverse of the above                */

        /**********************************************************************/
        /*  3.  This is the next 16 bytes of this structure.  It describes the*/
        /*  pattern in BYTES.  (Change DevPoint to POINTS).                   */
        /**********************************************************************/
        PBYTE            PatBM;        /* pointer to pattern bitmap           */
        USHORT           PatWidth;     /* width of pattern                    */
        USHORT           PatHeight;    /* height of pattern                   */
        USHORT           PatBytesPerRow; /* bytes per pattern row             */
        USHORT           usPatType;    /* type of pattern for (4,1)           */
        DevPoint         PatOrigin;    /* first index in pattern              */

        /**********************************************************************/
        /*  4.  This is the next 16 bytes of this structure.  The source is   */
        /*  copied from the source bitmap to this local storage.  This section*/
        /*  also contains the target start and end DWORD masks                */
        /**********************************************************************/
        PBYTE            abSrcRow;     /* memory for source row               */
        USHORT           usSrcBytes;   /* number of source bytes              */
        USHORT           usSrcAdjust;  /* position of source bytes            */
        ULONG            StartMask;    /* Start mask for current row          */
        ULONG            EndMask;      /* end mask for current row            */

        /**********************************************************************/
        /*  5.  This is the next 16 bytes of this structure.  It describes the*/
        /*  pattern in DWORDS plus other useful fields.                       */
        /**********************************************************************/
        PBYTE            abPatRow;     /* pointer to original pat row         */
        PBYTE            lpPatRow;     /* pointer to new pat row              */
        POINTS           ptsPatStart;  /* co-ordinates in pattern             */
        USHORT           usDummy2;     /* blank for padding                   */
        BYTE             ConvPat0;     /* '0' and '1' of pattern ...          */
        BYTE             ConvPat1;     /* ... in target format                */

        /**********************************************************************/
        /*  6.  Pattern items of memory                                       */
        /**********************************************************************/
        PBYTE            FontBM;       /* memory for font pattern             */
        USHORT           FontBMSize;   /* size of font pattern                */
        USHORT           usDummy;
        PBYTE            CacheBM;      /* memory for cache pattern            */
        USHORT           CacheBMSize;  /* size of cache pattern               */
        USHORT           usDummy3;

        /**********************************************************************/
        /*  7.  More Pattern items of memory                                  */
        /**********************************************************************/
        PBYTE            PatRowBM;     /* memory for pattern row              */
        USHORT           PatRowBMSize; /* size of pattern row                 */
        USHORT           usDummy4;
        USHORT           usFastFlags;  /* flags for per row                   */
        USHORT           usBltFlags;   /* flags for per blt                   */
        ULONG            ulDummy1;

        /**********************************************************************/
        /*  8.  This is the next 16 bytes of this structure.                  */
        /**********************************************************************/
        USHORT           PatternReq;   /* 'Pattern present' flag              */
        USHORT           PatCopyMode;  /* Source modification mode            */
        USHORT           Source;       /* 'Source present' flag               */
        USHORT           SrcCopyMode;  /* Source modification mode            */
        pBMListEntry     TrgLE;        /* target bitmap list entry            */
        pBMListEntry     SrcLE;        /* source bitmap list entry            */

        /**********************************************************************/
        /*  9/10.  This is the next 32 bytes of this structure.  It contains  */
        /*  the Source and target rectangles                                  */
        /**********************************************************************/
        DevRect          TrgRect;      /* target rectangle for bitblt         */
        DevRect          SaveTrgRect;  /* original target rectangle           */
        DevRect          SrcRect;      /* source rectangle for bitblt         */
        DevRect          SaveSrcRect;  /* original source rectangle           */

        /**********************************************************************/
        /*  Parameters supplied on the call.                                  */
        /**********************************************************************/
        lpDCI            SourceDCI;    /* source DC handle                    */
        ULONG            Count;        /* number of coordinate pairs          */
        PULONG           Parm;         /* Coordinates themselves              */
        ULONG            Mix;          /* mix value for Rop                   */
        ULONG            ArgStyle;     /* Blt style flags                     */
        BitBltAttrsType  ArgAttrs;     /* Blt attributes                      */
        lpDCI            TargetDCI;    /* target DC handle                    */

        /**********************************************************************/
        /*  Starting co-ordinates of blt, and direction to go from those      */
        /*  co-ordinates (prdb_StartPosAndDir).  DevPoint == POINTS           */
        /**********************************************************************/
        DevPoint         SrcStartPos;  /* start position for each source row  */
        DevPoint         TrgStartPos;  /* start position for each target row  */
        USHORT           HorzDir;      /* horizontal direction                */
        USHORT           VertDir;      /* vertical direction                  */

        /**********************************************************************/
        /*  Bit processing fields for the general case blt.                   */
        /**********************************************************************/
        USHORT           Rop;          /* Raster operation                    */
        OpStringType     OpString;     /* string of binary operations for Rop */
        ParseStringType  ParseStr;     /* parse string to use for Rop         */
        USHORT           StrIndex;     /* index into parse string for         */
                                       /* first operand                       */

        /**********************************************************************/
        /*  Other fields                                                      */
        /**********************************************************************/
        PBYTE            GS_Pattern;   /* Grey Scale pattern                  */
    } BltParms;

/******************************************************************************/
/*  And a pointer to them                                                     */
/******************************************************************************/
typedef BltParms *  lpBltParms;
