/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDBEXTF
 *
 * DESCRIPTIVE NAME = External function definitions for the prdb..
 *                    module
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Exported routines                                                         */
/******************************************************************************/
ULONG  prdb_BitBlt(
              hanDC,
              PBYTE,
              ULONG,
              PULONG,
              ULONG,
              ULONG,
              BitBltAttrsType *,
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdb_PolyMarker(
              HDC,
              PPOINTL,
              ULONG,
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdb_DeviceCreateBitmap(
              hanDC,
              PBITMAPINFOHEADER2,     /* CON3201 - GRE change */
              ULONG,
              PBYTE,
              PBITMAPINFO2,           /* CON3201 - GRE change */
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdn_DeviceCreateBitmap(
              hanDC,
              PBITMAPINFOHEADER2,     /* CON3201 - GRE change */
              ULONG,
              PBYTE,
              PBITMAPINFO2,           /* CON3201 - GRE change */
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdb_DeviceDeleteBitmap(
              hanDC,
              pBMListEntry,
              PDELETERETURN,
              ULONG,
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdb_DeviceSelectBitmap(
              hanDC,
              pBMListEntry,
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdb_GetBitmapParameters(
              hanDC,
              PBITMAPINFOHEADER2,     /* CON3201 - GRE change */
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdb_GetSetBitmapBits(
              hanDC,
              PBYTE,
              ULONG,
              ULONG,
              PBYTE,
              PBITMAPINFO2,           /* CON3201 - GRE change */
              lpDCI,
              ULONG);

ULONG  EXPENTRY prdn_GetSetBitmapBits(
              hanDC,
              PBYTE,
              ULONG,
              ULONG,
              PBYTE,
              PBITMAPINFO2,           /* CON3201 - GRE change */
              lpDCI,
              ULONG);
/*
ULONG  prdb_SetPel( */
ULONG  EXPENTRY prdb_SetPel(                                       /* CON3201 */
              hanDC,
              PULONG,
              lpDCI,
              ULONG);
/*
ULONG  prdb_GetPel( */
ULONG  EXPENTRY prdb_GetPel(                                       /* CON3201 */
              hanDC,
              WcsPoint *,
              lpDCI,
              ULONG);
/*
ULONG  prdb_ImageData( */
ULONG  EXPENTRY prdb_ImageData(                                    /* CON3201 */
              hanDC,
              PBYTE,
              ULONG,
              ULONG,
              lpDCI,
              ULONG);

BOOL prdb_GetGreyScaleInfo(ULONG,                    /*  PD00462  */
                           PUSHORT,
                           PBYTE *,
                           lpDCI);

/******************************************************************************/
/*  Internal Routines                                                         */
/******************************************************************************/
BitmapListEntry * prdb_CreateBitmap(
              lpDCI,
              BOOL,
              BitmapParms *);

USHORT prdb_DeleteBitmap(
              pBMListEntry);

USHORT prdb_FreeBitmap(
              PBYTE);

VOID   prdb_GetOffsets(
              BitmapListEntry *,
              USHORT,
              USHORT,
              PULONG,
              PUSHORT );

VOID   prdb_MixPel(
              BitmapListEntry *,
              USHORT,
              USHORT,
              BYTE,
              USHORT);

pBMListEntry CheckBitmap(
              hanDC,
              ULONG,
              USHORT,
              PBYTE,
              lpDCI,
              PUSHORT);

VOID   prdb_HugeSetByte(
              PBYTE,
              ULONG,
              BYTE);

BYTE   prdb_HugeGetByte(
              PBYTE,
              ULONG);

PBYTE  prdb_HugeAddress(
              PBYTE,
              ULONG,
              USHORT);

PBYTE  prdb_HugeIncrement(
              PBYTE,
              USHORT);

PBYTE  prdb_HugeDecrement(
              PBYTE,
              USHORT);

VOID   prdb_ConvertExttoInt(
              pBMListEntry,
              PBYTE,
              PBITMAPINFO2,            /* CON3201 - GRE change */
              ULONG,
              USHORT,
              lpDCI);

VOID   prdb_TableExttoInt(
              RGB2 *,                 /* CON3201 - GRE change */
              lpBMSPad);

VOID   prdb_TransferExttoInt(
              lpBMSPad);

VOID   convert_ext1_to_int1(
              lpBMSPad);

VOID   convert_ext4_to_int1(
              lpBMSPad);

VOID   convert_ext8_to_int1(
              lpBMSPad);

VOID   convert_ext24_to_int1(
              lpBMSPad);

VOID   convert_ext1_to_int4(
              lpBMSPad);

VOID   convert_ext4_to_int4(
              lpBMSPad);

VOID   convert_ext8_to_int4(
              lpBMSPad);

VOID   convert_ext24_to_int4(
              lpBMSPad);

VOID   prdb_ConvertInttoExt(
              pBMListEntry,
              PBYTE,
              PBITMAPINFO2,           /* CON3201 - GRE change */
              ULONG,
              USHORT,
              lpDCI);

VOID   prdb_SetExternalColourTable(
              RGB2 *,                 /* CON3201 - GRE change */
              lpBMSPad);

VOID   prdb_CopyInttoExt(
              lpBMSPad);

VOID   prdb_TransferInttoExt(
              lpBMSPad);

VOID   convert_int1_to_ext4(
              lpBMSPad);

VOID   convert_int1_to_ext8(
              lpBMSPad);

VOID   convert_int1_to_ext24(
              lpBMSPad);

VOID   convert_int4_to_ext1(
              lpBMSPad);

VOID   convert_int4_to_ext8(
              lpBMSPad);

VOID   convert_int4_to_ext24(
              lpBMSPad);

/******************************************************************************/
/*  PD00567 : New functions for greyscaling source bitmaps.                   */
/******************************************************************************/
VOID   prdb_GreyScaleSourceBitmap(
              lpBltParms,
              pBMListEntry,
              lpDCI);

ULONG  prdb_GetNextColor(
              PBYTE *,
              BOOL,
              BOOL,
              USHORT,
              PUSHORT,
              PUSHORT,
              lpDCI);
