/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDBCONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Bitmap constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  GetPel return value (-254) when no index exists corresponding to the color*/
/******************************************************************************/
#define NO_COLOUR_INDEX    0xffffff02L

/******************************************************************************/
/*  Direction indicators on a bitblt                                          */
/******************************************************************************/
#define RIGHT                        1 /* right                               */
#define LEFT                         2 /* left                                */
#define UP                           1 /* up                                  */
#define DOWN                         2 /* down                                */

/******************************************************************************/
/*  Logical operations on a bitblt Rop                                        */
/******************************************************************************/
#define BB_NOT                       0 /* logical not                         */
#define BB_XOR                       1 /* logical XOR                         */
#define BB_OR                        2 /* logical OR                          */
#define BB_AND                       3 /* logical AND                         */

/******************************************************************************/
/*  Phase directions on a bitblt                                              */
/******************************************************************************/
#define POS                          1 /* positive phase                      */
#define NEG                          2 /* negative phase                      */

/******************************************************************************/
/*  Operand definitions on a bitblt                                           */
/******************************************************************************/
#define SRC                          0 /* source                              */
#define DEST                         1 /* destination                         */
#define PAT                          2 /* pattern                             */
#define PUSH                         3 /* a push                              */
#define POP                          4 /* a pop                               */

/******************************************************************************/
/*  Other constants                                                           */
/******************************************************************************/
#define NUMBER_PARSE                 8 /* Total number of parse strs          */

/******************************************************************************/
/*  indicators for type of source supplied to bitblt                          */
/******************************************************************************/
#define NO_SOURCE                    0 /* no source supplied (mode 0 only)    */
#define SELECTED_BITMAP              1 /* source bitmap, selected into DC     */
#define UNSELECTED_BITMAP            2 /* source bitmap, not selected into DC */
#define SOURCE_DC                    4 /* source is a DC                      */

/******************************************************************************/
/*  Codes for image attributes expansion                                      */
/******************************************************************************/
#define SRC_ZEROS                    0
#define SRC_INVERT_BITS              1
#define SRC_COPY_BITS                2
#define SRC_ONES                     3

/******************************************************************************/
/*  Codes for pattern attributes expansion                                    */
/******************************************************************************/
#define PAT_ZEROS                    0
#define PAT_INVERT_BITS              1
#define PAT_COPY_BITS                2
#define PAT_ONES                     3

/******************************************************************************/
/*  Color Constants : these give the Red, Green and Blue components of the    */
/*  colors in the internal eight color palette.  These values are taken from  */
/*  the values in DVTEightColors in PRDDTAB.C                                 */
/******************************************************************************/
#define DVT8Col0Red               0x00
#define DVT8Col1Red               0x00
#define DVT8Col2Red               0xFF
#define DVT8Col3Red               0xFF
#define DVT8Col4Red               0x00
#define DVT8Col5Red               0x00
#define DVT8Col6Red               0xFF
#define DVT8Col7Red               0xFF
#define DVT8Col0Green             0x00
#define DVT8Col1Green             0x00
#define DVT8Col2Green             0x00
#define DVT8Col3Green             0x00
#define DVT8Col4Green             0xFF
#define DVT8Col5Green             0xFF
#define DVT8Col6Green             0xFF
#define DVT8Col7Green             0xFF
#define DVT8Col0Blue              0x00
#define DVT8Col1Blue              0xFF
#define DVT8Col2Blue              0x00
#define DVT8Col3Blue              0xFF
#define DVT8Col4Blue              0x00
#define DVT8Col5Blue              0xFF
#define DVT8Col6Blue              0x00
#define DVT8Col7Blue              0xFF

/******************************************************************************/
/*  The following two constants are used when writing to internal 1bpp bitmaps*/
/*  to represent the bit values corresponding to the two colors.  The two must*/
/*  always be different, and both should always be zero or one.  Mono bitmap  */
/*  DCR defines that the values are Black = 0 and White = 1.                  */
/******************************************************************************/
#define MONO_BLACK                   0
#define MONO_WHITE                   1

/******************************************************************************/
/*  For External (4 or 8) bpp -> Internal 1bpp conversions there is a small   */
/*  chance that all of the colors in the external color table map to only one */
/*  of white or black.  Thus when we are building the color conversion table  */
/*  in TableExttoInt, we keep track of whether any color has mapped to black, */
/*  and whether any color has mapped to white, by ORing a flag with HAD_WHITE */
/*  or HAD_BLACK.                                                             */
/******************************************************************************/
#define HAD_WHITE                    1
#define HAD_BLACK                    2

/******************************************************************************/
/*  Define's for grey scaling                                                 */
/******************************************************************************/
#define GS_PATTERN_WIDTH             8
#define GS_PATTERN_HEIGHT            8
#define GS_PATTERN_BYTES_PER_ROW     1
#define GS_FLAG                     99

/******************************************************************************/
/*  Min and max color values for source bitmap greyscaling - white and        */
/*  black...                                                                  */
/******************************************************************************/
#define GS_BLACK_INDEX          0x0000
#define GS_WHITE_INDEX          0x0200

/******************************************************************************/
/*  BitBlt fast path constants                                                */
/******************************************************************************/
#define  TRG_ROW_IN_SEG         0x0001 /* Set on if all target dwords which   */
                                       /* will be picked up for this row are  */
                                       /* within a single segment             */

#define  SRC_ROW_IN_SEG         0x0002 /* Set on if all source bytes which    */
                                       /* will be picked up for this row (by  */
                                       /* prdb_GetSourceRow) are in a single  */
                                       /* segment                             */

#define  SRC_START_CARRY        0x0004 /* Set on if the first source byte must*/
                                       /* be used as a carry into the source  */
                                       /* row                                 */

#define  SRC_END_CARRY          0x0008 /* Set on if the last source carry must*/
                                       /* be used as a carry into the source  */
                                       /* row                                 */

#define  BLT_PAT_ROW_REQD       0x0010 /* Set on if the pattern has been      */
                                       /* expanded to the full pattern row    */

#define  PAT_ALL_ONES           0x0020 /* Set on pattern if this is a         */
                                       /* predefined pattern with every bit   */
                                       /* set                                 */

#define  PAT_ALL_ZEROS          0x0040 /* Set on pattern if this is a         */
                                       /* predefined pattern with no bits set */

/******************************************************************************/
/*  Pattern processing flags                                                  */
/******************************************************************************/
#define  BLT_PAT_11_BITMAP      0x0000 /* Pattern is a (1,1) bitmap           */
#define  BLT_PAT_41_BITMAP      0x0001 /* Pattern is a (4,1) bitmap           */
#define  BLT_PAT_MONO_REQ       0x0002 /* (4,1) posing as (1,1)               */

/******************************************************************************/
/*  Quick pattern processing flags                                            */
/******************************************************************************/
#define  BLT_USE_BYTE           0x0000 /* Pat byte is parameter               */
#define  BLT_USE_PAT            0x0001 /* Pat byte from pattern               */
#define  BLT_USE_INV_PAT        0x0002 /* Pat byte from pattern               */

/******************************************************************************/
/*  600DPI : 64 patterns in the greyscale tables                              */
/******************************************************************************/
#define NUM_GREY_PATTERNS           64

/******************************************************************************/
/*  PD00567 : Internal 4,1 bitmap conversion flags                            */
/******************************************************************************/
#define ALL_41_WHITE              0x77
#define ALL_11_WHITE              0xFF
#define ALL_41_WHITE_D      0x77777777
