/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDACONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Attributes Constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Constants for realize font                                         */
/**********************************************************************/
#define NO_FONT_MATCH               0
#define MATCH_DELTA                16

/**********************************************************************/
/* Default values for global attributes for colours and mixes.  The   */
/* colors are interpretted as f/g CLR_BLACK; b/g CLR_WHITE.           */
/**********************************************************************/
#define DEFAULT_FOREGROUND_COL     -7
#define DEFAULT_BACKGROUND_COL     -8
#define DEFAULT_FOREGROUND_MIX      0x2          /* overpaint         */
#define DEFAULT_BACKGROUND_MIX      0x5          /* transparent       */

/**********************************************************************/
/* Constants used to handle a code page change.                       */
/**********************************************************************/
#define CODEPAGE_FOUND              1
#define CODEPAGE_NOT_FOUND          2

/**********************************************************************/
/* Constant for flag passed to prda_CopyMetrics.                      */
/**********************************************************************/
#define USE_CHAR_BOX                1
#define USE_POINT_SIZE              2                      /* PD00137 */

/**********************************************************************/
/* Constants passed to prda_GetDefaultCharBox.                        */
/**********************************************************************/
#define WIDTH                       1
#define HEIGHT                      2
#define WORLD_COORDS                4
#define DEVICE_COORDS               8

/**********************************************************************/
/* Constant to define the Maximum number of device attributes.        */
/* This constant can not be larger than 4 since  it is only the       */
/* 2 low order bits in the BaseMatchNo field of the LCID structure.   */
/* Normal = 0, Double Wide = 1, Double High = 2, Double HighWide = 3  */
/* Used in prda_ProcessAttributes (prdaqery.c).                       */
/**********************************************************************/
#define MAX_DEVICE_ATTRIBUTE        4

/**********************************************************************/
/*  Constants for use with RealizeFont processing.                    */
/**********************************************************************/
#define ALL_DEVICE_ATTRIBUTES       3
#define MAX_CODEPAGE_FONT_INDEX     8
#define INVALID_CODEPAGE_INDEX      0xff

/**********************************************************************/
/* The top bit of the type field in the FontInfo indicates whether    */
/* the default font should be simulated or not.   This mask is used    */
/* to turn on the top bit.                                            */
/**********************************************************************/
#define SIMULATE_DFLT_FONT        0x8000

/**********************************************************************/
/* Number of entries in Code Page Use table                           */
/**********************************************************************/
#define CPT_USE_TABLE     2

/******************************************************************************/
/*  PD00681 : New define to indicate that the default font has been realized. */
/******************************************************************************/
#define FATTR_SEL_DEFAULT           0x80
