;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;*****************************************************************************
;*
;* SOURCE FILE NAME = ENGINE.INC
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;* NOTES
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG          APAR     CHANGE DESCRIPTION
;*   --------  ----------    -----    --------------------------------------
;*
;******************************************************************************
        page    ,132

INCLUDE firewall.inc

;       The following two equates are just used as shorthand
;       for the "word ptr" and "byte ptr" overrides.

wptr    equ     word ptr
bptr    equ     byte ptr

; The following structure should be used to access high and low
; words of a DWORD.  This means that "word ptr foo[2]" -> "foo.hi".


FARPOINTER      struc
off     dw      ?
sel     dw      ?
FARPOINTER      ends

; The following macros pertain to firewall code


;---------------------------Macro---------------------------------------;
; rip is the macro which invokes the error processor to perform the
; call to WinSetErrorInfo to abort the process.
;
; Usage:
;       rip     arg1,arg2
; Where:
;       if arg1 == text, arg2 contains the text of error message
;       otherwise, arg1 is the name of the message it will be referenced by
;-----------------------------------------------------------------------;

rip     macro   arg1,arg2
        local   msg_offset
if FIREWALLS
ifidni <arg1>,<text>
;;CODE3        segment DWORD USE32 PUBLIC 'code'
msg_offset      equ    this byte
            db   '&arg2',0
;;CODE3        ends
        save    eax
        ADR     msg_offset
        cCall   perform_rip
else
        ifnb    <arg2>
                .err
        endif
        cCall   perform_rip,< &arg1>
endif
endif
endm


;-----------------------------Macro-------------------------------------------;
; assert
;
; If FIREWALLS is nonzero, tests whether the given condition is satisfied and
; reports an error via rip if not.  if FIREWALLS is 0, does nothing.
;
; Note that either the Operand1 or Operand2 must be a register or constant.
;
; Entry:
;       Operand1, Operator, Operand2 [,ErrorMessage]
;   where
;       Operand1 = the first operand
;       Operand2 = the second operand
;       Operator = one of:
;           E   equal                  NE  not equal
;           G   greater                NG  not greater
;           GE  greater or equal       NGE not greater nor equal
;           L   less                   NL  not less
;           LE  less or equal          NLE not less nor equal
;           A   above                  NA  not above
;           AE  above or equal         NAE not above nor equal
;           B   below                  NB  not below
;           BE  below of equal         NBE not below nor equal
;           C   carry                  NC  not carry
;           O   overflow               NO  not overflow
;           S   sign                   NS  not sign
;       ErrorMessage = the error message string to use.  if omitted,
;           the assert statement itself is displayed in the error message.
;
; Or:
;       FlagCond [,ErrorMessage]
;   where
;       FlagCond = one of:
;           Z   zero                   NZ  not zero
;           C   carry                  NC  not carry
;           O   overflow               NO  not overflow
;           S   sign                   NS  not sign
;           P   parity                 NP  not parity
;           D   direction              ND  not direction
;       ErrorMessage = the error message string to use.  if omitted,
;           the assert statement itself is displayed in the error message.
;
; Examples:
;       assert  ax,E,1
;       assert  si,LE,RegionSize,msg_RegBadRegion
;       assert  di,A,si
;       assert  NO
;
; Registers Preserved:
;
; Registers Destroyed:
;
; History:
;  Mon 07-Mar-1988 05:48:46  -by-  Charles Whitmer [chuckwh]
; Ported to display driver.
;
;  Wed 27-Jan-1988 18:18:24     -by-    Brian Conte     [brianc]
; Added support for "assert D" and "assert ND".
;
;  Sat 09-Jan-1988 20:28:53     -by-    Brian Conte     [brianc]
; Added ErrorMessage parameter.
;
;  Mon 04-Jan-1988 11:15:34     -by-    Brian Conte     [brianc]
; Renamed it from "ensure" to "assert".
;
;  Tue 22-Dec-1987 18:04:43     -by-    Brian Conte     [brianc]
; Added FlagCond option.
;
;  Sun 20-Dec-1987 22:28:32     -by-    Brian Conte     [brianc]
; Wrote it.
;-----------------------------------------------------------------------------;

assert  macro   arg1,arg2,arg3,arg4
        local   ok,error,report_it

if FIREWALLS
ifnb    <arg3>
        cmp     arg1,arg3
        j&arg2  ok
ifb     <arg4>
        rip     text,<assert &arg1,&arg2,&arg3>
else
        rip     arg4
endif
else
ifidni  <arg1>,<d>
        push    ebp
        pushfd
        mov     ebp,esp
        test    byte ptr [ebp+1],04h
        jnz     ok
else
ifidni  <arg1>,<nd>
        push    ebp
        pushfd
        mov     ebp,esp
        test    byte ptr [ebp+1],04h
        jz      ok
else
        j&arg1  ok
endif
endif
ifb     <arg2>
        rip     text,<assert &arg1>
else
        rip     arg2
endif
endif
ok:
ifb     <arg3>
ifidni  <arg1>,<d>
        popfd
        pop     ebp
endif
ifidni  <arg1>,<nd>
        popfd
        pop     ebp
endif
endif
endif   ;FIREWALLS
        endm


;---------------------------Macro---------------------------------------;
; ErrorMsg is the macro which will define each errro message.  Each
; error message can be accessed by an extrn declaration.
;
; Usage:
;       errmsg lbl,msg
; Where:
;       lbl - the name it will be referenced by
;       msg - the contents of the error message
;-----------------------------------------------------------------------;

ErrorMsg    MACRO   lbl,msg
if FIREWALLS
  public lbl
  lbl   LABEL   WORD
        DB      '&msg',0
endif
ENDM


;-------------------------------Public-Macro-----------------------------;
; check
;
;  checks whether the given function has the correct parameters
;
; usage:
;
;  check  FunctionName,<parm1,parm2,parm3>
;
; History:
;  Wed 06-Apr-1988              -by-   Martin Picha        [martinpi]
; Wrote it.
;------------------------------------------------------------------------;

check   macro   funcname,parms
        inner_check     %prm_&funcname,<parms>
        endm

inner_check macro string1,string2
        .errdif <string1>,<string2>
        endm
