/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = QPMSG.C
 *
 * DESCRIPTIVE NAME = PM Print Queue Processor
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * This module displays message box for errors detected by the 32-bit
 * PMPRINT Queue Processor.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_WINDIALOGS
#define INCL_WINERRORS
#define INCL_GPIERRORS
#include "pmprint.h"

/****************************************************************************
 *
 * FUNCTION NAME = SplQpMessage
 *
 * DESCRIPTION   = Displays message(and optionally log the error)
 *
 * INPUT         = pszPort     - port name job in error is printing on
 *                 uErrId      - resource ID of error text
 *                 uErrCode    - error code detected( PMERR_ )
 *                               If uErrCode == 0
 *                                  call WinGetLastError() to get error code
 *                               else
 *                                  call WinSetErrorInfo() to set error code
 *
 * OUTPUT        = Error possibly logged and message displayed to user
 *                 Returns MBID_ key pressed to end SplMessageBox
 *
 * RETURN-NORMAL = MBID_OK or MBID_CANCEL
 *
 *
 * RETURN-ERROR  = MBID_ERROR
 *
 *
 ****************************************************************************/
USHORT SplQpMessage(PSZ pszPort, USHORT uErrId, USHORT uErrCode)
{
    USHORT uSeverity;
    USHORT fErrInfo;
    USHORT fErrData;
    USHORT fStyle;
    USHORT rc;
    CHAR   szMsgText[360] ;
    CHAR   szTitle[120] ;

    /*
    ** if uErrCode is given
    **   issue WinSetErrorInfo
    ** else
    **   call WinGetLastError to find cause of failure
    **   if cause was "out of memory"
    **      display "out of memory" message
    **   else
    **      display message that goes with uErrId.
    */
    if (uErrCode) {
        if (uErrId == SPL_ID_QP_INVALID_PARAMETER)
           uSeverity = SEVERITY_WARNING;
        else
           uSeverity = SEVERITY_ERROR;
        WinSetErrorInfo(MAKEERRORID(uSeverity, uErrCode ), SEI_NOPROMPT);
    } else {

        uErrCode = (USHORT)WinGetLastError(HABX);
        if ( (uErrCode == PMERR_INSUFFICIENT_MEMORY) ||
             (uErrCode == PMERR_SPL_NO_MEMORY) ){

            uErrId = SPL_ID_QP_MEM_ERROR ;
        }

    }

    /*
    ** Setup OK pushbutton for warnings, Cancel for Errors
    */
    fErrInfo  = SPLINFO_QPERROR;
    if(uErrId == SPL_ID_QP_INVALID_PARAMETER ||
       uErrId == SPL_ID_QP_MEM_ERROR) {
        fErrInfo |= SPLINFO_WARNING;
        fErrData = SPLDATA_OTHER;
        fStyle = MB_OK;
        uSeverity = SEVERITY_WARNING;
    } else {
        fErrData = SPLDATA_UNEXPECTERROR;
        fStyle = MB_CANCEL;
        uSeverity = SEVERITY_ERROR;
    }

    szMsgText[0] = '\0' ;
    szTitle[0]   = '\0' ;
    WinLoadString(HABX, hModPMPrint, uErrId, sizeof(szMsgText), szMsgText) ;
    WinLoadString(HABX, hModPMPrint, SPL_ID_QP_PMPRINT_TITLE,
                  sizeof(szTitle), szTitle) ;

    rc = SplMessageBox( pszPort,
                        fErrInfo,
                        fErrData,
                        szMsgText,
                        szTitle,
                        0,
                        fStyle
                        );

    return( rc );
}
