/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = QPINIT.C
 *
 * DESCRIPTIVE NAME = PM Spooler Queue Processor
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * This file contains the initialization and termination code for the 32-bit
 * PM Spooler Queue Processor(PMPRINT.QPR).
 *
 * FUNCTIONS   :   ExitListProc       - called by OS/2 during process exit
 *                 InitResources      - called to setup per-process data
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_DOSNLS
#define INCL_DOSPFS
#define INCL_WINP_MISC
#define INCL_WINWINDOWMGR

#include "pmprint.h"

/*
** internal function prototypes
*/
VOID FreeQProcInstResources(PID uPid, USHORT uExitReason);

/****************************************************************************
 *
 * FUNCTION NAME = ExitListProc
 *
 * DESCRIPTION   = Exit list procedure installed by PMPRINT
 *
 * INPUT         = uExitType   - Reason for process termination
 *                      TC_EXIT            0 - Normal exit
 *                      TC_HARDERROR       1 - Hard-error halt
 *                      TC_TRAP            2 - Trap for 16-bit child process
 *                      TC_KILLPROCESS     3 - Unintercepted DosKillProcess
 *                      TC_EXCEPTION       4 - Exception for 32-bit child
 *
 *
 * OUTPUT        = frees any memory allocated for this process by PMPRINT
 *
 * RETURN-NORMAL = call DosExitList to handle remaining Exit List Procedures
 *
 * RETURN-ERROR  = same as NORMAL
 *
 ****************************************************************************/

VOID APIENTRY ExitListProc( ULONG uExitType )
{
   /*
   ** If any resources allocated for this process
   **   free them
   */
   if (fInitDone) {

      if (uExitType)
      {
          /*
          ** Not a normal process termination
          */
          Warning( "ExitListProc called for PID: %0x  Reason: %2x",
                      pPIB->pib_ulpid, uExitType );
      }

     EnterSem();
       FreeQProcInstResources(pPIB->pib_ulpid, uExitType);
     ExitSem();
   }

   DosExitList( EXLST_EXIT, (PFNEXITLIST)ExitListProc );
}


/****************************************************************************
 *
 * FUNCTION NAME = _DLL_InitTerm
 *
 * DESCRIPTION   = DLL initialization/termination routine
 *
 * INPUT         = hModule     - Module handle for this DLL(PMPRINT.QPR)
 *               = ulFlag      - Reason for call
 *                                         0 - DLL firstime load for process
 *
 *
 * OUTPUT        = sets up per process data on first load of PMPRINT
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG _System _DLL_InitTerm(HMODULE hModule, ULONG ulFlag)
{

   switch (ulFlag)
   {
     case 0:
       /*
       ** First time load of PMPRINT for this process
       **
       ** if multiple threads from same process attempting to print
       **    must make second calling thread wait in
       **    SplQpOpen until resources initiailized
       */
       fQprDoingInit = TRUE ;

       if (!hModPMPrint)
       {
           /*
           ** Remember our module handle for resources
           */
           hModPMPrint = hModule;

           /*
           ** Create per process instance of PMPRINT Mutex semaphore
           **   as non-shared, non-named.
           ** This is used to serialize access to list of QPROCINST
           **   structures pointed at by pQprocInstHead
           */
           DosCreateMutexSem( NULL, &semPMPRINT, 0, 0);

           pQprocInstHead = NULL;

           DosGetInfoBlocks(&pTIB, &pPIB);

           fInitDone = TRUE ;

       }

       fQprDoingInit = FALSE ;
       break;
     case 1:
       break;

     default:
       return 0;
   }
   /*
   ** Return success
   */
   return( 1 );
}


/****************************************************************************
 *
 * FUNCTION NAME = FreeQProcInstResources
 *
 * DESCRIPTION   = Free QPROCINST structures allocated for calling process
 *
 * INPUT         = uPid        - process ID to free resources for
 *               = uExitReason - Reason for process termination
 *                      TC_EXIT            0 - Normal exit
 *                      TC_HARDERROR       1 - Hard-error halt
 *                      TC_TRAP            2 - Trap for 16-bit child process
 *                      TC_KILLPROCESS     3 - Unintercepted DosKillProcess
 *                      TC_EXCEPTION       4 - Exception for 32-bit child
 *
 *
 * OUTPUT        = frees any memory allocated for this process by PMPRINT
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = same as NORMAL
 *
 ****************************************************************************/

VOID FreeQProcInstResources(PID uPid, USHORT uExitReason)
{
    PQPROCINST pQProc = pQprocInstHead;

    /*
    ** Go thru per process list of QPROCINST structures and free all memory
    **
    ** Note: uPid should always match since this is per-process list
    */
    while (pQProc)
        if (pQProc->uPid == uPid)
        {
            Warning( "SplExitList: HPROC: %0x not freed by PMPRINT",
                        pQProc, 0);
            pQProc = DestroyQProcInst( pQProc );
        } else {

            pQProc = pQProc->pNext;
        }


    return;

    /*
    ** not used:
    */
    uExitReason;
}
