;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = STRBLT.INC
;*
;* DESCRIPTIVE NAME = Common include information in STRBLT.INC 
;*
;*
;* VERSION      V2.0
;*
;* DATE         04/15/87
;*
;* DESCRIPTION  This module contains the definition of strblt's frame, flag
;*              definitions, and anything else common to all the seperate
;*              modules which make up the strblt function.
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

;/*
;**       Definitions for the "accel" flag
;*/

IS_OPAQUE       equ     00000001b                ;Background mode is opaque
IS_XOR_TEXT     equ     00000010b                ;XOR'd text
IS_OR_TEXT      equ     00000100b                ;OR'd text
ABC_FONT        equ     00001000b                ;Font is an ABC font
HAVE_CHAR_EXTRA equ     00010000b                ;Char extra is present
HAVE_WIDTH_VECT equ     00100000b                ;Have a width vector
WIDTH_IS_8      equ     01000000b                ;Font is 8 pixels per character
FIXED_PITCH     equ     10000000b                ;Font is fixed pitch


;/*
;**       Definitions for the "excel" flag
;*/

OPAQUE_RECT     equ     00000001b                ;Opaquing rectangle is present
TEXT_VISIBLE    equ     00000010b                ;Some part of the text is visible
BOUNDED_IN_Y    equ     00000100b                ;Text fits within opaque rectangle in Y
IS_DEVICE       equ     00001000b                ;Destination is our device
FIRST_IN_PREV   equ     00010000b                ;First char starts in previous byte
RES_EGA_INNER   equ     00100000b                ;Restore EGA for opaque inner loop
CLIPPED_RIGHT   equ     01000000b                ;Overhanging right side of clip rect
CLIPPED_LEFT    equ     10000000b                ;Overhanging left  side of clip rect


;/*
;**       Definitions for the "wc_flags"
;*/

WC_OLD_OPAQUE   equ     00000001b                ;Shadow of IS_OPAQUE
WC_SET_LR       equ     00000010b                ;Set left/right into text bbox
WC_FIRST        equ     00000100b                ;First substring being output
STEPPED_BACK    equ     00001000b                ;Stepped backwards at somepoint
ROP_IS_NOP      equ     00010000b                ;fore and back mixes both LeaveAlone
;**             equ     00100000b
;**             equ     01000000b
;**             equ     10000000b


;/*
;** FONT_ENTRIES is the format of the individual character records in
;** a fixed or proportional font.
;*/


FONT_ENTRIES    struc
fe_dBits        dd      ?
fe_width        dw      ?
FONT_ENTRIES    ends

;/*
;** ABC_FONT_ENTRIES is the format of the individual character records in
;** an ABC spaced font.
;*/

ABC_FONT_ENTRIES struc
abc_fe_dBits     dd     ?
abc_a_space      dw     ?
abc_b_space      dw     ?
abc_c_space      dw     ?
ABC_FONT_ENTRIES ends


STACK_SLOP      equ     200                       ;# of bytes of stack space we cannot
                                                  ;  use when building up a string

;/*
;**       Definitions for the eto_options parameters
;*/

;**             equ     00000001b                ;Be thankful we removed this bit!
ETO_OPAQUE_FILL equ     00000010b                ;Fill opaque rect with background color
ETO_OPAQUE_CLIP equ     00000100b                ;Clip to opaque rectangle
;**             equ     00001000b
;**             equ     00010000b
;**             equ     00100000b
;**             equ     01000000b
;**             equ     10000000b


;/*
;**       Index for foreground and background colors stored
;**       in the frame variable "colors"
;*/

FOREGROUND      equ     0
BACKGROUND      equ     1


;/*
;**       frame_data is the definition of the data which is pushed
;**       into the stack for each character (where a character
;**       should be defined as a pattern of 8 bits or less).
;*/

frame_data      struc
fd_width        db      ?                         ;Width of the character
fd_phase        db      ?                         ;X location mod 8
fd_bits_offset  dw      ?                         ;Offset to the bits
frame_data      ends


;/*
;**       The local font structure has information copied from the
;**       font structure passed to strblt.  Having the data in a
;**       structure makes it a little more efficient when copying
;**       the data to the frame.
;*/

local_font_def  struc
font_width      dw      0                         ;Width field for the font
font_height     dw      0                         ;Height field for the font
first_char      dw      0                         ;First character in the font
last_char       dw      0                         ;Last character in the font (mapped)
default_char    dw      0                         ;Default character for out of range
local_font_def  ends

;/*
;** Variables for the STRBLT drawing routines saved at top of ring 2 stack
;*/

ss_variables    segment at 0
ss_height       dw      ?                         ;# of scans to output
ss_next_scan    dw      ?                         ;Delta to next scan of a bitmap
ss_draw         dw      ?                         ;Function to do output
ss_draw_clipped dw      ?                         ;Function to do clipped output
ss_phases       dw      ?                         ;Phases for 4 character case
ss_clip_mask    db      ?                         ;Clipping mask
ss_num_chars    db      ?                         ;Number characters for n char case
ss_colors       dw      ?                         ;Foreground/background colors
ss_p_frame      dw      ?                         ;Link to stack frame
ss_column_width dw      ?                         ;Width of character data column output
                                                  ;  Not used in EGA/VGA/CGA drivers
SS_VARIABLES_LEN = $-ss_height
ss_variables    ends

;/***************************************************************************
;*
;* MACRO NAME    = define_frame
;*
;* DESCRIPTION   = Macro for defining the frame for strblt functions 
;*                 This file allows the frame definiton to be shared by all
;*                 the modules which make up the strblt function.
;*
;* INPUT         =
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

;/*
;**!!! We don't need lp_Device any more, we can just take it from lp_ddc
;**
;**!!! Until we come up with something better, when you change the frame
;**!!! you'll have to change textext.inc
;*/

ifndef  incTextExtentFrame

define_frame macro  name

cProc   name,<FAR,PUBLIC,WIN,PASCAL,NODATA>,<si,di>

        parmD   lp_DDC                  ;DDC
        parmD   lp_device               ;Destination device
        parmW   x                       ;Left origin of string
        parmW   y                       ;Top  origin of string
        parmD   lp_clip_rect            ;Clipping rectangle
        parmD   lp_string               ;The string itself
        parmW   count                   ;Number of characters in the string
        parmW   npAttrs                 ;Offset to attribute bundle to use
        parmD   lp_dx                   ;Widths for the characters
        parmD   lp_opaque_rect          ;Opaquing rectangle
        parmW   eto_options             ;ExtTextOut options

        localB  accel                   ;Accelerator flags
        localB  excel                   ;Accelerator flags
        localB  wc_flags                ;Flags for worst case text
        localB  fbTranslate             ;String translation flag
        localW  colors                  ;Text/background colors

        localW  char_extra              ;# extra pixels to add each char
        localW  num_null_pixels         ;Number of pixels to add
        localW  null_char_offset        ;Offset of the special null character

        localW  lhs                     ;Extent code lhs (0 based)
        localW  rhs                     ;Extent code lhs (0 based)
        localW  concat                  ;Extent code concatenation point (o based)

        localW  selFont                 ; This variable contains the Font segment
        localW  offFont                 ; Once the font is cached, this
                                        ; variable contains Cache segment offset.
        localV  lfd,%(size local_font_def)
        localV  clip,%(size RECTS)
        localV  text_bbox,%(size RECTS)
        localV  o_rect,%(size RECTS)

        localB  smart_flags
        localB  special_bm_opaque_color ;Used for opauqe mode bitmaps
        localB  num_planes                        ;Number of planes in a bitmap
        localB  left_clip_mask                    ;lhs clip mask (00 if no partial left)
        localB  right_clip_mask                   ;rhs clip mask (00 if no partial byte)
        localW  cell_adjust                       ;Delta to get from one column to next
        localW  buffer                            ;Offset of buffer on the stack
        localW  fix_total_bytes                   ;Total bytes of a fixed pitch char

        localW  next_scan                         ;Index to get to next scan line
        localW  next_plane                        ;Index to get to next plane
ifdef DEV_INTERLEAVE
        localW  next_scan_xor                     ;XOR mask/adjustment for interlace
endif ;DEV_INTERLEAVE
        localW  opaque_routine                    ;Routine which does actual opaquing
        localW  opaque_height                     ;Height of opaque box (sometimes)
        localD  lp_surface                        ;Pointer to first byte of destination
        localW  temp_off_lp_bits                  ;Intermediate pointer to dev surface
        localW  scan_start                        ;Delta from start of scan

        localW  clipped_font_height               ;Actual height of bits to be drawn
        localW  amt_clipped_on_top                ;# of font scans clipped off top

        localW  clear_stack                       ;SP value used to clean up stack
        localW  min_stack                         ;SP where we run out of stack
        localW  build_proc                        ;Procedure which builds stack data

        localW  phase
        localW  x2
        localW  inner_loop

        localW  clipped_table                     ;Dispatch table for clipped characters
        localW  non_clipped_table                 ;Dispatch table for non-clipped chars
        localW  inner_byte_count                  ;Number of whole dest bytes altered

        localW  current_lhs                       ;LHS of current sub-string
        localW  current_rhs                       ;RHS of current sub-string
        localW  wc_opaque_lhs                     ;Left  side opaqued by worst case code
        localW  wc_opaque_rhs                     ;Right side opaqued by worst case code

        localW  string_start_bias                 ;# chars skipped at start of string
        localW  ret_addr                          ;Fixed pitch draw routine return addr
        localW  unrolled_entry_point              ;Start addr for unrolled loops

        localW  vect_one_in_first                 ;Dispatch vectors for fixed pitch code
        localW  vect_two_in_first
        localW  vect_one_in_middle
        localW  vect_two_in_middle
        localW  vect_one_in_last
        localW  vect_two_in_last

        localW  ret_addr_2
        localW  ega_oc_saved_data

        endm

endif
