;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page        ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = SCANCORR.ASM
;*
;* DESCRIPTIVE NAME = Scanline correlation program
;*
;*
;* VERSION      V2.0
;*
;* DATE         8/4/92
;*
;* DESCRIPTION  This module contains routines from SCANLINE.ASM 
;*              which are common to all drivers, including the
;*              scanline sub-function of Output. 
;*
;* FUNCTIONS    do_sl_corr
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/19/88                     Robert J. Carragher [t-robc] - Created
;*   09/02/88                     Lee A. Newberg [leen]
;*                                  Rewrote the final intersection 
;*                                  checking.  Moved intersect_range
;*                                   within line.  Added Pseudo code.
;*   07/19/88                     Tony Pisculli [tonyp]
;*                                  complete rewrite
;*   05/12/88                     Kent Settle [kentse]
;*                                  fixed invalid pointer passed 
;*                                  to RectVisible
;*   03/06/88                     Mike Harrington [mikehar]
;*                                  wrote do_sl_corr
;*****************************************************************************/

        .xlist
        include         cmacros.inc
INCL_GRE_CLIP           equ        1
INCL_GRE_SCANS          equ        1
INCL_GPIREGIONS         equ        1
INCL_DDIMISC            equ        1
INCL_DEV                equ        1
INCL_DDICOMFLAGS        equ        1
        include         pmgre.inc
        include driver.inc
        include display.inc
        include scanline.inc
        include assert.mac
        include njmp.mac
        .list

        ??_out  scanline


        errcode <BITMAP_NOT_SELECTED>

        externA  DOSHUGEINCR
        externA  SCREEN_CBSCAN                ;Screen width in bytes

sBegin        FarCode
        externNP intersect_with_corr
        externNP intersect_rcl
sEnd

sBegin Data
        externD  pfnDefRectVisible
sEnd    Data

;/*
;**        Special tables used for setting up the EGA for performing
;**        certain Rops in one pass
;*/

;/***************************************************************************
;*
;* FUNCTION NAME = do_sl_corr
;*
;* DESCRIPTION   = scanline correlation routine called by  
;*                 enumerate_clip_rects
;*                 Registers Preserved:       
;*                        SI,DI,DS,ES,BP      
;*                 Registers Destroyed:       
;*                        BX,DX               
;*                 Calls:                     
;*                        intersect_with_corr 
;*
;* INPUT         = BX        = clip RECTL    
;*                 SI        = npddc         
;*                 DI        = nplpScansData 
;*
;* OUTPUT        = AX        = 0 when done (correlate hit or early out) 
;*                 CX        = 2 if correlate, 0 if no correlate        
;*
;* RETURN-NORMAL = AX        = 0 when done (correlate hit or early out) 
;*                 CX        = 2 if correlate, 0 if no correlate        
;* RETURN-ERROR  = None
;*
;* PSEUDO-CODE   =
;*   do_sl_corr
;*   rclClip FAR *SS:BX;                                                     
;*   ddc NEAR *SI;                                                           
;*   ScansData FAR * FAR * SS:DI;                                            
;*                                                                           
;*   For each Scans Pair                                                     
;*       - Intersect the clip rectange, the pick window, and the Scan Pair   
;*          Bounding Box.                                                    
;*       - Compute the leftmost part of the scan pair in this rectangle.     
;*       - Compute the rightmost part of the scan pair in this rectangle.    
;*       - Check if this range intersects the X range of the pick window.    
;*
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

sBegin  BlueMoon
        assumes cs,BlueMoon
        externW BlueMoonData

cProc   do_sl_corr,<PUBLIC,NEAR,NODATA,NONWIN>,<ds,es>
        localW  cCount
        localW  nprclClip
        localV  rclBBox,<SIZE RECTL>
cBegin
        cld
        mov     nprclClip,bx

;/*
;**  intersect clip rect with correlation rect
;*/
        mov     ds,BlueMoonData                     ; DS:SI = ddc
        assumes ds,Data
        farPtr  mything,ss,bx
        cCall   intersect_with_corr,<mything>
        mov     bx,nprclClip
        or      ax,ax
        jnz     dsc_intersected
        jmp     exit_do_sl_corr
dsc_intersected:

;/*
;**   get number of shortline pairs and first pair
;*/
        lds     si,dword ptr ss:[di]                ; DS:SI = lpScansData
        assumes ds,nothing
        mov     ax,[si].sd_c.lo
        mov     cCount,ax
        assert  [si].sd_c.hi,E,0
        assert  [si].sd_c.lo,GE,0

        les     di,[si].sd_pslFirstRight        ; ES:DI = right-hand shortline
        assumes es,nothing
        lds     si,[si].sd_pslFirstLeft                ; DS:SI = left-hand shortline
        assumes ds,nothing
        
;/*     
;**  get bounding box of shortline pair
;*/
dsc_get_bbox:
        mov     ax,[si].sl_slh.slh_sxLeft
        mov     rclBBox.rcl_xLeft.lo,ax
        cwd
        mov     rclBBox.rcl_xLeft.hi,dx
        mov     ax,[si].sl_slh.slh_ptsStart.pts_y
        mov     rclBBox.rcl_yBottom.lo,ax
        cwd
        mov     rclBBox.rcl_yBottom.hi,dx

        mov     ax,es:[di].sl_slh.slh_sxRight
        mov     rclBBox.rcl_xRight.lo,ax
        cwd
        mov     rclBBox.rcl_xRight.hi,dx
        mov     ax,es:[di].sl_slh.slh_ptsStop.pts_y
        mov     rclBBox.rcl_yTop.lo,ax
        cwd
        mov     rclBBox.rcl_yTop.hi,dx
;/*
;**  intersect correlation rectangle with shortline-pair bounding box
;*/
        push    ds
        push    si
        push    es
        push    di
        mov     ax,ss
        mov     ds,ax
        mov     si,nprclClip                ; DS:SI = clip rect
        mov     es,ax
        lea     di,rclBBox                ; ES:DI = shortline-pair bounding box
        mov     bx,1
        cCall   intersect_rcl
        pop     di
        pop     es
        pop     si
        pop     ds
        or      ax,ax
        jnz     dsc_this_pair
        jmp     dsc_next_pair
dsc_this_pair:

;/*
;**   All the excitement is happening in rclBBox which is an inclusive-exclusive
;**   rectangle.  The scanline is  inclusive-exclusive, too.
;*/

        mov     bx,rclBBox.rcl_yBottom.lo
        sub     bx,[si].sl_slh.slh_ptsStart.pts_y
        assert  GE
        add     bx,bx
        assert  NC

        mov     cx,[si].sl_ax[bx]
        mov     dx,es:[di].sl_ax[bx]

        mov     bx,rclBBox.rcl_yTop.lo
        dec     bx                                ; Because it's exclusive
        assert  NO
        sub     bx,[si].sl_slh.slh_ptsStart.pts_y
        assert  GE
        add     bx,bx
        assert  NC

        cmp     cx,[si].sl_ax[bx]
        jl      @F
        mov     cx,[si].sl_ax[bx]
@@:
        cmp     dx,es:[di].sl_ax[bx]
        jg      @F
        mov     dx,es:[di].sl_ax[bx]
@@:

;/*
;**  CX = the leftmost point the scanline gets to.  (inclusive)
;**  DX = the rightmost point the scanline gets to.  (exclusive)
;*/

        mov     bx,nprclClip
        mov     ax,ss:[bx].rcl_xLeft.lo         ; (inclusive)
        mov     bx,ss:[bx].rcl_xRight.lo        ; (exclusive)               
                                                                            
;/*
;**  Check whether the x ranges,[CX,DX) and [AX,BX), intersect.
;*/

        assert  AX,LE,BX
        assert  CX,LE,DX
        cmp     ax,dx
        mov     ax,0                        ; Preserve flags.
        jge     dsc_next_pair
        cmp     cx,bx
        jge     dsc_next_pair
        mov     al,2
        jmp     short exit_do_sl_corr

dsc_next_pair:
        dec     cCount
        jz      exit_do_sl_corr
        lds     si,[si].slh_pslhNext
        assumes ds,nothing
        les     di,es:[di].slh_pslhNext
        assumes es,nothing
        jmp     dsc_get_bbox

exit_do_sl_corr:
        mov     cx,ax                   ; correlate info returned in CX
        xor     al,2                    ; tell enumerate_clip_rects to stop
                                        ; if correlation hit occurs.
cEnd

sEnd    BlueMoon
end
