;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = RESOLVEC.ASM
;*
;* DESCRIPTIVE NAME = Extracted routines from RESOLVE.ASM which are 
;*                    common to all drivers
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/08/88
;*
;* DESCRIPTION  
;*
;*    This module resolves undefined externals until they can be properly
;*    resolved (e.g. by finding the proper .H file to stuff the constants
;*    into).
;*
;* FUNCTIONS    Public:  SetCharFont
;*                       SetMarkerFont
;*                             
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/08/88                     Robert J. Carragher [t-robc] 
;*****************************************************************************/

        .xlist
        include cmacros.inc
INCL_DDIBUNDLES         equ                      1
INCL_DEV                equ                      1
INCL_FONTFILEFORMAT     equ                      1
INCL_GRE_FONTS          equ                      1
        include pmgre.inc
DINCL_ENABLE            equ                      1
DINCL_ROPS              equ                      1
DINCL_BB_ROPS           equ                      1
DINCL_SAVE_SCREEN_BITS  equ                      1
DINCL_VIO               equ                      1
        include driver.inc
        include fontseg.inc
        .list

        errcode <HUGE_FONTS_NOT_SUPPORTED>

        externFP GreEntry3

        pubabs  DEF_LOG_FORE_CLR,7
        pubabs  DEF_LOG_BACK_CLR,0

        pubabs  DEF_FB_LINE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_LINE,%(ROP_P)
        pubabs  DEF_BMIX_LINE,%(ROP_D)
        pubabs  DEF_LINE_TYPE,%(LINETYPE_SOLID-1)
        pubabs  DEF_LINE_ERROR,0
        pubabs  DEF_LINE_MASK,0

        pubabs  DEF_FB_MARKER,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_MARKER,%(CHAR_ROP_P)
        pubabs  DEF_BMIX_MARKER,%(BA_IS_XPARENT)
        pubabs  DEF_MARKER_FB_FLAGS,0
        pubabs  DEF_MARKER_FS_FLAGS,0
        pubabs  DEF_MARKER_CODE_POINT,%(MARKSYM_CROSS)

        pubabs  DEF_FB_CHAR,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_CHAR,%(CHAR_ROP_P)
        pubabs  DEF_BMIX_CHAR,%(BA_IS_XPARENT)
        pubabs  DEF_FONT_FS_FLAGS,0

        pubabs  DEF_FB_PATTERN,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_PATTERN,%(ROP_P)
        pubabs  DEF_BMIX_PATTERN,%(ROP_D)
        pubabs  DEF_PATTERN_FB_FLAGS,(PA_SINGLE_CLR)
        pubabs  DEF_PATTERN_FS_FLAGS,0
        pubabs  DEF_PATTERN_CODE_POINT,%(PATSYM_SOLID)

        pubabs  DEF_FB_IMAGE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_IMAGE,%(FM_OVERPAINT-1)
        pubabs  DEF_BMIX_IMAGE,%(BA_IS_XPARENT)


        pubabs  IC_SDFB,<SD_DEVICE or SD_COLOR>
        pubabs  SCREEN_SDFB,<SD_DEVICE or SD_COLOR or SD_NONNULL>
        pubabs  SCREEN_CYSEG,0

        pubabs  DEVCAPS_HEIGHT_IN_CHARS,24
        pubabs  DEVCAPS_WIDTH_IN_CHARS,80

        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,8
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8

sBegin  Data
        externB gsspScreen
        externD padBitmapFormats
        externD adDevCapsData
        externB ddcInit
sEnd    Data

sBegin  Code
        assumes cs,Code


        assumes ds,Data
        assumes es,nothing

FD_VECTOR       equ     0000000000000001B

;/***************************************************************************
;*
;* FUNCTION NAME = SetCharFont
;*
;* DESCRIPTION   = Font selection routine
;*
;*   We expect this routine to set BA_REREALIZE if it is appropriate.
;*  
;*   We can ignore the offset to the font because we FIREWALLed it to be
;*   zero, and all our code would fall apart if it wasn't.
;*  
;*   We don't need to worry about writing into the ddc and then detecting
;*   an error because DeviceSetAttributes saved the contents of the bundle
;*   for error recovery.
;*
;* INPUT         = DS:BX --> ddc
;*                 DX:AX  =  font handle / font pointer
;*                 BP     =  attr index for characters
;*                 CX     =  ca_fs, most flags cleared
;*                 ES:SI --> attribute bundle
;* OUTPUT        = None
;*
;* RETURN-NORMAL = None
;* RETURN-ERROR  = None
;*
;**************************************************************************/

        assumes ds,Data
        assumes es,nothing

cProc   SetCharFont,<FAR,PUBLIC,NONWIN>,<es,si>
cBegin

ifdef FIREWALLS
        mov     [bx].ddc_ca.ca_paus.sel,INVALID_SEL
endif

;/*
;**   Get all the data from the defs bundle while we still have it's pointer
;**   If this is a user supplied font, the code page will be in the defs
;**   bundle.  If it is the default, the code page is in ddc_ca.ca_idCodePage
;*/

        add     si,es:[si].dcbnd_cAttr
        add     si,(SIZE dcbnd_cDefs + SIZE dcbnd_cAttr)
        mov     ax,es:[si].cdef_charSpacing
        xor     ah,ah                             
        mov     [bx].ddc_ca.ca_cExtraPels,ax
        neg     ax                                ;'C' if non-zero
        sbb     ax,ax                             ;FFFF if non-zero char extra
        and     ax,CA_CHAR_EXTRA
        or      cx,ax

        mov     ax,es:[si].cdef_CodePage
        or      cx,cx
        js      scf_have_desired_code_page
        .errnz  CA_USER_FONT-8000h
        mov     ax,[bx].ddc_ca.ca_idCodePage
scf_have_desired_code_page:
        mov     si,ax                             ;Save desired code page in SI

;/*
;** Now reach into the font and pull out lots of good information so we
;** can set a bunch of different CA_ flags.
;*/

        access  ax,dx                             ;Make sure we can access font
        mov     es,dx
        assumes es,FontSeg
        xor     ax,ax

        or      cx,CA_VECTOR
        test    fsMetrics.foca_fsDefn,FD_VECTOR
        jne     scf_all_done                      ;!!! test for raster instead of vector
        and     cx,not CA_VECTOR                  ;It is raster

;/*
;** its a raster font, the display driver can't handle huge fonts
;** (but the engine now can handle huge vectore fonts)
;*/

        test    fsMetrics.foca_fsTypeFlags,FM_TYPE_64K
        jnz     scf_log_huge_error               ;Font is huge, don't accept it

        cmp     fsDef.fdCellWidth,8
        jne     @F
        or      cx,CA_WIDTH_IS_8
@@:
        test    fsMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      @F
        or      cx,CA_FIXED_PITCH
@@:
        cmp     fsDef.fdh_fsChardef,FONTDEFCHAR3
        jne     @F
        or      cx,CA_ABC_SPACE
@@:

;/*
;** If the font is not in the default code page (850), then no mapping
;** is possible.  If the font is the default code page and a different
;** code page is to be used, get the mapping array.  If getting the
;** mapping array fails, return an error.
;*/

        cmp     fsMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
        jne     scf_all_done
        cmp     si,DEFAULTVIOCODEPAGE
        je      scf_all_done
        or      si,si                             ;0 = use the default in the font
        je      scf_all_done

;/*
;**  Get the mapping vector for this code page.  Don't bother to get access
;**  now since the access test has to be made at output time.
;*/

        check   QueryCodePageVector,<idCP,hddc,ulFunN>
        save    <bx,cx>
        xor     dx,dx
        farPtr  myCPID,dx,si
        farPtr  myhddc,dx,dx
        cCall   GreEntry3,<myCPID,myhddc,GreQueryCodePageVector>
        mov     [bx].ddc_ca.ca_paus.sel,dx
        mov     [bx].ddc_ca.ca_paus.off,ax
        or      ax,dx
        jz      scf_exit                          ;Error, return 0
        or      cx,CA_MUST_MAP

scf_all_done:
        or      [bx].ddc_ca.ca_ba.ba_fb,BA_REREALIZE
        mov     ax,1
scf_exit:

cEnd

scf_log_huge_error:
        mov     ax,PMERR_HUGE_FONTS_NOT_SUPPORTED
        save_error_code
        xor     ax,ax
        cwd

        jmp     short scf_exit

;/***************************************************************************
;*
;* FUNCTION NAME = SetMarkerFont
;*
;* DESCRIPTION   = Marker selection routine
;*
;*   We expect this routine to set BA_REREALIZE if it is appropriate.
;*  
;*   We can ignore the offset to the font because we firewalled it to be
;*   zero, and all our code would fall apart if it wasn't.
;*  
;*   We don't need to worry about writing into the ddc and then detecting
;*   an error because DeviceSetAttributes saved the contents of the bundle
;*   for error recovery.
;*
;* INPUT         = DS:BX --> ddc
;*                 DX:AX  =  font handle / font pointer
;*                 BP     =  attr index for characters
;*                 CX     =  pa_fs
;*                 ES:SI --> attribute bundle
;* OUTPUT        = None
;*
;* RETURN-NORMAL = None
;* RETURN-ERROR  = None
;*
;**************************************************************************/

        assumes ds,Data
        assumes es,nothing

cProc   SetMarkerFont,<FAR,PUBLIC,NONWIN>,<es,di>
cBegin

ifdef FIREWALLS
        mov     [bx].ddc_ma.ma_paus.sel,INVALID_SEL
endif

;/*
;** Get all the data from the defs bundle while we still have it's pointer
;** If this is a user supplied font, the code page will be in the defs
;** bundle.  If it is the default, we want to set the default code page
;** so we don't try for the mapping vector.
;*/

        add     si,es:[si].dmbnd_cAttr
        add     si,(SIZE dmbnd_cDefs + SIZE dmbnd_cAttr)
        mov     si,es:[si].mdef_CodePage
        or      cx,cx
        js      @F
        .errnz  CA_USER_FONT-8000h
        mov     si,DEFAULTVIOCODEPAGE
@@:

;/*
;** Now reach into the font and pull out lots of good information so we
;** can set a bunch of different CA_ flags.  It seems a little silly
;** to execute this code even for the default marker, but someday we
;** might allow the font to be set at initialization time.
;*/

        access  ax,dx                             ;Make sure we can access font
        mov     es,dx
        assumes es,FontSeg
        xor     ax,ax

        or      cx,CA_VECTOR
        test    fsMetrics.foca_fsDefn,FD_VECTOR
        jne     smf_all_done                      ;!!! test for raster instead of vector
        and     cx,not CA_VECTOR                  ;It is raster

;/*
;** its a raster font, the display driver can't handle huge fonts
;** (but the engine now can handle huge vectore fonts)
;*/

        test    fsMetrics.foca_fsTypeFlags,FM_TYPE_64K
        jnz     smf_log_huge_error               ;Font is huge, don't accept it

        cmp     fsDef.fdCellWidth,8
        jne     @F
        or      cx,CA_WIDTH_IS_8
@@:
        test    fsMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      @F
        or      cx,CA_FIXED_PITCH
@@:
        cmp     fsDef.fdh_fsChardef,FONTDEFCHAR3
        jne     @F
        or      cx,CA_ABC_SPACE
@@:

;/*
;**  If the font is not in the default code page (850), then no mapping
;**  is possible.  If the font is the default code page and a different
;**  code page is to be used, get the mapping array.  If getting the
;**  mapping array fails, return an error.
;*/

        cmp     fsMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
        jne     smf_all_done
        cmp     si,DEFAULTVIOCODEPAGE
        je      smf_all_done
        or      si,si                             ;0 = use the default in the font
        je      smf_all_done

;/*
;** Get the mapping vector for this code page.  Don't bother to get access
;** now since the access test has to be made at output time.
;*/

        check   QueryCodePageVector,<idCP,hddc,ulFunN>
        save    <bx,cx>
        xor     dx,dx
        farPtr  myCPID,dx,si
        farPtr  myhddc,dx,dx
        cCall   GreEntry3,<myCPID,myhddc,GreQueryCodePageVector>
        mov     [bx].ddc_ma.ma_paus.sel,dx
        mov     [bx].ddc_ma.ma_paus.off,ax
        or      ax,dx
        jz      smf_exit                          ;Error, return 0
        or      cx,CA_MUST_MAP

smf_all_done:
        or      [bx].ddc_ma.ma_ba.ba_fb,BA_REREALIZE
        mov     ax,1
smf_exit:

cEnd

smf_log_huge_error:
        mov     ax,PMERR_HUGE_FONTS_NOT_SUPPORTED
        save_error_code
        xor     ax,ax
        cwd

        jmp     short smf_exit

sEnd    Code
end
