;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = QUERY.ASM
;*
;* DESCRIPTIVE NAME = This file contains the routines which handle device queries 
;*
;*
;* VERSION      V2.0
;*
;* DATE         8/4/92
;*
;* DESCRIPTION  Set up segment sequence and device driver header for an
;*              OS/2 device driver.  Provide STRATEGY and IDC entry
;*              points for this device driver.  These small functions
;*              take the registers passed in and push them onto the
;*              stack for C routines to use.
;*
;* FUNCTIONS    Exported:    QueryDeviceBitmaps
;*                           QueryDeviceCaps     
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/16/87                     Hock Lee [hockl] - Created
;*   10/21/91  @SM06xxx           David A Kerr AltSysFont not correct
;*   02/12/88                     Charles Whitmer [chuckwh]
;*                                   The small rewrite.  Maximal 
;*                                   paranoia about argument checking.
;*   01/27/88                     Walt Moore [waltm] The big rewrite.
;*   01/26/88                     Wes Rupel [wesleyr]
;*                                   Finished implementing DCR 23633
;*   01/17/88                     Bob Grudem [bobgru]
;*                                   Changed OutDataLength parameter 
;*                                   to be Count as per DCR 23633.
;*   07/17/87                     Hock Lee [hockl] Modified for new DDI.
;*   05/06/87                     Hock Lee [hockl] Wrote QueryDeviceBitmaps
;*   08/01/88                     Walt Moore      [waltm]
;*                                   DCR 24065 which says we should return 0 
;*                                   for anything which is outside the valid 
;*                                   range of table entries.                 
;*   09/01/87                     Hock Lee [hockl] Changed return code.
;*   07/17/87                     Hock Lee [hockl] Modified for new DDI.
;*   03/30/87                     Ron Gery [rong] fixed indexing off-by-one error
;*   02/24/88                     Charles Whitmer [chuckwh]
;*                                    Wrote QueryHardCopyCaps
;*   01/08/90                     Viroon  Touranachun [viroont]
;*                                    Cloned it from QueryDevResource().
;*
;*****************************************************************************/

        .286p
        .xlist
        include cmacros.inc
INCL_GRE_BITMAPS        equ     1
INCL_GRE_DEVICE         equ     1
INCL_DDI                equ     1
INCL_DDIMISC            equ     1
INCL_DEV                equ     1
INCL_DDICOMFLAGS        equ     1
INCL_WINPOINTERS        equ     1
INCL_DOSRESOURCES       equ     1
        include pmgre.inc
        include driver.inc
        .list

        errcode <INV_LENGTH_OR_COUNT>
        errcode <INV_IN_PATH,INV_IN_AREA,BASE_ERROR>

        externA COUNT_DEV_CAPS_DATA     ;# of elements in adDevCapsData

        externFP    DosGetResource2

sBegin  Data

        externW hModule
        externD adDevCapsData           ;Get Device Caps data table
        externD padBitmapFormats        ;Pointer to bitmap formats
        externW wDisplay                ;Display Type
ifdef BGA
        externW fAltSysFont              
        externW usSysFontRes             
endif                                    
                                         
sEnd    Data                             
                                         
                                         
sBegin  Code
assumes cs,Code

        externW         CodeData

page
;/***************************************************************************
;*
;* FUNCTION NAME = QueryDeviceBitmaps
;*
;* DESCRIPTION   = 
;*
;*     This function returns a list of bitmap formats supported by the device.
;*     The number of formats supported can be found using the QueryDeviceCaps     
;*     function.  Each value in the list is of the form:                          
;*         (u32_Planes, u32_BitsPerPixel).                                        
;*                                                                                            
;*     Zero fills the unused buffer space.                                        
;*                                                                                
;*     Registers Preserved:       
;*           SI,DI,BP,DS          
;*     Registers Destroyed:       
;*           AX,BX,CX,DX,ES,FLAGS 
;*
;* INPUT         = hdc,pbmf,clBitmapFormats,hddc,ulFunN
;* OUTPUT        = None
;*                 
;* RETURN-NORMAL = DX:AX = 1    
;* RETURN-ERROR  = DX:AX = 0    
;*                 Error logged 
;**************************************************************************/

        check   QueryDeviceBitmaps,<hdc,pbmf,clBitmapFormats,hddc,ulFunN>

        assumes ds,nothing
        assumes es,nothing

cProc   QueryDeviceBitmaps,<PUBLIC,FAR,NODATA>,<di,si>

        parmD   hdc
        parmD   lpOutData
        parmD   Count
        parmD   hddc
        parmD   FunN

cBegin
        mov     ds,CodeData
        assumes ds,Data
        cmp     Count.hi,0
        jnz     qdb_error
        mov     dx,Count.lo
        shr     dx,1                    ; DX = types we may return
        jnc     qdb_valid
qdb_error:
        mov     ax,PMERR_INV_LENGTH_OR_COUNT
qdb_error_ret:
        save_error_code
        xor     ax,ax
        jmp     short qdb_exit
qdb_valid:

;/*
;**  return the minimum of what we have and what fits
;*/

        mov     cx,adDevCapsData[CAPS_BITMAP_FORMATS*4].lo
        cmp     cx,dx
        jb      have_the_min
        mov     cx,dx                   ; CX = types to return
have_the_min:
        sub     dx,cx                   ; DX = how much zero fill
        add     dx,dx
        add     dx,dx                   ; watch for overflow
        jc      qdb_error
        jcxz    qdb_exit_ok
        lds     si,padBitmapFormats     ;Pointer to bitmap formats
        assumes ds,nothing
        les     di,lpOutData            ;--> where we're to return the formats
        assumes es,nothing
        cld
        shl     cx,2
        rep     movsw
        mov     cx,dx
        xor     ax,ax
        rep     stosw
qdb_exit_ok:
        mov     ax,1
qdb_exit:
        cwd
cEnd

page
;/***************************************************************************
;*
;* FUNCTION NAME = QueryDeviceCaps
;*
;* DESCRIPTION   = The desired value is returned from the devcaps_table block.
;*
;*                 Registers Preserved:      
;*                       SI,DI,BP,DS         
;*                 Registers Destroyed:      
;*                       AX,BX,CX,DX,ES,FLAGS
;*
;* INPUT         = hdc,Index,lpOutData,Count,hddc,FunN
;* OUTPUT        = None
;*
;* RETURN-NORMAL = DX:AX = 1
;* RETURN-ERROR  = DX:AX = 0
;*                 error logged
;**************************************************************************/

        check   QueryDeviceCaps,<hdc,lIndex,plData,clData,hddc,ulFunN>

        assumes ds,nothing
        assumes es,nothing

cProc   QueryDeviceCaps,<PUBLIC,FAR,NODATA>,<di,si>
        parmD   hdc
        parmD   Index
        parmD   lpOutData
        parmD   Count
        parmD   hddc
        parmD   FunN
cBegin
        cld
        mov     ds,CodeData
        assumes ds,Data

        mov     ax,4000h                ;16K dwords per 64K segemnt
        cwd                             ;DX = 0
        cmp     Count.hi,dx
        jne     qdc_have_count
        mov     cx,Count.lo
        or      cx,cx
        jnz     qdc_good_count          ;Asked for zero elements
        mov     ax,PMERR_INV_LENGTH_OR_COUNT
        save_error_code
        xor     ax,ax
        jmp     short qdc_error_return
qdc_good_count:
        cmp     cx,ax
        ja      qdc_have_count
        xchg    ax,cx                   ;Give them what they asked for
qdc_have_count:                         ;AX = number of dwords to write
        les     di,lpOutData
        assumes es,nothing
        cmp     Index.hi,dx
        jne     qdc_xfered_caps
        mov     si,Index.lo
        .errnz  CAPS_FAMILY             ;Must be zero based
        mov     cx,COUNT_DEV_CAPS_DATA  ;Max index + 1
        cmp     si,cx
        jae     qdc_xfered_caps         ;No dev caps to xfer

;/*
;**  We will have to transfer some number of device caps to the caller's
;**  buffer.
;*/

        sub     cx,si                   ;CX = number dev caps remaining
        sub     ax,cx                   ;AX = number to zero fill
        jnc     @F                      ;Return to end, and zero fill
        add     cx,ax                   ;Number of dev caps to xfer
        xor     ax,ax                   ;Nothing to zero fill
@@:
        shl     si,2                    ;SI = start index * 4
        .errnz  SIZE_DWORD-4
        add     cx,cx                   ;DWORD count to WORD count
        add     si,DataOFFSET adDevCapsData[CAPS_FAMILY*SIZE_DWORD]
        rep     movsw

qdc_xfered_caps:
        add     ax,ax
        jz      qdc_all_done            ;Nothing to fill with
        xchg    ax,cx
        xor     ax,ax
        rep     stosw

qdc_all_done:
        mov     ax,1
qdc_error_return:
        cwd
        fw_zero <cx,es>
cEnd

page

;/***************************************************************************
;*
;* FUNCTION NAME = QueryHardcopyCaps
;*
;* DESCRIPTION   = Returns zero forms.  
;*
;*                 Registers Preserved: 
;*                       SI,DI,BP,DS    
;*                 Registers Destroyed: 
;*                       none           
;*
;* INPUT         = hdc,Start,Count,lpInfo,hddc,FunN  
;* OUTPUT        = None
;*
;* RETURN-NORMAL = DX:AX = 0 
;* RETURN-ERROR  = None
;*
;* PSEUDO-CODE   =
;*
;*   {
;*       return(0);
;*   }
;*
;**************************************************************************/

        check   QueryHardcopyCaps,<hdc,lStart,chci,phci,hddc,ulFunN>

        assumes ds,nothing
        assumes es,nothing

cProc   QueryHardcopyCaps,<PUBLIC,FAR,NODATA,NONWIN>
        parmD   hdc
        parmD   Start
        parmD   Count
        parmD   lpInfo
        parmD   hddc
        parmD   FunN
cBegin
        xor     ax,ax
        cwd
cEnd

page
;/***************************************************************************
;*
;* FUNCTION NAME = QueryDevResource2
;*
;* DESCRIPTION   = This function returns the selectors and offsets to resources to 
;*                 the graphics engine and the user interface component. Since this
;*                 driver has only one set of resources this is        easy
;*                 Warning:                                                               
;*                   The 8514 now has two default fonts; one for the 8514 and one 
;*                   for 8515. We must return the appropriate font by recognizing 
;*                   the display.
;*
;* INPUT         = DWORD  hdc;    
;*                 DWORD  resType;
;*                 DWORD  id;     
;*                 DWORD  hddc;   
;*                 DWORD  FunN;   
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = DX = selector to the resource                                    
;*                 AX = offset to the resource                                    
;*                 DX:AX = 0 if resource doesn't exist (that never happens to us).
;* RETURN-ERROR  = DX:AX = -1
;*
;**************************************************************************/

        check   QueryDevResource2,<hdc,ulType,idRes,hddc,ulFunN>

        assumes ds,Data
        assumes es,nothing

cProc   QueryDevResource2,<PUBLIC,FAR,NODATA>,<di,si>
        parmD   hdc
        parmD   resType
        parmD   id
        parmD   hddc
        parmD   FunN
        localD  pResource

cBegin
        mov     ds,CodeData
        assumes ds,Data

        lea     ax,pResource
        farPtr  lpAddr,ss,ax
        push    hModule
        push    resType.lo

        mov     bx,id.lo               ; load request @SM06xxx

ifdef BGA
         cmp     bx,SFONT_RASTER       ; check to see if we are being asked about
         jne     short qdr2_push_id    ; the font - if not, don't mess with it

                                       ; ok, we have been asked to load the font
         mov     bx,usSysFontRes       ; load id of font in use
                                       ; and continue

else
                                       ; @SM07779 start
        cmp     wDisplay,DISPLAY_PLASMA ; bigger pointers on LCD and Plasma
        jne     short qdr2_push_id      ; if not, don't mess with it
        cmp     resType.lo, RT_POINTER  ; is it a pointer type?
        jne     short qdr2_push_id      ; if not, don't mess with it
        cmp     bx,SPTR_ARROW
        jne     short qdr2_noa
        mov     bx,291                  
        jmp     short qdr2_push_id      ; go get it
 qdr2_noa:
        cmp     bx,SPTR_TEXT
        jne     short qdr2_not
        mov     bx,292                  
                                        ; and continue
 qdr2_not:

endif

qdr2_push_id:
        push    bx                    ; SM06xxx
qdr2_make_call:
        cCall   DosGetResource2,<lpAddr>
        or      ax,ax
        jnz     error_QueryDevResource2
        mov     ax,pResource.lo
        mov     dx,pResource.hi
exit_QueryDevResource2:
cEnd

error_QueryDevResource2:
        xchg    ax,bx
        mov     ax,PMERR_BASE_ERROR
        save_error_code
        xor     ax,ax
        cwd
        jmp     short   exit_QueryDevResource2

sEnd    Code
end
