;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = STRBLT8.INC
;*
;* DESCRIPTIVE NAME = PPXY specific include information from STRBLT.INC 
;*
;*
;* VERSION      V2.0
;*
;* DATE         09/02/88
;*
;* DESCRIPTION  This module contains the definition of strblt's frame, flag
;*              definitions, and anything else common to all the seperate
;*              modules which make up the strblt function.
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   09/02/88                     Author:  Robert J. Carragher [t-robc]
;*****************************************************************************/


        include strblt.inc                        ;Get the common include stuff

;/*
;** This comes the definitions for the "excel" flag
;*/

CACHED_FONT     equ     00100000b                 ;Font is cached in offscreen memory

;/*
;**  HW_FONT_ENTRIES is the format of the individual character records in
;**  a fixed or proportional font that has been cached in the offscreen
;**  memory.   Obviously, this is a device-dependent structure, thereby reducing
;**  this file to device dependency; however, STRBLT and cohorts will likely
;**  become device dependent as well.
;*/


HW_FONT_ENTRIES struc
hwfe_StartX     dw      ?                        ; Start X of character in device memory
hwfe_StartY     dw      ?                        ; Start Y of character in device memory
hwfe_Width      dw      ?                        ; Width of character in device memory
hwfe_Plane      dw      ?                        ; The memory plane the character lives in
HW_FONT_ENTRIES ends

MAX_CACHED_FONTS    equ     16                   ; maximum number of cached fonts allowed

;/*
;**  HW_ABC_FONT_ENTRIES is the information needed for each character in a
;** cached ABC-spaced font.
;*/

HW_ABC_FONT_ENTRIES struc
hwabc_StartX     dw      ?                       ; Start X of character in device memory
hwabc_StartY     dw      ?                       ; Start Y of character in device memory
hwabc_a_space    dw      ?                       ; Space to left when displayed
hwabc_b_space    dw      ?                       ; Character width
hwabc_c_space    dw      ?                       ; Space to right when displayed
hwabc_Plane      dw      ?                       ; The memory plane the character lives in
HW_ABC_FONT_ENTRIES ends
