;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*****************************************************************************
;*
;* SOURCE FILE NAME =  RESOLVE.ASM
;*
;* DESCRIPTIVE NAME =  Device Specific Initialization.
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/01/91
;*
;* DESCRIPTION  Device Specific Initialization.           
;*              
;*              
;* FUNCTIONS    device_specific_init
;*              device_specific_post_init
;*              Load&loadseg
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/01/91                     Written by Scott Lawson
;*   04/02/90                     johnc - Critical section check now in 
;*                                both retail and debug
;*   02/02/89                     P.J.Vickers, IBM Hursley.  Support for 
;*                                new monitors             @D1A
;*                                DCRs 24274 and 24230     @D1A
;*****************************************************************************/

        .xlist
        include cmacros.inc
        include assert.mac
INCL_DDIBUNDLES         equ     1
INCL_DEV                equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
INCL_GPILOGCOLORTABLE   equ     1
INCL_GPIBITMAPS         equ     1
        include pmgre.inc
DINCL_ENABLE            equ     1
DINCL_ROPS              equ     1
DINCL_BB_ROPS           equ     1
DINCL_SAVE_SCREEN_BITS  equ     1
DINCL_VIO               equ     1
        include driver.inc
        Include 8514.inc
        include strblt8.inc
        include fontseg.inc
        include palette.inc
        .list

        errcode <HARDWARE_INIT_FAILURE>

        pubabs  DEFAULT_SELTEXTVRAM,-1          ; To cause GP-Fault

ifdef   8514DEBUG

;/*
;**  Temporary macros
;*/

LoadStub        Macro   loadseg
sBegin  HwConfig
        assumes Cs,HwConfig
        assumes Ds,Data
cProc   Load&loadseg,<FAR,PUBLIC,NODATA>
cBegin  nogen
        Mov     pConfigFuncs.sel,HwConfigBASE
        Mov     pConfigFuncs.off,HwConfigOFFSET loadseg&Funcs
        Ret
cEnd    nogen
sEnd
        Endm


endif; 8514DEBUG

        externA  DOSPAGESIZE
        externFP GreEntry3

        pubabs  DEF_LOG_FORE_CLR,7
        pubabs  DEF_LOG_BACK_CLR,0
        pubabs  DEF_IPC_FORE_CLR,00000000b      ;For 8514
        pubabs  DEF_IPC_BACK_CLR,11111111b      ;For 8514

        pubabs  DEF_FMIX_LINE,%(ROP_P)
        pubabs  DEF_FB_LINE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_LINE,%(ROP_D)
        pubabs  DEF_LINE_TYPE,%(LINETYPE_SOLID-1)
        pubabs  DEF_LINE_ERROR,0
        pubabs  DEF_LINE_MASK,0
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,16
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,16

        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,120
        pubabs  DEVCAPS_VERTICAL_FONT_RES,120

        pubabs  DEF_FMIX_MARKER,%(CHAR_ROP_P)
        pubabs  DEF_FB_MARKER,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_MARKER,%(BA_IS_XPARENT)
        pubabs  DEF_MARKER_FB_FLAGS,0
        pubabs  DEF_MARKER_FS_FLAGS,0
        pubabs  DEF_MARKER_CODE_POINT,%(MARKSYM_CROSS)

        pubabs  DEF_FMIX_CHAR,%(CHAR_ROP_P)
        pubabs  DEF_FB_CHAR,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_CHAR,%(BA_IS_XPARENT)

        pubabs  DEF_FMIX_PATTERN,%(ROP_P)
        pubabs  DEF_FB_PATTERN,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_PATTERN,%(ROP_D)
        pubabs  DEF_PATTERN_FB_FLAGS,(PA_SINGLE_CLR)
        pubabs  DEF_PATTERN_FS_FLAGS,0
        pubabs  DEF_PATTERN_CODE_POINT,%(PATSYM_SOLID)

        pubabs  DEF_FMIX_IMAGE,%(FM_OVERPAINT-1)
        pubabs  DEF_FB_IMAGE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_IMAGE,%(BA_IS_XPARENT)

        pubabs  VISIBLE_SIZE_WORDS,80*480/2
        pubabs  INIT_FSHADOW_MEM,0              ;Don't use it for VGA

        pubabs  DEVCAPS_VERTICAL_RESOLUTION,3622
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,3622
        pubabs  DEVCAPS_COLORS,256
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,256
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_COLOR_INDEX,255

        pubabs  DEVCAPS_HEIGHT_IN_CHARS,24
        pubabs  DEVCAPS_WIDTH_IN_CHARS,80
        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_CHAR_HEIGHT,18
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,8
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8

;/*
;** This driver supports color pointer
;*/
CAPS_COLOR_POINTER_SUPPORT      equ     128
        pubabs  DEVCAPS_COLOR_POINTER_SUPPORT,%(CAPS_COLOR_POINTER_SUPPORT)

        pubabs  IC_SDFB,<SD_DEVICE or SD_COLOR>
        pubabs  SCREEN_CX,1024
        pubabs  SCREEN_CY,768
        pubabs  SCREEN_CBSCAN,1024
        pubabs  SCREEN_DSCAN,1024
        pubabs  SCREEN_SDFB,<SD_DEVICE or SD_COLOR or SD_NONNULL>
        pubabs  SCREEN_CYSEG,0



sBegin  PtrData
        externW and_x_cell              ; and mask ul
        externW and_y_cell              ; and mask ul
        externW xor_x_cell              ; xor mask ul
        externW xor_y_cell              ; xor mask ul
        externW save_x_cell             ; save area for bits behind pointer
        externW save_y_cell             ; save area for bits behind pointer

        externW Ptr_sd_cx               ; PtrData copy of width of framebuffer
        externW Ptr_sd_cy               ; PtrData copy of height of framebuffer
        externW Ptr_hwFlags             ; PtrData copy of hwFlags
sEnd    PtrData


sBegin  Data
        externB gsspScreen              ; get screen selector struct
        externB sdScreen                ; screen surface definition
        externB ddcInit                 ; ddc used for initial values
        externW adDevCapsData           ; -> device capabilities data
        externW npbmcDev                ; near -> device bitmap format struct
        externW npbmcColor              ; near -> color bitmap format struct
        externW adDevCapsData           ; -> device capabilities
        externW bmc4Pixel1Plane         ; hw surface definition format
        externD padBitmapFormats        ; -> allowed create bitmap formats

        externW OffScreenYMIN           ; offscreen top for fonts
        externW OffScreenXMIN           ; offscreen left for fonts
        externW OffScreenYMAX           ; offscreen bottom for fonts
        externW OffScreenXMAX           ; offscreen right for fonts

        externW BltBufferY              ; offscreen y of blt temp buffer
        externW BltBufferX              ; offscreen x of blt temp buffer
        externW BltBufferYExt           ; height of blt temp buffer
        externW BltBufferXExt           ; width of blt temp buffer
        externW cResource               ; Number of resources to load       @D1A

        externW PatCacheY               ; offscreen y for cached pattern
        externW PatCacheYExt            ; height of cached pattern
        externW PatCacheXExt            ; width of cached pattern

        externW SsbX                    ; ssb left x
        externW SsbY                    ; ssb top y
        externW SsbXExt                 ; ssb width
        externW SsbYExt                 ; ssb height

        externW BoardMaxY               ; max real addressable y on board
        externW ipc_index_mask          ; mask to bpp depending on configuration

        externW usSysFontRes            ; value of system font resource id
        externW fAltSysFont             ; flag for Alternate system font

        globalW hwFlags,0               ; hw flags, telling us hw config
        globalW selFont_list,0,MAX_CACHED_FONTS
        globalW selCache_list,0,MAX_CACHED_FONTS

;/*
;**       Warning there is code in pointer.asm which needs depends on this values
;*/
        globalW cPtrSizes,5     ; There are 5 valid pointer sizes:
        dw      32,32           ;   32 x 32    ( width x height )
        dw      40,40           ;   40 x 40
        dw      64,64           ;   64 x 64
        dw      64,32           ;   64 x 32
        dw      32,64           ;   32 x 64

sEnd    Data


        externA PTR_WIDTH_BITS

ifdef   8514DEBUG

        externD HwConfig0Funcs
        externD HwConfig1Funcs
        externD HwConfig2Funcs
        externD HwConfig3Funcs
        externD HwConfig4Funcs
        externD HwConfig5Funcs
        externD HwConfig6Funcs
        externD HwConfig7Funcs

endif;  8514DEBUG

        externFP InitDefaultPalette

sBegin  PalSeg
        externB end_crit_code
sEnd    PalSeg

sBegin  Code
        assumes cs,Code
        assumes ds,Data
        assumes es,nothing

        externW CodeData
        externW MyPtrCodeData           ; segbase of pointer data segment

;/*
;** Following table is indexed into based on whether or not we are talking
;** to a 4 or 8 bpp 8514/A adapter (as determined by the presence of the
;** memory expansion unit on the adapter)
;*/

ifdef   4BPP_USED
adBitmapFormats4 Label  Dword
        Dd      1,4             ;1 plane, 4 pel
        Dd      1,1             ;1 plane, 1 pel
endif;  4BPP_USED

adBitmapFormats8 Label  Dword
        Dd      1,8             ;1 plane, 8 pel
        Dd      1,1             ;1 plane, 1 pel

;/*
;**  Following table specifies legal hw operating modes as determined by the
;**  hardware options bits in the CNTL_STATUS register of the 8514/A
;**  (device identity values)
;** 
;**  maaaxxxx
;**  76543210
;** 
;**  Bit 7 on  = 8 planes per pel
;**        off = 4 planes per pel
;** 
;**  Bits 654
;** 
;**  000 - illegal
;**  001 - Albany - 8507
;**  010 - 8514
;**  011 - Dallas
;**  100 - illegal
;**  101 - 8503 (BW)
;**  110 - 8512\8513
;**  111 - no monitor
;*/

adHwModes       Label   Word

ifdef   4BPP_USED
   dw   HW_ILLEGAL
   dw   HW_ILLEGAL+HW_4_BPP+HW_MON_1024+HW_MONO_MON
   dw   HW_ILLEGAL+HW_4_BPP+HW_MON_1024+HW_COLOR_MON
   dw   HW_ILLEGAL+HW_4_BPP+HW_MON_1024+HW_COLOR_MON+HW_DALLAS ;85?? (Dallas)
   dw   HW_ILLEGAL
   dw   HW_ILLEGAL+HW_4_BPP+HW_MON_640+HW_MONO_MON
   dw   HW_ILLEGAL+HW_4_BPP+HW_MON_640+HW_COLOR_MON
   dw   HW_ILLEGAL        ; no monitor

   dw   HW_ILLEGAL
   dw   HW_LEGAL+HW_8_BPP+HW_MON_1024+HW_COLOR_MON           ;8507 (Albany)
   dw   HW_LEGAL+HW_8_BPP+HW_MON_1024+HW_COLOR_MON
   dw   HW_LEGAL+HW_8_BPP+HW_MON_1024+HW_COLOR_MON+HW_DALLAS ;85?? (Dallas)
   dw   HW_ILLEGAL
   dw   HW_LEGAL+HW_8_BPP+HW_MON_640+HW_MONO_MON
   dw   HW_LEGAL+HW_8_BPP+HW_MON_640+HW_COLOR_MON
   dw   HW_ILLEGAL        ; no monitor
else
   dw   HW_ILLEGAL
   dw   HW_ILLEGAL+HW_MON_1024+HW_MONO_MON
   dw   HW_ILLEGAL+HW_MON_1024+HW_COLOR_MON
   dw   HW_ILLEGAL+HW_MON_1024+HW_COLOR_MON+HW_DALLAS ;85?? (Dallas)
   dw   HW_ILLEGAL
   dw   HW_ILLEGAL+HW_MON_640+HW_MONO_MON
   dw   HW_ILLEGAL+HW_MON_640+HW_COLOR_MON
   dw   HW_ILLEGAL        ; no monitor

   dw   HW_ILLEGAL
   dw   HW_LEGAL+HW_MON_1024+HW_COLOR_MON            ;8507 (Albany)
   dw   HW_LEGAL+HW_MON_1024+HW_COLOR_MON
   dw   HW_LEGAL+HW_MON_1024+HW_COLOR_MON+HW_DALLAS ;85?? (Dallas)
   dw   HW_ILLEGAL
   dw   HW_LEGAL+HW_MON_640+HW_MONO_MON
   dw   HW_LEGAL+HW_MON_640+HW_COLOR_MON
   dw   HW_ILLEGAL        ; no monitor
endif;  4BPP_USED

ifdef   8514DEBUG

;/*
;** Following table contains pointers to stub functions in the different
;** configuration dependent code segments. They are called by the init code
;** to ensure that the correct code segment is loaded (mainly for ease of
;** debugging). As a side-affect, they also set up the pointer to the table
;** of configuration specific routines contained in the particular code segment.
;*/

pCodeSegs       Label   Dword
        dd      LoadHwConfig0
        dd      LoadHwConfig1
        dd      LoadHwConfig2
        dd      LoadHwConfig3
        dd      LoadHwConfig4
        dd      LoadHwConfig5
        dd      LoadHwConfig6
        dd      LoadHwConfig7

endif;  8514DEBUG

;/***************************************************************************
;*
;* FUNCTION NAME = device_specific_init 
;*
;* DESCRIPTION   = Device Specific Initialization routine
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

cProc   device_specific_init,<FAR,PUBLIC,NODATA>
cBegin

        mov     ax,DOSPAGESIZE
        cmp     ax,PalSegOFFSET end_crit_code
        jae     crit_sec_code_ok
        int     3
crit_sec_code_ok:

;/*
;** The 8514/A framebuffer is not accessible via host memory, ergo no
;** screen selector is needed. Initialize the size field of the GSSP
;** structure to 0 to signify this situation
;*/

        Mov     gsspScreen.gssp_size,0  ; we don't use a screen selector

;/*
;**  Determine the hardware environment as dictated by the following:
;** 
;**        4 bit plane memory expansion installed or not on 8514/A
;**        lo res or hi res monitor attached
;**        monochrome or color monitor attached
;*/

        Mov     Dx,CNTL_STATUS          ; read 8514/A status
        In      Ax,Dx
        And     Ax,CS_OPTIONS           ; isolate options bit fields
        Shr     Ax,3                    ; down into word offset position
        .errnz  CS_OPTIONS    And 1111111100001111b
        Mov     Bx,Ax
        Mov     Ax,adHwModes[Bx]        ; get hw options flags
        Mov     hwFlags,Ax              ; save for later referral
        Mov     Dx,Ax                   ; keep local copy of hwFlags
        Shl     Ax,1                    ; get legal/illegal mode bit to carry
        .errnz  HW_LEGAL-08000h
        Sbb     Cx,Cx                   ; 0:illegal,-1:legal
        Jnz     @F                      ; legal hw mode...
        xor     cx,cx                   ; show error
        mov     ax,PMERR_HARDWARE_INIT_FAILURE
        assert  ax,E,0  ; let the poor user know where the problem is.
        Jmp     exit_device_specific_init; jump out on error...
@@:

;/*
;** Initialisations based on family-type
;*/

;/*
;** we want 102 only if : - it's an 8515 and not fAltSysFont
;**                       or
;**                       - it's an 8514 and fAltSysFont
;*/

        mov     ax,fAltSysFont       ; we want 102 only if :
        test    dl,HW_DALLAS         ;  - it's an 8514 and fAltSysFont
        jz      not_dallas           ; or
        dec     ax                   ;  -  it's an 8515 and not fAltSysFont
not_dallas:
        or      ax,ax
        jz      end_family_init

;/*
;**     In future it would be good to select a system font explicitly.
;**     At that time it might be a good idea to set up fAltSysFont as
;**     usAltSysFontResID instead, and use that number (if non-0) as the
;**     resource id of the font to load in QUERY.ASM
;*/

        Mov     adDevCapsData[CAPS_HORIZONTAL_RESOLUTION*SIZE_DWORD],4098
        Mov     adDevCapsData[CAPS_VERTICAL_RESOLUTION*SIZE_DWORD],4098

        mov     si,DataOFFSET cResource ;load alternative 12x22 system font
        lodsw                           ; font resource count
        or      ax,ax
        jz      end_family_init         ; skip if no resources (?)
        mov     [si].fr_usId,RES_ID_DALLAS ; load alternative font
        mov     usSysFontRes,RES_ID_DALLAS ; remember its value

;/*
;** Should it be required, here's where we will overwrite the                 @D1A
;** preset font metrics in adDevCapsData.                                     @D1A
;*/

end_family_init:                                                           ;@D1A

ifdef   4BPP_USED

;/*
;** Initializations based on pixel depth
;*/

        Test    Dl,HW_8_BPP             ; running 8 bpp ?
        .errnz  High HW_8_BPP
        Jz      hw_is_4bpp              ; no -- do 4bpp inits below...

endif;  4BPP_USED

;/*
;** Initializations dependent on running 8 bpp
;*/

        Mov     padBitmapFormats.off,CodeOFFSET adBitmapFormats8

ifdef   4BPP_USED
        Jmp     end_hw_bpp_init         ; final bpp inits...

;/*
;** Initializations dependent on running 4 bpp
;*/
hw_is_4bpp:

        Mov     padBitmapFormats.off,CodeOFFSET adBitmapFormats4

        Mov     ipc_index_mask,15       ; mask for bpp

        Mov     Ax,CodeOFFSET bmc4Pixel1Plane
        Mov     npbmcDev,Ax
        Mov     npbmcColor,Ax

        Mov     adDevCapsData[CAPS_COLORS*SIZE_DWORD],16
        Mov     adDevCapsData[CAPS_COLOR_INDEX*SIZE_DWORD],15
        Mov     adDevCapsData[CAPS_COLOR_BITCOUNT*SIZE_DWORD],4
endif;  4BPP_USED

end_hw_bpp_init:

;/*
;** Initializations based on display width (which in turn will determine
;** display vertical resolution for this implementation)
;*/

        Test    Dl,HW_MON_640           ; running 640 wide ?
        .errnz  High HW_MON_640
        Jnz     hw_is_640               ; yes -- do 640 wide inits below...

;/*
;** Initializations dependent on running 1024 wide (and thus 768 high)
;*/

        Jmp     end_hw_resolution_init  ; final resolution inits...

;/*
;** Initializations dependent on running 640 wide (and thus 480 high)
;*/
hw_is_640:

        Mov     sdScreen.sd_cx,640
        Mov     adDevCapsData[CAPS_WIDTH*SIZE_DWORD],640
        Mov     sdScreen.sd_cy,480
        Mov     adDevCapsData[CAPS_HEIGHT*SIZE_DWORD],480

        mov     es,MyPtrCodeData
        assumes es,PtrData

        MapXY   and_x_cell,640,IS_X,IS_512
        MapXY   and_y_cell,0,IS_Y,IS_512
        MapXY   xor_x_cell,672,IS_X,IS_512
        MapXY   xor_y_cell,0,IS_Y,IS_512
        MapXY   save_x_cell,704,IS_X,IS_512
        MapXY   save_y_cell,0,IS_Y,IS_512

        MapXY   OffScreenXMIN,640,IS_X,IS_512; use right edge of framebuffer
        MapXY   OffScreenYMIN,32,IS_Y,IS_512; leave room for cursor images
        MapXY   OffScreenXMAX,(640+384-1),IS_X,IS_512
        MapXY   OffScreenYMAX,(480+32-1),IS_Y,IS_512; 

        MapXY   BltBufferY,488,IS_Y,IS_512; start y of blt temp buffer
        Mov     BltBufferYExt,32        ; only have 32 scanlines
        Mov     BltBufferXExt,640       ; only need a framebuffer width

        MapXY   PatCacheY,480,IS_Y,IS_512; use offscreen at bottom for pattern
        Mov     PatCacheYExt,8          ; only 8 lines cached
        Mov     PatCacheXExt,640        ; full width of framebuffer

        MapXY   SsbX,736,IS_X,IS_512    ; ssb area is right edge of framebuffer
        MapXY   SsbY,0,IS_Y,IS_512
        Mov     SsbXExt,(1024-736)      ; width of ssb area
        Mov     SsbYExt,32              ; just the height of a cursor

        MapXY   BoardMaxY,512,IS_Y,IS_512; max y addressable

end_hw_resolution_init:


;/*
;** Initializations based on color vs. monochrome monitor
;*/

        Test    Dl,HW_MONO_MON          ; running mono monitor ?
        .errnz  High HW_MONO_MON
        Jnz     hw_is_mono              ; yes -- do mono inits below...

;/*
;** Initializations dependent on running color monitor
;*/

        Jmp     end_hw_color_init       ; final color/mono inits...

;/*
;** Initializations dependent on running monochrome monitor
;*/
hw_is_mono:

        And     sdScreen.sd_fb,Not SD_COLOR
        Mov     adDevCapsData[CAPS_PHYS_COLORS*SIZE_DWORD].lo,64
        Mov     adDevCapsData[CAPS_PHYS_COLORS*SIZE_DWORD].hi,0
        mov     adDevCapsData[CAPS_COLORS*SIZE_DWORD].hi,64
        mov     adDevCapsData[CAPS_COLORS*SIZE_DWORD].hi,0

end_hw_color_init:


;/*
;** Initializations which must be done after the above initializations
;*/

        Mov     padBitmapFormats.sel,CodeBASE

        Mov     Ax,sdScreen.sd_cx       ; pixels in x

ifdef   4BPP_USED
        Test    Dl,HW_8_BPP             ; if 8bpp we have correct delta...
        .errnz  High HW_8_BPP
        Jnz     @F
        Shr     Ax,1                    ; else 2 pixels are packed / byte
endif;  4BPP_USED

@@:     Mov     sdScreen.sd_dScan,Ax

        Mov     adDevCapsData[CAPS_MARKER_HEIGHT*SIZE_DWORD].hi,0
        Mov     adDevCapsData[CAPS_MARKER_HEIGHT*SIZE_DWORD].lo,11
        Mov     adDevCapsData[CAPS_MARKER_WIDTH*SIZE_DWORD].hi,0
        Mov     adDevCapsData[CAPS_MARKER_WIDTH*SIZE_DWORD].lo,11
;  Since we don't support Palette Manager, wipe out this bit. Don't lie to PMWIN or
;    we break restores behind menus.     Defect 57193  MLC
;       or      adDevCapsData[CAPS_ADDITIONAL_GRAPHICS*SIZE_DWORD].lo,CAPS_PALETTE_MANAGER
        .erre   CAPS_PALETTE_MANAGER lt 0FFFFh

ifdef   8514DEBUG

;/*
;** Ensure that the configuration specific code segment has been loaded
;*/

        Mov     Bx,hwFlags              ; hardware options
        And     Bx,HW_OPTIONS
        .errnz  HW_OPTIONS And 11111000b
        Shl     Bx,2                    ; pointer index
        Call    pCodeSegs[Bx]           ; call stub, load segment

endif; 8514DEBUG

        missing_code    <Alter hwFlags based on environment and/or PRESSERV.INI>
        missing_code    <Take care of unfinished initializations>

        xor     ax,ax
        Mov     Cx,1                    ; indicate success

exit_device_specific_init:

cEnd

cProc   device_specific_post_init,<FAR,PUBLIC,NODATA>
cBegin

;/*
;** Load cloned values into the cursor data segment.
;*/

        mov     es,MyPtrCodeData        ; get access to ptr data segment
        assumes es,PtrData

        mov     ax,hwFlags              ; cloned h/w flags
        mov     Ptr_hwFlags,ax

        mov     ax,sdScreen.sd_cx       ; cloned width of framebuffer
        mov     Ptr_sd_cx,ax

        mov     ax,sdScreen.sd_cy       ; cloned height of framebuffer
        mov     Ptr_sd_cy,ax

        cCall   InitDefaultPalette
cEnd

sEnd    Code


ifdef   8514DEBUG

;/*
;** Declare stub procedures in each of the configuration dependent code segments,
;** their sole function being that of a routine which may be called with null
;** actions that accomplishes the goal of loading the particular segment.
;*/

        LoadStub        HwConfig0
        LoadStub        HwConfig1
        LoadStub        HwConfig2
        LoadStub        HwConfig3
        LoadStub        HwConfig4
        LoadStub        HwConfig5
        LoadStub        HwConfig6
        LoadStub        HwConfig7

endif;  8514DEBUG

        End
