;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PHY16CLR.ASM
;*
;* DESCRIPTIVE NAME = This module contains color stuff 
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  ColorConvert converts a logical color (an RGB triplet) to a
;*              physical color (a byte).
;*
;* FUNCTIONS    far_rgb_to_ipc_16
;*              rgb_to_ipc_16
;*                                
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   02/08/88                     Walt Moore [waltm] Temp kludge for the rewrite
;*   07/13/88                     Bob Grudem [bobgru] Added special case
;*                                checking for intense black (iblk?  macro).
;*   07/19/88                     Bob Grudem [bobgru] Rewrote from scratch to
;*                                match color mapping of dithering code.  See
;*                                the discussion above for details.
;*   07/27/88                     Bob Grudem [bobgru] Changed packed_ipc_table
;*                                so that dimmest colors were chosen in ties
;*                                instead of brightest.  This resolves the
;*                                problem of 7FBFFF (supposed to be PALEBLUE)
;*                                mapping to white, when it is used as
;*                                background for white text on the title bar!
;*                                Moreover, it does it in a consistent way that
;*                                doesn't break any of the new code.
;*   09/08/88                     Charles Whitmer [chuckwh] Changed to the exact
;*                                mapping algorithm described below.  This fixes
;*                                PTR 5760 which noted that the different mapped
;*                                regions of the RGB cube were not convex.  This
;*                                is a little more complex than the old method,
;*                                and also a little slower.  Before my change,
;*                                the MENU test in FUNTEST took 119 msec.  After
;*                                my change, it takes 121.  On the larger Random
;*                                Dialogs Test, it stayed the same at 672 msec.
;*                                So maybe we lost 2% on smaller stuff.
;*   06/21/89                     Bob Grudem [bobgru] Added the VGA-specific
;*                                code.
;*
;*****************************************************************************/


.286p

        .xlist
        include cmacros.inc
INCL_DDIBUNDLES         equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_DDIMISC            equ     1
INCL_DEV                equ     1
INCL_GRE_DEVMISC1       equ     1
INCL_GRE_FONTS          equ     1
INCL_WINSYS             equ     1
        include pmgre.inc
DINCL_CLR_TBL           equ     1
DINCL_VIO               equ     1

        include driver.inc
        include display.inc
        include fontseg.inc
        .list
        .lall

        ??_out  ColorConversion

        errcode <HUGE_FONTS_NOT_SUPPORTED,INV_PATTERN_ATTR>
        errcode <INV_PATTERN_SET_ATTR,INV_PATTERN_SET_FONT>


        externFP GreEntry3

;/*
;**  Equates which deal with the fixed palette and color mapping.
;**  The bits in the DRV_IPC_ equates are
;** 
;**    Bit 5  ONES_OR_ZEROS (an accelerater bit)
;**        4  MONO_BIT      (an accelerater bit)
;**        3  i  (intensity bit)
;**        2  r  (red bit)
;**        1  g  (green bit)
;**        0  b  (blue bit)
;** 
;**  ipc (internal physical color) is the name used for these throughout
;**  the driver.  Some places ipc is used to refer to the same but without
;**  the accelerator flags (i.e. exactly the bits you would read from the
;**  hardware bitplanes).  To avoid confusion I will start calling these
;**  h/w ipc's (as opposed to "driver ipc's" which have accererator bits).
;** 
;**  Note that the numeric order of DRV_IPC_XX correspondes to what is
;**  programed into the hardware palette, and NOT what is in the default
;**  color table.
;** 
;**  The IPCs_API_RGB_ equates give the corresponding API RGB value for
;**  the DRV_IPC_'s.
;** 
;*/


;/*
;** These have the high nibble cleared out.
;*/
DRV_IPC_00      equ     00000000b       ; black
DRV_IPC_01      equ     00000001b       ; dark blue
DRV_IPC_02      equ     00000010b       ; dark green
DRV_IPC_03      equ     00000011b       ; dark turquoise
DRV_IPC_04      equ     00000100b       ; dark red
DRV_IPC_05      equ     00000101b       ; purple
DRV_IPC_06      equ     00000110b       ; mustard
DRV_IPC_07      equ     00000111b       ; gray
DRV_IPC_08      equ     00001000b       ; light gray
DRV_IPC_09      equ     00001001b       ; blue
DRV_IPC_10      equ     00001010b       ; green
DRV_IPC_11      equ     00001011b       ; turquoise (cyan)
DRV_IPC_12      equ     00001100b       ; red
DRV_IPC_13      equ     00001101b       ; pink (magenta)
DRV_IPC_14      equ     00001110b       ; yellow
DRV_IPC_15      equ     00001111b       ; white


IPCs_API_RGB_00 equ     00000000h       ; black
IPCs_API_RGB_01 equ     00000080h       ; dark blue
IPCs_API_RGB_02 equ     00008000h       ; dark green
IPCs_API_RGB_03 equ     00008080h       ; dark turquoise
IPCs_API_RGB_04 equ     00800000h       ; dark red
IPCs_API_RGB_05 equ     00800080h       ; purple
IPCs_API_RGB_06 equ     00808000h       ; mustard
IPCs_API_RGB_07 equ     00808080h       ; gray
IPCs_API_RGB_08 equ     00CCCCCCh       ; very light gray
IPCs_API_RGB_09 equ     000000FFh       ; blue
IPCs_API_RGB_10 equ     0000FF00h       ; green
IPCs_API_RGB_11 equ     0000FFFFh       ; turquoise (cyan)
IPCs_API_RGB_12 equ     00FF0000h       ; red
IPCs_API_RGB_13 equ     00FF00FFh       ; pink (magenta)
IPCs_API_RGB_14 equ     00FFFF00h       ; yellow
IPCs_API_RGB_15 equ     00FFFFFFh       ; white

DRV_ACCEL_BITS_00      equ     ONES_OR_ZEROS shr 8
DRV_ACCEL_BITS_01      equ     0
DRV_ACCEL_BITS_02      equ     0
DRV_ACCEL_BITS_03      equ     0
DRV_ACCEL_BITS_04      equ     0
DRV_ACCEL_BITS_05      equ     0
DRV_ACCEL_BITS_06      equ     0
DRV_ACCEL_BITS_07      equ     0
DRV_ACCEL_BITS_08      equ     MONO_BIT shr 8
DRV_ACCEL_BITS_09      equ     0
DRV_ACCEL_BITS_10      equ     0
DRV_ACCEL_BITS_11      equ     MONO_BIT shr 8
DRV_ACCEL_BITS_12      equ     0
DRV_ACCEL_BITS_13      equ     MONO_BIT shr 8
DRV_ACCEL_BITS_14      equ     MONO_BIT shr 8
DRV_ACCEL_BITS_15      equ     (ONES_OR_ZEROS or MONO_BIT) shr 8

sBegin  Data

;/*
;** aIPC256toIPC16
;**
;** This is the table for the conversion from 256 to 16
;*/

        public  aIPC256toIPC16
aIPC256toIPC16         label   byte
        db      256 dup (0)


sEnd    Data

sBegin  Bitmap
sEnd    Bitmap

sBegin  Code
        assumes cs,Code

        externW  CodeData

aAccelBits      label   byte
        db      DRV_ACCEL_BITS_00       ; black
        db      DRV_ACCEL_BITS_01       ; dark blue
        db      DRV_ACCEL_BITS_02       ; dark green
        db      DRV_ACCEL_BITS_03       ; dark turquoise
        db      DRV_ACCEL_BITS_04       ; dark red
        db      DRV_ACCEL_BITS_05       ; purple
        db      DRV_ACCEL_BITS_06       ; mustard
        db      DRV_ACCEL_BITS_07       ; gray
        db      DRV_ACCEL_BITS_08       ; light gray
        db      DRV_ACCEL_BITS_09       ; blue
        db      DRV_ACCEL_BITS_10       ; green
        db      DRV_ACCEL_BITS_11       ; turquoise (cyan)
        db      DRV_ACCEL_BITS_12       ; red
        db      DRV_ACCEL_BITS_13       ; pink (magenta)
        db      DRV_ACCEL_BITS_14       ; yellow
        db      DRV_ACCEL_BITS_15       ; white


aIPC16toIPC256 label    byte
        db      0   ;0          ; map [0-7] -> [0-7]
        db      0   ;1
        db      0   ;2
        db      0   ;3
        db      0   ;4
        db      0   ;5
        db      0   ;6
        db      0   ;7
        db      248 ;8          ; map [8-15] -> [248-255]
        db      248 ;9
        db      248 ;10
        db      248 ;11
        db      248 ;12
        db      248 ;13
        db      248 ;14
        db      248 ;15


;/***************************************************************************
;*
;* FUNCTION NAME = rgb_to_ipc_16
;*
;* DESCRIPTION   = rgb_to_ipc accepts a logical RGB color value and returns the
;*                 device dependent, physical representation of bits necessary 
;*                 to display the color closest to the specified color on the  
;*                 device.                                                     
;*
;*                 Registers Preserved: 
;*                       BX,CX,SI,DI,DS,ES  
;*                 Registers Destroyed:     
;*                       DX                 
;*
;* INPUT         = DX:AX  =  RGB color (AL=blue, AH=green, DL=red) 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AL              = physical color index        
;*                 AL:C0           = blue  intensity msb         
;*                 AL:C1           = green intensity msb         
;*                 AL:C2           = red   intensity msb         
;*                 AL:C3           = intensity                   
;*                 AL:MONO_BIT     = 0 if BX < BWThreshold       
;*                                 = 1 if BX >= BWThreshold      
;*                 AL:ONES_OR_ZEROS= 1 if bits are 1111 or 0000  
;*                 Sign bit clear (AX)
;* RETURN-ERROR  = Sign bit set (AX) if error. (Note: No errors are possible in
;*                 this function, so always clear the sign bit -- calling code  
;*
;**************************************************************************/

;/*
;** Exact Mapping Algorithm                                               
;**                                                                       
;** The previous algorithm, which we used to do color mapping, divided    
;** the RGB cube into 729 tiny cubes, and then looked up the result in    
;** a table.  (A very cleverly coded table, I might add.)                 
;** Unfortunately, this means that the regions of the RGB cube that       
;** map to each palette color are not necessarily convex.  This is        
;** bad.  An app can follow a straight line through the RGB cube and      
;** have it go in and out of the same palette color several times!        
;**                                                                       
;** What I do here is map the given color to the nearest palette color,   
;** where nearest is meant in a Euclidean sense.  I.e. I find the         
;** palette color that minimizes (dR)^2 + (dG)^2 + (dB)^2.                
;**                                                                       
;** The result of analyzing the RGB cube this way is that there are 16    
;** regions bounded by several planes.  Since there is a 6-fold           
;** symmetry to this mapping problem, I assume that the color indices     
;** are in a decreasing order.  I.e. I have 3 indices, c1 c2 and c3,      
;** such that:                                                            
;**                                                                       
;**     FF >= c1 >= c2 >= c3 >= 0.                                        
;**                                                                       
;** This restricts us to a tetrahedron with 1/6th the volume of the       
;** cube. There are only 8 palette colors in this tetrahedron as follows: 
;**                                                                       
;**     EGA:                      VGA:                                    
;**     ----                      ----                                    
;**     0:  (00,00,00)            0:  (00,00,00)                          
;**     1:  (20,20,20)            1:  (CC,CC,CC)                          
;**     2:  (80,00,00)            2:  (80,00,00)                          
;**     3:  (FF,00,00)            3:  (FF,00,00)                          
;**     4:  (80,80,00)            4:  (80,80,00)                          
;**     5:  (80,80,80)            5:  (80,80,80)                          
;**     6:  (FF,FF,00)            6:  (FF,FF,00)                          
;**     7:  (FF,FF,FF)            7:  (FF,FF,FF)                          
;**                                                                       
;** Given the ordering restriction there are only 13 relevant             
;** conditions that separate the color regions.  They are:                
;**                                                                       
;** EGA:                                                                  
;** ----                                                                  
;**     c1 +   c2 +   c3 <  30h      (0:1)                                
;**     c1 +   c2 +   c3 <  F0h      (1:5)                                
;**   3 c1 + 3 c2 -   c3 < 1D0h      (1:4)                                
;**   3 c1 -   c2 -   c3 <  D0h      (1:2)                                
;**            c2        <  40h      (2:4)                                
;**     c1               <  C0h      (2:3)                                
;**     c1 -   c2        <  80h      (4:3)                                
;**                   c3 <  40h      (4:5)                                
;**     c1 +   c2        < 180h      (4:6)                                
;**     c1 -   c2 -   c3 <  40h      (5:3)                                
;**     c1 +   c2 -   c3 < 140h      (5:6)                                
;**     c1 +   c2 +   c3 < 240h      (5:7)                                
;**                   c3 <  80h      (6:7)                                
;**                                                                       
;** VGA:                                                                  
;** ----                                                                  
;**     c1               <  40h      (0:2)                                
;**     c1 +   c2 - 4 c3 <  32h      (1:6)                                
;**     c1 +   c2 +   c3 < 2AFh      (1:7)                                
;**     c1               <  C0h      (2:3)                                
;**            c2        <  40h      (2:4)                                
;**            c2        <  80h      (3:6)                                
;**     c1 -   c2        <  80h      (4:3)                                
;**                   c3 <  40h      (4:5)                                
;**     c1 +   c2        < 180h      (4:6)                                
;**     c1 +   c2 +   c3 < 1F2h      (5:1)                                
;**     c1 +   c2 -   c3 < 140h      (5:6)                                
;**     c1 -   c2 -   c3 <  40h      (5:3)                                
;**                   c3 <  80h      (6:7)                                
;**                                                                       
;** I have identified each condition with (n:m).  The given condition     
;** must be true if the color is to be mapped to n.  It must be false     
;** for the color to be mapped to m.  For example, we must have:          
;**                                                                       
;**    (2:4) AND (2:3) AND NOT (1:2)                                      
;**                                                                       
;** if a given color is to be mapped into color 2.                        
;**                                                                       
;** The boundary of EGA region 1 is the most complex.  Things are         
;** simplified if we shrink this region a tiny bit by redefining          
;** (1:2).  Hopefully no one will even notice this.  This change also     
;** makes (1:5) and (1:4) useless. The simplified list of planes is       
;** therefore:                                                            
;**                                                                       
;**     c1           <  40h      (1:2)'                                   
;**     c1           <  C0h      (2:3)                                    
;**          c2      <  40h      (2:4)                                    
;**               c3 <  40h      (4:5)                                    
;**               c3 <  80h      (6:7)                                    
;**     c1 + c2      < 180h      (4:6)                                    
;**     c1 + c2 + c3 <  30h      (0:1)                                    
;**     c1 + c2 + c3 < 240h      (5:7)                                    
;**     c1 + c2 - c3 < 140h      (5:6)                                    
;**     c1 - c2      <  80h      (4:3)                                    
;**     c1 - c2 - c3 <  40h      (5:3)                                    
;**                                                                       
;** To determine the region we are in, we'll perform all 11 tests and     
;** pack the true/false values into a word.  We'll then examine the       
;** word for the requirements for each region.                            
;**                                                                       
;** For the VGA, we'll perform all 13 tests and otherwise act like        
;** the EGA.                                                              
;*/

;/*
;** The following 8 words show which of the 11 conditions must be true
;** for the given color to map into each region.  Note that I have taken
;** the n value from each (n:m) in order.  The bit in the nth word below
;** it is on.
;*/

rgb_true_map    equ     this word
        dw      1000000000000b  ; 0
        dw      0000000010100b  ; 1
        dw      0110000000000b  ; 2
        dw      0001000000000b  ; 3
        dw      0000101000010b  ; 4
        dw      0000000101001b  ; 5
        dw      0000010000000b  ; 6
        dw      0000000000000b  ; 7

;/*
;** The following 8 words show which of the 11 conditions we depend on
;** for the given color to map into each region.  If a bit is on here,
;** it means that we have a requirement for it to be true or false.  If
;** the corresponding bit is on in rgb_true_map, we require the
;** condition to be true.  Otherwise we require it to be false.
;** If the bit is not on in rgb_needed_map, then the given region doesn't
;** care about that test.
;** Note that I have taken the n and m values from each (n:m) in order.
;** The bits in the nth and mth words below them are on.
;*/

rgb_needed_map  equ     this word
        dw      1000000000000b  ; 0
        dw      0000000110100b  ; 1
        dw      1110000000000b  ; 2
        dw      0101000000011b  ; 3
        dw      0010101000010b  ; 4
        dw      0000100101001b  ; 5
        dw      0001011001100b  ; 6
        dw      0000010010000b  ; 7

;/*
;** Once we have decided which of the 8 colors to map to from the sorted      
;** RGB value, we need to unsort the index and pick up the accelerator bits   
;** at the same time.  (There's probably a neat macroized way to do this,     
;** but it seemed just as easy to enter the table manually.)                  
;**                                                                           
;** I start by listing what IRGB value we should return for each of the 8     
;** sorted colors and 6 permutations.  I do it in binary so that its          
;** correctness can be easily checked.                                        
;**                                                                           
;**                                     Permutation Number                    
;**         color      \       0     1     2     3     4     5     6     7    
;**        indices      \     BGR    -    BRG   GRB   GBR   RBG    -    RGB   
;** ------------------------------------------------------------------------- 
;** 0:  (00,00,00)   0000 |  0000b   -   0000b 0000b 0000b 0000b   -   0000b  
;** 1:  (20,20,20)   1000 |  1000b   -   1000b 1000b 1000b 1000b   -   1000b  
;** 2:  (80,00,00)   0100 |  0001b   -   0010b 0010b 0001b 0100b   -   0100b  
;** 3:  (FF,00,00)   1100 |  1001b   -   1010b 1010b 1001b 1100b   -   1100b  
;** 4:  (80,80,00)   0110 |  0011b   -   0011b 0110b 0101b 0101b   -   0110b  
;** 5:  (80,80,80)   0111 |  0111b   -   0111b 0111b 0111b 0111b   -   0111b  
;** 6:  (FF,FF,00)   1110 |  1011b   -   1011b 1110b 1101b 1101b   -   1110b  
;** 7:  (FF,FF,FF)   1111 |  1111b   -   1111b 1111b 1111b 1111b   -   1111b  
;**                                                                           
;** And now the same table in decimal:                                        
;**                                                                           
;** 0:  (00,00,00)   0000 |    00    -     00    00    00    00    -     00   
;** 1:  (20,20,20)   1000 |    08    -     08    08    08    08    -     08   
;** 2:  (80,00,00)   0100 |    01    -     02    02    01    04    -     04   
;** 3:  (FF,00,00)   1100 |    09    -     10    10    09    12    -     12   
;** 4:  (80,80,00)   0110 |    03    -     03    06    05    05    -     06   
;** 5:  (80,80,80)   0111 |    07    -     07    07    07    07    -     07   
;** 6:  (FF,FF,00)   1110 |    11    -     11    14    13    13    -     14   
;** 7:  (FF,FF,FF)   1111 |    15    -     15    15    15    15    -     15   
;*/

;/*
;** And now the real thing with accelerators attached!
;*/

aipcColorAndPerm        equ     this byte
        db      DRV_IPC_00,-1,DRV_IPC_00,DRV_IPC_00,\
                 DRV_IPC_00,DRV_IPC_00,-1,DRV_IPC_00
        db      DRV_IPC_08,-1,DRV_IPC_08,DRV_IPC_08,\
                 DRV_IPC_08,DRV_IPC_08,-1,DRV_IPC_08
        db      DRV_IPC_01,-1,DRV_IPC_02,DRV_IPC_02,\
                 DRV_IPC_01,DRV_IPC_04,-1,DRV_IPC_04
        db      DRV_IPC_09,-1,DRV_IPC_10,DRV_IPC_10,\
                 DRV_IPC_09,DRV_IPC_12,-1,DRV_IPC_12
        db      DRV_IPC_03,-1,DRV_IPC_03,DRV_IPC_06,\
                 DRV_IPC_05,DRV_IPC_05,-1,DRV_IPC_06
        db      DRV_IPC_07,-1,DRV_IPC_07,DRV_IPC_07,\
                 DRV_IPC_07,DRV_IPC_07,-1,DRV_IPC_07
        db      DRV_IPC_11,-1,DRV_IPC_11,DRV_IPC_14,\
                 DRV_IPC_13,DRV_IPC_13,-1,DRV_IPC_14
        db      DRV_IPC_15,-1,DRV_IPC_15,DRV_IPC_15,\
                 DRV_IPC_15,DRV_IPC_15,-1,DRV_IPC_15


        assumes ds,nothing
        assumes es,nothing

cProc   far_rgb_to_ipc_16,<FAR,PUBLIC,NODATA,NONWIN>
cBegin
        call    rgb_to_ipc_16
cEnd

cProc   rgb_to_ipc_16,<NEAR,PUBLIC>,<cx,si,di>
cBegin

;/*
;** Sort the color indices to get c1 >= c2 >= c3.
;** DL = c1, AH = c2, AL = c3.
;*/

        xor     si,si
        cmp     ah,dl                   ; CF on if c2 < c1
        adc     si,si
        cmp     al,ah                   ; CF on if c3 < c2
        adc     si,si
        cmp     al,dl                   ; CF on if c3 < c1
        adc     si,si                   ; SI = permutation number
        mov     bx,si
        add     bx,bx
        add     bx,CodeOFFSET rgb_sort
        jmp     bx
rgb_sort:
        xchg    ah,al                   ; 123 -> 132
        xchg    al,al                   ;   (NOP)
        xchg    dl,al                   ; 132 -> 231
        xchg    ah,al                   ; 231 -> 213
        xchg    dl,al                   ; 213 -> 312
        xchg    ah,al                   ; 312 -> 321  done!
        xchg    al,al                   ;   (NOP)
        .errnz  ($ - rgb_sort) - 14

;/*
;** Calculate the 11 conditions
;*/

        xor     bx,bx
        xchg    bl,ah                   ; AX = c3, BX = c2
        xor     dh,dh                   ; DX = c1
        xor     di,di                   ; DI = condition flags

        cmp     dl,40h                  ; c1 < 40h
        adc     di,di

        cmp     dl,0C0h                 ; c1 < C0h
        adc     di,di

        cmp     bl,40h                  ; c2 < 40h
        adc     di,di

        cmp     bl,80h                  ; c2 < 80h
        adc     di,di

        cmp     al,40h                  ; c3 < 40h
        adc     di,di

        cmp     al,80h
        adc     di,di                   ; c3 < 80h

        mov     cx,dx
        add     cx,bx                   ; CX = c1 + c2
        cmp     cx,180h                 ; c1 + c2 < 180h
        adc     di,di

        add     cx,ax                   ; CX = c1 + c2 + c3
        cmp     cx,1F2h                 ; c1 + c2 + c3 < 1F2h
        adc     di,di

        cmp     cx,2AFh                 ; c1 + c2 + c3 < 2AFh
        adc     di,di

        sub     cx,ax
        sub     cx,ax
        cmp     cx,140h                 ; c1 + c2 - c3 < 140h
        adc     di,di

        sub     cx,ax
        sub     cx,ax
        sub     cx,ax
        add     cx,200h
        cmp     cx,232h                 ; c1 + c2 - 4*c3 < 32h
        adc     di,di

        mov     cx,dx
        sub     cx,bx                   ; CX = c1 - c2
        cmp     cx,80h                  ; c1 - c2 < 80h
        adc     di,di

        sub     cx,ax
        add     cx,100h                 ; CX = c1 - c2 - c3 + 100h, which is > 0
        cmp     cx,140h                 ; c1 - c2 - c3 < 40h
        adc     di,di

;/*
;** Now check the conditions against the requirements for each of the
;** 8 regions.  We first invert all bits which we require to be true,
;** and then make sure that all needed bits are off.
;*/

        mov     bx,-2
rgb_region_loop:
        inc     bx
        inc     bx
        mov     cx,rgb_true_map[bx]     ; turn off the TRUE guys
        xor     cx,di
        and     cx,rgb_needed_map[bx]   ; Check that all TRUEs and FALSEs
        jnz     rgb_region_loop         ;   are really off.

;/*
;** Now turn the color number and permutation into an ipc with accelerators.
;*/

        shl     bx,2
        add     bx,si                   ; BX = 8 * color + permutation
        mov     al,aipcColorAndPerm[bx]
        mov     bl,al
        xor     bh,bh
        mov     ah,aAccelBits[bx]
        or      al,aIPC16toIPC256[bx]
cEnd

sEnd

end
