;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PALETTE.INC
;*
;* DESCRIPTIVE NAME = palette-related declares and macros
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/


;/*
;** fbPal constants (palette flags)
;**
;** PF_DEF_OVERRIDE       1 ==> Default palette has been overridden
;**                       0 ==> Default palette has not been overridden
;*/

PF_DEF_OVERRIDE         equ                      1


;/*
;**  RealizePalette constants (private):
;** 
;**  RP_REALIZE_DEFAULT_PALETTE
;**        The only action to perform on this call is to restore the
;**        default palette to the foreground.
;*/

RP_REALIZE_DEFAULT_PALETTE                       equ 8000h

;/*
;** rgb2_bReserved constants:
;**
;** !!! describe effect on ColorMatch and MatchAPal of RESERVED and EXPLICIT
;**
;** Flags exported to API:
;**     PC_RESERVED   Indicates an animating index.
;**
;**     PC_EXPLICIT   Don't insert the rgb into the hardware palette. Instead,
;**                   take it as the index to use, and just take whatever color
;**                   is in that slot.
;**
;** Flags not exported to API:
;**     PC_NEW        This palette color was just changed, so it should be
;**                   reported as a mapping change whether or not its
;**                   bPrev value is the same as its newly matched bCur value.
;**
;**     PC_DEFAULT    The palette slot is soft-reserved for the default back-
;**                   ground palette.  The only way to override this is with
;**                   the LCOL_OVERRIDE_SYSCLRS option in GpiCreatePalette.
;**
;**     PC_FOREGROUND The palette slot is used by the foreground palette,
;**                   or (hack) by a background palette that needed two
;**                   passes to get a match.
;**
;*/

PC_NEW          equ     20h
PC_DEFAULT      equ     40h
PC_FOREGROUND   equ     80h

;/*
;** palseg_fs constants:
;**
;** PR_REALIZED   This palette has been realized in the foreground.  If
;**               this flag is set, the palette can be rerealized in the
;**               foreground by restoring the palseg_abFore indices.
;**
;** PR_REREALIZE  Will be set for any palette which has changed since the
;**               last realization
;**
;** PR_OVERRIDE_DEFAULTS
;**               This palette can override the reserved default colors when
;**               it comes to the foreground.  It will only take these colors
;**               if needed.
;**
;** PR_BCUR_VALID
;**               Set if the palclr_bCur values of a devpal are valid.
;**
;** PR_BPREV_VALID
;**               Set if the palclr_bPrev values of a devpal are valid.
;*/

;/*
;**                     equ                      0000000000000001b
;**                     equ                      0000000000000010b
PR_PURECOLOR            equ                      0000000000000100b
PR_OVERRIDE_DEFAULTS    equ                      0000000000001000b
;**                     equ                      0000000000010000b
;**                     equ                      0000000000100000b
;**                     equ                      0000000001000000b
;**                     equ                      0000000010000000b
;**                     equ                      0000000100000000b
;**                     equ                      0000001000000000b
;**                     equ                      0000010000000000b
;**                     equ                      0000100000000000b
PR_BCUR_VALID           equ                      0001000000000000b
PR_BFORE_VALID          equ                      0010000000000000b
PR_BPREV_VALID          equ                      0100000000000000b
PR_REREALIZE            equ                      1000000000000000b


.errnz  PR_PURECOLOR - LCOL_PURECOLOR
.errnz  PR_OVERRIDE_DEFAULTS - LCOL_OVERRIDE_DEFAULT_COLORS

;/*
;** MatchAPal constants:
;**
;** FB_FORE       Realize as foreground. This palette used to be foreground
;**                 so restore its colors to their former foreground slots.
;** FB_NEW        Realize as foreground. This palette has never been in
;**                 foreground before.
;** FB_OVERRIDE   Allow the palette to overwrite the default colors.
;*/

FB_FORE         equ     00000001b
FB_NEW          equ     00000010b
FB_OVERRIDE     equ     00000100b


;/*
;** Miscellaneous constants
;*/


SIZE_HW_PAL             equ                      256
NUM_RESERVED_CLRS       equ                       16

PAL_IDENTIFIER          equ                      'pd'
PAL_TYPE                equ                      'hp'
FREE_HDEVPAL            equ                      -1


;/*
;** Device palette handle
;*/

DEVPAL STRUC
devpal_ident            dw                       ?
devpal_next             dw                       ?
devpal_pPalSeg          dd                       ?
devpal_cUsage           dw                       ?
devpal_idRealization    dw                       ?
DEVPAL ENDS


;/*
;** *plColorData element when format is LCOLF_INDRGB
;*/


INDRGB STRUC
indrgb_ulIndex  dd      ?
indrgb_rgb      db      SIZE RGB2 dup (?)
INDRGB ENDS


;/*
;** Palette color.  Element of palseg_apalclr.
;*/


PALCLR STRUC
palclr_rgb              dd                       ?
palclr_bCur             db                       ?
palclr_bFore            db                       ?
palclr_bPrev            db                       ?
palclr_bReserved        db                       ?
PALCLR ENDS
.errnz  (size PALCLR) - 8

;/*
;**  Palette data segment.  The array palseg_apalclr is variable in size,
;**  so it's not strictly part of this structure.
;*/


PALSEG STRUC
palseg_fs               dw                       ?
palseg_usMax            dw                       ?
palseg_cb               dw                       ?
PALSEG ENDS
palseg_apalclr          equ                      SIZE PALSEG


;/*
;**  flags for MatchTwoPalettes
;*/


;MTP_6_BITS      equ     00000001b                ;only use hi 6 bits of component
;MTP_HWPAL       equ     00000010b                ;match against hwpal
MTP_LIMIT_SIZE   equ     00000100b                ;limit source size to SIZE_HW_PAL


;/*
;** fbPalMap / MakePaletteMappingValid flags
;**
;** These flags can be or'd together to produce an index into apfnPalMappers.
;*/

MPMV_SRC_DEF            equ                      00000001b ;source palette is default
MPMV_SRC_DEV            equ                      00000010b ;source is device
MPMV_DST_DEF            equ                      00000100b ;dest palette is default
MPMV_DST_DEV            equ                      00001000b ;destination is device
MPMV_SRC_DST_IDENTICAL  equ                      00010000b ;source and dest palettes same
MPMV_SRC_HBM            equ                      00100000b ;source is hbitmap not hddc
;                       equ                      01000000b ;unused
MPMV_INVALID            equ                      10000000b ;pal mapping cache is invalid

;/***************************************************************************
;*
;* FUNCTION NAME = devpal?
;*
;* DESCRIPTION   = Macro to validate some basic properties of an hdevpal. 
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

devpal? macro   hdevpal,size
ifdef   FIREWALLS
  ifb   <size>
        cCall   validate_hdevpal,<hdevpal>
  else
        cCall   validate_hdevpal,<PAL_TYPE, hdevpal>
  endif
endif
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = palinfo?
;*
;* DESCRIPTION   = 
;*
;*    Macro to validate palette parameters in the form of the palinfo
;*    structure.  This just unpacks them and passes them to a common
;*    subroutine.  This also is only used by DeviceCreatePalette, which
;*    requires validation of the flCmd parameter, so it passes this fact, too.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ifdef   FIREWALLS
vpp_DeviceCreatePalette equ                      1
endif

palinfo? macro  ppalinfo
local   call_the_big_one
local   nothing_more_to_do
ifdef   FIREWALLS

        push    ds
        push    si
        push    ax

        mov     ax,ppalinfo.hi
        or      ax,ax
        jnz     call_the_big_one
        rip     text,<Invalid ppalinfo>
        jmp     short nothing_more_to_do
call_the_big_one:
        lds     si,ppalinfo
        assumes ds,nothing

;/*
;** I know this is ugly, but when I use farPtr's and Arg's, I get a stack
;** overflow in MASM (bobgru).
;*/

        push    vpp_DeviceCreatePalette
        push    [si].palinfo_flCmd.hi
        push    [si].palinfo_flCmd.lo
        push    [si].palinfo_ulFormat.hi
        push    [si].palinfo_ulFormat.lo
        push    0
        push    0
        push    [si].palinfo_cclr.hi
        push    [si].palinfo_cclr.lo

        lea     ax,[si].palinfo_argb.lo
        push    ds
        push    ax

        cCall   validate_pal_params
nothing_more_to_do:
        pop     ax
        pop     si
        pop     ds
        assumes ds,nothing
endif
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = palprm?
;*
;* DESCRIPTION   = 
;*
;*    Macro to validate palette parameters when they are explicitly passed.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


palprm? macro   ulFormat,lStart,clColorData,plColorData
ifdef   FIREWALLS

        farPtr  myNull,ax,ax

        push    ax
        xor     ax,ax
        cCall   validate_pal_params,<0,myNull,ulFormat,lStart,clColorData,plColorData>
        pop     ax
endif
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = palOff
;*
;* DESCRIPTION   = 
;*
;*    Macro to create an offset into palseg_apalclr from a palette index.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

palOff  macro   reg
        shl     reg,3
        .errnz  (size PALCLR) - 8
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = palInd
;*
;* DESCRIPTION   = 
;*
;*    Macro to create a palette index from an offset into palseg_apalclr. 
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

palInd  macro   reg
        shr     reg,3
        .errnz  (size PALCLR) - 8
        endm


;/***************************************************************************
;*
;* FUNCTION NAME = rgbOff
;*
;* DESCRIPTION   = 
;*
;*    Macro to create an offset into argbHW from an index. 
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


rgbOff  macro   reg
        shl     reg,2
        .errnz  (size RGB2) - 4
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = rgbInd
;*
;* DESCRIPTION   = 
;*
;*    Macro to create an index from an offset into argbHW. 
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

rgbInd  macro   reg
        shr     reg,2
        .errnz  (size RGB2) - 4
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = palSize
;*
;* DESCRIPTION   = 
;*
;*    Macro to compute palette size, truncate it to limit, and put in reg. 
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

palSize macro   reg,seg,off,limit
        local   palsize_ok
        mov     reg,seg:[off].palseg_usMax
        inc     reg
  ifnb <limit>
        cmp     reg,limit
        jb      palsize_ok
        mov     reg,limit
palsize_ok:
  endif
        endm

;/***************************************************************************
;*
;* FUNCTION NAME = index?
;*
;* DESCRIPTION   = Macro to validate a palette index. 
;*
;* INPUT         = EAX = index to validate                      
;*                 palseg:paloff -> palette to check against
;*                 max_pel = maximum pel size allowed for index
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

index?  macro   inv_index, palseg, paloff, max_pel
        local   valid_index

        ror     eax,16
        or      ax,ax
        jnz     inv_index
        ror     eax,16
        cmp     ax,palseg:[paloff].palseg_usMax
        ja      inv_index

        cmp     ax,max_pel
        jbe     short valid_index

        farPtr  index_pPal,palseg,paloff
        cCall   MapDownPaletteIndex,<ax,index_pPal,max_pel>

valid_index:
        endm
