;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*****************************************************************************
;*
;* SOURCE FILE NAME = DISPLAY.INC
;*
;* DESCRIPTIVE NAME = OEM defined objects definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/16/87
;*
;* DESCRIPTION  This file contains definitions of OEM defined objects used by
;*              the driver.
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/16/87                     Geoff Shapiro [geoffs] 
;*****************************************************************************/


;/*
;**     The color structure is how this driver stores its physical
;**     colors in memory.  The color consists of two bytes, a
;**     byte which is a combination of one bit from each plane, plus
;**     other special information, and a second byte which indicates
;**     whether or not the color information is valid.
;**
;**     IPC = Internal Physical Color
;*/

IPC             struc
ipc_bClr        db      ?                         ;color information
ipc_bStatus     db      ?                         ;validity status of ipc_bClr
IPC             ends

;/*
;**     Definitions for the ipc_bClr byte of the physical color
;**
;**     Some of these definitions have limitations as to when they
;**     are valid.  They are as follows:
;**
;**     C0_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C1_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C2_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C3_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C4_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C5_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C6_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     C7_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**     MONO_BIT        mono  device, phys color
;**     ONES_OR_ZEROS   color device, phys color, solid brushes if SOLID_COLOR
;*/

C0_BIT          Equ     00000001b                ;  C0 color
C1_BIT          Equ     00000010b                ;  C1 color
C2_BIT          Equ     00000100b                ;  C2 color
C3_BIT          Equ     00001000b                ;  C3 color
C4_BIT          Equ     00010000b                ;  C4 color
C5_BIT          Equ     00100000b                ;  C5 color
C6_BIT          Equ     01000000b                ;  C6 color
C7_BIT          Equ     10000000b                ;  C7 color
MM_ALL          Equ     C0_BIT+C1_BIT+C2_BIT+C3_BIT+C4_BIT+C5_BIT+C6_BIT+C7_BIT
MONO_BIT        Equ     0000000100000000b;  Monochrome bit
ONES_OR_ZEROS   Equ     0000001000000000b;  Color is really all 1's or all 0's
;**             Equ     0100000000000000b
;**             Equ     1000000000000000b

        errnz   <(size IPC) - 2>                 ;Must be a word


LO_THRESHOLD    equ     040h                      ; rgb threshold for low intensity
HI_THRESHOLD    equ     080h                      ; rgb threshold for high intensity
I_THRESHOLD     equ     080h                      ; intensity threshold


;/*
;**       IPB = Internal Physical Brush
;*/

IPB             struc
ipb_abPlane0    db      SIZE_PATTERN dup (?)
ipb_abPlane1    db      SIZE_PATTERN dup (?)
ipb_abPlane2    db      SIZE_PATTERN dup (?)
ipb_abPlane3    db      SIZE_PATTERN dup (?)
IPB             ends


;/*
;**     Height and width in pels of one color plane of physical brush.
;*/

PATTERN_WIDTH   equ     8
PATTERN_HEIGHT  equ     8

;/*
;**     single pass flag
;*/

SINGLE_OK       equ     1

;/*
;**    Number of True Greys in the hardware palette
;*/

cGreys          equ     32

;/*
;** new constants used by 8514 color realization modifications
;*/


;/*
;**       palette type flags
;*/

DEFAULT_PALETTE         equ     0
REALIZED_PALETTE        equ     1
