;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = CellBlt.inc
;*
;* DESCRIPTIVE NAME = 
;*
;*
;* VERSION      V2.0
;*
;* DATE         06/26/87
;*
;* DESCRIPTION  This module contains the definition of the frame created by 
;*              CharRect and used by a variety of subfunctions.  It also    
;*              includes anything else common to the separate *.asm files   
;*              which constitute the CharRect function(s).                  
;*
;* FUNCTIONS    public: name
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   06/26/87                     Author:   ronm   
;*                                ronm -ld CellBlt.asm file.
;*                                ronm Generated from the old CellBlt.asm
;*                                file.
;*   07/18/87                     ronm Adjusted to match the new dispatching
;*                                interface.
;*   10/13/87                     ronm Abs => AbsVal to avoid reserved word                        
;*                                conflict with Masm 5.0
;*****************************************************************************/


;/*
;**  VIO_FONT_ENTRIES is the format of the individual character records in
;**  a fixed or proportional font.
;*/

VIO_FONT_ENTRIES    struc
fe_dBits        dd      ?
fe_width        dw      ?
VIO_FONT_ENTRIES    ends

;/***************************************************************************
;*
;* FUNCTION NAME = define_CharRect_frame
;*
;* DESCRIPTION   = Macro for defining the frame for CharRect functions
;*                 This file allows the frame definiton to be shared by all
;*                 the modules which make up the CharRect function.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


define_CharRect_frame macro  name

cProc   name,<FAR,PUBLIC,NODATA>,<si,di,ds,es>

        parmD   hdc                     ; Handle for our DC.
        parmD   lpPS                    ; Address of the Vio PS.
        parmD   lpRectDesc              ; Desc. for the rectangle to draw.
        parmD   hddc                    ; Handle for our Device Display Context
        parmD   FunN                    ; Index for the desired driver
                                        ; function (presumably CharRect).


;/*
;** Logical Video Buffer Information: ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

        localW  wRowCount               ; Dimensions of the logical
        localW  wColCount               ; video buffer.

        localW  wCellSize               ; Bytes per character cell in
                                        ; the logical video buffer.

        localW  wLVBRowBytes            ; Number of bytes per LVB row.


;/*
;** Destination Bitmap Information:  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

        localD  lpBitmapBits            ; Long pointer to the destination
                                        ; bit rectangle.
        localW  wDestWidth              ; Width and height of the
        localW  wDestHeight             ; destination bitmap.
        localW  wDestBMWidth            ; Width of the destination
                                        ; bit array in bytes.


;/*
;** Symbol Set Information ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

        localV  wSymbolSetSelectors,8   ; Selectors and offsets for the
        localV  wSymbolSetOffsets,8     ; symbol sets used herein.


;/*
;** Temporary Variables for DrawImageRect and friends ;;;;;;;;;;;;;;;;;;;;;
;*/


        localB  bHorizontalClipMask     ; Clip mask for the current column.
        localW  wUnderscoreMask         ; Word mask used to implement the
                                        ; underscore AVio attribute.

        localW  wCellHeight             ; Height in pixels of a cell image.
        localW  wCellWidth              ; Width  in pixels of a cell image.

bCellHeight EQU BYTE PTR (wCellHeight)  ; No cell is taller than 255 pixels!
bCellWidth  EQU BYTE PTR (wCellWidth )  ; No cell is wider  than 255 pixels!

        localW  wLastAttributes         ; Holds the previous word of AVio
                                        ; attribute information.

        localW  wVertLineOffset         ; Pixel coordinates of the
        localW  wHorzPixelOffset        ; screen bitmap relative to
                                        ; the conceptual LVB image.

        localW  wDestColOffset          ; Column offset corresponding to
                                        ; wHorzPixelOffset.  We presume
                                        ; strongly that columns are 8 pixels
                                        ; wide and aligned on byte boundaries.

        localW  wTopRow                 ; These four variables define the
        localW  wBotRow                 ; bounds of the LVB cells which
        localW  wLeftCol                ; are to be drawn, and which don't
        localW  wRightCol               ; need to be clipped.

        localW  wTopFullLine            ; Topmost horizontal line of the LVB
                                        ; image corresponding to a cell image
                                        ; which is not vertically clipped.

        localW  wBotFullLine            ; Image line which bounds the bottom
                                        ; of the full cell region.

        localW  wLeftFullLine           ; Leftmost line vertical line for a
                                        ; cell image which is not horizontally
                                        ; clipped.

        localW  wRightFullLine          ; Image line which bounds the right
                                        ; side of the full cell region.

        localW  wTopLines               ; The height of the top border region.

        localW  wBotLines               ; The height of the bottom border
                                        ; region.

        localW  wLeftLines              ; The width of the left border region.

        localW  wRightLines             ; The width of the right border region.

        localW  wCellSizeShift          ; A shift factor for simulating
                                        ; multiplications by the size of
                                        ; an LVB cell in bytes.

        localW  seg_LVB                 ; Selector for the LVB.  Offset == 0!

        localW  pFirstFullLVBCell       ; Offset to the first LVB cell in
                                        ; row major order whose cell image
                                        ; is to be drawn without clipping.

        localW  pLastFullLVBCell        ; Offset to the last word of the
                                        ; the last LVB cell (in row major order)
                                        ; to be drawn without clipping.

        localW  pFirstLVBCell           ; These two variables parallel
        localW  pLastLVBCell            ; pFirstFullLVBCell and
                                        ; pLastFullLVBCell.  They're
                                        ; used as arguments to the routines
                                        ; ScanVerticalBorder and
                                        ; ScanHorizontalBorder.


        localW  pReturnAddress          ; The location in the pseudo code
                                        ; of the return address to be used
                                        ; InterpretAttributes.

;/*
;** The following increments are set up and used by CellDraw.asm.
;*/

        localW  wDest1stIncr            ; Destination increment for moving
                                        ; from one scan line to the next for
                                        ; a single cell image.

        localW  wDest2ndIncr            ; Destination increment for moving
                                        ; from just below one cell image
                                        ; to the top scan line of the next
                                        ; cell image.

        localW  wDest3rdIncr            ; Destination increment for moving
                                        ; from just beyond the end of one
                                        ; cell image row to the beginning
                                        ; of the next row (within a column
                                        ; set).  The number of columns in
                                        ; the set is given by wFullCols.

        localW  wFullRows               ; The number of rows of LVB cells
                                        ; in the unclipped central region.
                                        ; This value will be negative when
                                        ; the image consists of a single
                                        ; horizontal row image which must
                                        ; be clipped vertically.

        localW  wFullCols               ; The number of columns of LVB
                                        ; cells in the unclipped central
                                        ; region.  This value will be
                                        ; negative when the image consists
                                        ; of a single vertical column
                                        ; image which must be clipped
                                        ; horizontally.

        localDP pStackLimit             ; SP limit used to determine when
                                        ; the scan must be partitioned.

        localW  wTopLineOffset          ; Vertical offset within a cell
                                        ; image of the first horizontal
                                        ; line to draw.

        localW  wScanLineCount          ; Number of horizontal lines to
                                        ; draw for the current cell set.

        localW  wLeftLineOffset         ; Horizontal offset within a cell
                                        ; of the first vertical line to draw.

        localW  wVertLineCount          ; Number of vertical lines to draw
                                        ; for the current cell set.

    bScanLines  EQU BYTE PTR (wScanLineCount)
                                        ; No cell is taller than 255 pixels!

        localW  npcpmap                 ; DGroup offset for the current
                                        ; code page mapping vector.

        localW  xcoordTopLeft           ; Destination coordinates for the
        localW  ycoordTopLeft           ; top left corner of the drawing
                                        ; rectangle.

        localW  xcoordStart             ; Starting destination coordinates
        localW  ycoordStart             ; for a drawing pass.

        localW  fSomethingDrawn         ; True if something was drawn during
                                        ; a call to CharRectangle
;/*
;**  The following frame variables characterize the currently active font.
;**  See CellDraw.asm for details.
;*/

        localW  selFont                 ; Selector for the font segment.
        localW  wFirstGlyph             ; Lowest defined glyph index.
        localW  wGlyphSpan              ; Number of glyphs in the font.
        localW  wDefaultGlyph           ; Glyph index to substitute for
                                        ; undefined glyphs.

        localDP npinxGlyph              ; Used to reference pseudo code
                                        ; when we're out of registers.



;/*
;** Temporary Variables for the Scanning Functions... ;;;;;;;;;;;;;;;;;;;;;
;*/


        localW  wSaveCounts             ; For preserving row/col counts.
        localCP npNextCellLabel         ; Code pointer for the scan loop
                                        ; to use next.


;/*
;** Temporary Variables for DrawFullCells... ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

        localW  wLVBRowInc
        localDP pCell


        localW  wfForceColors
        localW  wselfontsave
        localW  wVertLVBIncr

        localW  OpaqueColorSave         ; local storage for the opaque colors
                                        ; for EGAMono


;/*
;** Variables for enumerating the clip rectangles ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

        localV  drBounds,<size RECTL>       ; Screen pixel bounds for the
                                            ; image rectangle denoted by
                                            ; *lpRectDesc.  Note the use
                                            ; of double word fields and
                                            ; bottom-left origin.

        localV  rClipRect,<SIZE RECTS>      ; The clip rect for each
                                            ; iteration of DrawImageRect.


;/*
;** Text cursor exclusion ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

        localW  fExcluding


        localW  fDontDraw               ; == 1 => doesn't drawn anything,
                                        ;         but may do bounds calc.

        localW  wHeightGapHW

        endm


define_Invert_Cursor_Frame  macro   name

cProc   name,<PUBLIC,NEAR>,<bx,cx,dx,si,di,ds,es>

        parmD   hdc
        parmW   pDDC
        parmW   afFunN
        parmD   lpBitmapBits
        parmW   wDestHeight
        parmW   wDestBMWidth
        parmW   wXCoord
        parmW   wYCoord
        parmW   wHeight
        parmW   wWidth

        localW  fSomethingDrawn
        localV  drBounds,<size RECTL>

        endm



Use286Code      = 1                     ; The processor we assume for
Use8086Code     = 0                     ; generating code.  The selected
                                        ; processor option should be 1.
                                        ; All others should equal 0.

IF  Use286Code

        .286c                           ; Tell Masm that non-privileged
                                        ; 286 instructions are ok.

ENDIF

;/*
;** Variables for the DrawImageRect routine saved at top of ring 2 stack
;*/

cb_variables segment at 0
cb_BPSaveSlot       dw      ?               ;# of scans to output
cb_Default_Glyph    dw      ?               ;Delta to next scan of a bitmap
cb_Dest_3rd_Incr    dw      ?               ;Function to do output
cb_variables_len = $-cb_BPSaveSlot
cb_variables ends

        externFP far_exclude                ; Exclude area from screen
        externFP far_unexclude              ; Restore area excluded from screen
        externFP MoveCursor                 ; Redraw the mouse cursor

        externFP far_enter_driver           ; For setting up the correct
        externFP far_leave_driver           ; instance data segment.

        externFP far_enumerate_clip_rects

        externFP InnerGREEntry              ; Dispatcher for Engine calls

StackFirewall       EQU     128         ; How much stack space to keep
                                        ; for interrupt routines.

StackCallOverhead   EQU     4           ; Stack space for two near
                                        ; return addresses.



;/*
;**;;;;;;;;;;; Macros for 286/8086 Dependant Code ;;;;;;;;;;;;;;;;;;;;;;;
;*/



ShiftLeft   MACRO   Dest,Count

IF  Use8086Code

        REPT    Count
        shl     Dest,1
        ENDM

ENDIF

IF  Use286Code
        shl     Dest,Count
ENDIF

            ENDM



ShiftRight  MACRO   Dest,Count

IF  Use8086Code

        REPT    Count
        shr     Dest,1
        ENDM

ENDIF

IF  Use286Code
        shr     Dest,Count
ENDIF

            ENDM



AShiftRight MACRO   Dest,Count

IF  Use8086Code

        REPT    Count
        sar     Dest,1
        ENDM

ENDIF

IF  Use286Code
        sar     Dest,Count
ENDIF

            ENDM


PushCon MACRO   Reg,Constant

IF  Use8086Code
        mov     Reg,Constant
        push    Reg
ENDIF

IF  Use286Code
        push    Constant
ENDIF

        ENDM


PushRet MACRO   Reg,Addr

IF  Use8086Code

        mov     Reg,VioSegOFFSET Addr
        push    Reg

ENDIF

IF  Use286Code

        push    VioSegOFFSET Addr

ENDIF

        stc
        sbb     Reg,Reg
        push    Reg

        ENDM



;/*
;**::::::::::: Branchless Numeric Comparisons ;;;;;;;;;;;;;;;;;;;;;;;;;;;
;**
;** 
;**  The following Macros compute several numeric functions which are
;**  traditionally accomplished by code that includes a comparison and
;**  a conditional jump.  Conditional jumps have the unfortunate property
;**  of flushing the prefetch queue.  These code sequences don't flush the
;**  prefetch queue and may be faster than code with conditional jumps.
;** 
 ** 
;**  The macros USMin and USMax compute, respectively, the minimum and
;**  maximum of two unsigned values.  The input values are given by the
;**  registers leftReg and rightReg.  One additional work register (workReg)
;**  is required.  The result value is left in leftReg.
;*/

USMin   MACRO   leftReg,rightReg,workReg

        sub     rightReg,leftReg
        sbb     workReg,workReg
        and     rightReg,workReg
        add     leftReg,rightReg

        ENDM

USMax   MACRO   leftReg,rightReg,workReg

        sub     rightReg,leftReg
        cmc
        sbb     workReg,workReg
        and     rightReg,workReg
        add     leftReg,rightReg

        ENDM


;/*
;** The macros SMin and SMax compute the minimum and maximum value of
;** two signed numbers.  One number must be in AX.  The other is in
;** register Reg.  The result will be in Reg.  In the process DX will
;** be trashed.
;*/


SMin    MACRO   Reg

        sub     ax,Reg
        cwd
        and     ax,dx
        add     Reg,ax

        ENDM

SMax    MACRO   Reg

        sub     ax,Reg
        cwd
        not     dx
        and     ax,dx
        add     Reg,ax

        ENDM

;/*
;** The AbsVal macro takes the absolute value of the signed number in AX.
;** DX is trashed in the process.
;*/

AbsVal  MACRO

        cwd
        xor     ax,dx
        sub     ax,dx

        ENDM



;/*
;**;;;;;;;;;;;;;;;; Attribute Field Definitions ;;;;;;;;;;;;;;;;;;;;;;;
;*/

;/*
;**  These definitions are used internally to maintain attribute
;**  information extracted from Logical Video Buffer cells.
;** 
;**  Vio/AVio attribute words:
;** 
;**  High Byte --  Byte & 0F0h is the background color.
;**                Byte & 00Fh is the foreground color.
;** 
;**  Low Byte  --  Byte & 080h == 1 when Underscoring.
;**                Byte & 040h == 1 for Reverse Video.
;**                Byte & 010h == 1 for Transparent cells.
;**                Byte & 003h gives the symbol set index to use.
;*/



AVioColorSetMask        EQU   0FF00h

AVioUnderscoreMask      EQU     080h
AVioReverseVideoMask    EQU     040h
AVioTransparentMask     EQU     010h
AVioLCIDMask            EQU     003h

AVioDefinedBits         EQU     0D3h

;/*
;** When a cell refers to an LCID that's not loaded, we draw it
;** as a blank in the default font (LCID 0).  SURROGATE_CHARACTER
;** is the assumed glyph index for blank.
;*/

SURROGATE_CHARACTER     EQU     20h


;/*
;**;;;;;;;;;;;;;;;; Cell & Symbol Set Macros ;;;;;;;;;;;;;;;;;;;;;;;;;;
;*/

;/*
;**  The macros PixToCol, ColToPix, and PixModCol below are used to
;**  transform between pixel column coordinates and character cell
;**  column coordinates.  The code they contain is trivial.  They
;**  are defined to make the remaining code less dependant on the
;**  exact width of the character cells supported.
;*/

ColToPix        MACRO   reg             ; Start of macro

                IFDIFI  <reg>,<ax>      ; Is register ax ?
                xchg    ax,reg          ; No, so swap ax with reg
                ENDIF                   ; End of IFDIFI

                mul     BYTE PTR wCellWidth ; Multiply ax by char width

                IFDIFI  <reg>,<ax>      ; Is register ax ?
                xchg    ax,reg          ; Swap registers back
                ENDIF                   ; End of IFDIFI

                ENDM                    ; End of macro



PixToCol        MACRO   reg             ; Start of macro

                IFDIFI  <reg>,<ax>      ; Is register ax ?
                xchg    ax,reg          ; copy the register into it
                ENDIF                   ; End of IFDIFI

                cwd
                idiv    wCellWidth      ; Divide ax by char width

                IFDIFI  <reg>,<ax>      ; Is register ax ?
                xchg    ax,reg          ; No, so copy back result and...
                ENDIF                   ; End of IFDIFI

                ENDM                    ; End of macro

;/*
;** MaxSymbolLines defines the tallest image cell which can be drawn.
;*/

MaxSymbolLines      EQU     32                                             ;@D2A
HW_BLT              EQU     1           ; Screen-to-screen copy for faster vio scroll


