;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = POINTER.INC
;*
;* DESCRIPTIVE NAME = Definitions relating to the pointer shape.
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/29/88
;*
;* DESCRIPTION  Constants are defined for the pointer drawing routine describing 
;*              the size of the poinetr shape.  Some of these constants are also 
;*              required for memory allocation in EGA/VGA VRAM.                  
;*              
;*              Public Data:          PTR_ROUND_LEFT
;*                                    PTR_ROUND_RIGHT
;*                                    PTR_WIDTH_BITS
;*                                    PTR_HEIGHT
;*                                    MASKS_WIDTH_BITS
;*              
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        Public  PTR_HEIGHT
        Public  PTR_WIDTH_BITS
        Public  MASKS_WIDTH_BITS

;/*
;**  The following values relate to the  pointer drawing code.
;*/

;/*
;**  Change following two equates to get different pointer size
;**  ie: 64 wide cursors should be 64 and 8 respectively.
;**  ie: 32 wide cursors should be 32 and 4 respectively.
;*/

PTR_HEIGHT      Equ     32                         ;Height of pointer
PTR_WIDTH_BYTES Equ     4                          ;Width in bytes of pointer

PTR_WIDTH_BITS  Equ     (PTR_WIDTH_BYTES*8)      ;Width in bits of pointer
MASKS_WIDTH_BITS Equ    (PTR_WIDTH_BITS*2)       ; Width of mask area in pixels


;/*
;**  The following values allow us to set rounding for cursor exclusion.
;**  These values are applied as an AND mask (for rounding left) and as
;**  an OR mask (for rounding right).
;*/

;/*
;**  8514/A hardware does not need rounding for cursor exclusion. (It could be
;**  argued that the cursor blting would be a bit more efficient if we did do
;**  rounding, but the difference on the 8514/A is expected to be too small to
;**  bother with the rounding).
;*/

        Public  PTR_ROUND_LEFT
        Public  PTR_ROUND_RIGHT

PTR_ROUND_LEFT  equ     0ffffh
PTR_ROUND_RIGHT equ     0
