;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PALSUP.ASM
;*
;* DESCRIPTIVE NAME = Initial data and initialization code for palettes. 
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/16/89
;*
;* DESCRIPTION  
;*
;* FUNCTIONS    Public:               InitDefaultPalette  
;*                                    OEMUpdateColors
;*
;*              Public Data:          devpalDefault
;*                                    abDefPalMap_16_256
;*                                    hwpalData
;*                                    argbHW
;*                                    phwpal
;*                                    palsegDefPal
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/16/89                     Author:  Bob Grudem [bobgru]
;*****************************************************************************/

        .xlist
        include cmacros.inc
        include assert.mac
INCL_GRE_PALETTE        equ     1
INCL_GPIBITMAPS         equ     1       ;for RGB2 defintion
INCL_DDIBUNDLES         equ     1
INCL_GPILOGCOLORTABLE   equ     1
        include pmgre.inc
DINCL_CLR_TBL           equ     1       ;for DEFAULT_COLOR_TABLE_SIZE
        include driver.inc
        include display.inc
        Include 8514.inc
        include njmp.mac
        include palette.inc
        .list

        externFP    far_exclude         ; CURSORSC.ASM
        externFP    far_unexclude       ; CURSORSC.ASM
        externFP    far_rgb_to_ipc_16   ; PHY16CLR.ASM

sBegin  Data

        externB ddcInit                 ; Initial ddc
        externB aIPC256toIPC16          ; convertsion table from ipc256 to ipc16

;/*
;** devpalDefault
;*/

        public  devpalDefault
devpalDefault   DEVPAL  <PAL_IDENTIFIER,0,0,0>

;/*
;** abDefPalMap_16_256  et all
;**
;** Maps the default palette into the hardware palette,
;** i.e. the realization table.  It's compacted here for convenience.
;** A firewall at initialization compares this array with the values
;** in palsegDefPal.
;*/

        public  abDefPalMap_16_256
abDefPalMap_16_256      label   byte
        db        0,    1,    2,    3,    4,    5,    6,    7
        db      0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

        public  abDefPalMap_32_256
abDefPalMap_32_256      label   byte
        db        0,    1,    2,    3,    4,    5,    6,    7
        db        8,    9,   0Ah,  0Bh,  0Ch,  0Dh,  0Eh,  0Fh
        db      0F0h, 0F1h, 0F2h, 0F3h, 0F4h, 0F5h, 0F6h, 0F7h
        db      0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

        public  abDefPalMap_64_256
abDefPalMap_64_256      label   byte
        db        0,    1,    2,    3,    4,    5,    6,    7
        db        8,    9,   0Ah,  0Bh,  0Ch,  0Dh,  0Eh,  0Fh
        db      010h, 010h, 010h, 010h, 010h, 010h, 010h, 010h
        db      018h, 019h, 01Ah, 01Bh, 01Ch, 01Dh, 01Eh, 01Fh
        db      0E0h, 0E1h, 0E2h, 0E3h, 0E4h, 0E5h, 0E6h, 0E7h
        db      0E8h, 0E9h, 0EAh, 0EBh, 0ECh, 0EDh, 0EEh, 0EFh
        db      0F0h, 0F1h, 0F2h, 0F3h, 0F4h, 0F5h, 0F6h, 0F7h
        db      0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

        public  abDefPalMap_128_256
abDefPalMap_128_256     label   byte
        db        0,    1,    2,    3,    4,    5,    6,    7
        db        8,    9,   0Ah,  0Bh,  0Ch,  0Dh,  0Eh,  0Fh
        db      010h, 010h, 010h, 010h, 010h, 010h, 010h, 010h
        db      018h, 019h, 01Ah, 01Bh, 01Ch, 01Dh, 01Eh, 01Fh
        db      020h, 020h, 020h, 020h, 020h, 020h, 020h, 020h
        db      028h, 029h, 02Ah, 02Bh, 02Ch, 02Dh, 02Eh, 02Fh
        db      030h, 030h, 030h, 030h, 030h, 030h, 030h, 030h
        db      038h, 039h, 03Ah, 03Bh, 03Ch, 03Dh, 03Eh, 03Fh
        db      0C0h, 0C1h, 0C2h, 0C3h, 0C4h, 0C5h, 0C6h, 0C7h
        db      0C8h, 0C9h, 0CAh, 0CBh, 0CCh, 0CDh, 0CEh, 0CFh
        db      0D0h, 0D1h, 0D2h, 0D3h, 0D4h, 0D5h, 0D6h, 0D7h
        db      0D8h, 0D9h, 0DAh, 0DBh, 0DCh, 0DDh, 0DEh, 0DFh
        db      0E0h, 0E1h, 0E2h, 0E3h, 0E4h, 0E5h, 0E6h, 0E7h
        db      0E8h, 0E9h, 0EAh, 0EBh, 0ECh, 0EDh, 0EEh, 0EFh
        db      0F0h, 0F1h, 0F2h, 0F3h, 0F4h, 0F5h, 0F6h, 0F7h
        db      0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

        public  abDefPalMap_256_256
abDefPalMap_256_256     label   byte
        db        0,    1,    2,    3,    4,    5,    6,    7
        db      0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

;/*
;** argbHW
;**
;** This is the shadow of the physical palette.
;*/

        public  argbHW
argbHW          label   byte
        dd      SIZE_HW_PAL dup (0)

;/*
;** phwpal
;**
;** Points to shadow hardware palette.
;*/

        public  phwpal
phwpal  label   dword
        dw      DataOFFSET argbHW
        dw      DataBASE

;/*
;** palsegDefPal
;**
;** This is the default palette.
;*/

SIZE_DEFAULT_PALETTE    equ     256

        public  palsegDefPal
palsegDefPal    label   byte

        dw      0
        .errnz  palseg_fs

        dw      SIZE_DEFAULT_PALETTE-1
        .errnz  palseg_usMax - palseg_fs - 2

        dw      (SIZE_DEFAULT_PALETTE * (size PALCLR))+(size PALSEG)
        .errnz  palseg_cb - palseg_usMax - 2
        .errnz  palseg_apalclr - palseg_cb - 2

PalIndx Macro index,CurrR,CurrG,CurrB
Pal_color_data_&index equ (CurrR Shl 16)+(CurrG Shl 8)+CurrB
        PALCLR  <Pal_color_data_&index or (PC_DEFAULT shl 24),&index,&index,&index,0>
        Endm

        public  PalColor
PalColor        label   byte

        PalIndex = 0

        irp     CurrR,<0,43,85>
        irp     CurrG,<0,36,73,109,146,182,219,255>
        irp     CurrB,<0,85,170,255>
        PalIndx % PalIndex,CurrR,CurrG,CurrB
        PalIndex = PalIndex +1
        endm
        endm
        endm
        irp     CurrR,<128>
        irp     CurrG,<0,36,73,109>
        irp     CurrB,<0,85,170,255>
        PalIndx % PalIndex,CurrR,CurrG,CurrB
        PalIndex = PalIndex +1
        endm
        endm
        endm

        irp     PalGrey,<0,8,16,24,33,41,49,57,65,74,82,90,98,107,115,123,132,139,148,156,165,172,180,189,197,206,213,222,230,238,246,254>
        PalIndx % PalIndex,PalGrey,PalGrey,PalGrey
        PalIndex = PalIndex +1
        endm

        irp     CurrR,<128>
        irp     CurrG,<146,182,219,255>
        irp     CurrB,<0,85,170,255>
        PalIndx % PalIndex,CurrR,CurrG,CurrB
        PalIndex = PalIndex + 1
        endm
        endm
        endm
        irp     CurrR,<170,213,255>
        irp     CurrG,<0,36,73,109,146,182,219,255>
        irp     CurrB,<0,85,170,255>
        PalIndx % PalIndex,CurrR,CurrG,CurrB
        PalIndex = PalIndex + 1
        endm
        endm
        endm

        .errnz  ($ - (palsegDefPal.palseg_apalclr))/(size PALCLR) - SIZE_DEFAULT_PALETTE

PalIndx256 Macro index,CurrR,CurrG,CurrB
Pal_color_data256_&index equ (CurrR Shl 16)+(CurrG Shl 8)+CurrB
        PALCLR  <Pal_color_data256_&index or (PC_DEFAULT shl 24),&index,&index,&index,0>
        Endm

        public  PalColor256
PalColor256     label   byte

        PalIndex256 = 0

        irp     CurrR,<0,43,85>
        irp     CurrG,<0,36,73,109,146,182,219,255>
        irp     CurrB,<0,85,170,255>
        PalIndx256 % PalIndex256,CurrR,CurrG,CurrB
        PalIndex256 = PalIndex256 +1
        endm
        endm
        endm
        irp     CurrR,<128>
        irp     CurrG,<0,36,73,109>
        irp     CurrB,<0,85,170,255>
        PalIndx256 % PalIndex256,CurrR,CurrG,CurrB
        PalIndex256 = PalIndex256 +1
        endm
        endm
        endm

        irp     PalGrey,<0,8,16,24,33,41,49,57,65,74,82,90,98,107,115,123,132,139,148,156,165,172,180,189,197,206,213,222,230,238,246,254>
        PalIndx256 % PalIndex256,PalGrey,PalGrey,PalGrey
        PalIndex256 = PalIndex256 +1
        endm

        irp     CurrR,<128>
        irp     CurrG,<146,182,219,255>
        irp     CurrB,<0,85,170,255>
        PalIndx256 % PalIndex256,CurrR,CurrG,CurrB
        PalIndex256 = PalIndex256 + 1
        endm
        endm
        endm
        irp     CurrR,<170,213,255>
        irp     CurrG,<0,36,73,109,146,182,219,255>
        irp     CurrB,<0,85,170,255>
        PalIndx256 % PalIndex256,CurrR,CurrG,CurrB
        PalIndex256 = PalIndex256 + 1
        endm
        endm
        endm

PalIndx128 Macro index,CurrR,CurrG,CurrB
Pal_color_data128_&index equ (CurrR Shl 16)+(CurrG Shl 8)+CurrB
        PALCLR  <Pal_color_data128_&index or (PC_DEFAULT shl 24),&index,&index,&index,0>
        Endm


        public  PalColor128
PalColor128     label   byte

        PalIndex128 = 0

        irp     CurrR,<0,64>
        irp     CurrG,<0,51,102,153,204,255>
        irp     CurrB,<0,85,170,255>
        PalIndx128 % PalIndex128,CurrR,CurrG,CurrB
        PalIndex128 = PalIndex128 +1
        endm
        endm
        endm

        irp     CurrR,<128>
        irp     CurrG,<0,51,102>
        irp     CurrB,<0,85,170,255>
        PalIndx128 % PalIndex128,CurrR,CurrG,CurrB
        PalIndex128 = PalIndex128 +1
        endm
        endm
        endm

        irp     PalGrey,<28,56,84,112>
        PalIndx128 % PalIndex128,PalGrey,PalGrey,PalGrey
        PalIndex128 = PalIndex128 +1
        endm

        PalIndex128 = PalIndex128 +128

        irp     PalGrey,<140,168,196,224>
        PalIndx128 % PalIndex128,PalGrey,PalGrey,PalGrey
        PalIndex128 = PalIndex128 +1
        endm

        irp     CurrR,<128>
        irp     CurrG,<153,204,255>
        irp     CurrB,<0,85,170,255>
        PalIndx128 % PalIndex128,CurrR,CurrG,CurrB
        PalIndex128 = PalIndex128 +1
        endm
        endm
        endm

        irp     CurrR,<192,255>
        irp     CurrG,<0,51,102,153,204,255>
        irp     CurrB,<0,85,170,255>
        PalIndx128 % PalIndex128,CurrR,CurrG,CurrB
        PalIndex128 = PalIndex128 + 1
        endm
        endm
        endm

PalIndx64 Macro index,CurrR,CurrG,CurrB
Pal_color_data64_&index equ (CurrR Shl 16)+(CurrG Shl 8)+CurrB
        PALCLR  <Pal_color_data64_&index or (PC_DEFAULT shl 24),&index,&index,&index,0>
        Endm


        public  PalColor64
PalColor64      label   byte

        PalIndex64 = 0

        irp     CurrR,<0,85>
        irp     CurrG,<0,64,128,192,255>
        irp     CurrB,<0,128,255>
        PalIndx64 % PalIndex64,CurrR,CurrG,CurrB
        PalIndex64 = PalIndex64 +1
        endm
        endm
        endm

        irp     PalGrey,<85,128>
        PalIndx64 % PalIndex64,PalGrey,PalGrey,PalGrey
        PalIndex64 = PalIndex64 +1
        endm

        PalIndex64 = PalIndex64 +192

        irp     PalGrey,<166,204>
        PalIndx64 % PalIndex64,PalGrey,PalGrey,PalGrey
        PalIndex64 = PalIndex64 +1
        endm

        irp     CurrR,<170,255>
        irp     CurrG,<0,64,128,192,255>
        irp     CurrB,<0,128,255>

        PalIndx64 % PalIndex64,CurrR,CurrG,CurrB
        PalIndex64 = PalIndex64 +1
        endm
        endm
        endm

        public  PalColor32
PalColor32      label   byte
        PALCLR  <00000000h or (PC_DEFAULT shl 24),0,0,0,0> ; black
        PALCLR  <00000040h or (PC_DEFAULT shl 24),1,1,1,0> ; very dark blue
        PALCLR  <00004000h or (PC_DEFAULT shl 24),2,2,2,0> ; very dark green
        PALCLR  <00004040h or (PC_DEFAULT shl 24),3,3,3,0> ; very dark cyan
        PALCLR  <00400000h or (PC_DEFAULT shl 24),4,4,4,0> ; very dark red
        PALCLR  <00400040h or (PC_DEFAULT shl 24),5,5,5,0> ; very dark magenta
        PALCLR  <00404000h or (PC_DEFAULT shl 24),6,6,6,0> ; very dark yellow
        PALCLR  <00000080h or (PC_DEFAULT shl 24),7,7,7,0> ; dark blue
        PALCLR  <00008000h or (PC_DEFAULT shl 24),8,8,8,0> ; dark green
        PALCLR  <00008080h or (PC_DEFAULT shl 24),9,9,9,0> ; dark cyan
        PALCLR  <00800000h or (PC_DEFAULT shl 24),0Ah,0Ah,0Ah,0> ; dark red
        PALCLR  <00800080h or (PC_DEFAULT shl 24),0Bh,0Bh,0Bh,0> ; dark magenta
        PALCLR  <00808000h or (PC_DEFAULT shl 24),0Ch,0Ch,0Ch,0> ; dark yellow
        PALCLR  <002B2B2Bh or (PC_DEFAULT shl 24),0Dh,0Dh,0Dh,0> ; very dark gray
        PALCLR  <00555555h or (PC_DEFAULT shl 24),0Eh,0Eh,0Eh,0> ; dark gray
        PALCLR  <00808080h or (PC_DEFAULT shl 24),0Fh,0Fh,0Fh,0> ; gray
        PALCLR  <00A6A6A6h or (PC_DEFAULT shl 24),0F0h,0F0h,0F0h,0> ; quite light gray
        PALCLR  <00CCCCCCh or (PC_DEFAULT shl 24),0F1h,0F1h,0F1h,0> ; light gray
        PALCLR  <00E0E0E0h or (PC_DEFAULT shl 24),0F2h,0F2h,0F2h,0> ; very light gray
        PALCLR  <000000C0h or (PC_DEFAULT shl 24),0F3h,0F3h,0F3h,0> ; light blue
        PALCLR  <0000C000h or (PC_DEFAULT shl 24),0F4h,0F4h,0F4h,0> ; light green
        PALCLR  <0000C0C0h or (PC_DEFAULT shl 24),0F5h,0F5h,0F5h,0> ; light cyan
        PALCLR  <00C00000h or (PC_DEFAULT shl 24),0F6h,0F6h,0F6h,0> ; light red
        PALCLR  <00C000C0h or (PC_DEFAULT shl 24),0F7h,0F7h,0F7h,0> ; light magenta
        PALCLR  <00C0C000h or (PC_DEFAULT shl 24),0F8h,0F8h,0F8h,0> ; light yellow
        PALCLR  <000000FFh or (PC_DEFAULT shl 24),0F9h,0F9h,0F9h,0> ; blue
        PALCLR  <0000FF00h or (PC_DEFAULT shl 24),0FAh,0FAh,0FAh,0> ; green
        PALCLR  <0000FFFFh or (PC_DEFAULT shl 24),0FBh,0FBh,0FBh,0> ; cyan
        PALCLR  <00FF0000h or (PC_DEFAULT shl 24),0FCh,0FCh,0FCh,0> ; red
        PALCLR  <00FF00FFh or (PC_DEFAULT shl 24),0FDh,0FDh,0FDh,0> ; magenta
        PALCLR  <00FFFF00h or (PC_DEFAULT shl 24),0FEh,0FEh,0FEh,0> ; yellow
        PALCLR  <00FFFFFFh or (PC_DEFAULT shl 24),0FFh,0FFh,0FFh,0> ; white

        public  PalColor16
PalColor16      label   byte
        PALCLR  <00000000h or (PC_DEFAULT shl 24),0,0,0,0> ; black
        PALCLR  <00000080h or (PC_DEFAULT shl 24),1,1,1,0> ; dark blue
        PALCLR  <00008000h or (PC_DEFAULT shl 24),2,2,2,0> ; dark green
        PALCLR  <00008080h or (PC_DEFAULT shl 24),3,3,3,0> ; dark cyan
        PALCLR  <00800000h or (PC_DEFAULT shl 24),4,4,4,0> ; dark red
        PALCLR  <00800080h or (PC_DEFAULT shl 24),5,5,5,0> ; dark magenta
        PALCLR  <00808000h or (PC_DEFAULT shl 24),6,6,6,0> ; dark yellow
        PALCLR  <00808080h or (PC_DEFAULT shl 24),7,7,7,0> ; dark gray
        PALCLR  <00CCCCCCh or (PC_DEFAULT shl 24),0F8h,0F8h,0F8h,0> ; gray
        PALCLR  <000000FFh or (PC_DEFAULT shl 24),0F9h,0F9h,0F9h,0> ; blue
        PALCLR  <0000FF00h or (PC_DEFAULT shl 24),0FAh,0FAh,0FAh,0> ; green
        PALCLR  <0000FFFFh or (PC_DEFAULT shl 24),0FBh,0FBh,0FBh,0> ; cyan
        PALCLR  <00FF0000h or (PC_DEFAULT shl 24),0FCh,0FCh,0FCh,0> ; red
        PALCLR  <00FF00FFh or (PC_DEFAULT shl 24),0FDh,0FDh,0FDh,0> ; magenta
        PALCLR  <00FFFF00h or (PC_DEFAULT shl 24),0FEh,0FEh,0FEh,0> ; yellow
        PALCLR  <00FFFFFFh or (PC_DEFAULT shl 24),0FFh,0FFh,0FFh,0> ; white

sEnd    Data


sBegin  CompileCodeData
        externB     asDDARun            ; CMPLCODE.ASM
sEnd    CompileCodeData

sBegin  Data
        externB     sdScreen
        externW     BoardMaxY           ; max real addressable y on board
sEnd

sBegin  PtrData
        externB     screen_busy         ; cursor exclusion flag
sEnd    PtrData

sBegin  InitSeg
        assumes cs,InitSeg

        externW  InitSegData

;/***************************************************************************
;*
;* FUNCTION NAME = InitDefaultPalette
;*
;* DESCRIPTION   = Initialize the default palette.                   
;*                 Registers Preserved:                              
;*                       BP                                          
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
;*                                                               
;* INPUT         = NONE                                          
;* OUTPUT        = NONE                                          
;*                                                               
;* RETURN-NORMAL = AX = 0                    
;* RETURN-ERROR  = AX <> 0                   
;*                 error has not been logged 
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

cProc   InitDefaultPalette,<FAR,PUBLIC,NODATA>,<>
cBegin

        mov     ds,InitSegData
        assumes ds,Data

;/*
;** Fix up the DDC initializer.
;*/

        mov     si,DataOFFSET ddcInit
        mov     di,DataOFFSET devpalDefault
        mov     [si].ddc_npdevpal,di

;/*
;** Fix up default devpal.
;*/

        mov     si,DataOFFSET palsegDefPal
        mov     [di].devpal_pPalSeg.lo,si
        mov     [di].devpal_pPalSeg.hi,ds

;/*
;** Initialize the hardware palette shadow.
;** DS:SI --> palsegDefPal
;** DS:DI --> argbHW
;*/

        mov     di,DataOFFSET argbHW
        palSize cx,ds,si
        add     si,palseg_apalclr
@@:
        mov     ax,word ptr [si].palclr_rgb.rgb2_bBlue
        mov     dx,word ptr [si].palclr_rgb.rgb2_bRed
        mov     bl,[si].palclr_bCur
        xor     bh,bh
        rgbOff  bx
        mov     word ptr [di+bx].rgb2_bBlue,ax
        mov     word ptr [di+bx].rgb2_bRed,dx
        add     si,size PALCLR
        loop    @B

        .errnz  rgb2_bBlue
        .errnz  rgb2_bGreen    - rgb2_bBlue  - 1
        .errnz  rgb2_bRed      - rgb2_bGreen - 1
        .errnz  rgb2_fcOptions - rgb2_bRed   - 1
        .errnz  (size RGB2) - 4


        mov     si,DataOFFSET palsegDefPal
        mov     di,DataOFFSET aIPC256toIPC16
        mov     cx,256

idp_loop:
        mov     ax,word ptr [si].palseg_apalclr.palclr_rgb.rgb2_bBlue
        mov     dx,word ptr [si].palseg_apalclr.palclr_rgb.rgb2_bRed

        cCall   far_rgb_to_ipc_16

        mov     byte ptr ds:[di],bl

        add     si,SIZE PALCLR
        inc     di
        loop    idp_loop


ifdef FIREWALLS
;/*
;** Validate abDefPalMap_16_256, which must contain the bCur values for
;** the default palette.
;*/
        mov     si,DataOFFSET abDefPalMap_16_256
        mov     di,DataOFFSET palsegDefPal
        palSize cx,ds,di
        add     di,palseg_apalclr
@@:
        lodsb
        mov     ah,al
        cmp     ax,word ptr [di].palclr_bFore
        jne     idp_rip
        cmp     al,[di].palclr_bPrev
        jne     idp_rip
        add     di,size PALCLR
        loop    @B


        jmp     short idp_ok

        .errnz  palclr_bFore     - palclr_bCur  - 1
        .errnz  palclr_bPrev     - palclr_bFore - 1
        .errnz  palclr_bReserved - palclr_bPrev - 1

idp_rip:
        rip     text,<InitDefaultPalette: abDefPalMap_16_256 corrupt>
idp_ok:
endif

;/*
;** No errors.
;*/

        xor     ax,ax
cEnd

sEnd    InitSeg

sBegin  PalSeg
        assumes cs,PalSeg

        externW     PalSegData
        externW     MyPtrPalSegData
        externW     MyCmplPalSegData

;/*
;** argbLinearTo8514
;**
;** This table maps the linear RGB color component onto a curve to
;** brighten it.  The 8514 has a lot of really dark colors.
;**
;** This table comes from DCR 25074.
;*/

        public  argbLinearTo8514
argbLinearTo8514        label   byte

        db    00h       ;00  00
        db    0Dh       ;01  01
        db    0Eh       ;02  02
        db    0Eh       ;03  03
        db    0Fh       ;04  04
        db    10h       ;05  05
        db    10h       ;06  06
        db    11h       ;07  07
        db    11h       ;08  08
        db    12h       ;09  09
        db    13h       ;0A  10
        db    13h       ;0B  11
        db    14h       ;0C  12
        db    15h       ;0D  13
        db    15h       ;0E  14
        db    16h       ;0F  15
        db    17h       ;10  16
        db    18h       ;11  17
        db    18h       ;12  18
        db    19h       ;13  19
        db    1Ah       ;14  20
        db    1Bh       ;15  21
        db    1Bh       ;16  22
        db    1Ch       ;17  23
        db    1Dh       ;18  24
        db    1Eh       ;19  25
        db    1Eh       ;1A  26
        db    1Fh       ;1B  27
        db    20h       ;1C  28
        db    21h       ;1D  29
        db    22h       ;1E  30
        db    22h       ;1F  31
        db    23h       ;20  32
        db    24h       ;21  33
        db    25h       ;22  34
        db    26h       ;23  35
        db    26h       ;24  36
        db    27h       ;25  37
        db    28h       ;26  38
        db    29h       ;27  39
        db    2Ah       ;28  40
        db    2Bh       ;29  41
        db    2Ch       ;2A  42
        db    2Ch       ;2B  43
        db    2Dh       ;2C  44
        db    2Eh       ;2D  45
        db    2Fh       ;2E  46
        db    30h       ;2F  47
        db    31h       ;30  48
        db    32h       ;31  49
        db    33h       ;32  50
        db    34h       ;33  51
        db    35h       ;34  52
        db    36h       ;35  53
        db    36h       ;36  54
        db    37h       ;37  55
        db    38h       ;38  56
        db    39h       ;39  57
        db    3Ah       ;3A  58
        db    3Bh       ;3B  59
        db    3Ch       ;3C  60
        db    3Dh       ;3D  61
        db    3Eh       ;3E  62
        db    3Fh       ;3F  63

;/*
;** argbLinearTo8515
;**
;** This table maps the linear RGB color component onto a curve to
;** brighten it.  The 8515 is different than the 8514.
;*/

        public  argbLinearTo8515
argbLinearTo8515        label   byte

        db    00h       ;00  00
        db    04h       ;01  01
        db    05h       ;02  02
        db    05h       ;03  03
        db    06h       ;04  04
        db    07h       ;05  05
        db    07h       ;06  06
        db    08h       ;07  07
        db    09h       ;08  08
        db    09h       ;09  09
        db    0Ah       ;0A  10
        db    0Bh       ;0B  11
        db    0Bh       ;0C  12
        db    0Ch       ;0D  13
        db    0Dh       ;0E  14
        db    0Eh       ;0F  15
        db    0Eh       ;10  16
        db    0Fh       ;11  17
        db    10h       ;12  18
        db    11h       ;13  19
        db    12h       ;14  20
        db    13h       ;15  21
        db    13h       ;16  22
        db    14h       ;17  23
        db    15h       ;18  24
        db    16h       ;19  25
        db    17h       ;1A  26
        db    18h       ;1B  27
        db    19h       ;1C  28
        db    1Ah       ;1D  29
        db    1Bh       ;1E  30
        db    1Ch       ;1F  31
        db    1Dh       ;20  32
        db    1Eh       ;21  33
        db    1Fh       ;22  34
        db    20h       ;23  35
        db    21h       ;24  36
        db    22h       ;25  37
        db    23h       ;26  38
        db    24h       ;27  39
        db    25h       ;28  40
        db    26h       ;29  41
        db    27h       ;2A  42
        db    28h       ;2B  43
        db    29h       ;2C  44
        db    2Ah       ;2D  45
        db    2Bh       ;2E  46
        db    2Ch       ;2F  47
        db    2Dh       ;30  48
        db    2Eh       ;31  49
        db    30h       ;32  50
        db    31h       ;33  51
        db    32h       ;34  52
        db    33h       ;35  53
        db    35h       ;36  54
        db    35h       ;37  55
        db    37h       ;38  56
        db    38h       ;39  57
        db    39h       ;3A  58
        db    3Ah       ;3B  59
        db    3Bh       ;3C  60
        db    3Dh       ;3D  61
        db    3Eh       ;3E  62
        db    3Fh       ;3F  63


;/***************************************************************************
;*
;* FUNCTION NAME = OEMUpdateColors
;*
;* DESCRIPTION   = Update the contents of a visible rectangle using the palette 
;*                 mapping vector.
;*
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,ES,FLAGS
;*                 Registers Preserved:
;*                       DS,SI,DI,BP
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


        assumes ds,nothing
        assumes es,nothing

OUC_ODD_PEL     equ     01h             ;indicate the odd pel scan

cProc   OEMUpdateColors, <NEAR, PUBLIC>, <si, di, ds>
        parmD   lpVisRect
        parmD   lpTranslate

        localW  xDst                    ;the visible rectangle left
        localW  yDst                    ;the visible rectangle bottom
        localW  cxExt                   ;the visible horizontal extent
        localW  cyExt                   ;the visible vertical extent
        localW  cwScanSize              ;# of complete double pels
        localB  fbOddPel                ;flag for odd # of pels

cBegin

;/*
;** Get the visible rectangle origin and extents.
;*/

        cld
        mov     ds,PalSegData
        assumes ds,Data
        les     bx,lpVisRect            ;ES:BX --> visible rectangle
        assumes es,nothing
        mov     cx,es:[bx].rcl_xLeft.lo ;CX = Left
        mov     xDst,cx
        mov     ax,es:[bx].rcl_xRight.lo
        mov     si,ax                   ;SI = AX = Right
        sub     ax,cx                   ;AX = Right - Left = cxExt
        mov     cxExt,ax
        mov     dx,es:[bx].rcl_yBottom.lo;DX = Bottom
        mov     bx,es:[bx].rcl_yTop.lo
        sub     bx,dx                   ;BX = Top - Bottom = cyExt
        mov     cyExt,bx

        mov     ax,ds:sdScreen.sd_cy    ;the screen height
        sub     ax,dx                   ;DX = bottom scan
        mov     di,ax                   ;DI = flipped bottom scan (high # scan)
        sub     ax,bx                   ;BX = vertical extent
        mov     dx,ax                   ;DX = AX = flipped top scan
        mov     yDst,ax

;/*
;**   Cursor Exclusion for a device destination
;*/

ouc_cursor_exclude:
        dec     si                      ;Make top&right sides inclusive
        dec     di
        cCall   far_exclude             ;Exclude the area from the screen

;/*
;**   Set up the area on the screen where we will update its contents.
;*/

        GrabScreen  OEMUpdateColors,FAR,PalSeg; don't let cursor operations kill us

        WaitQ   6                       ; set up scissor rectangle
        Mov     Ax,xDst                 ; min left x
        Or      Ah,High XMIN_2DECODE
        .errnz  Low XMIN_2DECODE
        outwQ   XMIN                    ; x clip bounds is clipped rect bounds
        And     Ah,Not (High DECODE_FIELD)
        .errnz  Low DECODE_FIELD
        Add     Ax,cxExt                ; max right x
        Or      Ah,High XMAX_2DECODE
        .errnz  Low XMAX_2DECODE
        outwQ   XMAX
        outwQ   YMIN,YMIN_2DECODE       ; min y is always 0

        mov     ax,ds:BoardMaxY         ; maximum display area height
        Or      Ah,High YMAX_2DECODE
        .errnz  Low YMAX_2DECODE
        outwQ   YMAX
        Mov     Al,0ffh                 ; all planes enabled for r/w
        outbQ   READ_ENABLE,Al
        outbQ   WRITE_ENABLE,Al

;/*
;** Set the forground and background mix register to source-copy.
;*/

        WaitQ   4
        mov     ax,FUNC_2OP_VAR+FUNC_S
        outwQ   FUNCTION_1
        outwQ   FUNCTION_0

;/*
;** Set the read/write area.
;*/

        mov     ax,cxExt                ; now get X-ext inclusive
        dec     ax
        outwQ   LX
        xor     ax, ax                  ; do one line at a time, i.e., Y-ext
        outwQ   LY

;/*
;**   We cannot afford to read-translate-write one pel at a time, or else we need
;**   to switch the operation mode (COMMAND) for every pel. Quite expensive,
;**   isn't it? So let's set up one memory buffer to store one scan and translate
;**   each pel while we write them back.
;**   Fortunately, we already have a memory buffer used to store the DDA run for
;**   StretchBlt, asDDARun, whose size is (word size * screen width), and since
;**   we always have a visible rectangle contained in the screen, this buffer is
;**   always large enough.
;*/

ouc_init_update:
        mov     ax,MyCmplPalSegData     ; asDDARun is in the instance data seg
        mov     ds,ax
        assumes ds,nothing
        mov     es,ax
        assumes es,nothing

        CPUMode 386

        lgs     bx,lpTranslate          ; GS:BX --> palette mapping vector
        assumes gs,nothing
        mov     cx,cxExt                ; the scan width
        shr     cx,1                    ; odd # of pixels ?
        setc    fbOddPel                ; set to 1 if odd # of pels
        .errnz  OUC_ODD_PEL-1
        mov     cwScanSize,cx           ; # of complete double pels

        CPUMode 286

        mov     ax,yDst
        add     ax,cyExt                ; AX = Top scan
        mov     cyExt,ax                ; now cyExt = Top Scan
        mov     ax,yDst                 ; AX = the first scan

ouc_update_next_scan:
        cmp     ax,cyExt                ; AX = the next scan to update
        njge    ouc_exit

        WaitQ   3
        outwQ   X0,xDst                 ; X position
        outwQ   Y0,yDst                 ; Y position

CMDREAD         =       (\
                         CMD_C_HRECT+CMD_BYTEORDER+CMD_BYTE+CMD_FV_VAR+CMD_DY+\
                         CMD_DX+CMD_MA_ACCESS+CMD_PA_ONE+CMD_RW_R\
                        )

        outwQ   CMD_FLAGS,CMDREAD

        WaitQIN                         ; wait for the empty queue
        lea     di,asDDARun             ; ES:DI --> asDDARun
        mov     dx,COLOR_0

        mov     cx,cwScanSize           ; CX = number of complete double pels
        jcxz    ouc_get_last_pel

        CPUMode 386

ouc_get_pel_loop:
        in      ax, dx                  ; get two pixels
        xlatb   gs:[bx]                 ; translate the one in al
        xchg    al, ah
        xlatb   gs:[bx]
        xchg    al, ah
        stosw
        loop    ouc_get_pel_loop

ouc_get_last_pel:
        test    fbOddPel,OUC_ODD_PEL    ; check if odd or even pixel count
        jz      short ouc_store_pels
        in      ax, dx
        xlatb   gs:[bx]
        stosb

        CPUMode 286

ouc_store_pels:
        WaitQ   3
        outwQ   X0,xDst                 ; X position
        outwQ   Y0,yDst                 ; Y position

CMDWRITE        =       (\
                         CMD_C_HRECT+CMD_BYTEORDER+CMD_BYTE+CMD_FV_VAR+CMD_DY+\
                         CMD_DX+CMD_MA_ACCESS+CMD_PA_ONE+CMD_RW_W\
                        )

        outwQ   CMD_FLAGS,CMDWRITE

        WaitQOUT                        ; wait for an empty queue
        lea     si,asDDARun
        mov     dx,COLOR_0

        mov     cx,cwScanSize           ; get the number of words to write
        rep     outsw

ouc_store_last_pel:
        test    fbOddPel,OUC_ODD_PEL
        jz      ouc_increment_scan
        lodsb
        out     dx, ax

ouc_increment_scan:
        mov     ax,yDst
        inc     ax
        mov     yDst,ax
        jmp     ouc_update_next_scan

ouc_exit:
        ReleaseScreen OEMUpdateColors,FAR,PalSeg ;allow cursor to do what it has to
        cCall   far_unexclude

cEnd

sEnd    PalSeg
end
