;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = 8514MEMD.ASM
;*
;* DESCRIPTIVE NAME = 
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/23/88
;*
;* DESCRIPTION  This file contains the definition of offscreen memory for the   
;*              8514/A Winthorn display drivers.
;*
;*              The layout of 8514/A offscreen memory is defined.
;*
;*              Restrictions:
;*
;*              This is the only file which should have any dependancies on the
;*              screen height.
;*
;*              Public Data:          SCREEN_CX
;*                                    SCREEN_CY
;*
;* FUNCTIONS    
;*              
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/23/88                     Author:  Geoff Shapiro [geoffs]
;*****************************************************************************/

        .xlist
        include cmacros.inc
INCL_DEV                equ                      1
INCL_SUB                equ                      1
        include pmgre.inc
DINCL_SAVE_SCREEN_BITS  equ                      1
        include driver.inc
        include 8514.inc
        include 8514mem.inc
        .list

        public  SCREEN_CY
        public  SCREEN_CX
        public  INIT_POINTER_X
        public  INIT_POINTER_Y

        missing_code    <These will have to be runtime determined>
SCREEN_CX       =       1024                      ;Screen width in pixels
SCREEN_CY       =       768                       ;Screen height in scans

INIT_POINTER_X  Equ     SCREEN_CX/2              ;Initial pointer x
INIT_POINTER_Y  Equ     SCREEN_CY/2              ;Initial pointer x

        externA PTR_WIDTH_BITS                    ; width of pointer in pixels
        externA PTR_HEIGHT                        ; height of pointer in scans

;/*
;**-----------------------------------------------------------------------;
;**   Define the layout of 8514 memory.
;**-----------------------------------------------------------------------;
;**  
;**  
;**                       8514A Memory Map (HiRes only)
;**                                                           1023
;**         Ŀ
;**                                                                
;**                                                                
;**                                                                
;**                                                                
;**                                                                
;**                               onscreen area                    
;**                                                                
;**                                                                
;**                                                                
;**                                                                
;**                                                                
;**          (32x32)   64        128      196                      
;**          (40x40)   80        160      240                      
;**          (64x64)  128        256                               
;**     768 Ĵ
;**          ptr  ptr  ptr  ptr  work                         
;**          and  xor  savecolor area     SaveScreenBits area 
;**          mask mask areabitmp                              
;**     848 Ĵ
;**                              Pattern Cache                     
;**     864 Ĵ
;**                                                                
;**                Font storage area and 3-op blt temporary        
;**                                                 space.         
;**                                                                
;**                                                                
;**                                                                
;**                                                                
;**                                                                
;**    1023 
;**
;**  
;**  
;**  
;**  
;**   Note that the XOR and AND masks each only occupy one plane.
;**   Thus they could be placed on separate planes at the same address.
;**   Then the Color Pointer Bitmap could be moved to where the XOR mask
;**   is and that would free up more memory for SSB.
;**  
;**   Work Area: for 32x32 and 40x40 pointers the XOR and AND and restoring
;**   of the old pointer are all done in the work area then it is blitted
;**   to the screen.  This is not done for 64x64 because the work area would
;**   then be huge and no one now should be using 64x64 pointers.
;**  
;**--------------------------------------------------------------------------;

CPTRMASKS   equ  4

;/*
;** !Warning! changing theses values may mean changes are necessary for
;** pointer.asm code
;*/
 
sBegin  Data

        globalW OffScreenYMIN,864                ; dflt 1kx768 offscreen y for fonts
        globalW OffScreenXMIN,0                  ; dflt 1kx768 offscreen x for fonts
        globalW OffScreenYMAX,864+160-1          ; dflt height of offscreen area
        globalW OffScreenXMAX,1024-1             ; dflt width of offscreen area
        globalW OffScreenValid,0                 ; nothing cached in offscreen
        globalW OffScreenHighWater,864           ; where offscreen fonts end

        globalW BltBufferY,864                   ; dflt 1kx768 offscreen y for blt buf
        globalW BltBufferX,0                     ; dflt 1kx768 offscreen x for blt buf
        globalW BltBufferYExt,160                ; dflt height of blt buffer
        globalW BltBufferXExt,1024               ; dflt width of blt buffer

        PatCacheYVal equ 848
        globalW PatCacheY,PatCacheYVal           ; dflt 1kx768 offscreen y for pattern
        globalW PatCacheX,0                      ; dflt 1kx768 offscreen x for pattern
        globalW PatCacheYExt,16                  ; dflt height of cached pattern
        globalW PatCacheXExt,1024                ; dflt width of blt buffer

        globalW SsbX,(CPTRMASKS*64)              ; dflt 1kx768 ssb x
        globalW SsbY,768                         ; dflt 1kx768 ssb y
        globalW SsbXExt,1024-(CPTRMASKS*64)      ; dflt 1kx768 width of ssb area

;/*
;** note SsbXExt is the end of the max with of the pointer area which
;** occurs when the pointer size is 64x64.
;*/
        globalW SsbYExt,80                       ; dflt 1kx768 max height of ssb area
        .errnz  (PTR_WIDTH_BITS GT 64)
        .errnz  (PTR_HEIGHT GT 64)
        globalW SsbNextX,0                       ; offset to next free rectangle

        globalW BoardMaxY,1023                   ; max real addressable y on board

sEnd    Data

sBegin  PtrData
        globalW PtrPatCacheY,PatCacheYVal
sEnd    Data


sBegin  Code
        assumes Ds,Data
        assumes Es,nothing

sEnd    Code

        End


;/*
;** The positions of the various offscreen items for lores mode are dynamically
;** initialized in resolve.asm in the function called device_specific_init.
;*/


