;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = 8514INIT.ASM
;*
;* DESCRIPTIVE NAME = This module contains the function which will program an   
;*                    8514 for color operation for Winthorn.  This file is part 
;*                    of the device dependent sources.
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  The display adapter is programmed for the following              
;*              configurations dependent on the expansion memory installed,      
;*              monitor attached:                                                
;*
;*              1kx768x8
;*              1kx768x4
;*              640x480x8
;*              640x480x4
;*
;* FUNCTIONS    Public Functions:     physical_enable  
;*                                    physical_disable
;*                                    copy_ring_to_ring
;*
;*                                    ring3_physical_enable
;*                                    ring3_VioGetPSAddress
;*                                    far_physical_enable  
;*                                    far_physical_disable 
;*                                    notify_vdd           
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/03/88                     Author:  Geoff Shapiro [geoffs]
;*   08/02/88                     Jeff Parsons [jeffpar] Created (pulled out of
;*                                Death() actually).
;*   08/22/88                     Wes Rupel [wesleyr] Moved JeffPar's EGA
;*                                changes to 8514.
;*   09/20/88                     Mitchell McLain [gssc!mmm] Invalidate the font
;*				  cache.
;*   11/11/92  @Vr.mcs001  50428  Fast screen switch not repainting properly
;*   01/12/93  @Vr.mcs002  59796  Register system semafores
;*****************************************************************************/

        .286p

        .xlist
        include cmacros.inc
INCL_DEV                equ     1
INCL_SUB                equ     1
ifdef PALMGR
INCL_GPIBITMAPS         equ     1
INCL_GPILOGCOLORTABLE   equ     1
endif
        include pmgre.inc
DINCL_SAVE_SCREEN_BITS  equ     1
        include driver.inc
        include 8514.inc
	include 8514mem.inc

;@Vr.mcs002 start
; * * * * * * Driver Semaphore Registration for use with PM Debuggers * * * * *

dbSem			struc
        sem_type        dd      ?       ; semaphore type
        sem_addr        dd      ?       ; semaphore addr
        sem_alias       dd      ?
dbSem                   ends

semList                 struc
        sl_next         dd      ?
        sl_count        dd      ?
        sl_sem          db      SIZE dbSem DUP (?)
semList                 ends

DBSEM_USER_SPECIFIED    equ     1
DBSEM_FIRST             equ     1
DBG_C_RegisterSemList   equ     32


include                 dbgapi.inc

; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;@Vr.mcs002 end

ifdef PALMGR
        include palette.inc
endif
        .list

        ??_out  8514init


        externFP DosCallback
        externFP VioSetMode
        externFP VioWrtTTY
        externFP VioSetCurPos
        externFP VioGetConfig
        externFP VioGetPSAddress
        externFP DosRequestVDD
        externFP ring3_CriticalError
	externFP far_invalidate_cache
	externFP Dos16SelToFlat 	;@Vr.mcs002

sBegin  Data
        externB fGrimReaper
        externB sdScreen
        externW selDeathToUse
        externW hwFlags                 ; 8514/A hw state flags
        externW OffScreenValid          ; Offscreen font cache validity flag
        externW f8514FastSS             ; disable/enable 8514 FastScreenSwitch
        externD hVideoVDD
        externB fbOffScreen
        externB drqVideo
	externW wDisplay		;Display Type
	externB semDriver		;@Vr.mcs002

ifdef PALMGR
        externB argbHW
endif
sEnd	Data

;@Vr.mcs002 start

.386p
CODE32  SEGMENT DWORD USE32 PUBLIC 'CODE'

        extrn   Dos32Debug:near
        ASSUME  CS:FLAT

rsl10:  push    eax
        call    Dos32Debug
        jmp     far ptr rsl20
CODE32  ENDS

sBegin  Ring3Code

        assumes CS,Ring3Code

cProc   RegisterSemList,<PUBLIC,FAR,NODATA>
        localV  semList1,%(size semList)
        localV  dbgBuf,%(size uDB)
cBegin
        push    eax
        push    ebx
        mov     [semList1].sl_count,1
        mov     [semList1].sl_sem.sem_type,DBSEM_FIRST
        mov     ax,ds
        shl     eax,16
        call    Dos16SelToFlat
        mov     ax,offset semDriver
        mov     [semList1].sl_sem.sem_addr,eax
        mov     [dbgBuf].uDB_Cmd,DBG_C_RegisterSemList
        mov     ax,ss
        shl     eax,16
        call    Dos16SelToFlat
        lea     ebx,semList1
        add     ebx,eax
        mov     [dbgBuf].uDB_Buffer,ebx
        mov     [dbgBuf].uDB_Len,(size semList)
        lea     ebx,dbgBuf
        add     eax,ebx
        jmp     far ptr FLAT:rsl10
rsl20:  pop     ebx
        pop     eax
cEnd
        sEnd    Ring3Code

.286p

;@Vr.mcs002 end

page
sBegin  Ring3Code
        assumes cs,Ring3Code

;/*
;**  Since we don't know what are good defaults for the viomi_fmt_ID
;**  and viomi_attrib fields, we'll set the structure length to
;**  exclude them and throw in some error checking on the fields.
;*/

CB_VIOSETMODE   equ     viomi_fmt_ID
                .errnz  viomi_attrib-viomi_fmt_ID-1
                .errnz  SIZE viomi_attrib-1

VGMT_MAKEITWORK Equ     08h

;/*
;** The following parameters are the parameters passed to VioSetMode
;** to enter the desired graphics mode.
;*/

ifdef 4BPP

;/*
;** 1024x768x4 mode
;*/

viomi_1k_4      Label   Byte

        dw      CB_VIOSETMODE
        .errnz  viomi_cb

        db      VGMT_MAKEITWORK or VGMT_OTHER or VGMT_GRAPHICS
        .errnz  viomi_fbType-viomi_cb-2

        db      4
        .errnz  viomi_color-viomi_fbType-1

        dw      80
        .errnz  viomi_col-viomi_color-1

        dw      24
        .errnz  viomi_row-viomi_col-2

        dw      1024
        .errnz  viomi_hres-viomi_row-2

        dw      768
        .errnz  viomi_vres-viomi_hres-2
        .errnz  ($-viomi_1k_4)-CB_VIOSETMODE

;/*
;** 640x480x4 mode
;*/

viomi_640_4     Label   Byte

        dw      CB_VIOSETMODE
        .errnz  viomi_cb

        db      VGMT_MAKEITWORK or VGMT_OTHER or VGMT_GRAPHICS
        .errnz  viomi_fbType-viomi_cb-2

        db      4
        .errnz  viomi_color-viomi_fbType-1

        dw      80
        .errnz  viomi_col-viomi_color-1

        dw      24
        .errnz  viomi_row-viomi_col-2

        dw      640
        .errnz  viomi_hres-viomi_row-2

        dw      480
        .errnz  viomi_vres-viomi_hres-2
        .errnz  ($-viomi_640_4)-CB_VIOSETMODE

endif ;4BPP

;/*
;** 640x480x8 mode
;*/

viomi_640_8     Label   Byte

        dw      CB_VIOSETMODE
        .errnz  viomi_cb

        db      VGMT_MAKEITWORK or VGMT_OTHER or VGMT_GRAPHICS
        .errnz  viomi_fbType-viomi_cb-2

        db      8
        .errnz  viomi_color-viomi_fbType-1

        dw      80
        .errnz  viomi_col-viomi_color-1

        dw      34
        .errnz  viomi_row-viomi_col-2

        dw      640
        .errnz  viomi_hres-viomi_row-2

        dw      480
        .errnz  viomi_vres-viomi_hres-2
        .errnz  ($-viomi_640_8)-CB_VIOSETMODE


;/*
;** 1024x768x8 mode
;*/

public  viomi_1k_8
viomi_1k_8      Label   Byte

        dw      CB_VIOSETMODE
        .errnz  viomi_cb

        db      VGMT_MAKEITWORK or VGMT_OTHER or VGMT_GRAPHICS
        .errnz  viomi_fbType-viomi_cb-2

        db      8
        .errnz  viomi_color-viomi_fbType-1

        dw      85
        .errnz  viomi_col-viomi_color-1

        dw      38
        .errnz  viomi_row-viomi_col-2

        dw      1024
        .errnz  viomi_hres-viomi_row-2

        dw      768
        .errnz  viomi_vres-viomi_hres-2
        .errnz  ($-viomi_1k_8)-CB_VIOSETMODE


;/***************************************************************************
;*
;* FUNCTION NAME = ring3_physical_enable
;*
;* DESCRIPTION   = ring3_physical_enable makes the actual calls to Vio to     
;*                 enable the desired graphics mode.  This code must reside at
;*                 ring 3. It will be called from the ring2 code via          
;*                 DosCallback.                                               
;*
;*                 Registers Preserved:
;*                       SI,DI,BP,DS
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,ES,FLAGS
;*                 Calls:
;*                       VioSetMode
;*
;* INPUT         = AX = hwFlags, tells us if 640 or 1024 line mode 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = Vio return code       
;* RETURN-ERROR  = AX = Vio error return code 
;*
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

cProc   ring3_physical_enable,<FAR,PUBLIC,NODATA>

cBegin
	call	RegisterSemList 	    ;@Vr.mcs002 end

        mov     dx,Ring3CodeOFFSET viomi_640_8
        .errnz  High HW_MON_640
        test    al,HW_MON_640               ; I would've called this MON_1024
        jnz     @F
        mov     dx,Ring3CodeOFFSET viomi_1k_8
@@:
        farPtr  pviomi,cs,dx
        cCall   VioSetMode,<pviomi,0>
        or      ax,ax
        jnz     pe_fail

pe_exit:
cEnd

pe_fail:
        cCall   ring3_CriticalError
        jmp     short pe_exit


cProc   ring3_VioGetPSAddress,<FAR,PUBLIC,NODATA>
cBegin
        xor     ax,ax
        push    ax
        push    ax
        mov     bx,sp
        farPtr  ppaviops,ss,bx
        cCall   VioGetPSAddress,<ppaviops,dx>
        or      ax,ax
        pop     ax
        pop     dx
        jz      ring3_VioGetPS_okay
        xor     ax,ax
        xor     dx,dx
ring3_VioGetPS_okay:
cEnd

sEnd Ring3Code
page

sBegin  PalSeg
        assumes cs,PalSeg

        staticD ring3_enable,ring3_physical_enable

        externNP SetHWPalette           ;critsec.asm
        externNP LoadGreyPalette        ;critsec.asm
        externNP LoadKColorPalette      ;critsec.asm
ifdef KLUGE
        externNP RESET_BOARD_STATE      ;critsec.asm
endif

        externW PalSegData
        externW ctDefault

page
;/***************************************************************************
;*
;* FUNCTION NAME = physical_enable
;*
;* DESCRIPTION   = We have decided to call VioSetMode to effect the actual    
;*                 mode change to the required graphics mode.  This has the   
;*                 desirable side-affect of letting the Vio subsystem know    
;*                 that the screen mode has changed.  This is important since 
;*                 it needs to know this if things like VioPopUp are going to 
;*                 work.                                                      
;*
;*                 Registers Preserved:
;*                       SI,DI,BP,DS,ES
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,FLAGS
;*                 Calls:
;*                       VioSetMode
;*
;* INPUT         = FALSE if called from Resurrection.                        
;*                 cbDirty is the number of VRAM bytes to restore for a fast
;*                 video RAM restoration.  It is irrelevant to the 8514.
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = 0 if successful                        
;* RETURN-ERROR  = AX = Error code if not successful (AX <> 0) 
;*
;**************************************************************************/

        assumes ds,Data
        assumes es,nothing

cProc   far_physical_enable,<FAR,PUBLIC,WIN,PASCAL>,,<si,di> ; DI not used!!!
        parmW   fInitMem
        parmD   cbDirty         ; used in EGA, but not in 8514 driver
cBegin

;/*
;**  Always invalidate the offscreen font cache.
;** 
;**  Can't rely on the op-complete bit from the Control/Status register
;**  because there's no guarantee that it will reflect reality when coming
;**  back here.  Another program could have reset it before relinquishing
;**  control back to this screen group.
;*/

        and     OffScreenValid,not OFFSCREEN_VALID; Invalidate the cache.

        cCall   far_invalidate_cache,<es,di,bx,cx>

ifdef   KLUGE
        mov     cx,fInitMem             ; if clearing then ok to do this
        jcxz    @F                      ; skip it if not clearing...
        call    _KlugeReset             ; else get around hw/sw problem
@@:
endif
					; @Vr.mcs001 unnescessary code removed

;/*
;** Initialize for the requested hardware configuration
;*/
        mov     ax,hwFlags              ; pass hwflags to ring3 enable code
        save    <ds>                    ; trashed by upward ring transition
        cCall   DosCallback,<ring3_enable>
        or      ax,ax
        Jz      @F
        Jmp     enable_failed           ; could not set mode
@@:

;/*
;**  Turn off video to monitor by disabling the output of the DAC. We don't
;**  want too many visible glitches as we load the palette and perhaps clear
;**  the screen.
;*/

        Sub     Al,Al                   ; turn off DAC video output
        Mov     Dx,RAMDAC_PMASK
        Out     Dx,Al

;/*
;**  Load the default color palette. The palette we load will be dependent on
;**  the mode that we are running in. Palette default data lives in the code
;**  segment of this routine for color configurations. It is dynamically built
;**  for greyscale configurations.
;*/

        Sub     Al,Al                   ; start loading w/index 0

        Test    hwFlags,HW_MONO_MON     ; greyscale ?
        Jz      load_color_palette      ; no -- its a color configuration...
        cCall   LoadGreyPalette
        Jmp     short palette_loaded
load_color_palette:
ifdef PALMGR
        farPtr  pEntries,ds,ax
        arg     0
        arg     256
        arg     pEntries
        arg     1                       ;override check for Death
        mov     ax,DataOFFSET argbHW

endif
        cCall   SetHWPalette
palette_loaded:

;/*
;**  Invalidate selDeathToUse.  Make sd_pBits.sel in the surface valid.  Hopefully
;**  this will hose anyone who thinks they can just pick up selDeathToUse
;**  and use it.
;*/

        mov     ax,INVALID_SEL
        xchg    ax,selDeathToUse
        mov     sdScreen.sd_pBits.sel,ax
        mov     fGrimReaper,0           ;Screen access allowed

;/*
;** Initialize VRAM if requested to do so
;*/

        Mov     Cx,fInitMem             ; will be zero if to skip memory fill
        Jcxz    screen_filled

;/*
;** Clear the bit planes to their initial values (blackness):
;*/

        WaitQ   8
        outwQ   XMIN,(XMIN_2DECODE+0)   ;; set scissor to full screen
        outwQ   YMIN,(YMIN_2DECODE+0)
        Mov     Ax,sdScreen.sd_cx       ; get max x
        Dec     Ax
        outwQ   LX,Ax                   ; set width of rect
        Or      Ax,XMAX_2DECODE
        outwQ   XMAX,Ax                 ; set max scissor x extent
        Mov     Ax,sdScreen.sd_cy       ; get max y
        Dec     Ax
        outwQ   LY,Ax                   ; set height of rect
        Or      Ax,YMAX_2DECODE
        outwQ   YMAX,Ax                 ; set max scissor y extent
        Sub     Ax,Ax                   ; rectangle ul is at ul of screen
        outwQ   X0,Ax
        outwQ   Y0,Ax

        WaitQ   4
        outbQ   WRITE_ENABLE,0ffh
        .errnz  High (FUNC_2OP_COL1+FUNC_ZEROS)
        outbQ   FUNCTION_1,(FUNC_2OP_COL1+FUNC_ZEROS)
        outwQ   MODE,(MODE_2DECODE+MD_PS_ONES+MD_UP_FALSE)
        outwQ   CMD_FLAGS,(CMD_C_HRECT+CMD_FV_FIX+CMD_PA_FOUR+CMD_RW_W+CMD_MA_ACCESS+CMD_DY+CMD_DX)

screen_filled:

;/*
;** Allow video output from the DAC to the monitor
;*/

        Mov     Al,0ffh                 ; enable DAC video output
        Mov     Dx,RAMDAC_PMASK
        Out     Dx,Al

;/*
;** If there's a VDD out there, let it know if the VGA is available
;*/

        clc                             ; coming fgnd
        call    notify_vdd              ; notify the VDD, if any

;/*
;** All done, show success.
;*/

        mov     ax,1                    ; return 1 if FastSS disabled, otherwise 0
        and     ax,f8514FastSS
        mov     cx,fInitMem             ; Called from Resurrection?
        jcxz    @F                      ; Yes.
        xor     ax,ax                   ; No. First time.
@@:

enable_failed:

cEnd

page
;/***************************************************************************
;*
;* FUNCTION NAME = physical_disable
;*
;* DESCRIPTION   = Prepare for death.
;*
;*                 Registers Preserved:      
;*                       SI,DI,BP,DS         
;*                 Registers Destroyed:      
;*                       AX,BX,CX,DX,ES,FLAGS
;*                 Calls:                    
;*                       save_textvram       
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        assumes ds,Data
        assumes es,nothing

cProc   far_physical_disable,<FAR,PUBLIC,WIN,PASCAL>
cBegin
        dec     fGrimReaper             ;Make it -1
        mov     ax,INVALID_SEL
        xchg    sdScreen.sd_pBits.sel,ax
        mov     selDeathToUse,ax

;/*
;** If there's a VDD out there, let it know if the VGA is no longer available
;*/

        stc                             ; going bgnd
        call    notify_vdd              ; notify the VDD, if any
cEnd

page
;/***************************************************************************
;*
;* FUNCTION NAME = notify_vdd
;*
;* DESCRIPTION   = Prepare for death.
;*
;*                 Registers Preserved:      
;*                       SI,DI,BP,DS,ES
;*                 Registers Destroyed:      
;*                       AX,BX,CX,DX,FLAGS
;*                 Calls:                    
;*                       DosRequestVDD       
;*
;* INPUT         = Carry clear if coming fgnd, set if going bgnd 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        assumes ds,Data
        assumes es,nothing

cProc   notify_vdd,<NEAR,PUBLIC>
cBegin
        mov     ax,1
        mov     drqVideo.vvd_nbReserved.lo,ax
        dec     ax
        mov     drqVideo.vvd_nbReserved.hi,ax
        mov     drqVideo.vvd_pPhysVRAM.lo,ax
        mov     drqVideo.vvd_pPhysVRAM.hi,000Ah
        jnc     notify_ready

        mov     drqVideo.vvd_pPhysVRAM.hi,ax
        dec     ax                      ;AX == 0FFFFh
        mov     drqVideo.vvd_nbReserved.lo,ax
        mov     drqVideo.vvd_nbReserved.hi,ax

notify_ready:
        test    fbOffScreen,OFFSCR_VDD  ;is VDD open?
        jz      notify_exit             ;no

        sub     ax,ax
        farPtr  hvdd,hVideoVDD.hi,hVideoVDD.lo
        farPtr  cbInput,ax,%(size vvdrq_s)
        farPtr  pInput,ds,<DataOFFSET drqVideo>
        farPtr  cbOutput,ax,ax
        farPtr  pOutput,ax,ax
        cCall   DosRequestVDD,<hvdd,ax,VVDSYSREQ_SETDRQ,cbInput,pInput,cbOutput,pOutput>

notify_exit:
cEnd


;/*
;**==============================================================
;*/


ifdef   KLUGE

pause   Macro
        Local   lp1

        Mov     Bl,10
        Mov     Cx,0
lp1:    Loop    lp1
        Dec     Bl
        Jnz     lp1
        Endm


        public  _KlugeReset
_KlugeReset     Proc    near

        Call    INITIALISE_BOARD
        pause

;/*
;** Turn off video to monitor by disabling the output of the DAC. We don't
;** want too many visible glitches as we load the palette and perhaps clear
;** the screen.
;*/

        Sub     Al,Al                   ; turn off DAC video output
        Mov     Dx,RAMDAC_PMASK
        Out     Dx,Al

;/*
;** Load a color palette...
;*/

        cCall   LoadKColorPalette

;/*
;** Allow video output from the DAC to the monitor
;*/

        Mov     Al,0ffh                 ; enable DAC video output
        Mov     Dx,RAMDAC_PMASK
        Out     Dx,Al

        pause

;/*
;** clear the screen
;*/

        WaitQ   8
        outwQ   XMIN,(XMIN_2DECODE+0)   ;; set scissor to full screen
        outwQ   YMIN,(YMIN_2DECODE+0)
        Mov     Ax,1023
        outwQ   LX,Ax                   ; set width of rect
        Or      Ax,XMAX_2DECODE
        outwQ   XMAX,Ax                 ; set max scissor x extent
        Mov     Ax,1023                 ; get max y
        outwQ   LY,Ax                   ; set height of rect
        Or      Ax,YMAX_2DECODE
        outwQ   YMAX,Ax                 ; set max scissor y extent
        Sub     Ax,Ax                   ; rectangle ul is at ul of screen
        outwQ   X0,Ax
        outwQ   Y0,Ax

        WaitQ   5
        outwQ   COLOR_1,0               ; clear to black
        outwQ   WRITE_ENABLE,0ffh
        outwQ   FUNCTION_1,(FUNC_2OP_COL1+FUNC_S)
        outwQ   MODE,(MODE_2DECODE+MD_PS_ONES+MD_UP_FALSE)
        outwQ   CMD_FLAGS,(CMD_C_HRECT+CMD_FV_FIX+CMD_PA_FOUR+CMD_RW_W+CMD_MA_ACCESS+CMD_DY+CMD_DX)

        pause

;/*
;** fill the screen with a different color
;*/

        WaitQ   8
        outwQ   XMIN,(XMIN_2DECODE+0)   ;; set scissor to full screen
        outwQ   YMIN,(YMIN_2DECODE+0)
        Mov     Ax,1023
        outwQ   LX,Ax                   ; set width of rect
        Or      Ax,XMAX_2DECODE
        outwQ   XMAX,Ax                 ; set max scissor x extent
        Mov     Ax,1023                 ; get max y
        outwQ   LY,Ax                   ; set height of rect
        Or      Ax,YMAX_2DECODE
        outwQ   YMAX,Ax                 ; set max scissor y extent
        Sub     Ax,Ax                   ; rectangle ul is at ul of screen
        outwQ   X0,Ax
        outwQ   Y0,Ax

        WaitQ   4
        outwQ   WRITE_ENABLE,0ffh
        outwQ   FUNCTION_1,(FUNC_2OP_COL1+FUNC_ND)
        outwQ   MODE,(MODE_2DECODE+MD_PS_ONES+MD_UP_FALSE)
        outwQ   CMD_FLAGS,(CMD_C_HRECT+CMD_FV_FIX+CMD_PA_FOUR+CMD_RW_W+CMD_MA_ACCESS+CMD_DY+CMD_DX)

        pause
        cCall   RESET_BOARD_STATE

exit:
        Ret
_KlugeReset     Endp

INITIALISE_BOARD        proc    near

IB_OPEN_ADAPTER:

;/*
;**Now, set the adapter into Hi-Res mode, setting some states as we go along:
;*/

mov             dx,2eah                         ;get "open adapter" port
xor             ax,ax                           ;send out a zero
out             dx,al                           ; 
mov             dx,42e8h                        ;set state in control port
mov             ax,9000h                        ; 
out             dx,ax                           ; 
mov             ax,5000h                        ; 
out             dx,ax                           ; 
mov             ax,53h                          ; 
mov             dx,22e8h                        ;set CRTC state to "normal
out             dx,ax                           ; 
mov             ax,07h                          ;set misc I/O register
mov             dx,4ae8h                        ;to advanced function mode
out             dx,ax                           ; 
mov             ax,660h                         ;set frame total length
mov             dx,12e8h                        ; 
out             dx,ax                           ; 
mov             ax,600h                         ;set frame sync position
mov             dx,1ae8h                        ; 
out             dx,ax                           ; 
mov             ax,5fbh                         ;set frame blank start
mov             dx,16e8h                        ; 
out             dx,ax                           ; 
mov             ax,9dh                          ;set line total length
mov             dx,2e8h                         ; 
out             dx,ax                           ; 
mov             ax,81h                          ;set line sync position
mov             dx,0ae8h                        ; 
out             dx,ax                           ; 
mov             ax,7fh                          ;set line blank start
mov             dx,6e8h                         ; 
out             dx,ax                           ; 
mov             ax,16h                          ;set line sync width
mov             dx,0ee8h                        ; 
out             dx,ax                           ; 
mov             ax,08h                          ;set frame sync width
mov             dx,1ee8h                        ; 
out             dx,ax                           ; 
mov             ax,33h                          ;reset CRTC mode
mov             dx,22e8h                        ; 
out             dx,ax                           ; 

IB_1:
mov             dx,QSTATUS                  ;check status for ready
in              ax,dx                           ; 
and             ax,02h                          ;ready to do next command?
jnz             IB_1                            ;nope, wait till ready
mov             ax,5006h                        ;set config register
mov             dx,0bee8h                       ; 
out             dx,ax                           ; 
mov             al,0ffh                         ;set pixel mask in palette DAC
mov             dx,2eah                         ; 
out             dx,al                           ; 
xor             ax,ax                           ;set colour compare reg to 0
mov             dx,0b2e8h                       ; 
out             dx,ax                           ; 
mov             al,0ffh                         ;set write enable to all on
mov             dx,WRITE_ENABLE                 ; 
out             dx,ax                           ; 

ret
INITIALISE_BOARD endp
endif

sEnd    PalSeg
        End
