/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)8514.h	6.1 90/11/18";*/
/*  $Log:	8514.h,v $
 * Revision 3.1  88/06/06  12:32:00  geoffs
 * Upgrade to Rev. 4.26
 * 
 * Revision 1.1  88/02/18  08:58:24  mmm
 * Initial revision
 *  */
/*
;
; I/O port definitions for the INMOS RAMDAC:
;
;
 */
#define	RAMDAC_PMASK	0x02ea		/* pixel mask */
#define	RAMDAC_RADDR	0x02eb		/* read lut index address */
#define	RAMDAC_WADDR	0x02ec		/* write lut index address */
#define	RAMDAC_RGB	0x02ed		/* rgb data port */

/*
;
; I/O port definitions for the 8514/A Update Controller (primary decodes):
; (NOTE: We utilize the discard feature i/o ports)
;
 */
#define	Y0		0x82e8		/* src y coordinate for primitives */
#define	X0		0x86e8		/* src x coordinate for primitives */
#define	Y1		0x8ae8		/* dest y coordinate for Copy Rectangle */
#define	X1		0x8ee8		/* dest x coordinate for Copy Rectangle */

#define	K1		0x8ae8		/* Bresenham term1 for vectors */
#define	K2		0x8ee8		/* Bresenham term2 for vectors */
#define	ERR_TERM	0x92e8		/* Bresenham error term accumulator */

#define	LX		0x96e8		/* x-axis length for primitives */

#define	CMD_FLAGS	0x9ae8		/* command/flags register (w) */
#define	CMD_COMMAND	0xe000		/* command field (1110000000000000b)*/
#define	CMD_C_NULL	0x0000		/* null command (0000000000000000b) */
#define	CMD_C_VECTOR	0x2000		/* output vector (0010000000000000b) */
#define	CMD_C_HRECT	0x4000		/* horizontal rectangle (0100000000000000b) */
#define	CMD_C_VRECT	0x6000		/* vertical rectangle (0110000000000000b) */
#define	CMD_C_FRECT	0x8000		/* fast rectangle (1000000000000000b) */
#define	CMD_C_OUTLINE	0xa000		/* outline draw (1010000000000000b) */
#define	CMD_C_COPYRECT	0xc000		/* copy rectangle (1100000000000000b) */
#define	CMD_BYTEORDER	0x1000		/* byte order field (0001000000000000b) */
#define	CMD_BYTE_HILO	0x0400		/* byte hi/lo field (0000010000000000b) */
#define	CMD_BYTE_WORD	0x0200		/* byte/word field (0000001000000000b) */
#define	CMD_FIX_VAR	0x0100		/* fixed/variable data field (0000000100000000b) */
#define	CMD_FV_VAR	0x0100		/* use variable data (0000000100000000b) */
#define	CMD_FV_FIX	0x0000		/* use fixed data (0000000000000000b) */
#define	CMD_DYZX	0x00e0		/* direction flags (0000000011100000b) */
#define	CMD_DY		0x0080		/* y increment (0000000010000000b) */
#define	CMD_DZ		0x0040		/* z increment (0000000001000000b) */
#define	CMD_DX		0x0020		/* x increment (0000000000100000b) */
#define	CMD_D210	CMD_DYZX	/* coded direction flags */
#define	CMD_D2		CMD_DY
#define	CMD_D1		CMD_DZ
#define	CMD_D0		CMD_DX
#define	CMD_MOVE_ACCESS	0x0010		/* move/access flag field (0000000000010000b) */
#define	CMD_MA_MOVE	0x0000		/* move (no access of bit planes) (0000000000000000b) */
#define	CMD_MA_ACCESS	0x0010		/* access bit planes (0000000000010000b) */
#define	CMD_CODED_DIR	0x0008		/* coded direction flag (0000000000001000b) */
#define	CMD_CD_ANGLED	0x0000		/* direction flags == DYZX (0000000000000000b) */
#define	CMD_CD_45	0x0008		/* direction flags == D210 (0000000000001000b) */
#define CMD_LAST_PEL_NUL 0x0004		/* draw last pel field (0000000000000100b) */
#define	CMD_LP_NULL	0x0004		/* don't draw last pel (0000000000000100b) */
#define	CMD_LP_DRAW	0x0000		/* draw last pel (0000000000000000b) */
#define	CMD_PEL_ACCRUAL	0x0002		/* pel accrual field (0000000000000010b) */
#define	CMD_PA_FOUR	0x0002		/* r/w 4 pels at a time (0000000000000010b) */
#define	CMD_PA_ONE	0x0000		/* r/w 1 pel at a time (0000000000000000b) */
#define	CMD_RW		0x0001		/* r/w bit planes (0000000000000001b) */
#define	CMD_RW_R	0x0000		/* read bit planes (0000000000000000b) */
#define	CMD_RW_W	0x0001		/* write bit planes (0000000000000001b) */

#define	QSTATUS		0x9ae8		/* queue status register (r) */
#define	QS_AFC_OPTION	0x8000		/* AFC option installed field (1000000000000000b) */
#define	QS_BUSY		0x0200		/* reset when input queue empty (0000001000000000b) */
#define	QS_R_Q_STAT	0x0100		/* data available in read queue (0000000100000000b) */
#define	QS_W_Q_STAT	0x00ff		/* # words in write queue field (0000000011111111b) */
#define	QS_W_Q_FULL	0x00ff		/* write queue is full (0000000011111111b) */

#define	SHORTSTROKE	0x9ee8		/* short stroke data (w) */
#define	SS_D012		0xe0		/* coded direction flag fields (11100000b) */
#define	SS_MOVE_ACCESS	0x10		/* move/access field (00010000b) */
#define	SS_LX		0x0f		/* length of short stroke field (00001111b) */

#define	COLOR_0		0xa2e8		/* background color (r/w) */
#define COLOR_0_WAIT	0xe2e8		/* COLOR 0 wait port */
#define	COLOR_1		0xa6e8		/* foreground color (r/w) */

#define	WRITE_ENABLE	0xaae8		/* plane write enable register (w) */
#define	READ_ENABLE	0xaee8		/* plane read enable register (w) */

#define	COLOR_COMP	0xb2e8		/* color comparison register (w) */

#define	FUNCTION_0	0xb6e8		/* background mix (w) */
#define	FUNCTION_1	0xbae8		/* foreground mix (w) */
#define	FUNC_2OPSRC	0x60		/* second operand src field (w) (1100000b) */
#define	FUNC_2OP_COL0	0x00		/* second operand src is COLOR_0 (0000000b) */
#define	FUNC_2OP_COL1	0x20		/* second operand src is COLOR_1 (0100000b) */
#define	FUNC_2OP_VAR	0x40		/* second operand src is variable data (1000000b) */
#define	FUNC_2OP_COPY	0x60		/* second operand src is copy rectangle (1100000b) */
#define	FUNC_ALU	0x1f		/* ALU function (mix mode, w) (0011111b) */
#define	FUNC_ND		0x00		/* ~dest -> dest (0000000b) */
#define	FUNC_ZEROS	0x01		/* 0s -> dest (0000001b) */
#define	FUNC_ONES	0x02		/* 1s -> dest (0000010b) */
#define	FUNC_D		0x03		/* dest -> dest (0000011b) */
#define	FUNC_NS		0x04		/* ~src -> dest (0000100b) */
#define	FUNC_S_XOR_D	0x05		/* src xor dest -> dest (0000101b) */
#define	FUNC_S_XNOR_D	0x06		/* src xnor dest -> dest (0000110b) */
#define	FUNC_S		0x07		/* src -> dest (0000111b) */
#define	FUNC_NS_OR_ND	0x08		/* ~src or ~dest -> dest (0001000b) */
#define	FUNC_NS_OR_D	0x09		/* ~src or dest -> dest (0001001b) */
#define	FUNC_S_OR_ND	0x0a		/* src or ~dest -> dest (0001010b) */
#define	FUNC_S_OR_D	0x0b		/* src or ~dest -> dest (0001011b) */
#define	FUNC_S_AND_D	0x0c		/* src and dest -> dest (0001100b) */
#define	FUNC_S_AND_ND	0x0d		/* src and ~dest -> dest (0001101b) */
#define	FUNC_NS_AND_D	0x0e		/* ~src and dest -> dest (0001110b) */
#define	FUNC_NS_AND_ND	0x0f		/* ~src and ~dest -> dest (0001111b) */
#define	FUNC_MIN_S_D	0x10		/* min(src,dest) -> dest (0010000b) */
#define	FUNC_D_SUB_S	0x11		/* dest - src -> dest (0010001b) */
#define	FUNC_S_SUB_D	0x12		/* src - dest -> dest (0010010b) */
#define	FUNC_D_ADD_S	0x13		/* src + dest -> dest (0010011b) */
#define	FUNC_MAX_S_D	0x14		/* max(src,dest) -> dest (0010100b) */
#define	FUNC_D_SUB_S_2	0x15		/* (dest - src)/2 -> dest (0010101b) */
#define	FUNC_S_SUB_D_2	0x16		/* (src - dest)/2 -> dest (0010110b) */
#define	FUNC_D_ADD_S_2	0x17		/* (src + dest)/2 -> dest (0010111b) */
#define	FUNC_D_SUBS_S	0x19		/* dest - src -> dest w/saturate (0011001b) */
#define	FUNC_S_SUBS_D	0x1a		/* src - dest -> dest w/saturate (0011010b) */
#define	FUNC_D_ADDS_S	0x1b		/* src + dest -> dest w/saturate (0011011b) */
#define	FUNC_D_SUBS_S_2	0x1d		/* (dest - src)/2 -> dest w/saturate (0011101b) */
#define	FUNC_S_SUBS_D_2	0x1e		/* (src - dest)/2 -> dest (0011110b) */

#define	SECOND_DECODE	0xbee8		/* secondary decodes */

#define	CNTL_STATUS	0x42e8		/* control/status register */
#define	CS_RESET_CNTL	0xc000		/* reset control field (w) (1100000000000000b) */
#define	CS_R_NULL	0x0000		/* null effect (0000000000000000b) */
#define	CS_R_NORMAL	0x4000		/* update controller normal operation (0100000000000000b) */
#define	CS_R_RESET	0x8000		/* reset update controller (1000000000000000b) */
#define CS_TESTMODE_CNTL 0x2000		/* test mode control field (w) (0010000000000000b) */
#define	CS_T_NULL	0x0000		/* null effect (0000000000000000b) */
#define	CS_T_NORMAL	0x1000		/* normal mode (0001000000000000b) */
#define	CS_T_TESTMODE	0x2000		/* test mode (0010000000000000b) */
#define	CS_INTMASK	0x0f00		/* interrupt mask field (w) (0000111100000000b) */
#define	CS_I_OPDONE	0x0800		/* op completed interrupt (0000100000000000b) */
#define	CS_I_OVERRUN	0x0400		/* queue overrun interrupt (0000010000000000b) */
#define	CS_I_CORRELATE	0x0200		/* correlation interrupt (0000001000000000b) */
#define	CS_I_VRETRACE	0x0100		/* frame flyback interrupt (0000000100000000b) */
#define	CS_MISR		0xff00		/* diagnostic MISR bits (r) (1111111100000000b) */
#define	CS_OPTIONS	0x00f0		/* hardware options field (r) (0000000011110000b) */
#define	CS_O_4PLANES	0x0080		/* 4-bit plane extension installed (r) (0000000010000000b) */
#define	CS_O_MONITORS	0x0070		/* monitor id field (r) (0000000001110000b) */
#define	CS_O_LORES_MONO	0x0010		/* 640x480 mono monitor (0000000000010000b) */
#define	CS_O_LORES_COL	0x0020		/* 640x480 color monitor (0000000000100000b) */
#define	CS_O_HIRES_MONO	0x0050		/* 1024x768 mono monitor (0000000001010000b) */
#define	CS_O_HIRES_COL	0x0060		/* 1024x768 color monitor (0000000001100000b) */
#define	CS_O_NONE	0x0070		/* no monitor attached (0000000001110000b) */
#define	CS_OPDONE	0x0008		/* op complete (r/w) (0000000000001000b) */
#define	CS_OVERRUN	0x0004		/* queue overrun field (r/w) (0000000000000100b) */
#define	CS_CORRELATE	0x0002		/* correlate status (r/w) (0000000000000010b) */
#define	CS_VRETRACE	0x0001		/* frame flyback status (0000000000000001b) */

#define	PROM_PAGE	0x46e8		/* prom page select register */

#define	MISC_IO		0x4ae8		/* miscellaneous i/o register */
#define	MI_PELCLK	0x04		/* pel clock rate (00000100b) */
#define	MI_PELCLK_640	0x00		/* pel clock for 640 wide (00000000b) */
#define	MI_PELCLK_1024	0x04		/* pel clock for 1024 wide (00000100b) */
#define	MI_AF_MODE	0x01		/* advanced function mode select (00000001b) */
#define	MI_AF_VGA	0x00		/* VGA has control (00000000b) */
#define	MI_AF_AFC	0x01		/* 8514A has control (00000001b) */

#define	ADAPTER_ID	0x0100		/* adapter id register */
#define	ADAPTER_ENABLE	0x0102		/* adapter enable register */

/*
;
; I/O port definitions for the 8514/A Update Controller (secondary decodes):
; (NOTE: We utilize the discard feature i/o ports)
;
 */
#define	LY		0xbee8		/* y-axis length for primitives (w) */
#define	LY_2DECODE	0x0000		/* secondary decode (0000000000000000b) */

#define	YMIN		0xbee8		/* scissor min y (w) */
#define	YMIN_2DECODE	0x1000		/* secondary decode (0001000000000000b) */

#define	XMIN		0xbee8		/* scissor min x (w) */
#define	XMIN_2DECODE	0x2000		/* secondary decode (0010000000000000b) */

#define	YMAX		0xbee8		/* scissor max y (w) */
#define	YMAX_2DECODE	0x3000		/* secondary decode (0011000000000000b) */

#define	XMAX		0xbee8		/* scissor max x (w) */
#define	XMAX_2DECODE	0x4000		/* secondary decode (0100000000000000b) */

#define	CONFIG		0xbee8		/* configuration (w) */
#define	CONFIG_2DECODE	0x5000		/* secondary decode (0101000000000000b) */
#define	CFG_UPDATE_BANK	0x10		/* chooses 1k vs 512 line modes (w) (10000b) */
#define	CFG_VRAM_BANK	0x0c		/* vram bank select field (w) (01100b) */
#define	CFG_VRAM_1024	0x04		/* value for 1k line mode (00100b) */
#define	CFG_VRAM_512	0x00		/* value for 512 line mode (00000b) */
#define	CFG_INTERLEAVE	0x02		/* interleave field (w) (00010b) */
#define	CFG_WORDWIDTH	0x01		/* wordwidth field (w) (00001b) */

#define	PATTERN_0	0xbee8		/* pattern 0 register (w) */
#define PATTERN_0_2DECODE 0x8000	/* secondary decode (1000000000000000b) */
#define	PATTERN_0_DATA	0x1e		/* lo 4 bits pattern field (00011110b) */

#define	PATTERN_1	0xbee8		/* pattern 1 register (w) */
#define PATTERN_1_2DECODE 0x9000	/* secondary decode (1001000000000000b) */
#define	PATTERN_1_DATA	0x1e		/* hi 4 bits pattern field (00011110b) */

#define MODE		0xbee8		/* mode register (w) */
#define	MODE_2DECODE	0xa000		/* secondary decode (1010000000000000b) */
#define	MD_PATT_SRC	0xc0		/* pattern source select field (11000000b) */
#define	MD_PS_ONES	0x00		/* pattern = ONEs (00000000b) */
#define	MD_PS_PATT	0x40		/* pattern = PATTERN_0,PATTERN_1 regs (01000000b) */
#define	MD_PS_VAR	0x80		/* pattern = variable data (10000000b) */
#define	MD_PS_COPY	0xc0		/* pattern = copy rectangle (read phase) (11000000b) */
#define	MD_UNDERPAINT	0x38		/* underpaint control field (00111000b) */
#define	MD_UP_FALSE	0x00		/* always false (00000000b) */
#define	MD_UP_TRUE	0x08		/* always true (00001000b) */
#define	MD_UP_GE	0x10		/* plane data >= color compare (00010000b) */
#define	MD_UP_LT	0x18		/* plane data <  color compare (00011000b) */
#define	MD_UP_NE	0x20		/* plane data != color compare (00100000b) */
#define	MD_UP_EQ	0x28		/* plane data == color compare (00101000b) */
#define	MD_UP_LE	0x30		/* plane data <= color compare (00110000b) */
#define	MD_UP_GT	0x38		/* plane data >  color compare (00111000b) */
#define	MD_AREAFILL	0x06		/* area fill control field (00000110b) */
#define	MD_AF_W_NORMAL	0x00		/* normal operation for writes (00000000b) */
#define	MD_AF_R_THRU	0x00		/* thru planes for reads (00000000b) */
#define	MD_AF_W_SPP	0x04		/* special plane fill for writes (00000100b) */
#define	MD_AF_R_ACROSS	0x04		/* across planes for reads (00000100b) */
#define	MD_AF_W_SPC	0x06		/* special color fill for writes (00000110b) */
#define	MD_WORDWIDTH	0x01		/* word width field (00000001b) */

/*
;
; I/O port definitions for the 8514/A Display Controller:
;
 */
#define	LINE_TOTAL	0x02e8		/* line total length */
#define	LINE_BLANK	0x06e8		/* line blank start */
#define	LINE_SYNC_POS	0x0ae8		/* line sync position */
#define	LINE_SYNC_WIDE	0x0ee8		/* line sync width */
#define	FRAME_TOTAL	0x12e8		/* frame total length */
#define	FRAME_BLANK	0x16e8		/* frame blank start */
#define	FRAME_SYNC_POS	0x1ae8		/* frame sync position */
#define	FRAME_SYNC_WIDE	0x1ee8		/* frame sync width */

#define	CRTC_MODE	0x22e8		/* crtc mode */
#define	CRTM_RESET	0x60		/* crtc reset field (01100000b) */
#define	CRTM_R_NULL	0x00		/* no effect (00000000b) */
#define	CRTM_R_NORMAL	0x20		/* normal operation (00100000b) */
#define	CRTM_R_RESET	0x40		/* reset crt controller (01000000b) */
#define	CRTM_INTERLACE	0x10		/* interlace field (00010000b) */
#define	CRTM_VREPL	0x08		/* vertical replication (00001000b) */
#define	CRTM_VRAM_BANK	0x03		/* vram bank select field (00000110b) */
#define	CRTM_VB_1024	0x02		/* vram bank select for 1024 lines (00000010b) */
#define	CRTM_VB_512	0x00		/* vram bank select for 512 lines (00000000b) */
#define	CRTM_INTERLEAVE	0x01		/* interleave mode (00000001b) */

#define	CRTC_STATUS	0x02e8		/* crtc status */

/*
;
; Macros to access the hardware:
;
 */


/*
; WaitIO
; ------
; General purpose macro to sit on an i/o port and test for a particular value:
;
;	p:		port # to be polled. If not present then it is assumed
;			that the port # has already been loaded into Dx.
;
;	s:		sense of jump needed to remain in polling loop.
;
;	m:		the value that will be and'ed with the
;			polled contents of Port.
;
;	e:		the value that must match the Port
;			contents, after masking
;
 */
#define WaitIO(p,m,e) while ((inpw (p) & m) == e)
#define WaitIONot(p,m,e) while ((inpw (p) & m) != e)


/*
; WaitQ
; -----
; Special purpose macro to wait for the 8514A adapter's input queue to have
; a minimum # of words of free space. The queue is up to 8 words deep and
; at any time the # words still to be dequeued can be ascertained.
;
;	s:		fall out of wait loop if at least this many words are
;			available in the queue. This parameter must be present.
;
 */
#define WaitQ(s) WaitIONot (QSTATUS, (0x80 >> (s - 1)), 0)

/*
; outwQ
; -----
; Special purpose macro to output a word value to the 8514A input queue.
;
;	Port:		port # for which data that is written will be queued.
;			If this parameter is not present the port # will be
;			assumed to already have been loaded into Dx.
;
;	Data:		immediate or indirect specification of data that will
;			be output to Port. If this parameter is not present
;			the data will be assumed to already have been loaded
;			into the Ax register.
;
 */
#define outwQ(p,d) outpw(p,d)

/*
; outbQ
; -----
; Special purpose macro to output a byte value to the 8514A input queue. This
; macro differs from outwQ in that it is assumed that only the low half of the
; Ax register needs to be loaded. A slight saving in code size is thereby
; achieved.
;
;	Port:		port # for which data that is written will be queued.
;			If this parameter is not present the port # will be
;			assumed to already have been loaded into the Dx register
;
;	Data:		immediate or indirect specification of data that will
;			be output to Port. If this parameter is not present
;			the data will be assumed to already have been loaded
;			into the Ax register.
;
;	SaveRegs:	parameter is present if registers used in polling are
;			to be saved and restored, the actual content of this
;			parameter is ignored, only its presence matters.
;
 */
#define outbQ(p,d) outp(p,d)

/*
; LoadPattern
; -----------
; Load the 8514/A pattern registers with an 8 bit pattern value. The macro
; shields us from the fact that an 8 bit pattern gets loaded into the 8514/A
; as two 4 bit values, each half shifted up 1 bit, and sent out to independent
; ports.
;
;	Pattern:	8 bit pattern to be loaded. If not present then it is
;			assumed that the pattern is already loaded into Al.
;
 */
#define LoadPattern(p)\
    outpw(PATTERN_0, PATTERN_0_2DECODE | ((p & 0x000f) << 1));\
    outpw(PATTERN_1, PATTERN_1_2DECODE | (((p >> 4) & 0x000f) << 1))
