;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = polyline.inc
;*
;* DESCRIPTIVE NAME = Contains equates used by Polyline. 
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/30/87
;*
;* DESCRIPTION  
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/30/87                     Written by Kent Settle
;*****************************************************************************/


DEST_IS_BITMAP  equ     00000000b                ;Device is bitmap.
DEST_IS_DEV     equ     10000000b                ;Device is the screen (us)
DEST_IS_HUGE    equ     01000000b                ;Device is a huge bitmap
;               equ     00100000b
CALLED_BY_DRAWLINE equ  00010000b                ;called by drawline flag.
DRAW_ONE_PEL    equ     00001000b                ;draw last point of line?
;               equ     00000100b
;               equ     00000010b
DEST_IS_COLOR   equ     00000001b                ;Device is color

HYPOTENUSE      equ     61
Y_MAJOR_DIST    equ     48
X_MAJOR_DIST    equ     38
Y_MINOR_DIST    equ     HYPOTENUSE - X_MAJOR_DIST
X_MINOR_DIST    equ     HYPOTENUSE - Y_MAJOR_DIST
;MAX_STYLE_ERR  equ     2 * HYPOTENUSE
MAX_STYLE_ERR   equ     0100h

;/*
;** The following bit indexes are combined to index into the previous
;** axis update tables.  The placement of the entries are dependant
;** on these indexes.  If one changes, so must the other.
;*/

Y_MAJOR         equ     00000001b                ;Y is the major axis
DIAGONAL        equ     00000010b                ; stepping along a diagonal
STEP_UP         equ     00000100b                ;The DDA is stepping up
VERTICAL        equ     4
STEP_LEFT       equ     00001000b                ;The DDA is stepping right
HUGE_UPDATE     equ     01000000b                ;Huge bitmap update

CASE_TABLE_MASK equ     00000011b                ; only worry about diagonal + y major.

BITMAP_DO_NOTHING   equ 00h

ONLY_ONE_PLANE  equ     01
RASTER_OP_MASK  equ     000Fh
PARTIAL_BYTE_MASK equ   00000111b

MAX_STANDARD_STYLE      equ                      8   ; maximum standard line style.
MIN_USER_LINE_STYLE     equ                      65  ; min user defined line style.
MAX_USER_LINE_STYLE     equ                      254 ; max user defined line style.
SOLID_STYLE_MASK        equ                      0FFh
LINE_IS_SOLID           equ                      6   ;LINETYPE_SOLID-1!!!!

LEFT_TABLE_JUMP         equ                      6
STYLE_TABLE_JUMP        equ                      12


round_ax_colon_bx macro
        cwd
        add     dx,8000h
        add     bx,dx
        adc     ax,0
endm

;/*
;** fsLineFlags
;*/

LF_LEFT_XCHG            equ                      0001h
LF_XY_XCHG              equ                      0002h
LF_HALF_FLIP            equ                      0004h
LF_Y_FLIP               equ                      0008h
LF_VERTICAL_FLIP        equ                      0100h

;/*
;** fsPolyFlags
;*/

PF_BETTER_CLIP          equ                      0001h
PF_DRAW_FIRST_PEL       equ                      0002h
PF_DOING_BACKGROUND     equ     0004h

;/*
;** clipped line information
;*/

LINESEGMENT     struc
lsg_rcsClip     db      (SIZE RECTS) dup(?)
lsg_xStart      dw      ?
lsg_yStart      dw      ?
lsg_fsLineFlags dw      ?
lsg_xA          dw      ?
lsg_xB          dw      ?
lsg_cdx         dw      ?
lsg_cdy         dw      ?
LINESEGMENT     ends
