;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = OEMBLT.INC
;*
;* DESCRIPTIVE NAME = oem bitblt function definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  Parameters and data passed to the oem bitblt function 
;*
;* FUNCTIONS    NONE
;*              
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

;/*
;** The gray rop codes
;*/

GRAY_ROP        equ     80CAh                     ;At the API level

;/*
;** The Device Bitmap as a bitblt source
;*/

BLTMODE_SRC_HDBM equ    00100000h                 ;At the DDI level
BLTMODE_SCR_DRAW equ    00200000h                 ;At the DDI level

;/*
;**  flag values for obba_fs
;** 
;**  Note: BBF_TRANS_NO_CC is a qualifier for BBF_TRANS and BBF_ANTI_TRANS.
;**        If has no meaning by itself.
;*/

BBF_SRC_BITMAP  equ     0001h                     ;Source is a bitmap
BBF_HAVE_SOURCE equ     0002h                     ;A source is required
BBF_GRAY_ROP    equ     0004h                     ;Rop is the gray rap
BBF_SAME_SD     equ     0008h                     ;Source and dest are same surfaces
BBF_REVERSE_BMP equ     0010h                     ;A standard format bitmap's order is reverse
BBF_STRETCHBLT  equ     0020h                     ;require stretchblt
BBF_COLOR_SRC   equ     0040h                     ;Source is color
BBF_CMEM_TO_SCR equ     0080h                     ;color memory to screen blt
;**             equ     0100h
;**             equ     0200h
;**             equ     0400h
;**             equ     0800h
BBF_IMAGE_DATA  equ     1000h                     ;This blt is an image data blt
BBF_TRANS_NO_CC equ     2000h                     ;Transparency without color conversion
BBF_ANTI_TRANS  equ     4000h                     ;Anti-transparency needed
BBF_TRANS       equ     8000h                     ;Transparency needed


;/*
;** Return codes from oem bitblt
;*/

BBRC_SKIP_PASS_TWO      equ                      5AA5h ;Skip pass two of image data
BBRC_NORMAL             equ                      0001h ;Normal return code


;/*
;** The actual frame for oem bitblt
;*/

OBB_ARGS        struc
ifdef PALMGR
obba_pmappal    dd      ?
endif
obba_fsBlt      dw      ?
obba_ipcBkgnd   dw      ?
obba_usMix      dw      ?
obba_cyExt      dw      ?
obba_cxExt      dw      ?
obba_ySrc       dw      ?
obba_xSrc       dw      ?
obba_psdSrc     dd      ?
obba_yDst       dw      ?
obba_xDst       dw      ?
obba_pddcDst    dd      ?
OBB_ARGS        ends


;/*
;** Parameters and data passed to the oem strblt function
;*/

eto_args                struc
eto_Options             dw                       ?
eto_lpOpaqueRect        dd                       ?
eto_lpDX                dd                       ?
eto_npAttrs             dw      ?
eto_count               dw                       ?
eto_lpString            dd                       ?
eto_lpClipRect          dd                       ?
eto_y                   dw                       ?
eto_x                   dw                       ?
eto_lpDestDev           dd                       ?
eto_lpDDC               dd      ?
eto_args                ends

;/*
;** The actual frame for OemDrawBits
;*/

ODB_ARGS        struc
odba_cyExt      dw      ?
odba_cxExt      dw      ?
odba_ySrc       dw      ?
odba_xSrc       dw      ?
odba_psdSrc     dd      ?
odba_yDst       dw      ?
odba_xDst       dw      ?
odba_pddcDst    dd      ?
ODB_ARGS        ends

        .errnz  (size OBB_ARGS)-(size ODB_ARGS)-obba_cyExt
        .errnz  obba_cyExt   -odba_cyExt       -obba_cyExt
        .errnz  obba_cxExt   -odba_cxExt       -obba_cyExt
        .errnz  obba_ySrc    -odba_ySrc        -obba_cyExt
        .errnz  obba_xSrc    -odba_xSrc        -obba_cyExt
        .errnz  obba_psdSrc  -odba_psdSrc      -obba_cyExt
        .errnz  obba_yDst    -odba_yDst        -obba_cyExt
        .errnz  obba_xDst    -odba_xDst        -obba_cyExt
        .errnz  obba_pddcDst -odba_pddcDst     -obba_cyExt

;/*
;** The actual frame for OemStrchBlt
;*/


OSB_ARGS        struc
ifdef PALMGR
osba_pmappal    dd      ?
endif
osba_cyExt      dw      ?
osba_cxExt      dw      ?
osba_lpParm     dd      ?
osba_psdSrc     dd      ?
osba_yDst       dw      ?
osba_xDst       dw      ?
osba_pddcDst    dd      ?
OSB_ARGS        ends

ifdef   PALMGR
        .errnz  (size OBB_ARGS)-(size OSB_ARGS)-obba_cyExt+4
        .errnz  obba_cyExt   -osba_cyExt       -obba_cyExt+4
        .errnz  obba_cxExt   -osba_cxExt       -obba_cyExt+4
        .errnz  obba_ySrc    -osba_lpParm      -obba_cyExt+4
        .errnz  obba_psdSrc  -osba_psdSrc      -obba_cyExt+4
        .errnz  obba_yDst    -osba_yDst        -obba_cyExt+4
        .errnz  obba_xDst    -osba_xDst        -obba_cyExt+4
        .errnz  obba_pddcDst -osba_pddcDst     -obba_cyExt+4
else
        .errnz  (size OBB_ARGS)-(size OSB_ARGS)-obba_cyExt
        .errnz  obba_cyExt   -osba_cyExt       -obba_cyExt
        .errnz  obba_cxExt   -osba_cxExt       -obba_cyExt
        .errnz  obba_ySrc    -osba_lpParm      -obba_cyExt
        .errnz  obba_psdSrc  -osba_psdSrc      -obba_cyExt
        .errnz  obba_yDst    -osba_yDst        -obba_cyExt
        .errnz  obba_xDst    -osba_xDst        -obba_cyExt
        .errnz  obba_pddcDst -osba_pddcDst     -obba_cyExt
endif;  PALMGR


;/*
;** The stretchBlt parameter's structure pointed by osba_lpParm
;*/


STBLT   struc
stb_lpRectl     dd      ?
stb_xSrcDel     dw      ?
stb_ySrcDel     dw      ?
stb_xDstDel     dw      ?
stb_yDstDel     dw      ?
STBLT   ends
