;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = MAJOR0B.ASM
;*
;* DESCRIPTIVE NAME = Control Functions
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/05/87
;*
;* DESCRIPTION  Control Functions
;*
;* FUNCTIONS  Public: QueryCharCorr
;*                    GetPickWindow
;*                    SetPickWindow
;*                    far_recalc_correlate_rect,                                                                   
;*                    recalc_correlate_rect
;*                    correlate_for_rect_si
;*                    far_correlate_for_point_si                                                                   
;*                    correlate_for_point_si
;*                    intersect_rcl
;*                    intersect_with_corr
;* NOTES        NONE                            
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/05/87                     Hock Lee [hockl] Created program
;*                                                 Wrote GetPickWindow
;*                                                 Wrote SetPickWindow
;*                                                 Wrote recalc_correlate_rect
;*   10/06/87                     Hock Lee [hockl] Wrote QueryCharCorr
;*                                                 Modified correlate_for_point_si
;*   05/22/87                     Walt Moore [waltm]
;*                                Wrote correlate_for_point_si
;*   12/05/87                     Hock Lee [hockl] No longer clip pick window 
;*                                against graphics fields and viewing limit
;*                                since all correlations will be done against clip 
;*                                regions which include them.
;*   03/05/88                     Mike Harrington [mikehar]
;*                                Stole this routine from the engine and made it
;*                                work correctly.
;*                                Wrote intersect_with_corr
;*   02/01/88                     Charles Whitmer [chuckwh] Wrote intersect_rcl
;*   06/17/91                     Hock Lee [hockl] Allow full 16 bit coordinates 
;*                                pick window in device space. Truncate pick window 
;*                                if overflow is the result of DC origin offset.
;*   11/25/91                     Re-Written by Micrografx
;*
;*****************************************************************************/


        .286p
        .xlist
        include cmacros.inc
INCL_GRE_PICK           equ                      1
INCL_GRE_XFORMS         equ                      1
INCL_DDICOMFLAGS        equ                      1
        include pmgre.inc
        include driver.inc
        include display.inc
        include assert.mac
        include njmp.mac
        .list

        errcode <INV_PICK_APERTURE_POSN,INV_IN_PATH,INV_IN_AREA>

sBegin  Code
assumes cs,Code
        externNP        enter_driver
        externNP        leave_driver
        externNP        convert_device_screen
        externNP        convert_page_device
        externNP        convert_screen_world
sEnd    Code

sBegin  FarCode
assumes cs,FarCode

        externW         FarCodeData

        externNP        truncate_rectl            ; RECT.ASM

ifdef USECHARCORR
page

;/***************************************************************************
;*
;* FUNCTION NAME = QueryCharCorr   
;*
;* DESCRIPTION   = This function returns an offset indicating which character 
;*                 within a character string was selected, the last time a 
;*                 character string primitive returned a successful correlation hit.  
;*                 If more than one character in the string was selected, the 
;*                 offset of the first is returned.                                                               
;*                                                                                         
;*                 A value of zero indicates the first character in the string.  
;*                 A negative value indicates that no string has been correlated on.                  
;*
;*                 Registers Destroyed:
;*                         AX,BX,CX,DX,ES
;*
;* INPUT         = C Prototype:                                                              
;*                   LONG _syscall QueryCharCorr (HDC hdc, PVOID pInstance, 
;*                                                ULONG lFunction);
;*                                                                                           
;*                    where:                                                                 
;*                      hdc --> DDC                                                          
;*                      pInstance --> Instance data                                          
;*                      lFunction  -  HOW = Flags, LOW = Function                            
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = offset if hit
                        -2 if no hit. 
;* RETURN-ERROR  = AX = -1
;**************************************************************************/

        check   QueryCharCorr,<hdc,hddc,FunN>

        assumes ds,nothing
        assumes es,nothing

cProc   QueryCharCorr,<PUBLIC,FAR,NODATA>,<di,si>

        parmD   hdc
        parmD   hddc
        parmD   FunN

cBegin

;/*
;*/

        mov     ds,FarCodeData
        assumes ds,Data
        mov     si,hddc.lo                        ; DS:SI --> ddc
        mov     ax,[si].ddc_char_corr_offset
        cwd
        mov     cx,ax
cEnd

endif;USECHARCORR

page

;/***************************************************************************
;*
;* FUNCTION NAME = GetPickWindow 
;*
;* DESCRIPTION   = This function is invoked from the dispatch table in response to a
;*                 call to the GreGetPickWindow function and returns the position 
;*                 and size of the pick window, in page coordinate space.
;*
;*                 Registers Destroyed:
;*                         AX,BX,CX,DX,ES
;*                
;* INPUT         = lpPickWindow    The address at which to return an array
;*                                 containing the minimum and maximum xy coordinate
;*                                 pairs of the window:
;*                                 (s32_xmin, s32_ymin, s32_xmax, s32_ymax).
;*
;* OUTPUT        = None
;*
;* RETURN-NORMAL = AX = 1 
;* RETURN-ERROR  = AX = 0
;*
;**************************************************************************/

        check   GetPickWindow,<hdc,prcl,hddc,ulFunN>

        assumes ds,nothing
        assumes es,nothing

cProc   GetPickWindow,<PUBLIC,FAR,NODATA>,<di,si>

        parmD   hdc
        parmD   lpPickWindow
        parmD   hddc
        parmD   FunN

cBegin
        cld
        mov     ds,FarCodeData
        assumes ds,Data
        mov     si,hddc.lo                        ; DS:SI --> ddc
        mov     dx,si
        call    enter_driver
        jc      gpw_exit_no_lock                  ; DX:AX = 0 on error

        les     di,lpPickWindow                   ; ES:DI = lpPickWindow
        assumes es,nothing
        CPUMode 386
        lgs     si,[si].ddc_prddc
        assumes gs,nothing
        rddc?   gs,si
        add     si,rddc_rclPick                   ; DS:SI --> ddc_pick_window
        mov     cx,(size RECTL) / 4
        .errnz  (size RECTL) and 3
        rep     movs dword ptr es:[di],dword ptr gs:[si]

        CPUMode 286
        mov     ax,1                              ; show succes

GetPickWindow_exit:
        cwd
        call    leave_driver
gpw_exit_no_lock:
        mov     cx,ax
cEnd

sEnd    FarCode


sBegin  Code
assumes cs,Code

        externW CodeData

;/***************************************************************************
;*
;* FUNCTION NAME = SetPickWindow
;*
;* DESCRIPTION   = This sets the position and size of the pick window, in page  
;*                 coordinate space, for subsequent correlation operations.     
;*                 The boundary of the pick window is included in the area      
;*                 correlated upon.                                             
;*                 The driver is responsible for keeping the pick window.  It must 
;*                 be maintained in PAGE coordinates so that there is no round off 
;*                 error between a SetPickWindow and a GetPickWindow.              
;*                                                                                 
;*                 The driver's internal convention is that we ONLY use the current
;*                 pick window in SCREEN coordinates, which are clipped to viewing 
;*                 limits and graphics field and kept in ddc_corr_rect.            
;*                 The ddc_fb[0] byte will have the DDC_CORR_INV                   
;*                 bit set if the clip region changes.                             
;*
;*                 Registers Destroyed:  
;*                         AX,BX,CX,DX,ES
;*
;* INPUT         = lpPickWindow - Points to an array containing the minimum
;*                       and maximum xy coordinate pairs of the window:
;*                       (s32_xmin, s32_ymin, s32_xmax, s32_ymax).
;*                       The data in the array may be overwritten.
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = 1 
;* RETURN-ERROR  = AX = 0 (ERROR_WINDOW_LIMS_OUTSIDE_PAGE) 
;*
;**************************************************************************/

        check   SetPickWindow,<hdc,prcl,hddc,ulFunN>

        assumes ds,nothing
        assumes es,nothing

cProc   SetPickWindow,<PUBLIC,FAR,NODATA>,<di,si>

        parmD   hdc
        parmD   lpPickWindow
        parmD   hddc
        parmD   FunN

        localV  CorrRect,%(size RECTL)
        localV  ViewLimits,%(size RECTL)
        localV  GraphicsField,%(size RECTL)

cBegin
ifdef FIREWALLS
;/*
;** Since GPI will not call us with     rectangle, we have a firewall instead
;*/
     les     bx,lpPickWindow
        assumes es,nothing
        mov     ax,es:[bx].rcl_xRight.lo          ; make sure right >= left
        mov     dx,es:[bx].rcl_xRight.hi
        sub     ax,es:[bx].rcl_xLeft.lo
        sbb     dx,es:[bx].rcl_xLeft.hi
        jns     pick_window_x_ok
        rip     text,<bad pick window>
pick_window_x_ok:
        mov     ax,es:[bx].rcl_yTop.lo            ; make sure top >= bottom
        mov     dx,es:[bx].rcl_yTop.hi
        sub     ax,es:[bx].rcl_yBottom.lo
        sbb     dx,es:[bx].rcl_yBottom.hi
        jns     pick_window_y_ok
        rip     text,<bad pick window>
pick_window_y_ok:
endif

        cld
        mov     ds,CodeData
        assumes ds,Data
        mov     dx,hddc.lo
        call    enter_driver
        njc     spw_exit_no_lock                 ; DX:AX = 0 on error

        no_path_area    SetPickWindow_exit,both

;/*
;**  transform the coordinates in local space
;**  so we don't wipe out what we were passed in.
;*/

        lds     si,lpPickWindow
        assumes ds,nothing
        lea     di,CorrRect                       ; ES:DI -> CorrRect
        mov     cx,ss
        mov     es,cx
        assumes es,nothing
        mov     cx,(size RECTL) / 2
        rep     movsw                             ; fill in temporary rectangle

        mov     ds,CodeData                       ; restore segment value
        assumes ds,Data
        mov     si,hddc.lo                        ; DS:SI = DDC

;/*
;**  transform pick window to DEVICE coordinates
;*/

        lea     di,CorrRect                       ; SS:DI -> CorrRect
        farPtr  lp_rect,ss,di
        cCall   convert_page_device,<lp_rect,2> ; DS:SI = ddc
        or      ax,ax
        njz     SetPickWindow_exit               ; return error

;/*
;**  transform pick window to SCREEN coordinates
;**  if there is an overflow caused by DC origin offset, maxout
;**  or minout the coordinates
;*/

        farPtr  lp_rect,ss,di                     ; SS:DI -> CorrRect
        cCall   convert_device_screen,<lp_rect,2> ; DS:SI = ddc
        assert  dx,E,0                            ; DX = 16 bit overflow flag
        or      ax,ax
        jnz     @F
        inc     dx                                ; overflow 16 bits
@@:

;/*
;**  make right/top exclusive
;*/

        add     CorrRect.rcl_xRight.lo,1
        jno     @F
        inc     dx                                ; overflow 16 bits
@@:
        adc     CorrRect.rcl_xRight.hi,0

        add     CorrRect.rcl_yTop.lo,1
        jno     @F
        inc     dx                                ; overflow 16 bits
@@:
        adc     CorrRect.rcl_yTop.hi,0

        or      dx,dx                             ; did we overflow 16 bits?
        jz      got_pick_window                   ;   no

        mov     cx,ss                             ; overflow with this DC origin
        mov     es,cx                             ; ES:DI -> CorrRect
        assumes es,nothing
        call    truncate_rectl                    ; maxout and minout coordinates

got_pick_window:
        mov     ax,CorrRect.rcl_xLeft.lo
        mov     bx,CorrRect.rcl_xRight.lo
        cmp     ax,bx
        jz      null_pick_window                  ; we have a null pick window
        mov     cx,CorrRect.rcl_yBottom.lo
        mov     dx,CorrRect.rcl_yTop.lo
        cmp     cx,dx
        jz      null_pick_window                  ; we have a null pick window

;/*
;**  we have checked cross-over above, just to be sure
;*/

        assert  ax,L,bx
        assert  cx,L,dx

        ddc?    si
        les     di,[si].ddc_prddc                ; ES:DI = RDDC
        assumes es,nothing
        rddc?   es,di


;/*
;**  store the resulting pick window in the DDC
;*/

        lea     di,[di].rddc_rcsCorr              ; ES:DI = rddc_rcsCorr
        stosw                                     ; left
        xchg    ax,cx
        stosw                                     ; bottom
        xchg    ax,bx
        stosw                                     ; right
        xchg    ax,dx
        stosw                                     ; top

;/*
;**  save the pick window passed in
;*/

        .errnz  rddc_rclPick GT rddc_rcsCorr
        add     di,rddc_rclPick-rddc_rcsCorr-(SIZE RECTS) ; ES:DI -> rddc_rclPick
        mov     bx,si                                     ; BX = ddc
        lds     si,lpPickWindow                           ; DS:SI -> lpPickWindow
        assumes ds,nothing
        mov     cx,(size RECTL) / 4
        .errnz  (SIZE RECTL) and 3
        CPUMode 386
        rep     movsd
        CPUMode 286

        mov     ds,CodeData                       ; restore segment value
        assumes ds,Data

;/*
;**  now we trust them!
;*/
        ddc?    bx
        and     [bx].ddc_fb[0],not DDC_CORR_INV
        jmp     short SetPickWindow_good_exit

;/*
;**  resulting pick window is null
;*/

null_pick_window:

        mov     ax,PMERR_INV_PICK_APERTURE_POSN   
        save_error_code
        xor     ax,ax
        jmp     short SetPickWindow_exit

SetPickWindow_good_exit:
        mov     ax,1

SetPickWindow_exit:
        cwd
        call    leave_driver
spw_exit_no_lock:
        mov     cx,ax                 ; recalc_correlate_rect depends on CX return value
cEnd

        assumes ds,nothing
        assumes es,nothing

;/***************************************************************************
;*
;* FUNCTION NAME = recalc_correlate_rect 
;*
;* DESCRIPTION   = Recalculates the correlate rectangle (ddc_rcsCorr) using the 
;*                 current pick window only when clip region or transformation 
;*                 change.
;*
;*                 Registers Preserved:
;*                        SI,DI,DS,BP
;*                 Registers Destroyed:
;*                        AX,BX,CX,DX,ES,FLAGS
;* INPUT         = DS:SI = DDC 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = CX = 1        Success          
;*                 AX = CX = 0        Null pick window 
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

cProc   far_recalc_correlate_rect,<PUBLIC,FAR>
cBegin
        call    recalc_correlate_rect
cEnd

cProc   recalc_correlate_rect,<PUBLIC,NEAR>
cBegin
        ddc?    si

;/*
;**  call SetPickWindow to recalculate ddc_rcsCorr rectangle
;*/

        mov     ax,[si].ddc_prddc.off
        mov     dx,[si].ddc_prddc.sel
        add     ax,rddc_rclPick     ; DX:AX -> pick window

        check   SetPickWindow,<hdc,prcl,hddc,ulFunN>
        farPtr  lp_rect,dx,ax
        farPtr  myhdc,<[si].ddc_hdc.hi>,<[si].ddc_hdc.lo>
        farPtr  hddcTemp,ds,si
        farPtr  MyFunN,0,off_SetPickWindow
        cCall   SetPickWindow,<myhdc,lp_rect,hddcTemp,MyFunN>
        assert  ax,E,cx                          ; SetPickWindow returns CX
cEnd

sEnd    Code


sBegin  FarCode
assumes cs,FarCode

;/*
;*/


page

;/***************************************************************************
;*
;* FUNCTION NAME = correlate_for_point_si
;*
;* DESCRIPTION   = This function performs a correlation against the correlation 
;*                 rectangle and the given point.
;*
;*                 Registers Preserved:
;*                       SI,DI,DS,BP
;*
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,ES,FLAGS
;*
;* INPUT         = BX  =  X coordinate of the poin
;*                 DX  =  Y coordinate of the poin
;*                 SI --> DDC                     
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = 1 if no correlation hit 
;*                 AX = 2 if correlation hit    
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        assumes ds,Data
        assumes es,nothing

cProc   far_correlate_for_point_si,<PUBLIC,FAR,NODATA,NONWIN>
cBegin
        call   correlate_for_point_si
cEnd

cProc   correlate_for_point_si,<PUBLIC,NEAR,NODATA,NONWIN>,<si>
cBegin
        ddc?    si
        test    [si].ddc_fb,DDC_CORR_INV
        jz      do_correlate                      ; has corr rect in ddc
        push    bx                                ; save point
        push    dx
        cCall   far_recalc_correlate_rect   ; set the corr rect
        pop     dx                                ; restore point
        pop     bx
        jcxz    cfp_si_no_hit                     ; null pick window
do_correlate:
        mov     ax,2                              ; assume hit
        les     si,[si].ddc_prddc
        assumes es,nothing
        rddc?   es,si
        cmp     bx,es:[si].rddc_rcsCorr.rcs_pts1.pts_x
        jl      cfp_si_no_hit
        cmp     bx,es:[si].rddc_rcsCorr.rcs_pts2.pts_x
        jge     cfp_si_no_hit
        cmp     dx,es:[si].rddc_rcsCorr.rcs_pts2.pts_y
        jge     cfp_si_no_hit
        cmp     dx,es:[si].rddc_rcsCorr.rcs_pts1.pts_y
        jge     cfp_si_exit                       ; we have a hit here

cfp_si_no_hit:
        mov     ax,1

cfp_si_exit:

cEnd


;/***************************************************************************
;*
;* FUNCTION NAME = intersect_rcl 
;*
;* DESCRIPTION   = Takes the intersection of two RECTLs.  Overwrites the 
;*                 destination RECT with the intersection.  Assumes both RECTLs
;*                 are well ordered.
;*
;*                 Registers Destroyed:
;*                        BX,CX,DX     
;*
;* INPUT         = DS:SI = source RECTL                         
;*                 ES:DI = dest RECTL                           
;*                 BX = check for null rect on result?          
;* OUTPUT        = None
;*
;* RETURN-NORMAL = if BX = 1 on entry                  
;*                    AX = 0 null rect otherwise AX = 1
;*                 else                                 
;*                    nothing                           
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

makemin macro   dest_hi,dest_lo,src_hi,src_lo
        local   have_min,better_exchange
        cmp     dest_hi,src_hi
        jl      have_min
        jg      better_exchange
        cmp     dest_lo,src_lo
        jb      have_min
better_exchange:
        mov     dest_lo,src_lo
        mov     dest_hi,src_hi
have_min:
        endm

makemax macro   dest_hi,dest_lo,src_hi,src_lo
        local   have_max,better_exchange
        cmp     dest_hi,src_hi
        jg      have_max
        jl      better_exchange
        cmp     dest_lo,src_lo
        ja      have_max
better_exchange:
        mov     dest_lo,src_lo
        mov     dest_hi,src_hi
have_max:
        endm

        assumes ds,nothing
        assumes es,nothing

cProc   intersect_rcl,<PUBLIC,NEAR,NODATA>
cBegin

;/*
;** get the max left
;*/

        push    bx
        mov     ax,es:[di].rcl_xLeft.lo
        mov     dx,es:[di].rcl_xLeft.hi
        mov     bx,[si].rcl_xLeft.lo
        mov     cx,[si].rcl_xLeft.hi
        makemax dx,ax,cx,bx
        mov     es:[di].rcl_xLeft.lo,ax
        mov     es:[di].rcl_xLeft.hi,dx

;/*
;**  get the min right
;*/

        mov     ax,es:[di].rcl_xRight.lo
        mov     dx,es:[di].rcl_xRight.hi
        mov     bx,[si].rcl_xRight.lo
        mov     cx,[si].rcl_xRight.hi
        makemin dx,ax,cx,bx

;/*
;**  make sure X is well ordered
;*/

        mov     bx,es:[di].rcl_xLeft.lo
        mov     cx,es:[di].rcl_xLeft.hi
        makemax dx,ax,cx,bx
        mov     es:[di].rcl_xRight.lo,ax
        mov     es:[di].rcl_xRight.hi,dx

;/*
;**  get the max bottom
;*/

        mov     ax,es:[di].rcl_yBottom.lo
        mov     dx,es:[di].rcl_yBottom.hi
        mov     bx,[si].rcl_yBottom.lo
        mov     cx,[si].rcl_yBottom.hi
        makemax dx,ax,cx,bx
        mov     es:[di].rcl_yBottom.lo,ax
        mov     es:[di].rcl_yBottom.hi,dx

;/*
;**  get the min top
;*/

        mov     ax,es:[di].rcl_yTop.lo
        mov     dx,es:[di].rcl_yTop.hi
        mov     bx,[si].rcl_yTop.lo
        mov     cx,[si].rcl_yTop.hi
        makemin dx,ax,cx,bx

;/*
;**  make sure Y is well ordered
;*/

        mov     bx,es:[di].rcl_yBottom.lo
        mov     cx,es:[di].rcl_yBottom.hi
        makemax dx,ax,cx,bx
        mov     es:[di].rcl_yTop.lo,ax
        mov     es:[di].rcl_yTop.hi,dx

        pop     bx
        cmp     bx,1
        jne     intersect_rcl_exit
        mov     ax,word ptr es:[di].rcl_xLeft[0]
        cmp     ax,word ptr es:[di].rcl_xRight[0]  ; is left < right?
        jge     return_null_rect                   ;   no, null rect

        mov     ax,word ptr es:[di].rcl_yBottom[0]
        cmp     ax,word ptr es:[di].rcl_yTop[0]    ; is bottom < top?
        jge     return_null_rect                   ;   no, null rect
        mov     ax,1                               ; return clip rect
        jmp     short intersect_rcl_exit

;/*
;**  return null intersection
;*/

return_null_rect:

        mov     bx,di
        mov     cx,(SIZE RECTL) / 2
        xor     ax,ax
        rep     stosw
        mov     di,bx

intersect_rcl_exit:
cEnd


;/***************************************************************************
;*
;* FUNCTION NAME = intersect_with_corr
;*
;* DESCRIPTION   = Intersects the destination rectangle with the correlation 
;*                 rectangle.
;*
;*                 Registers Destroyed:
;*                        AX,BX,CX,DX  
;*
;* INPUT         = DS:SI = ddc                                       
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX = 1 if correlation, otherwise AX = 0
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

cProc   intersect_with_corr,<PUBLIC,NEAR,NODATA>,<ds,si,di>
        parmD   lpDestRect
cBegin

        ddc?    si
        test    [si].ddc_fb,DDC_CORR_INV
        jz      iwc_do_correlate                     ; has corr rect in ddc
        cCall   far_recalc_correlate_rect            ; set the corr rect
        jcxz    iwc_exit                             ; null pick window

iwc_do_correlate:
        mov     cx,size RECTS/2
        sub     sp,size RECTL
        mov     bx,sp
        mov     di,bx
        mov     ax,ss
        mov     es,ax

        lds     si,[si].ddc_prddc                 ; DS:SI = prddc
        assumes ds,nothing
        rddc?   ds,si
        lea     si,[si].rddc_rcsCorr

iwc_make_rcl:                                     ; convert rcs to a stack rcl
        lodsw   
        cwd
        stosw
        xchg    ax,dx
        stosw
        loop    iwc_make_rcl

        mov     si,bx

        mov     ax,ss
        mov     ds,ax                             ;ds:si-> src_rcl
        assumes ds,nothing
        les     di,lpDestRect                     ;es:di-> dst_rcl
        assumes es,nothing

;/*
;** Does our dest rect interesect with our correlation rect?
;*/
        mov     bx,1
        cCall   intersect_rcl
        add     sp,size RECTL
iwc_exit:
cEnd

sEnd    FarCode

        end
