;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page        ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = FIREWALL.ASM
;*
;* DESCRIPTIVE NAME = debug program
;*
;*
;* VERSION      V2.0
;*
;* DATE         8/4/92
;*
;* DESCRIPTION  This program processes a rip. It is assembled only when
;*              FIREWALL is defined.
;*
;* FUNCTIONS    Public: perform_rip
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/17/88                     Walt Moore - Created
;*   09/13/88                     Lee A. Newberg [leen]
;*                                   Preserves all registers.
;*
;*****************************************************************************/

ifdef FIREWALLS

        .286p
        .xlist
        include        cmacros.inc

        include        pmgre.inc
        .list

        externFP        <WinSetErrorInfo>,C

SEIOptions = SEI_REGISTERS+SEI_STACKTRACE

;/***************************************************************************
;* MACRO NAME    = ErrMsg
;*
;* DESCRIPTION   =
;*     ErrMsg is the macro which will define each errro message.  Each
;*     error message will have is offset from the start of the table
;*     defined as an absolute which can be accessed by an ExternA
;*     declaration.
;* Usage:
;*       errmsg name,text
;* Where:
;*       name - the name it will be referenced by
;*       text - the contents of the error message
;*
;**************************************************************************/
errmsg  macro   name,text
msg_&name =     (offset $)-(offset error_messages)
public  msg_&name
        db '&text',0
endm

_FIRESEG        segment WORD PUBLIC 'code'
        assume  cs:_FIRESEG

error_messages  label        byte

;/*
;** These are the new ones which are used in the driver to date.
;*/

errmsg        ColorTableNotDefault,<Validate - Color table should be the default but is not>
errmsg        BadPolySLPair,<Start/Stop Y values must match in the 2 PolyShortLines>
errmsg        BitBltError,<BitBlt returned an unexpected error>
errmsg        assert,<Generic assertion failure>

;/***************************************************************************
;*
;* FUNCTION NAME = perform_rip
;*
;* DESCRIPTION   = The given error message is passed to WinSetErrorInfo 
;*                 with the abort flag set
;*                 Registers Preserved:
;*                        all
;*                 Registers Destroyed:
;*                        none           
;*
;* INPUT         = None
;* OUTPUT        = None
;*
;* RETURN-NORMAL = None
;* RETURN-ERROR  = None
;*
;**************************************************************************/

cProc   perform_rip,<FAR,PUBLIC,NODATA>
        parmW   npError
cBegin
        pushf
        pusha
        push    es
        farPtr  pMsg,cs,npError
        farPtr  errorid,SEVERITY_SEVERE,1
        cCall   WinSetErrorInfo,<errorid,SEIOptions,pMsg>,<C>
        pop     es
        popa
        popf
cEnd

_FIRESEG        ends

endif
end
