;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page        ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EXIT.ASM
;*
;* DESCRIPTIVE NAME = Exit program
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/05/87
;*
;* DESCRIPTION  Contains exit routine for process termination. 
;*
;* FUNCTIONS    exit_list_proc
;*              real_exit_list_proc
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/05/87                     Hock Lee [hockl]  - Created
;*   01/24/89                     Bob Grudem [bobgru]
;*                                Added code to clear screen_busy if 
;*                                process owned driver semaphore.
;*   12/05/87                     Walt Moore - Wrote exit_list_proc
;*
;*****************************************************************************/

        .286p
        .xlist
        include        cmacros.inc
        include        pmgre.inc
        include driver.inc
        .list

        externFP FSRSemCheck
        externFP FSRSemExit
        externFP DosExitList

sBegin        PtrData
        externB screen_busy
sEnd        PtrData

sBegin        Data
        externW semDriver
sEnd        Data

sBegin        Code
        assumes cs,Code

        externW CodeData
        externW MyPtrCodeData

page

;/***************************************************************************
;*
;* FUNCTION NAME = real_exit_list_proc
;*
;* DESCRIPTION   = process termination procedure 
;*      This procedure cleans up all allocated resources or clears flags
;*      and semaphores that might be owned by the dying process.
;*                                                                              
;*      When done, passes control to another address on the exit list by        
;*      calling DosExitList.                                                    
;*                                                                              
;*      It is critical that this exit routine be as short and fail-safe as      
;*      possible.                                                               
;*
;*      Registers Preserved:        
;*             None                 
;*      Registers Destroyed:        
;*             All                  
;*      Calls:                      
;*             FSRSemLeave          
;*             DosExitList          
;*      
;* INPUT         = None
;* OUTPUT        = None
;*
;* RETURN-NORMAL = No return, passes control to DosExitList 
;* RETURN-ERROR  = None
;*
;**************************************************************************/

        assumes        ds,nothing
        assumes        es,nothing

cProc        real_exit_list_proc,<PUBLIC,FAR,NODATA>

cBegin        <nogen>

        push        ds
        mov        ds,CodeData
        assumes        ds,Data

;/*
;** If any thread of the dying process owns the semaphore, force the
;** screen to be not busy, just in case it was busy when the fault happened.
;*/

        cCall        FSRSemCheck,<DataOFFSET semDriver>
        or        dx,dx
        jnz        driver_sem_is_ok        ;result zero if some thread owns sem

        mov        es,MyPtrCodeData
        assumes es,PtrData
        mov        screen_busy,NOT_BUSY

        cCall        FSRSemExit,<DataOFFSET semDriver>

driver_sem_is_ok:
        pop        ds
        assumes ds,nothing

;/*
;**  Pass control to next routine in the exit list.  This call does NOT return.
;**  This call goes back to the kernel, so there's no need to trash ES.
;*/

        farPtr        dNull,0,0
        cCall        DosExitList,<3,dNull>

cEnd        <nogen>

sEnd        Code



sBegin        Ring3Code
        assumes cs,Ring3Code

page

;/***************************************************************************
;*
;* FUNCTION NAME = exit_list_proc
;*
;* DESCRIPTION   = This stub invokes the actual Driver exit list process code.   
;*                 It must reside at ring 3 since there is a     in OS/2 which   
;*                 which currently doesn't allow an exit list procedure to       
;*                 reside at ring 2.  We cannot perform the exit list processing 
;*                 at ring 3 since our DS will be a ring 2 selector.             
;*
;* INPUT         = Per real_exit_list_proc 
;* OUTPUT        = Per real_exit_list_proc 
;*
;* RETURN-NORMAL = Per real_exit_list_proc 
;* RETURN-ERROR  = Per real_exit_list_proc 
;*
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

cProc        exit_list_proc,<PUBLIC,FAR,NODATA>

cBegin        <nogen>

        call        real_exit_list_proc        ;Will not return!

cEnd        <nogen>

sEnd        Ring3Code

end
