;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page        ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = ERROR.ASM
;*
;* DESCRIPTIVE NAME = Display driver error declarations.
;*
;*
;* VERSION      V2.0
;*
;* DATE         05/26/92
;*
;* DESCRIPTION  This program used to process and save errors.
;*
;* FUNCTIONS    save_that_warning
;*              save_that_error
;*              save_that_unrecoverable_error
;*              save_that_severe_error
;*              save_that_???_error
;* 
;* NOTES        NONE
;* 
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*                                Hock Lee [hockl]  - Created
;*   09/24/88                     Hock Lee [hockl]  - Preserved ES.
;*   06/24/88                     Kent Settle [kentse]
;*                                Added save_that_warning.
;*   04/26/88                     Lee A. Newberg [leen]
;*                                   Added save_that_unrecoverable_error 
;*                                   and save_that_severe_error.
;*   11/11/87                     Hock Lee [hockl]
;*                                   Added rips for save_that_error.
;*   11/06/87                     Hock Lee [hockl]
;*                                   Wrote WinSetErrorInfo call.
;*   07/22/87                     Charles Whitmer [chuckwh]
;*                                   Wrote it. save_that_error
;* 
;* ***************************************************************************/

        .286p
        .xlist
        include            cmacros.inc
INCL_GPIERRORS             equ        1
        include            pmgre.inc
DINCL_ERROR                equ        1
SAVE_THAT_ERROR_DEFINED    equ        1
SAVE_THAT_WARNING_DEFINED  equ        1
SAVE_THAT_UNRECOVERABLE_DEFINED equ   1
        include driver.inc
        .list

        ??_out        error.asm

        externFP <WinSetErrorInfo>,C

        public        PMERR_INV_FONT_ATTRS
        public        PMERR_FONT_NOT_LOADED
        public        PMERR_INV_SETID
        public        PMERR_BASE_ERROR
        public        PMERR_BITMAP_IS_SELECTED
        public        PMERR_BITMAP_NOT_SELECTED
        public        PMERR_COL_TABLE_NOT_REALIZABLE
        public        PMERR_COORDINATE_OVERFLOW
        public        PMERR_INCORRECT_DC_TYPE
        public        PMERR_INSUFFICIENT_MEMORY
        public        PMERR_INV_BACKGROUND_COL_ATTR
        public        PMERR_INV_BACKGROUND_MIX_ATTR
        public        PMERR_INV_BITBLT_MIX
        public        PMERR_INV_CHAR_DIRECTION_ATTR
        public        PMERR_INV_CHAR_MODE_ATTR
        public        PMERR_INV_COLOR_ATTR
        public        PMERR_INV_COLOR_DATA
        public        PMERR_INV_COLOR_FORMAT
        public        PMERR_INV_COLOR_OPTIONS
        public        PMERR_INV_COLOR_INDEX
        public        PMERR_INV_COLOR_START_INDEX
        public        PMERR_INV_COORDINATE
        public        PMERR_INV_DC_TYPE
        public        PMERR_INV_HBITMAP
        public        PMERR_INV_HDC
        public        PMERR_INV_BITMAP_DIMENSION
        public        PMERR_INV_INFO_TABLE
        public        PMERR_INV_IN_PATH
        public        PMERR_INV_IN_AREA
        public        PMERR_INV_LENGTH_OR_COUNT
        public        PMERR_INV_LINE_TYPE_ATTR
        public        PMERR_INV_MIX_ATTR
        public        PMERR_INV_PATTERN_ATTR
        public        PMERR_INV_PICK_APERTURE_POSN
        public        PMERR_INV_QUERY_ELEMENT_NO
        public        PMERR_INV_RECT
        public        PMERR_INV_RGBCOLOR
        public        PMERR_INV_SCAN_START
        public        PMERR_INV_CODEPAGE
        public        PMERR_KERNING_NOT_SUPPORTED
        public        PMERR_REALIZE_NOT_SUPPORTED
        public        PMERR_COL_TABLE_NOT_REALIZED
        public        PMERR_BOUNDS_OVERFLOW
        public        PMERR_PEL_IS_CLIPPED
        public        PMERR_INV_FIRST_CHAR
        public        PMERR_DEV_FUNC_NOT_INSTALLED
        public        PMERR_HUGE_FONTS_NOT_SUPPORTED
        public        PMERR_INV_CURSOR_BITMAP
        public        PMERR_INV_DRAW_BORDER_OPTION
        public        PMERR_INV_IMAGE_DATA_LENGTH
        public        PMERR_INV_PATTERN_REF_PT_ATTR
        public        PMERR_PEL_NOT_AVAILABLE
        public        PMERR_INV_PATTERN_SET_ATTR
        public        PMERR_INV_PATTERN_SET_FONT
        public        PMERR_INV_BITBLT_STYLE
        public        PMERR_HARDWARE_INIT_FAILURE              
        public        PMERR_PALETTE_SELECTED
        public        PMERR_INV_OR_INCOMPAT_OPTIONS
        public  PMERR_INV_CHAR_ALIGN_ATTR

sBegin        Data

        externB         fbRip

sEnd        Data

sBegin        Code
        assumes cs,Code

        externW CodeData

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_warning
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

fOptions           equ        SEI_NOBEEP + SEI_NOPROMPT
fDosOptions        equ        SEI_NOBEEP + SEI_NOPROMPT + SEI_DOSERROR
fRipOptions        equ        SEI_REGISTERS+SEI_STACKTRACE

        assumes        ds,nothing
        assumes        es,nothing

cProc        save_that_warning,<PUBLIC,FAR,NODATA>
cBegin        <nogen>
        mov        cl,SEVERITY_WARNING
        jmpnext
cEnd        <nogen>

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_error
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
cProc        save_that_error,<PUBLIC,FAR,NODATA>
cBegin        <nogen>
        mov        cl,SEVERITY_ERROR
        jmpnext
cEnd        <nogen>

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_unrecoverable_error
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
cProc        save_that_unrecoverable_error,<PUBLIC,FAR,NODATA>
cBegin        <nogen>
        mov        cl,SEVERITY_UNRECOVERABLE
        jmpnext
cEnd        <nogen>

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_severe_error
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
cProc        save_that_severe_error,<PUBLIC,FAR,NODATA>
cBegin        <nogen>
        mov        cl,SEVERITY_SEVERE
        jmpnext stop
        errn$        save_that_???_error
cEnd        <nogen>

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_???_error
;*
;* DESCRIPTION   = Calls WinSetErrorInfo to save away the error code.  If AX is    
;*                 PMERR_BASE_ERROR then we save BX as the DOS error code as well. 
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
cProc        save_that_???_error,<PUBLIC,FAR,NODATA,NONWIN>
cBegin
        xor        ch,ch
        push        es                                ; save ES            

;/*                                                                        
;** check the RIP flag                                                      
;*/
        mov        es,CodeData
        assumes        es,Data
        test        fbRip,DDF_RIP_ERROR                ; check rip flag
        jz        no_rip
        farPtr        idError,SEVERITY_SEVERE,2        ; second message string
        cCall   WinSetErrorInfo,<idError,fRipOptions,ax>,<C>

;/*
;** handle non DOS case
;*/
no_rip:
        cmp        ax,PMERR_BASE_ERROR 
        jz        save_dos_error
        farPtr        idError,cx,ax
        cCall        WinSetErrorInfo,<idError,fOptions>,<C>
        jmp        short error_is_saved

;/*
;** handle DOS case
;*/
save_dos_error:
        cCall        WinSetErrorInfo,<idError,fDosOptions,bx>,<C>
error_is_saved:
        pop        es                                ; restore ES
cEnd


sEnd        Code

        end
