;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*****************************************************************************
;*
;* SOURCE FILE NAME = SCANLINE.INC
;*
;* DESCRIPTIVE NAME = definitions for scanline
;*
;*
;* VERSION      V2.0
;*
;* DATE         8/4/92
;*
;* DESCRIPTION  
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/
NBR_RECTS       equ     4                        ; # of clip-Rects in buffer on stack

EXTENDED_CONTROL struc
        ec_control      dw                       (size RGNRECT)/2 dup (?)
        ec_buffer       dw                       NBR_RECTS * (size RECTL ) / 2 dup (?)
        ec_rect_bound   dw                       (size RECTL)/2 dup (?)
EXTENDED_CONTROL ends


;/***************************************************************************
;*
;* MACRO NAME    = imin
;*
;* DESCRIPTION   = Returns in R1 the smallest of R1 and R2.  Note that these   
;*                 are treated as signed integers.
;*
;*                 Registers Destroyed:
;*                       Flags
;*                 Registers Preserved:
;*                       All
;*
;* INPUT         = NONE
;* OUTPUT        = R1 = min(R1,R2) 
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

imin    macro   R1,R2
        local   got_min_already
        cmp     R1,R2
        jl      got_min_already
        mov     R1,R2
got_min_already:
        endm

;/***************************************************************************
;*
;* MACRO NAME    = imax
;*
;* DESCRIPTION   = Returns in R1 the largest of R1 and R2.  Note that these
;*                 are treated as signed integers.
;*
;*                 Registers Destroyed:
;*                       Flags
;*                 Registers Preserved:
;*                       All
;*
;* INPUT         = NONE
;* OUTPUT        = R1 = max(R1,R2)
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

imax    macro   R1,R2
        local   got_max_already
        cmp     R1,R2
        jg      got_max_already
        mov     R1,R2
got_max_already:
        endm

;/*
;**     The cntrl_blk structure will contain the addresses of the
;**     processor for the first and last byte, inner loop, and the
;**     accelerator byte for skipping the operation.
;**
;**     There will be one structure for each plane processed
;*/

cntrl_blk       struc
first_last_proc dw      ?                         ;Address for first and last byte
inner_loop_proc dw      ?                         ;Address for inner loop bytes
nop_flag        db      ?                         ;D7 set if this is a nop
pattern         db      ?                         ;The pattern for the plane
plane_map_mask  db      ?                         ;EGA map mask value
                db      ?                         ;alignment
cntrl_blk       ends

                .errnz  (size cntrl_blk) and 1


;/*
;**     Bit definitions within the nop_flag field in the cntrl_blk
;**     structure.
;*/

NF_NOP          equ     00000001b
;**             equ     00000010b
;**             equ     00000100b
;**             equ     00001000b
;**             equ     00010000b
;**             equ     00100000b
;**             equ     01000000b
;**             equ     10000000b


;/*
;**     The following values are used to index into the control
;**     block structures for each plane.  The value for C3_DATA
;**     will be incorrect for a three plane driver, but then it
;**     won't be used for a three plane driver.
;**
;**     The values are stored in reverse order to match the
;**     looping logic with the plane selection logic.
;*/

MONO_DATA       equ                                  0  * (size cntrl_blk)
C3_DATA         equ     (BITS_PEL - 4) * (size cntrl_blk)
C2_DATA         equ     (BITS_PEL - 3) * (size cntrl_blk)
C1_DATA         equ     (BITS_PEL - 2) * (size cntrl_blk)
C0_DATA         equ     (BITS_PEL - 1) * (size cntrl_blk)
                .errnz  BITS_PEL - 4

;/*
;**     Define the type flags used to determine which type
;**     of scan needs to be performed (color or mono). The
;**     flag is used as a down counter, being decremented
;**     before use.
;*/
 
 
COLOR_OP        equ     BITS_PEL * (size cntrl_blk)
MONO_OP         equ     1 * (size cntrl_blk)


;/*
;**     The following equates are for the binary raster ops
;**     which will be passed to this routine.  The values
;**     shown are 0:15 since the rop is mapped upon entry
;**     into this function.
;*/


ROP_DDX         equ     0                         ;DDx
ROP_DPON        equ     1                         ;DPon
ROP_DPNA        equ     2                         ;DPna
ROP_PN          equ     3                         ;Pn
ROP_PDNA        equ     4                         ;PDna
ROP_DN          equ     5                         ;Dn
ROP_DPX         equ     6                         ;DPx
ROP_DPAN        equ     7                         ;DPan
ROP_DPA         equ     8                         ;DPa
ROP_DPXN        equ     9                         ;DPxn
ROP_D           equ     10                        ;D
ROP_DPNO        equ     11                        ;DPno
ROP_P           equ     12                        ;P
ROP_PDNO        equ     13                        ;PDno
ROP_DPO         equ     14                        ;DPo
ROP_DDXN        equ     15                        ;DDxn


;/*
;**     The following values will be set in another_tbl for
;**     doing various accelerations on the raster op.
;**
;**     NO_OBJECT is the value used to indicate that the drawing
;**     operation doesn't require a pen or brush.
;**
;**     STOSB_OK is the value used to show that the inner loop
;**     code for the EGA can use STOSB for the given rop as long
;**     as there are no transparent pixels.
;**
;**     MY_SINGLE_OK is set to indicate that the raster operation
;**     may be performed in one pass on the EGA if the brush is
;**     solid.  This is identical to SINGLE_OK, by why do extra
;**     table lookups?
;**
;**     NEG_PATTERN is used as a flag for special cased P and Pn
;**     operations on the EGA.                   If this flag is set, then the
;**     pattern needs to be negated before stored in EGA memory
;**     at current_brush.
;**
;**     ALT_NEG_PATTERN is used as a flag to indicated that the
;**     pattern should be negated for word templates.
;*/


NEG_PATTERN     equ     10000000b
NO_OBJECT       equ     01000000b
MY_SINGLE_OK    equ     00100000b
STOSB_OK        equ     00010000b
ALT_NEG_PATTERN equ     00000001b


;/*
;**     Define the loc_clean_up flags used to indicate what actions
;**     are required upon exit for restoring the EGA to the
;**     default state.
;**
;**     The flag will also be overloaded to contain a flag to
;**     the outer loop code indicating that EGA plane selection
;**     is required.
;*/


CU_NONE         equ     00000000b       ;No cleanup is needed
CU_REGS         equ     10000000b       ;Registers need restoring
CU_EXCLUDE      equ     01000000b       ;Exclusion rectangle must be cleared
CU_PLANE_SEL    equ     00000001b       ;EGA plane selection needed


;/*
;**     The following are the values which will be stored
;**     in loc_some_flags.
;*/

INDEX_MONO      equ     10000000b       ;Device is monochrome
INDEX_XPARENT   equ     00010000b       ;Transparent operation
INDEX_BLNK_FORGRND equ  00000100b       ;Need no paint on foreground
INDEX_BLNK_BKGRND  equ  00000010b       ;Need no paint on background
INDEX_BKGRD     equ     00000001b       ;Processors for background mixmode
