;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME =  RASTEROP.ASM
;*
;* DESCRIPTIVE NAME =  tables for bianary raster operations.
;*                                   
;*
;* VERSION      V2.0
;*
;* DATE         05/20/87
;*
;* DESCRIPTION  
;*              
;*  The EGA card has special drawing logic where a logical
;*  operation may be performed between the display memory
;*  and data from the processor.  There is also drawing
;*  logic that allows a byte from the processor to be
;*  taken as a color to be written into all enabled bits
;*  and enabled planes of a particular byte.  By combining
;*  these operations, most of the binary drawing modes
;*  specified by GDI can be implemented in one pass over
;*  EGA memory.
;*
;*  12 of the 16 GDI binary drawing modes can be done in one pass
;*  if writing a solid color using the EGA color write mode.
;*
;*  Scanline must also deal with background modes.  Brushes
;*  implicitly handle opaque mode by the colors they are realized
;*  in.  For transparent mode, a mask is computed from the
;*  brush for background and NOT background.  By using this mask
;*  in the EGA's Bit Mask register, only those bits that are
;*  forground will be changed.                   Scanline can use the same 12
;*  EGA drawing modes as lines if the color is solid.
;*
;*  Dithered patterns cannot be performed in one pass since
;*  they are not solid.
;*
;*
;*  EGA special support possible:
;*
;*      Operation         Single Pass
;*
;*          Operation     Single Pass
;*             DDx             y
;*             DPon
;*             DPna            y
;*             Pn              y
;*             PDna
;*             Dn              y
;*             DPx             y
;*             DPan
;*             DPa             y
;*             DPxn            y
;*             D               y
;*             DPno            y
;*             P               y
;*             PDno
;*             DPo             y
;*             DDxn            y
;*
;*
;*  The following cannot be performed in one pass using the
;*  EGA hardware.  They can be performed in two seperate
;*  operations to the EGA.  This will be done in the following
;*  manner:
;*
;*      The color will be used for the Write Plane Enable Mask
;*      after it has possibly been inverted to sync for the
;*      output mode being used (xor or set)
;*
;*      A write with 0's or 1's in drSet mode will occur.
;*      This will set bits to either 1's or 0's as needed.
;*
;*      After this write occurs, the color will be inverted
;*      for use as the Write Plane Enable Mask for those
;*      planes which must be XORed to get ~dest.  An XOR
;*      will occur to toggle those bits which must be toggled.
;*
;*
;*                    Color  Result
;*
;*      NOT (source OR dest)
;*                      0    ~dest   for color bits which are 0, xor with 1
;*                      1      0     for color bits which are 1, set to   0
;*
;*      source AND (NOT dest)
;*                      0      0     for color bits which are 0, set to   0
;*                      1    ~dest   for color bits which are 1, xor with 1
;*
;*      NOT (source AND dest)
;*                      0      1     for color bits which are 0, set to   1
;*                      1    ~dest   for color bits which are 1, xor with 1
;*
;*      source OR (NOT dest)
;*                      0    ~dest   for color bits which are 0, xor with 1
;*                      1      1     for color bits which are 1, set to   1
;*              
;*              
;*              
;* FUNCTIONS     NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   05/20/87                     Written by Kent Settle
;*
;*****************************************************************************/

        .xlist
        include cmacros.inc
        include pmgre.inc
DINCL_ROPS      equ     1
        include driver.inc
        include display.inc
        include egafam.inc
        .list


        ??_out  rasterop

;/*
;**     The following equates are used for those raster operations
;**     which can be performed in one operation on the EGA card.
;**     The values are ANDed and XORed with the pen to get the
;**     desired color to use for the raster operation.
;*/


ZERO_PEN        equ     0000h                     ;AND with 0000b, XOR with 0000b
PEN             equ     000Fh                     ;AND with 1111b, XOR with 0000b
ONE_PEN         equ     0F00h                     ;AND with 0000b, XOR with 1111b
NOT_PEN         equ     0F0Fh                     ;AND with 1111b, XOR with 1111b



;/*
;**     The following equates are used for those raster operations
;**     which required two operations to the EGA
;*/


INVERT          equ     00Fh                      ;INVERT color before using as plane mask
NO_INVERT       equ     000h                      ;Use the color directly as plane mask
SET_TO_1S       equ     00Fh                      ;For the Set, use 1's
SET_TO_0S       equ     000h                      ;For the Set, use 0's


;/*
;**     rop_data_r contains the value which will be output to the
;**     Data Rotate Register for the raster operations.  For
;**     those raster operations which require two passes, the
;**     value in this table will always be drSet.
;*/


rop_tables      macro prefix_

        public  &prefix_&flags
        public  &prefix_&data_r
        public  &prefix_&pen_and
        public  &prefix_&pen_xor

&prefix_&data_r      label byte
                db      DR_SET                    ;DDx
                db      DR_SET                    ;DPon ;Two operations required
                db      DR_AND                    ;DPna
                db      DR_SET                    ;Pn
                db      DR_SET                    ;PDna ;Two operations required
                db      DR_XOR                    ;Dn
                db      DR_XOR                    ;DPx
                db      DR_SET                    ;DPan ;Two operations required
                db      DR_AND                    ;DPa
                db      DR_XOR                    ;DPxn
                db      DR_OR                     ;D
                db      DR_OR                     ;DPno
                db      DR_SET                    ;P
                db      DR_SET                    ;PDno ;Two operations required
                db      DR_OR                     ;DPo
                db      DR_SET                    ;DDxn


;/*
;**     rop_flags contains flags indicating if the raster operation
;**     may be performed in one operation or if two operations are
;**     required.
;*/


&prefix_&flags       label   byte
                db      SINGLE_OK                ;DDx
                db      0                        ;DPon ;Two operations required
                db      SINGLE_OK                ;DPna
                db      SINGLE_OK                ;Pn
                db      0                        ;PDna ;Two operations required
                db      SINGLE_OK                ;Dn
                db      SINGLE_OK                ;DPx
                db      0                        ;DPan ;Two operations required
                db      SINGLE_OK                ;DPa
                db      SINGLE_OK                ;DPxn
                db      SINGLE_OK                ;D
                db      SINGLE_OK                ;DPno
                db      SINGLE_OK                ;P
                db      0                        ;PDno ;Two operations required
                db      SINGLE_OK                ;DPo
                db      SINGLE_OK                ;DDxn


&prefix_&pen_and     label   byte
                db      LOW ZERO_PEN             ;DDx
                db      LOW SET_TO_0S            ;DPon ;Two operations required
                db      LOW NOT_PEN              ;DPna
                db      LOW NOT_PEN              ;Pn
                db      LOW SET_TO_0S            ;PDna ;Two operations required
                db      LOW ONE_PEN              ;Dn
                db      LOW PEN                  ;DPx
                db      LOW SET_TO_1S            ;DPan ;Two operations required
                db      LOW PEN                  ;DPa
                db      LOW NOT_PEN              ;DPxn
                db      LOW ZERO_PEN             ;D
                db      LOW NOT_PEN              ;DPno
                db      LOW PEN                  ;P
                db      LOW SET_TO_1S            ;PDno ;Two operations required
                db      LOW PEN                  ;DPo
                db      LOW ONE_PEN              ;DDxn

&prefix_&pen_xor     label   byte
                db      HIGH ZERO_PEN            ;DDx
                db           NO_INVERT           ;DPon ;Two operations required
                db      HIGH NOT_PEN             ;DPna
                db      HIGH NOT_PEN             ;Pn
                db           INVERT              ;PDna ;Two operations required
                db      HIGH ONE_PEN             ;Dn
                db      HIGH PEN                 ;DPx
                db           INVERT              ;DPan ;Two operations required
                db      HIGH PEN                 ;DPa
                db      HIGH NOT_PEN             ;DPxn
                db      HIGH ZERO_PEN            ;D
                db      HIGH NOT_PEN             ;DPno
                db      HIGH PEN                 ;P
                db           NO_INVERT           ;PDno ;Two operations required
                db      HIGH PEN                 ;DPo
                db      HIGH ONE_PEN             ;DDxn

        endm

;/*
;**     We expect the rops to be in this order
;*/

                .errnz  ROP_DDX-0
                .errnz  ROP_DPON-1
                .errnz  ROP_DPNA-2
                .errnz  ROP_PN-3
                .errnz  ROP_PDNA-4
                .errnz  ROP_DN-5
                .errnz  ROP_DPX-6
                .errnz  ROP_DPAN-7
                .errnz  ROP_DPA-8
                .errnz  ROP_DPXN-9
                .errnz  ROP_D-10
                .errnz  ROP_DPNO-11
                .errnz  ROP_P-12
                .errnz  ROP_PDNO-13
                .errnz  ROP_DPO-14
                .errnz  ROP_DDXN-15


sBegin  Code
        assumes cs,Code
        rop_tables      Code_rop_
sEnd    Code

sBegin  Bitmap
        assumes cs,Bitmap
        rop_tables      Bitmap_rop_
sEnd    Bitmap

end
