;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*****************************************************************************
;*
;* SOURCE FILE NAME =  RESOLVE.ASM
;*
;* DESCRIPTIVE NAME =  Device Specific Initialization.
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/01/91
;*
;* DESCRIPTION  Device Specific Initialization.           
;*              
;*              
;* FUNCTIONS    device_specific_init
;*              device_specific_post_init
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/01/91                     Written by Scott Lawson
;*   04/02/90                     johnc - Critical section check now in 
;*                                both retail and debug
;*****************************************************************************/


        .xlist
        include cmacros.inc
INCL_DDIBUNDLES         equ     1
INCL_DEV                equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
        include pmgre.inc
DINCL_ENABLE            equ     1
DINCL_ROPS              equ     1
DINCL_BB_ROPS           equ     1
DINCL_SAVE_SCREEN_BITS  equ     1
DINCL_VIO               equ     1
        include driver.inc
        include pointer.inc
        include egafam.inc
        include fontseg.inc
        .list

        externFP GreEntry3
        externA  DOSPAGESIZE

        pubabs  DEF_LOG_FORE_CLR,7
        pubabs  DEF_LOG_BACK_CLR,0
        pubabs  DEF_IPC_FORE_CLR,100000b        ; For ega
        pubabs  DEF_IPC_BACK_CLR,111111b        ; For ega

        pubabs  DEF_FMIX_LINE,%(ROP_P)
        pubabs  DEF_FB_LINE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_LINE,%(ROP_D)
        pubabs  DEF_LINE_TYPE,%(LINETYPE_SOLID-1)
        pubabs  DEF_LINE_ERROR,0
        pubabs  DEF_LINE_MASK,0

        pubabs  DEF_FMIX_MARKER,%(CHAR_ROP_P)
        pubabs  DEF_FB_MARKER,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_MARKER,%(BA_IS_XPARENT)
        pubabs  DEF_MARKER_FB_FLAGS,0
        pubabs  DEF_MARKER_FS_FLAGS,0
        pubabs  DEF_MARKER_CODE_POINT,%(MARKSYM_CROSS)

        pubabs  DEF_FMIX_CHAR,%(CHAR_ROP_P)
        pubabs  DEF_FB_CHAR,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_CHAR,%(BA_IS_XPARENT)
        pubabs  DEF_FONT_FS_FLAGS,0

        pubabs  DEF_FMIX_PATTERN,%(ROP_P)
        pubabs  DEF_FB_PATTERN,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_PATTERN,%(ROP_D)
        pubabs  DEF_PATTERN_FB_FLAGS,(PA_SINGLE_CLR)
        pubabs  DEF_PATTERN_FS_FLAGS,0
        pubabs  DEF_PATTERN_CODE_POINT,%(PATSYM_SOLID)

        pubabs  DEF_FMIX_IMAGE,%(FM_OVERPAINT-1)
        pubabs  DEF_FB_IMAGE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_BMIX_IMAGE,%(BA_IS_XPARENT)


        pubabs  IC_SDFB,<SD_DEVICE or SD_COLOR>
        pubabs  SCREEN_SDFB,<SD_DEVICE or SD_COLOR or SD_NONNULL>
        pubabs  SCREEN_CYSEG,0
        pubabs  DEVCAPS_COLOR_INDEX,63

if SCAN_CNT eq 200
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2000   
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667 
        pubabs  VISIBLE_SIZE_WORDS,80*200/2        
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/3
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,5
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,10
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,72
        pubabs  DEVCAPS_CHAR_HEIGHT,12
endif

if SCAN_CNT eq 350
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2000
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667
        pubabs  VISIBLE_SIZE_WORDS,80*350/2
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/3
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,10
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,13
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,72
        pubabs  DEVCAPS_CHAR_HEIGHT,12
endif

if SCAN_CNT eq 480
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2667
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667
        pubabs  VISIBLE_SIZE_WORDS,80*480/2
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,13
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,13
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,96
        pubabs  DEVCAPS_CHAR_HEIGHT,14
endif

        pubabs  DEVCAPS_COLORS,16
        pubabs  COLOR_DONT_CARE,%((MM_ALL shl 8)+GRAF_CDC)

        pubabs  DEVCAPS_HEIGHT_IN_CHARS,24
        pubabs  DEVCAPS_WIDTH_IN_CHARS,80

        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,8
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8

;/*
;** This driver supports color pointer
;*/

CAPS_COLOR_POINTER_SUPPORT      equ     128
        pubabs  DEVCAPS_COLOR_POINTER_SUPPORT,%(CAPS_COLOR_POINTER_SUPPORT)

        pubabs  DEFAULT_SELTEXTVRAM,0           ; Indicates not in use

;/*
;**$003 --- Begin Insertion ---
;*/

ifdef SLITE
sBegin  PtrData
        externB fStarlight                      ; Starlight Present/Enabled flags
sEnd    PtrData
endif

;/*
;**$003 --- End Insertion ---
;*/


sBegin  Data
        externB gsspScreen
        externD padBitmapFormats
        externD adDevCapsData

        globalW cPtrSizes,1                 ; This driver has only 1 valid pointer size.
        dw      PTR_WIDTH_BITS,PTR_HEIGHT

sEnd    Data


sBegin  Code
        assumes cs,Code

        externB rot_bit_tbl
        externB end_crit_code
ifdef SLITE
        externW MyPtrCodeData               ;pointer to PTR Data area          $003
endif

        assumes ds,Data
        assumes es,nothing

        public  adBitmapFormats
adBitmapFormats label   dword
                dd      1,4                ;1 plane, 4 pel
                dd      1,1                ;1 plane, 1 pel

;/***************************************************************************
;*
;* FUNCTION NAME = device_specific_init 
;*
;* DESCRIPTION   = Device Specific Initialization routine
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

cProc   device_specific_init,<FAR,PUBLIC,NODATA>
cBegin
        mov     ax,DOSPAGESIZE
        cmp     ax,CodeOFFSET end_crit_code
        jae     crit_sec_code_ok
        int     3
crit_sec_code_ok:

;/*
;** Initialize the GSSP structure for the EGA
;*/

        mov     gsspScreen.gssp_cSel,1
        mov     gsspScreen.gssp_cb,0
        mov     gsspScreen.gssp_pPhysMem.lo,0
        mov     gsspScreen.gssp_pPhysMem.hi,0Ah
        mov     gsspScreen.gssp_size,size GSSP
        mov     padBitmapFormats.sel,CodeBASE
        mov     padBitmapFormats.off,CodeOFFSET adBitmapFormats
        mov     adDevCapsData[CAPS_MARKER_HEIGHT*SIZE_DWORD].hi,0
        mov     adDevCapsData[CAPS_MARKER_HEIGHT*SIZE_DWORD].lo,9
        mov     adDevCapsData[CAPS_MARKER_WIDTH*SIZE_DWORD].hi,0
        mov     adDevCapsData[CAPS_MARKER_WIDTH*SIZE_DWORD].lo,9
        mov     cx,1

cEnd

cProc   device_specific_post_init,<FAR,PUBLIC,NODATA>
cBegin

;/*
;**$001 --- Begin Insertion ---
;*/

ifdef SLITE
                                        ;Check for Starlight - Accelerated VGA
        push    ds
        mov     ds,MyPtrCodeData
        assumes ds,PtrData

        mov     fStarlight,0            ;assume no Starlight

        cli                             ;Enter Crit
        mov     dx,EGA_BASE+GRAF_ADDR   ;save Set/Reset Plane Color reg
        mov     al,GRAF_SET_RESET
        out     dx,al
        xchg    ah,al
        inc     dx
        in      al,dx
        xchg    ah,al                   ;realign & save for later
        mov     bx,ax                   ;restore

        dec     dx                      ;unlock Starlight
        mov     ax,GRAF_ESR+100h*ESR_UNLOCK
        out     dx,ax

        mov     al,GRAF_BBCR            ;enable Starlight extensions
        out     dx,al                   ;if present
        inc     dx
        in      al,dx
        or      al,BBCR_BBEN            ;set enable bit
        out     dx,al

        dec     dx                      ;get rotate register via std VGA
        mov     al,GRAF_DATA_ROT
        out     dx,al
        inc     dx
        in      al,dx
        mov     ah,al                   ;save it for later restore

        mov     dx,SL_BRot              ;get rotate reg via Starlight
        in      al,dx
        xor     al,07h                  ;and change it
        out     dx,al

        mov     dx,EGA_BASE+GRAF_ADDR   ;get rotate register via std VGA
        mov     al,GRAF_DATA_ROT
        out     dx,al
        inc     dx
        in      al,dx
        cmp     ah,al                   ;did it change ?
        je      not_Starlight           ;no--we're not on a Starlight
        inc     fStarlight              ;yes--we be on a Starlight
not_Starlight:
        mov     al,ah                   ;restore rotate reg
        out     dx,al

        dec     dx                      ;restore Set/Reset Plane Color reg
        mov     ax,bx
        out     dx,ax

        mov     ax,GRAF_ESR+100h*ESR_LOCK       ;lock Starlight
        out     dx,ax
        sti                             ;Leave Crit

        pop     ds
        assumes ds,nothing
endif

;/*
;**$001 --- End Insertion ---
;*/

        mov     ax,0                    ;Success
cEnd


HUGE_FONT       equ     8000h           
FD_VECTOR       equ     0000000000000001B


sEnd    Code
end
