;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = POLYSTYL.ASM
;*
;* DESCRIPTIVE NAME = Polyline styled line drawing device driver. 
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/30/87
;*
;* DESCRIPTION  
;*              
;*   This module contains all of the routines called by POLYLINE.ASM to draw
;*   styled polylines in memory bitmaps or the EGA.  The routines are basically 
;*   broken into six different cases.  Lines are categorized as x major,
;*   y major or diagonal.  They are also broken down into simple and 
;*   non-simple, or standard, cases; where simple means horizontal, vertical
;*   or on a diagonal.  These simple cases can be drawn much faster than
;*   the standard cases, and are therefore broken out from the rest.
;*  
;*   There are similar routines in PLYSOLID.ASM for solid lines to the EGA,
;*   and POLYBITM.ASM for solid lines to memory bitmaps.  While these 
;*   routines are all quite similar, they are separated purely for speed
;*   considerations.  POLYLINE.ASM is the dispatching module for all of 
;*   these routines, and the run length slice algorithm DDA, which all of
;*   these routines are based on, is explained in that module.
;*  
;*   At the end of this module are the *_pixel output routines:
;*   styled_dev_pixel draws the line portions of styled lines to the EGA
;*   styled_bm_pixel act similarly with bitmaps
;*   As needed, the address of one of these routines is loaded
;*   into StyledProc which is called to output each pixel.
;*
;*              
;*              
;* FUNCTIONS    setup_poly_frame_1
;*              dev_styled_horizontal
;*              dev_styled_vertical
;*              dev_styled_diagonal
;*                                   
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        .xlist
        include cmacros.inc
INCL_DDIPATHS   equ     1
        include pmgre.inc
        include driver.inc
        include display.inc
        include egamemf.inc
        include egafam.inc
        include polyline.inc
        .list

sBegin  BlueMoon
        assumes cs,BlueMoon

cProc   setup_poly_frame_1,<FAR,NODATA>
        include plylocal.inc                      
cBegin  nogen
cEnd    nogen

        public  dev_styled_horizontal

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_styled_horizontal 
;*
;* DESCRIPTION   = Draws a styled horizontal line on the EGA. 
;*
;*                 Registers Destroyed: 
;*                       AX,CX,SI       
;*                 Registers Preserved: 
;*                       DX,BP,ES       
;*
;* INPUT         = DS:DI = EGA address        
;*                 BL = rotating bit mask     
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA  
;*
;* OUTPUT        = DS:DI = new EGA address   
;*                 BL = new rotating bit mask
;*                 
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

dev_styled_horizontal    proc                     near

;/*
;**!!! special case LINETYPE_ALTERNATE for extra speed !!!
;*/

;/*
;** load all quantities into registers
;*/

        mov     al,bl                             ; AL = rotating bit mask
        mov     bl,bActiveStyleCounter            ; BL = style error
        mov     ah,bActiveStyleMask               ; AH = style mask
        mov     si,wStyleStepHorz                 ; SI = style step

;/*
;** run the loop
;*/

        dec     cx
        jz      dsh_last_byte
dsh_loop:

;/*
;** draw the pixel if the mask says so
;*/

        or      ah,ah
        jns     @F
        out     dx,al
        or      byte ptr [di],0FFh
@@:

;/*
;** advance to the next pixel
;*/

        ror     al,1
        adc     di,0

;/*
;** advance the style mask
;*/

        xor     bh,bh
        add     bx,si
        xchg    cl,bh
        rol     ah,cl
        mov     cl,bh
        loop    dsh_loop

;/*
;** draw the last pixel if the mask says so
;*/

dsh_last_byte:
        or      ah,ah
        jns     @F
        out     dx,al
        or      byte ptr [di],0FFh
@@:

;/*
;** unload all registers
;*/

        mov     bActiveStyleCounter,bl
        mov     bActiveStyleMask,ah
        mov     bl,al
        ret
dev_styled_horizontal    endp

        public  dev_styled_vertical

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_styled_vertical 
;*
;* DESCRIPTION   = Draws a stlyed vertical line on the EGA.                 
;*
;*                 Registers Destroyed: 
;*                       CX,SI       
;*                 Registers Preserved: 
;*                       DX,BP,ES       
;*
;* INPUT         = DS:DI = EGA address          
;*                 BL = rotating bit mask       
;*                 CX = number of bits to draw  
;*                 DX = EGA_BASE + GRAF_DATA    
;*
;* OUTPUT        = DS:DI = new EGA address   
;*                 BL = new rotating bit mask
;*                 
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

dev_styled_vertical    proc    near

;/*
;** load all quantities into registers
;*/

        mov     al,bl                             ; AL = rotating bit mask
        out     dx,al
        mov     bl,bActiveStyleCounter            ; BL = style error
        mov     ah,bActiveStyleMask               ; AH = style mask
        mov     si,cbScanAddressDelta             ; SI = scan delta

;/*
;** run the loop
;*/

        dec     cx
        jz      dsv_last_byte
dsv_loop:

;/*
;** draw the pixel if the mask says so
;*/

        or      ah,ah
        jns     @F
        or      byte ptr [di],0FFh
@@:

;/*
;** advance to the next pixel
;*/

        add     di,si

;/*
;** advance the style mask
;*/

        xor     bh,bh
        add     bx,wStyleStepVert
        xchg    cl,bh
        rol     ah,cl
        mov     cl,bh
        loop    dsv_loop

;/*
;** draw the last pixel if the mask says so
;*/

dsv_last_byte:
        or      ah,ah
        jns     @F
        or      byte ptr [di],0FFh
@@:

;/*
;** unload all registers
;*/

        mov     bActiveStyleCounter,bl
        mov     bActiveStyleMask,ah
        mov     bl,al
        ret
dev_styled_vertical    endp

        public  dev_styled_diagonal

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_styled_diagonal 
;*
;* DESCRIPTION   = Draws a stlyed diagonal line on the EGA.                 
;*
;*                 Registers Destroyed: 
;*                       CX,SI       
;*                 Registers Preserved: 
;*                       DX,BP,ES       
;*
;* INPUT         = DS:DI = EGA address          
;*                 BL = rotating bit mask       
;*                 CX = number of bits to draw  
;*                 DX = EGA_BASE + GRAF_DATA    
;*
;* OUTPUT        = DS:DI = new EGA address   
;*                 BL = new rotating bit mask
;*                 
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

        assumes ds,nothing
        assumes es,nothing

dev_styled_diagonal    proc    near

;/*
;** load all quantities into registers
;*/

        mov     al,bl                             ; AL = rotating bit mask
        mov     bl,bActiveStyleCounter            ; BL = style error
        mov     ah,bActiveStyleMask               ; AH = style mask
        mov     si,cbScanAddressDelta             ; SI = scan delta

;/*
;** run the loop
;*/

        dec     cx
        jz      dsd_last_byte
dsd_loop:

;/*
;** draw the pixel if the mask says so
;*/

        or      ah,ah
        jns     @F
        out     dx,al
        or      byte ptr [di],0FFh
@@:

;/*
;** advance to the next pixel
;*/

        ror     al,1
        adc     di,si

;/*
;** advance the style mask
;*/

        xor     bh,bh
        add     bx,wStyleStepDiag
        xchg    cl,bh
        rol     ah,cl
        mov     cl,bh
        loop    dsd_loop

;/*
;** draw the last pixel if the mask says so
;*/

dsd_last_byte:
        or      ah,ah
        jns     @F
        out     dx,al
        or      byte ptr [di],0FFh
@@:

;/*
;** unload all registers
;*/

        mov     bActiveStyleCounter,bl
        mov     bActiveStyleMask,ah
        mov     bl,al
        ret
dev_styled_diagonal    endp

sEnd    BlueMoon

        end
